/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.itemstack;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.enchantment.ChunkerEnchantmentType;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class JavaEnchantmentIDResolver
implements Resolver<Integer, ChunkerEnchantmentType> {
    private final InvertibleMap<ChunkerEnchantmentType, Integer> mapping = InvertibleMap.enumKeys(ChunkerEnchantmentType.class);

    public JavaEnchantmentIDResolver(Version javaVersion) {
        this.mapping.put(ChunkerEnchantmentType.ALL_DAMAGE_PROTECTION, 0);
        this.mapping.put(ChunkerEnchantmentType.FIRE_PROTECTION, 1);
        this.mapping.put(ChunkerEnchantmentType.FALL_PROTECTION, 2);
        this.mapping.put(ChunkerEnchantmentType.BLAST_PROTECTION, 3);
        this.mapping.put(ChunkerEnchantmentType.PROJECTILE_PROTECTION, 4);
        this.mapping.put(ChunkerEnchantmentType.RESPIRATION, 5);
        this.mapping.put(ChunkerEnchantmentType.AQUA_AFFINITY, 6);
        this.mapping.put(ChunkerEnchantmentType.THORNS, 7);
        this.mapping.put(ChunkerEnchantmentType.DEPTH_STRIDER, 8);
        this.mapping.put(ChunkerEnchantmentType.SHARPNESS, 16);
        this.mapping.put(ChunkerEnchantmentType.SMITE, 17);
        this.mapping.put(ChunkerEnchantmentType.BANE_OF_ARTHROPODS, 18);
        this.mapping.put(ChunkerEnchantmentType.KNOCKBACK, 19);
        this.mapping.put(ChunkerEnchantmentType.FIRE_ASPECT, 20);
        this.mapping.put(ChunkerEnchantmentType.MOB_LOOTING, 21);
        this.mapping.put(ChunkerEnchantmentType.SWEEPING_EDGE, 22);
        this.mapping.put(ChunkerEnchantmentType.BLOCK_EFFICIENCY, 32);
        this.mapping.put(ChunkerEnchantmentType.SILK_TOUCH, 33);
        this.mapping.put(ChunkerEnchantmentType.UNBREAKING, 34);
        this.mapping.put(ChunkerEnchantmentType.BLOCK_FORTUNE, 35);
        this.mapping.put(ChunkerEnchantmentType.POWER_ARROWS, 48);
        this.mapping.put(ChunkerEnchantmentType.PUNCH_ARROWS, 49);
        this.mapping.put(ChunkerEnchantmentType.FLAMING_ARROWS, 50);
        this.mapping.put(ChunkerEnchantmentType.INFINITY_ARROWS, 51);
        this.mapping.put(ChunkerEnchantmentType.FISHING_LUCK, 61);
        this.mapping.put(ChunkerEnchantmentType.FISHING_SPEED, 62);
        if (javaVersion.isGreaterThanOrEqual(1, 9, 0)) {
            this.mapping.put(ChunkerEnchantmentType.FROST_WALKER, 9);
            this.mapping.put(ChunkerEnchantmentType.MENDING, 70);
        }
        if (javaVersion.isGreaterThanOrEqual(1, 11, 0)) {
            this.mapping.put(ChunkerEnchantmentType.BINDING_CURSE, 10);
            this.mapping.put(ChunkerEnchantmentType.VANISHING_CURSE, 71);
        }
    }

    @Override
    public Optional<Integer> from(ChunkerEnchantmentType input) {
        return Optional.ofNullable(this.mapping.forward().get((Object)input));
    }

    @Override
    public Optional<ChunkerEnchantmentType> to(Integer input) {
        return Optional.ofNullable(this.mapping.inverse().get(input));
    }
}

