/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.itemstack;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.potion.ChunkerEffectType;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class JavaEffectResolver
implements Resolver<String, ChunkerEffectType> {
    private final InvertibleMap<ChunkerEffectType, String> mapping = InvertibleMap.enumKeys(ChunkerEffectType.class);

    public JavaEffectResolver(Version javaVersion) {
        this.mapping.put(ChunkerEffectType.EMPTY, "minecraft:empty");
        this.mapping.put(ChunkerEffectType.SPEED, "minecraft:speed");
        this.mapping.put(ChunkerEffectType.SLOWNESS, "minecraft:slowness");
        this.mapping.put(ChunkerEffectType.HASTE, "minecraft:haste");
        this.mapping.put(ChunkerEffectType.MINING_FATIGUE, "minecraft:mining_fatigue");
        this.mapping.put(ChunkerEffectType.STRENGTH, "minecraft:strength");
        this.mapping.put(ChunkerEffectType.INSTANT_HEALTH, "minecraft:instant_health");
        this.mapping.put(ChunkerEffectType.INSTANT_DAMAGE, "minecraft:instant_damage");
        this.mapping.put(ChunkerEffectType.JUMP_BOOST, "minecraft:jump_boost");
        this.mapping.put(ChunkerEffectType.NAUSEA, "minecraft:nausea");
        this.mapping.put(ChunkerEffectType.REGENERATION, "minecraft:regeneration");
        this.mapping.put(ChunkerEffectType.RESISTANCE, "minecraft:resistance");
        this.mapping.put(ChunkerEffectType.FIRE_RESISTANCE, "minecraft:fire_resistance");
        this.mapping.put(ChunkerEffectType.WATER_BREATHING, "minecraft:water_breathing");
        this.mapping.put(ChunkerEffectType.INVISIBILITY, "minecraft:invisibility");
        this.mapping.put(ChunkerEffectType.BLINDNESS, "minecraft:blindness");
        this.mapping.put(ChunkerEffectType.NIGHT_VISION, "minecraft:night_vision");
        this.mapping.put(ChunkerEffectType.HUNGER, "minecraft:hunger");
        this.mapping.put(ChunkerEffectType.WEAKNESS, "minecraft:weakness");
        this.mapping.put(ChunkerEffectType.POISON, "minecraft:poison");
        this.mapping.put(ChunkerEffectType.WITHER, "minecraft:wither");
        this.mapping.put(ChunkerEffectType.HEALTH_BOOST, "minecraft:health_boost");
        this.mapping.put(ChunkerEffectType.ABSORPTION, "minecraft:absorption");
        this.mapping.put(ChunkerEffectType.SATURATION, "minecraft:saturation");
        if (javaVersion.isGreaterThanOrEqual(1, 9, 0)) {
            this.mapping.put(ChunkerEffectType.LEVITATION, "minecraft:levitation");
            this.mapping.put(ChunkerEffectType.LUCK, "minecraft:luck");
            this.mapping.put(ChunkerEffectType.UNLUCK, "minecraft:unluck");
        }
        if (javaVersion.isGreaterThanOrEqual(1, 13, 0)) {
            this.mapping.put(ChunkerEffectType.CONDUIT_POWER, "minecraft:conduit_power");
            this.mapping.put(ChunkerEffectType.SLOW_FALLING, "minecraft:slow_falling");
            this.mapping.put(ChunkerEffectType.DOLPHINS_GRACE, "minecraft:dolphins_grace");
        }
        if (javaVersion.isGreaterThanOrEqual(1, 14, 0)) {
            this.mapping.put(ChunkerEffectType.BAD_OMEN, "minecraft:bad_omen");
            this.mapping.put(ChunkerEffectType.HERO_OF_THE_VILLAGE, "minecraft:hero_of_the_village");
        }
        if (javaVersion.isGreaterThanOrEqual(1, 19, 0)) {
            this.mapping.put(ChunkerEffectType.DARKNESS, "minecraft:darkness");
        }
        if (javaVersion.isGreaterThanOrEqual(1, 21, 0)) {
            this.mapping.put(ChunkerEffectType.TRIAL_OMEN, "minecraft:trial_omen");
            this.mapping.put(ChunkerEffectType.WIND_CHARGED, "minecraft:wind_charged");
            this.mapping.put(ChunkerEffectType.WEAVING, "minecraft:weaving");
            this.mapping.put(ChunkerEffectType.OOZING, "minecraft:oozing");
            this.mapping.put(ChunkerEffectType.INFESTED, "minecraft:infested");
            this.mapping.put(ChunkerEffectType.RAID_OMEN, "minecraft:raid_omen");
        }
        if (javaVersion.isGreaterThanOrEqual(1, 21, 11)) {
            this.mapping.put(ChunkerEffectType.BREATH_OF_THE_NAUTILUS, "minecraft:breath_of_the_nautilus");
        }
    }

    @Override
    public Optional<String> from(ChunkerEffectType input) {
        return Optional.ofNullable(this.mapping.forward().get((Object)input));
    }

    @Override
    public Optional<ChunkerEffectType> to(String input) {
        if (!((String)input).contains(":")) {
            input = "minecraft:" + (String)input;
        }
        return Optional.ofNullable(this.mapping.inverse().get(input));
    }
}

