/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.itemstack;

import com.google.gson.JsonElement;
import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.resolver.itemstack.ItemStackResolver;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.item.ChunkerVanillaItemType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemDisplay;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemProperty;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.enchantment.ChunkerEnchantmentType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.firework.ChunkerFireworkExplosion;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.firework.ChunkerFireworkShape;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.firework.ChunkerFireworks;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.horn.ChunkerHornInstrument;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.potion.ChunkerEffectType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.potion.ChunkerPotionType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.stew.ChunkerStewEffect;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.trim.ChunkerTrim;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.trim.ChunkerTrimMaterial;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.trim.ChunkerTrimPattern;
import com.hivemc.chunker.conversion.intermediate.column.entity.Entity;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerEntityType;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevel;
import com.hivemc.chunker.conversion.intermediate.level.map.ChunkerMap;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.array.IntArrayTag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.IntTag;
import com.hivemc.chunker.nbt.tags.primitive.ShortTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import com.hivemc.chunker.resolver.property.PropertyHandler;
import com.hivemc.chunker.util.JsonTextUtil;
import it.unimi.dsi.fastutil.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public class JavaComponentItemStackResolver
extends ItemStackResolver<JavaResolvers, CompoundTag> {
    public JavaComponentItemStackResolver(JavaResolvers resolvers) {
        super(resolvers);
    }

    @Override
    protected void registerHandlers(final JavaResolvers resolvers) {
        this.registerHandler(ChunkerItemProperty.AMOUNT, new PropertyHandler<CompoundTag, Integer>(){

            @Override
            public Optional<Integer> read(@NotNull CompoundTag value) {
                return Optional.of(value.getInt("count", 1));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull Integer count) {
                value.put("count", count);
            }
        });
        this.registerHandler(ChunkerItemProperty.DURABILITY, new PropertyHandler<CompoundTag, Integer>(){

            @Override
            public Optional<Integer> read(@NotNull CompoundTag value) {
                return value.getOptional("components", CompoundTag.class).flatMap(tag -> tag.getOptionalValue("minecraft:damage", Integer.class));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull Integer damage) {
                value.getOrCreateCompound("components").put("minecraft:damage", damage);
            }
        });
        this.registerHandler(ChunkerItemProperty.DISPLAY, new PropertyHandler<CompoundTag, ChunkerItemDisplay>(){

            @Override
            public Optional<ChunkerItemDisplay> read(@NotNull CompoundTag value) {
                CompoundTag compoundTag;
                Object dyedColor;
                CompoundTag tag = value.getCompound("components");
                if (tag == null) {
                    return Optional.empty();
                }
                List<JsonElement> lore = null;
                Color color = null;
                Object nameTag = tag.get("minecraft:custom_name");
                Object loreTag = tag.get("minecraft:lore");
                if (loreTag instanceof ListTag) {
                    ListTag loreTagList = (ListTag)loreTag;
                    lore = loreTagList.getValue().stream().map(JsonTextUtil::fromNBT).collect(Collectors.toList());
                }
                if ((dyedColor = tag.get("minecraft:dyed_color")) instanceof CompoundTag && (compoundTag = (CompoundTag)dyedColor).contains("rgb")) {
                    color = new Color(compoundTag.getInt("rgb"));
                } else if (dyedColor instanceof IntTag) {
                    IntTag intTag = (IntTag)dyedColor;
                    color = new Color(intTag.getValue());
                }
                return nameTag != null || lore != null || color != null ? Optional.of(new ChunkerItemDisplay(nameTag != null ? JsonTextUtil.fromNBT(nameTag) : null, lore, color)) : Optional.empty();
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerItemDisplay chunkerItemDisplay) {
                CompoundTag components = value.getOrCreateCompound("components");
                if (chunkerItemDisplay.displayName() != null) {
                    components.put("minecraft:custom_name", JsonTextUtil.toNBT(chunkerItemDisplay.displayName(), resolvers.dataVersion()));
                }
                if (chunkerItemDisplay.lore() != null) {
                    components.put("minecraft:lore", JsonTextUtil.toNBT(chunkerItemDisplay.lore(), 0, resolvers.dataVersion()));
                }
                if (chunkerItemDisplay.color() != null) {
                    if (resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 21, 5)) {
                        components.put("minecraft:dyed_color", chunkerItemDisplay.color().getRGB());
                    } else {
                        CompoundTag dyedColor = new CompoundTag(1);
                        dyedColor.put("rgb", chunkerItemDisplay.color().getRGB());
                        components.put("minecraft:dyed_color", dyedColor);
                    }
                }
            }
        });
        this.registerHandler(ChunkerItemProperty.CAN_PLACE_ON, new PropertyHandler<CompoundTag, List<ChunkerBlockIdentifier>>(){

            @Override
            public Optional<List<ChunkerBlockIdentifier>> read(@NotNull CompoundTag value) {
                CompoundTag tag = value.getCompound("components");
                if (tag == null) {
                    return Optional.empty();
                }
                CompoundTag component = tag.getCompound("minecraft:can_place_on");
                if (component == null) {
                    return Optional.empty();
                }
                ListTag predicates = component.getList("predicates", CompoundTag.class, null);
                if (predicates == null) {
                    return Optional.empty();
                }
                ArrayList<ChunkerBlockIdentifier> identifiers = new ArrayList<ChunkerBlockIdentifier>(predicates.size());
                for (CompoundTag predicate : predicates) {
                    ChunkerBlockIdentifier identifier;
                    String block = predicate.getString("blocks");
                    if (block == null || (identifier = resolvers.readBlockIdentifier(new Identifier(block)).copyWithout(VanillaBlockStates.WATERLOGGED)).isAir()) continue;
                    identifiers.add(identifier);
                }
                return Optional.of(identifiers);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull List<ChunkerBlockIdentifier> chunkerBlockIdentifiers) {
                ListTag predicates = new ListTag(TagType.COMPOUND, chunkerBlockIdentifiers.size());
                for (ChunkerBlockIdentifier chunkerBlockIdentifier : chunkerBlockIdentifiers) {
                    Optional<Identifier> identifier = resolvers.writeBlockIdentifier(chunkerBlockIdentifier, true);
                    if (!identifier.isPresent() || identifier.get().getIdentifier().equals("minecraft:air")) continue;
                    CompoundTag predicate = new CompoundTag(1);
                    predicate.put("blocks", identifier.get().getIdentifier());
                    predicates.add(predicate);
                }
                CompoundTag component = new CompoundTag(1);
                component.put("predicates", predicates);
                CompoundTag tag = value.getOrCreateCompound("components");
                tag.put("minecraft:can_place_on", component);
            }
        });
        this.registerHandler(ChunkerItemProperty.CAN_DESTROY, new PropertyHandler<CompoundTag, List<ChunkerBlockIdentifier>>(){

            @Override
            public Optional<List<ChunkerBlockIdentifier>> read(@NotNull CompoundTag value) {
                CompoundTag tag = value.getCompound("components");
                if (tag == null) {
                    return Optional.empty();
                }
                CompoundTag component = tag.getCompound("minecraft:can_break");
                if (component == null) {
                    return Optional.empty();
                }
                ListTag predicates = component.getList("predicates", CompoundTag.class, null);
                if (predicates == null) {
                    return Optional.empty();
                }
                ArrayList<ChunkerBlockIdentifier> identifiers = new ArrayList<ChunkerBlockIdentifier>(predicates.size());
                for (CompoundTag predicate : predicates) {
                    ChunkerBlockIdentifier identifier;
                    String block = predicate.getString("blocks");
                    if (block == null || (identifier = resolvers.readBlockIdentifier(new Identifier(block)).copyWithout(VanillaBlockStates.WATERLOGGED)).isAir()) continue;
                    identifiers.add(identifier);
                }
                return Optional.of(identifiers);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull List<ChunkerBlockIdentifier> chunkerBlockIdentifiers) {
                ListTag predicates = new ListTag(TagType.COMPOUND, chunkerBlockIdentifiers.size());
                for (ChunkerBlockIdentifier chunkerBlockIdentifier : chunkerBlockIdentifiers) {
                    Optional<Identifier> identifier = resolvers.writeBlockIdentifier(chunkerBlockIdentifier, true);
                    if (!identifier.isPresent() || identifier.get().getIdentifier().equals("minecraft:air")) continue;
                    CompoundTag predicate = new CompoundTag(1);
                    predicate.put("blocks", identifier.get().getIdentifier());
                    predicates.add(predicate);
                }
                CompoundTag component = new CompoundTag(1);
                component.put("predicates", predicates);
                CompoundTag tag = value.getOrCreateCompound("components");
                tag.put("minecraft:can_break", component);
            }
        });
        this.registerHandler(ChunkerItemProperty.REPAIR_COST, new PropertyHandler<CompoundTag, Integer>(){

            @Override
            public Optional<Integer> read(@NotNull CompoundTag value) {
                return value.getOptional("components", CompoundTag.class).flatMap(tag -> tag.getOptionalValue("minecraft:repair_cost", Integer.class));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull Integer repairCost) {
                value.getOrCreateCompound("components").put("minecraft:repair_cost", repairCost);
            }
        });
        this.registerContextualHandler(ChunkerItemProperty.ENCHANTMENTS, new PropertyHandler<Pair<ChunkerItemStack, CompoundTag>, Map<ChunkerEnchantmentType, Integer>>(){

            @Override
            public Optional<Map<ChunkerEnchantmentType, Integer>> read(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                CompoundTag tag = state.value().getCompound("components");
                if (tag == null) {
                    return Optional.empty();
                }
                String name = tag.contains("minecraft:enchantments") ? "minecraft:enchantments" : "minecraft:stored_enchantments";
                CompoundTag component = tag.getCompound(name);
                if (component == null) {
                    return Optional.empty();
                }
                CompoundTag enchantmentTags = component.getCompound("levels");
                if (enchantmentTags == null) {
                    if (resolvers.dataVersion().getVersion().isLessThan(1, 21, 5)) {
                        return Optional.empty();
                    }
                    enchantmentTags = component;
                }
                EnumMap<ChunkerEnchantmentType, Integer> enchantments = new EnumMap<ChunkerEnchantmentType, Integer>(ChunkerEnchantmentType.class);
                for (Map.Entry<String, Tag<?>> enchantment : enchantmentTags) {
                    int n;
                    String id = enchantment.getKey();
                    Optional<ChunkerEnchantmentType> enchantmentType = resolvers.enchantmentResolver().to(id);
                    if (enchantmentType.isEmpty()) {
                        resolvers.converter().logMissingMapping(Converter.MissingMappingType.ENCHANTMENT, id);
                        continue;
                    }
                    Tag<?> tag2 = enchantment.getValue();
                    if (tag2 instanceof IntTag) {
                        IntTag levelTag = (IntTag)tag2;
                        n = levelTag.getValue();
                    } else {
                        n = 1;
                    }
                    int level = n;
                    enchantments.put(enchantmentType.get(), level);
                }
                return Optional.of(enchantments);
            }

            @Override
            public void write(@NotNull Pair<ChunkerItemStack, CompoundTag> state, @NotNull Map<ChunkerEnchantmentType, Integer> value) {
                String name;
                CompoundTag enchantments = new CompoundTag(value.size());
                for (Map.Entry<ChunkerEnchantmentType, Integer> enchantment : value.entrySet()) {
                    Optional<String> id = resolvers.enchantmentResolver().from(enchantment.getKey());
                    if (id.isEmpty()) {
                        resolvers.converter().logMissingMapping(Converter.MissingMappingType.ENCHANTMENT, String.valueOf((Object)enchantment.getKey()));
                        continue;
                    }
                    enchantments.put(id.get(), enchantment.getValue());
                }
                String string = name = state.key().getIdentifier().getItemStackType() == ChunkerVanillaItemType.ENCHANTED_BOOK ? "minecraft:stored_enchantments" : "minecraft:enchantments";
                if (resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 21, 5)) {
                    state.value().getOrCreateCompound("components").put(name, enchantments);
                } else {
                    state.value().getOrCreateCompound("components").getOrCreateCompound(name).put("levels", enchantments);
                }
            }
        });
        this.registerHandler(ChunkerItemProperty.MAP_INDEX, new PropertyHandler<CompoundTag, Integer>(){

            @Override
            public Optional<Integer> read(@NotNull CompoundTag value) {
                CompoundTag tag = value.getCompound("components");
                if (tag == null) {
                    return Optional.empty();
                }
                Optional<Integer> id = tag.getOptionalValue("minecraft:map_id", Integer.class);
                if (id.isPresent() && resolvers.converter().level().isPresent()) {
                    ChunkerLevel level = resolvers.converter().level().get();
                    return level.findMapIndexByOriginalID(id.get().intValue());
                }
                return Optional.empty();
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull Integer index) {
                if (resolvers.converter().level().isPresent()) {
                    Optional<ChunkerMap> chunkerMap = resolvers.converter().level().get().getMapByIndex(index);
                    chunkerMap.ifPresent(map -> value.getOrCreateCompound("components").put("minecraft:map_id", (int)map.getId()));
                }
            }
        });
        this.registerContextualHandler(ChunkerItemProperty.SPAWN_EGG_MOB, new PropertyHandler<Pair<ChunkerItemStack, CompoundTag>, ChunkerEntityType>(){

            @Override
            public Optional<ChunkerEntityType> read(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                CompoundTag tag = state.value().getCompound("components");
                if (tag == null) {
                    return Optional.empty();
                }
                CompoundTag entityTag = tag.getCompound("minecraft:entity_data");
                if (entityTag == null) {
                    return Optional.empty();
                }
                return entityTag.getOptionalValue("id", String.class).flatMap(identifier -> {
                    Optional<ChunkerEntityType> type = resolvers.entityTypeResolver().to((String)identifier);
                    if (type.isEmpty()) {
                        resolvers.converter().logMissingMapping(Converter.MissingMappingType.ENTITY_TYPE, (String)identifier);
                        if (((ChunkerItemStack)state.key()).getIdentifier() == ChunkerVanillaItemType.SPAWN_EGG) {
                            state.key(null);
                        }
                    }
                    return type;
                });
            }

            @Override
            public void write(@NotNull Pair<ChunkerItemStack, CompoundTag> state, @NotNull ChunkerEntityType entityType) {
                Optional<String> type = resolvers.entityTypeResolver().from(entityType);
                if (type.isPresent()) {
                    CompoundTag entityTag = state.value().getOrCreateCompound("components").getOrCreateCompound("minecraft:entity_data");
                    entityTag.put("id", type.get());
                } else {
                    resolvers.converter().logMissingMapping(Converter.MissingMappingType.ENTITY_TYPE, String.valueOf(entityType));
                    if (state.key().getIdentifier() == ChunkerVanillaItemType.SPAWN_EGG) {
                        state.value(null);
                    }
                }
            }
        });
        this.registerContextualHandler(ChunkerItemProperty.BOOK_TITLE, new PropertyHandler<Pair<ChunkerItemStack, CompoundTag>, String>(){

            @Override
            public Optional<String> read(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                String componentName = state.key().getIdentifier().getItemStackType() == ChunkerVanillaItemType.WRITABLE_BOOK ? "minecraft:writable_book_content" : "minecraft:written_book_content";
                return state.value().getOptional("components", CompoundTag.class).flatMap(tag -> tag.getOptional(componentName, CompoundTag.class)).flatMap(tag -> tag.getOptional("title", CompoundTag.class)).flatMap(tag -> tag.getOptionalValue("raw", String.class));
            }

            @Override
            public void write(@NotNull Pair<ChunkerItemStack, CompoundTag> state, @NotNull String title) {
                String componentName = state.key().getIdentifier().getItemStackType() == ChunkerVanillaItemType.WRITABLE_BOOK ? "minecraft:writable_book_content" : "minecraft:written_book_content";
                CompoundTag tag = state.value().getOrCreateCompound("components").getOrCreateCompound(componentName).getOrCreateCompound("title");
                tag.put("raw", title);
            }
        });
        this.registerContextualHandler(ChunkerItemProperty.BOOK_AUTHOR, new PropertyHandler<Pair<ChunkerItemStack, CompoundTag>, String>(){

            @Override
            public Optional<String> read(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                String componentName = state.key().getIdentifier().getItemStackType() == ChunkerVanillaItemType.WRITABLE_BOOK ? "minecraft:writable_book_content" : "minecraft:written_book_content";
                return state.value().getOptional("components", CompoundTag.class).flatMap(tag -> tag.getOptional(componentName, CompoundTag.class)).flatMap(tag -> tag.getOptionalValue("author", String.class));
            }

            @Override
            public void write(@NotNull Pair<ChunkerItemStack, CompoundTag> state, @NotNull String author) {
                String componentName = state.key().getIdentifier().getItemStackType() == ChunkerVanillaItemType.WRITABLE_BOOK ? "minecraft:writable_book_content" : "minecraft:written_book_content";
                CompoundTag tag = state.value().getOrCreateCompound("components").getOrCreateCompound(componentName);
                tag.put("author", author);
            }
        });
        this.registerContextualHandler(ChunkerItemProperty.BOOK_PAGES, new PropertyHandler<Pair<ChunkerItemStack, CompoundTag>, List<JsonElement>>(){

            @Override
            public Optional<List<JsonElement>> read(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                CompoundTag tag = state.right().getCompound("components");
                if (tag == null) {
                    return Optional.empty();
                }
                String componentName = state.key().getIdentifier().getItemStackType() == ChunkerVanillaItemType.WRITABLE_BOOK ? "minecraft:writable_book_content" : "minecraft:written_book_content";
                CompoundTag component = tag.getCompound(componentName);
                if (component == null) {
                    return Optional.empty();
                }
                ListTag pages = component.getList("pages", CompoundTag.class, null);
                if (pages == null) {
                    return Optional.empty();
                }
                ArrayList<JsonElement> pagesJSON = new ArrayList<JsonElement>(pages.size());
                for (CompoundTag page : pages) {
                    Object rawTag = page.get("raw");
                    if (state.key().getIdentifier().getItemStackType() == ChunkerVanillaItemType.WRITABLE_BOOK) {
                        if (rawTag instanceof StringTag) {
                            StringTag stringTag = (StringTag)rawTag;
                            pagesJSON.add(JsonTextUtil.fromText(stringTag.getValue()));
                            continue;
                        }
                        pagesJSON.add(JsonTextUtil.EMPTY_TEXT_TAG);
                        continue;
                    }
                    pagesJSON.add(JsonTextUtil.fromNBT(rawTag));
                }
                return Optional.of(pagesJSON);
            }

            @Override
            public void write(@NotNull Pair<ChunkerItemStack, CompoundTag> state, @NotNull List<JsonElement> pagesJSON) {
                String componentName = state.key().getIdentifier().getItemStackType() == ChunkerVanillaItemType.WRITABLE_BOOK ? "minecraft:writable_book_content" : "minecraft:written_book_content";
                CompoundTag tag = state.right().getOrCreateCompound("components").getOrCreateCompound(componentName);
                ListTag pages = new ListTag(TagType.COMPOUND, pagesJSON.size());
                for (JsonElement pageJSON : pagesJSON) {
                    CompoundTag page = new CompoundTag(1);
                    if (state.key().getIdentifier().getItemStackType() == ChunkerVanillaItemType.WRITABLE_BOOK) {
                        page.put("raw", new StringTag(JsonTextUtil.toLegacy(pageJSON, false)));
                    } else {
                        page.put("raw", JsonTextUtil.toNBT(pageJSON, resolvers.dataVersion()));
                    }
                    pages.add(page);
                }
                tag.put("pages", pages);
            }
        });
        this.registerHandler(ChunkerItemProperty.HORN_INSTRUMENT, new PropertyHandler<CompoundTag, ChunkerHornInstrument>(){

            @Override
            public Optional<ChunkerHornInstrument> read(@NotNull CompoundTag value) {
                return value.getOptional("components", CompoundTag.class).flatMap(tag -> tag.getOptional("minecraft:instrument", Tag.class)).flatMap(tag -> {
                    String string;
                    if (tag instanceof StringTag) {
                        StringTag stringTag = (StringTag)tag;
                        string = stringTag.getBoxedValue();
                    } else {
                        string = null;
                    }
                    return Optional.ofNullable(string);
                }).map(resolvers::readHornInstrument);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerHornInstrument hornInstrument) {
                CompoundTag tag = value.getOrCreateCompound("components");
                tag.put("minecraft:instrument", resolvers.writeHornInstrument(hornInstrument));
            }
        });
        this.registerHandler(ChunkerItemProperty.POTION, new PropertyHandler<CompoundTag, ChunkerPotionType>(){

            @Override
            public Optional<ChunkerPotionType> read(@NotNull CompoundTag value) {
                return value.getOptional("components", CompoundTag.class).flatMap(tag -> tag.getOptional("minecraft:potion_contents", CompoundTag.class)).flatMap(tag -> tag.getOptionalValue("potion", String.class)).map(resolvers::readPotionType);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerPotionType potionType) {
                CompoundTag tag = value.getOrCreateCompound("components").getOrCreateCompound("minecraft:potion_contents");
                tag.put("potion", resolvers.writePotionType(potionType));
            }
        });
        this.registerHandler(ChunkerItemProperty.TRIM, new PropertyHandler<CompoundTag, ChunkerTrim>(){

            @Override
            public Optional<ChunkerTrim> read(@NotNull CompoundTag value) {
                Optional trim = value.getOptional("components", CompoundTag.class).flatMap(tag -> tag.getOptional("minecraft:trim", CompoundTag.class));
                if (trim.isEmpty()) {
                    return Optional.empty();
                }
                Optional trimPattern = ((CompoundTag)trim.get()).getOptionalValue("pattern", String.class).flatMap(identifier -> {
                    Optional<ChunkerTrimPattern> result = resolvers.trimPatternResolver().to((String)identifier);
                    if (result.isEmpty()) {
                        resolvers.converter().logMissingMapping(Converter.MissingMappingType.TRIM_PATTERN, (String)identifier);
                    }
                    return result;
                });
                if (trimPattern.isEmpty()) {
                    return Optional.empty();
                }
                Optional trimMaterial = ((CompoundTag)trim.get()).getOptionalValue("material", String.class).flatMap(identifier -> {
                    Optional<ChunkerTrimMaterial> result = resolvers.trimMaterialResolver().to((String)identifier);
                    if (result.isEmpty()) {
                        resolvers.converter().logMissingMapping(Converter.MissingMappingType.TRIM_MATERIAL, (String)identifier);
                    }
                    return result;
                });
                if (trimMaterial.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(new ChunkerTrim((ChunkerTrimMaterial)((Object)trimMaterial.get()), (ChunkerTrimPattern)((Object)trimPattern.get())));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerTrim chunkerTrim) {
                Optional<String> trimPattern = resolvers.trimPatternResolver().from(chunkerTrim.getPattern());
                if (trimPattern.isEmpty()) {
                    resolvers.converter().logMissingMapping(Converter.MissingMappingType.TRIM_PATTERN, String.valueOf((Object)chunkerTrim.getPattern()));
                    return;
                }
                Optional<String> trimMaterial = resolvers.trimMaterialResolver().from(chunkerTrim.getMaterial());
                if (trimMaterial.isEmpty()) {
                    resolvers.converter().logMissingMapping(Converter.MissingMappingType.TRIM_MATERIAL, String.valueOf((Object)chunkerTrim.getMaterial()));
                    return;
                }
                CompoundTag tag = value.getOrCreateCompound("components").getOrCreateCompound("minecraft:trim");
                tag.put("material", trimMaterial.get());
                tag.put("pattern", trimPattern.get());
            }
        });
        this.registerHandler(ChunkerItemProperty.STEW_EFFECT, new PropertyHandler<CompoundTag, ChunkerStewEffect>(){

            @Override
            public Optional<ChunkerStewEffect> read(@NotNull CompoundTag value) {
                Optional component = value.getOptional("components", CompoundTag.class).flatMap(tag -> Optional.ofNullable(tag.getList("minecraft:suspicious_stew_effects", CompoundTag.class, null)));
                if (component.isEmpty()) {
                    return Optional.empty();
                }
                ListTag effectTags = (ListTag)component.get();
                EnumMap<ChunkerEffectType, Integer> effectDurationMap = new EnumMap<ChunkerEffectType, Integer>(ChunkerEffectType.class);
                for (CompoundTag effectTag : effectTags) {
                    ChunkerEffectType effectType = resolvers.readEffect(effectTag.getString("id", null));
                    if (effectType == ChunkerEffectType.EMPTY) continue;
                    int duration = effectTag.getInt("duration", 160);
                    effectDurationMap.put(effectType, duration);
                }
                return Optional.of(new ChunkerStewEffect(effectDurationMap));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerStewEffect chunkerStewEffect) {
                if (chunkerStewEffect.getEffects().isEmpty()) {
                    return;
                }
                ListTag effectTags = new ListTag(TagType.COMPOUND, chunkerStewEffect.getEffects().size());
                for (Map.Entry<ChunkerEffectType, Integer> effect : chunkerStewEffect.getEffects().entrySet()) {
                    String id = resolvers.writeEffect(effect.getKey());
                    CompoundTag effectTag = new CompoundTag(2);
                    effectTag.put("duration", effect.getValue());
                    effectTag.put("id", id);
                    effectTags.add(effectTag);
                }
                value.getOrCreateCompound("components").put("minecraft:suspicious_stew_effects", effectTags);
            }
        });
        this.registerHandler(ChunkerItemProperty.FIREWORKS, new PropertyHandler<CompoundTag, ChunkerFireworks>(){

            @Override
            public Optional<ChunkerFireworks> read(@NotNull CompoundTag value) {
                Optional component = value.getOptional("components", CompoundTag.class).flatMap(tag -> tag.getOptional("minecraft:fireworks", CompoundTag.class));
                if (component.isEmpty()) {
                    return Optional.empty();
                }
                byte duration = ((CompoundTag)component.get()).getByte("flight_duration", (byte)1);
                List<ChunkerFireworkExplosion> explosions = Collections.emptyList();
                ListTag explosionsTag = ((CompoundTag)component.get()).getList("explosions", CompoundTag.class, null);
                if (explosionsTag != null) {
                    explosions = new ArrayList<ChunkerFireworkExplosion>(explosionsTag.size());
                    for (CompoundTag explosionTag : explosionsTag) {
                        ChunkerFireworkShape shape = explosionTag.getOptionalValue("shape", String.class).flatMap(ChunkerFireworkShape::getByName).orElse(ChunkerFireworkShape.SMALL_BALL);
                        Object colorsTag = explosionTag.get("colors");
                        List<Color> colors = Collections.emptyList();
                        if (colorsTag instanceof ListTag) {
                            ListTag colorsTagList = (ListTag)colorsTag;
                            colors = StreamSupport.stream(colorsTagList.spliterator(), false).mapToInt(colorsTagInt -> (Integer)colorsTagInt.getBoxedValue()).mapToObj(Color::new).toList();
                        } else if (colorsTag instanceof IntArrayTag) {
                            IntArrayTag colorsArrayTag = (IntArrayTag)colorsTag;
                            colors = IntStream.of(colorsArrayTag.getBoxedValue()).mapToObj(Color::new).toList();
                        }
                        Object fadeColorsTag = explosionTag.get("fade_colors");
                        List<Color> fadeColors = Collections.emptyList();
                        if (fadeColorsTag instanceof ListTag) {
                            ListTag fadeColorsTagList = (ListTag)fadeColorsTag;
                            fadeColors = StreamSupport.stream(fadeColorsTagList.spliterator(), false).mapToInt(colorsTagInt -> (Integer)colorsTagInt.getBoxedValue()).mapToObj(Color::new).toList();
                        } else if (fadeColorsTag instanceof IntArrayTag) {
                            IntArrayTag fadeColorsArrayTag = (IntArrayTag)fadeColorsTag;
                            fadeColors = IntStream.of(fadeColorsArrayTag.getBoxedValue()).mapToObj(Color::new).toList();
                        }
                        boolean trail = explosionTag.getByte("has_trail", (byte)0) == 1;
                        boolean twinkle = explosionTag.getByte("has_twinkle", (byte)0) == 1;
                        explosions.add(new ChunkerFireworkExplosion(shape, colors, fadeColors, trail, twinkle));
                    }
                }
                return Optional.of(new ChunkerFireworks(duration, explosions));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerFireworks chunkerFireworks) {
                if (chunkerFireworks.getExplosions().isEmpty() && chunkerFireworks.getFlightDuration() == 0) {
                    return;
                }
                CompoundTag tag = value.getOrCreateCompound("components").getOrCreateCompound("minecraft:fireworks");
                tag.put("flight_duration", chunkerFireworks.getFlightDuration());
                if (!chunkerFireworks.getExplosions().isEmpty()) {
                    ListTag explosions = new ListTag(TagType.COMPOUND, chunkerFireworks.getExplosions().size());
                    for (ChunkerFireworkExplosion chunkerFireworkExplosion : chunkerFireworks.getExplosions()) {
                        CompoundTag explosion = new CompoundTag(5);
                        explosion.put("shape", chunkerFireworkExplosion.getShape().getName());
                        if (resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 21, 5)) {
                            explosion.put("colors", new ListTag<IntTag, Integer>(TagType.INT, chunkerFireworkExplosion.getColors().stream().map(color -> new IntTag(color.getRGB() & 0xFFFFFF)).toList()));
                            explosion.put("fade_colors", new ListTag<IntTag, Integer>(TagType.INT, chunkerFireworkExplosion.getFadeColors().stream().map(color -> new IntTag(color.getRGB() & 0xFFFFFF)).toList()));
                        } else {
                            explosion.put("colors", chunkerFireworkExplosion.getColors().stream().mapToInt(Color::getRGB).map(argb -> argb & 0xFFFFFF).toArray());
                            explosion.put("fade_colors", chunkerFireworkExplosion.getFadeColors().stream().mapToInt(Color::getRGB).map(argb -> argb & 0xFFFFFF).toArray());
                        }
                        explosion.put("has_trail", chunkerFireworkExplosion.isTrail() ? (byte)1 : 0);
                        explosion.put("has_twinkle", chunkerFireworkExplosion.isTwinkle() ? (byte)1 : 0);
                        explosions.add(explosion);
                    }
                    tag.put("explosions", explosions);
                }
            }
        });
        this.registerHandler(ChunkerItemProperty.FIREWORK_EXPLOSION, new PropertyHandler<CompoundTag, ChunkerFireworkExplosion>(){

            @Override
            public Optional<ChunkerFireworkExplosion> read(@NotNull CompoundTag value) {
                Optional component = value.getOptional("components", CompoundTag.class).flatMap(tag -> tag.getOptional("minecraft:firework_explosion", CompoundTag.class));
                if (component.isEmpty()) {
                    return Optional.empty();
                }
                CompoundTag explosionTag = (CompoundTag)component.get();
                ChunkerFireworkShape shape = explosionTag.getOptionalValue("shape", String.class).flatMap(ChunkerFireworkShape::getByName).orElse(ChunkerFireworkShape.SMALL_BALL);
                Object colorsTag = explosionTag.get("colors");
                List<Color> colors = Collections.emptyList();
                if (colorsTag instanceof ListTag) {
                    ListTag colorsTagList = (ListTag)colorsTag;
                    colors = StreamSupport.stream(colorsTagList.spliterator(), false).mapToInt(colorsTagInt -> (Integer)colorsTagInt.getBoxedValue()).mapToObj(Color::new).toList();
                } else if (colorsTag instanceof IntArrayTag) {
                    IntArrayTag colorsArrayTag = (IntArrayTag)colorsTag;
                    colors = IntStream.of(colorsArrayTag.getBoxedValue()).mapToObj(Color::new).toList();
                }
                Object fadeColorsTag = explosionTag.get("fade_colors");
                List<Color> fadeColors = Collections.emptyList();
                if (fadeColorsTag instanceof ListTag) {
                    ListTag fadeColorsTagList = (ListTag)fadeColorsTag;
                    fadeColors = StreamSupport.stream(fadeColorsTagList.spliterator(), false).mapToInt(colorsTagInt -> (Integer)colorsTagInt.getBoxedValue()).mapToObj(Color::new).toList();
                } else if (fadeColorsTag instanceof IntArrayTag) {
                    IntArrayTag fadeColorsArrayTag = (IntArrayTag)fadeColorsTag;
                    fadeColors = IntStream.of(fadeColorsArrayTag.getBoxedValue()).mapToObj(Color::new).toList();
                }
                boolean trail = explosionTag.getByte("has_trail", (byte)0) == 1;
                boolean twinkle = explosionTag.getByte("has_twinkle", (byte)0) == 1;
                return Optional.of(new ChunkerFireworkExplosion(shape, colors, fadeColors, trail, twinkle));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerFireworkExplosion chunkerFireworkExplosion) {
                CompoundTag explosion = value.getOrCreateCompound("components").getOrCreateCompound("minecraft:firework_explosion");
                explosion.put("shape", chunkerFireworkExplosion.getShape().getName());
                if (resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 21, 5)) {
                    explosion.put("colors", new ListTag<IntTag, Integer>(TagType.INT, chunkerFireworkExplosion.getColors().stream().map(color -> new IntTag(color.getRGB() & 0xFFFFFF)).toList()));
                    explosion.put("fade_colors", new ListTag<IntTag, Integer>(TagType.INT, chunkerFireworkExplosion.getFadeColors().stream().map(color -> new IntTag(color.getRGB() & 0xFFFFFF)).toList()));
                } else {
                    explosion.put("colors", chunkerFireworkExplosion.getColors().stream().mapToInt(Color::getRGB).map(argb -> argb & 0xFFFFFF).toArray());
                    explosion.put("fade_colors", chunkerFireworkExplosion.getFadeColors().stream().mapToInt(Color::getRGB).map(argb -> argb & 0xFFFFFF).toArray());
                }
                explosion.put("has_trail", chunkerFireworkExplosion.isTrail() ? (byte)1 : 0);
                explosion.put("has_twinkle", chunkerFireworkExplosion.isTwinkle() ? (byte)1 : 0);
            }
        });
        this.registerHandler(ChunkerItemProperty.OMINOUS_BOTTLE_AMPLIFIER, new PropertyHandler<CompoundTag, Integer>(){

            @Override
            public Optional<Integer> read(@NotNull CompoundTag value) {
                return value.getOptional("components", CompoundTag.class).flatMap(tag -> tag.getOptionalValue("minecraft:ominous_bottle_amplifier", Integer.class));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull Integer repairCost) {
                value.getOrCreateCompound("components").put("minecraft:ominous_bottle_amplifier", repairCost);
            }
        });
        this.registerHandler(ChunkerItemProperty.BUNDLE_CONTENTS, new PropertyHandler<CompoundTag, List<ChunkerItemStack>>(){

            @Override
            public Optional<List<ChunkerItemStack>> read(@NotNull CompoundTag value) {
                Optional component = value.getOptional("components", CompoundTag.class).flatMap(tag -> tag.getOptionalList("minecraft:bundle_contents", CompoundTag.class));
                if (component.isEmpty()) {
                    return Optional.empty();
                }
                ListTag items = (ListTag)component.get();
                ArrayList<ChunkerItemStack> bundleContents = new ArrayList<ChunkerItemStack>(items.size());
                for (CompoundTag itemTag : items) {
                    ChunkerItemStack item = resolvers.readItem(itemTag);
                    if (item.getIdentifier().isAir()) continue;
                    bundleContents.add(item);
                }
                return Optional.of(bundleContents);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull List<ChunkerItemStack> bundleContents) {
                ListTag items = new ListTag(TagType.COMPOUND, bundleContents.size());
                for (ChunkerItemStack item : bundleContents) {
                    Optional<CompoundTag> itemTag;
                    if (item.getIdentifier().isAir() || (itemTag = resolvers.writeItem(item)).isEmpty()) continue;
                    items.add(itemTag.get());
                }
                value.getOrCreateCompound("components").put("minecraft:bundle_contents", items);
            }
        });
        this.registerContextualHandler(ChunkerItemProperty.ENTITY, new PropertyHandler<Pair<ChunkerItemStack, CompoundTag>, Entity>(){

            @Override
            public Optional<Entity> read(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                CompoundTag tag = state.value().getCompound("components");
                if (tag == null) {
                    return Optional.empty();
                }
                CompoundTag entityTag = tag.getCompound("minecraft:entity_data");
                Optional<Entity> generated = Optional.empty();
                if (entityTag != null) {
                    generated = resolvers.entityResolver().to(entityTag);
                }
                return generated;
            }

            @Override
            public void write(@NotNull Pair<ChunkerItemStack, CompoundTag> state, @NotNull Entity value) {
                Optional<CompoundTag> entityTag = resolvers.entityResolver().from(value);
                if (entityTag.isPresent()) {
                    CompoundTag tag = entityTag.get();
                    tag.remove("block_pos");
                    tag.remove("TileX");
                    tag.remove("TileY");
                    tag.remove("TileZ");
                    tag.remove("Pos");
                    tag.remove("Motion");
                    tag.remove("Rotation");
                    tag.remove("Rot");
                    tag.remove("facing");
                    tag.remove("Facing");
                    state.value().getOrCreateCompound("components").put("minecraft:entity_data", tag);
                }
            }
        });
        this.registerContextualHandler(ChunkerItemProperty.BLOCK_ENTITY, new PropertyHandler<Pair<ChunkerItemStack, CompoundTag>, BlockEntity>(){

            @Override
            public Optional<BlockEntity> read(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                CompoundTag tag = state.value().getCompound("components");
                if (tag == null) {
                    return Optional.empty();
                }
                Optional<Class<BlockEntity>> blockEntityClass = resolvers.blockEntityResolver().getBlockEntityClass(state.key().getIdentifier().getItemStackType());
                if (blockEntityClass.isEmpty()) {
                    return Optional.empty();
                }
                CompoundTag blockEntityTag = tag.getCompound("minecraft:block_entity_data");
                Optional<Object> generated = Optional.empty();
                if (blockEntityTag != null) {
                    generated = resolvers.blockEntityResolver().to(blockEntityClass.get(), blockEntityTag);
                }
                generated = resolvers.blockEntityResolver().generateFromItemNBT(blockEntityClass.get(), state.key(), generated.orElse(null), state.value());
                return generated.map(blockEntity -> resolvers.blockEntityResolver().updateBeforeProcess((CompoundTag)state.value(), (ChunkerItemStack)state.key(), blockEntity));
            }

            @Override
            public void write(@NotNull Pair<ChunkerItemStack, CompoundTag> state, @NotNull BlockEntity value) {
                Optional<CompoundTag> blockEntityTag;
                value = resolvers.blockEntityResolver().updateBeforeWrite(state.value(), state.key(), value);
                boolean writeBlockEntityData = resolvers.blockEntityResolver().writeToItemNBT(state.key(), value, state.value());
                if (writeBlockEntityData && (blockEntityTag = resolvers.blockEntityResolver().from(value)).isPresent()) {
                    CompoundTag tag = blockEntityTag.get();
                    tag.remove("x");
                    tag.remove("y");
                    tag.remove("z");
                    tag.remove("Rotation");
                    tag.remove("Rot");
                    tag.remove("facing");
                    tag.remove("Facing");
                    state.value().getOrCreateCompound("components").put("minecraft:block_entity_data", tag);
                }
            }
        });
    }

    @Override
    protected Optional<ChunkerItemStack> createPropertyHolder(CompoundTag input) {
        OptionalInt damage;
        Object damageTag = input.get("Damage");
        if (damageTag instanceof IntTag) {
            IntTag intTag = (IntTag)damageTag;
            damage = OptionalInt.of(intTag.getValue());
        } else if (damageTag instanceof ShortTag) {
            ShortTag shortTag = (ShortTag)damageTag;
            damage = OptionalInt.of(shortTag.getValue());
        } else {
            damage = OptionalInt.of(0);
        }
        Identifier identifier = Identifier.fromData(input.getString("id"), damage);
        return Optional.of(((JavaResolvers)this.resolvers).readItemIdentifier(identifier));
    }

    @Override
    protected Optional<CompoundTag> createOutput(ChunkerItemStack input) {
        CompoundTag output = new CompoundTag(2);
        Optional<Identifier> itemIdentifier = ((JavaResolvers)this.resolvers).chunkerItemIdentifierResolver().from(input);
        if (itemIdentifier.isPresent()) {
            output.put("id", itemIdentifier.get().getIdentifier());
            if (itemIdentifier.get().getDataValue().isPresent()) {
                output.put("Damage", itemIdentifier.get().getDataValue().getAsInt());
            }
            return Optional.of(output);
        }
        ChunkerItemStackIdentifier chunkerItemStackIdentifier = input.getIdentifier();
        if (chunkerItemStackIdentifier instanceof ChunkerBlockIdentifier) {
            ChunkerBlockIdentifier chunkerBlockIdentifier = (ChunkerBlockIdentifier)chunkerItemStackIdentifier;
            Optional<Identifier> blockIdentifier = ((JavaResolvers)this.resolvers).writeBlockIdentifier(chunkerBlockIdentifier, false);
            if (blockIdentifier.isEmpty()) {
                return Optional.empty();
            }
            output.put("id", blockIdentifier.get().getIdentifier());
            return Optional.of(output);
        }
        return Optional.empty();
    }
}

