/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.entity;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerCustomEntityType;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerEntityType;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerVanillaEntityType;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class JavaEntityTypeResolver
implements Resolver<String, ChunkerEntityType> {
    private final InvertibleMap<ChunkerVanillaEntityType, String> mapping = InvertibleMap.enumKeys(ChunkerVanillaEntityType.class);
    private final boolean customIdentifierSupported;

    public JavaEntityTypeResolver(Version version, boolean customIdentifierSupported) {
        this.customIdentifierSupported = customIdentifierSupported;
        this.mapping.put(ChunkerVanillaEntityType.AREA_EFFECT_CLOUD, "minecraft:area_effect_cloud");
        this.mapping.put(ChunkerVanillaEntityType.ARMOR_STAND, "minecraft:armor_stand");
        this.mapping.put(ChunkerVanillaEntityType.ARROW, "minecraft:arrow");
        this.mapping.put(ChunkerVanillaEntityType.BAT, "minecraft:bat");
        this.mapping.put(ChunkerVanillaEntityType.BLAZE, "minecraft:blaze");
        this.mapping.put(ChunkerVanillaEntityType.OAK_BOAT, "minecraft:boat");
        this.mapping.put(ChunkerVanillaEntityType.CAVE_SPIDER, "minecraft:cave_spider");
        this.mapping.put(ChunkerVanillaEntityType.OAK_CHEST_BOAT, "minecraft:chest_boat");
        this.mapping.put(ChunkerVanillaEntityType.CHEST_MINECART, "minecraft:chest_minecart");
        this.mapping.put(ChunkerVanillaEntityType.CHICKEN, "minecraft:chicken");
        this.mapping.put(ChunkerVanillaEntityType.COMMAND_BLOCK_MINECART, "minecraft:commandblock_minecart");
        this.mapping.put(ChunkerVanillaEntityType.COW, "minecraft:cow");
        this.mapping.put(ChunkerVanillaEntityType.CREEPER, "minecraft:creeper");
        this.mapping.put(ChunkerVanillaEntityType.DONKEY, "minecraft:donkey");
        this.mapping.put(ChunkerVanillaEntityType.DRAGON_FIREBALL, "minecraft:dragon_fireball");
        this.mapping.put(ChunkerVanillaEntityType.EGG, "minecraft:egg");
        this.mapping.put(ChunkerVanillaEntityType.ELDER_GUARDIAN, "minecraft:elder_guardian");
        this.mapping.put(ChunkerVanillaEntityType.END_CRYSTAL, "minecraft:ender_crystal");
        this.mapping.put(ChunkerVanillaEntityType.ENDER_DRAGON, "minecraft:ender_dragon");
        this.mapping.put(ChunkerVanillaEntityType.ENDER_PEARL, "minecraft:ender_pearl");
        this.mapping.put(ChunkerVanillaEntityType.ENDERMAN, "minecraft:enderman");
        this.mapping.put(ChunkerVanillaEntityType.ENDERMITE, "minecraft:endermite");
        this.mapping.put(ChunkerVanillaEntityType.EXPERIENCE_BOTTLE, "minecraft:xp_bottle");
        this.mapping.put(ChunkerVanillaEntityType.EXPERIENCE_ORB, "minecraft:xp_orb");
        this.mapping.put(ChunkerVanillaEntityType.EYE_OF_ENDER, "minecraft:eye_of_ender_signal");
        this.mapping.put(ChunkerVanillaEntityType.FALLING_BLOCK, "minecraft:falling_block");
        this.mapping.put(ChunkerVanillaEntityType.FIREWORK_ROCKET, "minecraft:fireworks_rocket");
        this.mapping.put(ChunkerVanillaEntityType.FURNACE_MINECART, "minecraft:furnace_minecart");
        this.mapping.put(ChunkerVanillaEntityType.GHAST, "minecraft:ghast");
        this.mapping.put(ChunkerVanillaEntityType.GIANT, "minecraft:giant");
        this.mapping.put(ChunkerVanillaEntityType.GUARDIAN, "minecraft:guardian");
        this.mapping.put(ChunkerVanillaEntityType.HOPPER_MINECART, "minecraft:hopper_minecart");
        this.mapping.put(ChunkerVanillaEntityType.HORSE, "minecraft:horse");
        this.mapping.put(ChunkerVanillaEntityType.IRON_GOLEM, "minecraft:villager_golem");
        this.mapping.put(ChunkerVanillaEntityType.ITEM, "minecraft:item");
        this.mapping.put(ChunkerVanillaEntityType.ITEM_FRAME, "minecraft:item_frame");
        this.mapping.put(ChunkerVanillaEntityType.FIREBALL, "minecraft:fireball");
        this.mapping.put(ChunkerVanillaEntityType.LEASH_KNOT, "minecraft:leash_knot");
        this.mapping.put(ChunkerVanillaEntityType.LIGHTNING_BOLT, "minecraft:lightning_bolt");
        this.mapping.put(ChunkerVanillaEntityType.MAGMA_CUBE, "minecraft:magma_cube");
        this.mapping.put(ChunkerVanillaEntityType.MARKER, "minecraft:marker");
        this.mapping.put(ChunkerVanillaEntityType.MINECART, "minecraft:minecart");
        this.mapping.put(ChunkerVanillaEntityType.MOOSHROOM, "minecraft:mooshroom");
        this.mapping.put(ChunkerVanillaEntityType.MULE, "minecraft:mule");
        this.mapping.put(ChunkerVanillaEntityType.OCELOT, "minecraft:ocelot");
        this.mapping.put(ChunkerVanillaEntityType.PAINTING, "minecraft:painting");
        this.mapping.put(ChunkerVanillaEntityType.PIG, "minecraft:pig");
        this.mapping.put(ChunkerVanillaEntityType.POTION, "minecraft:potion");
        this.mapping.put(ChunkerVanillaEntityType.RABBIT, "minecraft:rabbit");
        this.mapping.put(ChunkerVanillaEntityType.SHEEP, "minecraft:sheep");
        this.mapping.put(ChunkerVanillaEntityType.SILVERFISH, "minecraft:silverfish");
        this.mapping.put(ChunkerVanillaEntityType.SKELETON, "minecraft:skeleton");
        this.mapping.put(ChunkerVanillaEntityType.SKELETON_HORSE, "minecraft:skeleton_horse");
        this.mapping.put(ChunkerVanillaEntityType.SLIME, "minecraft:slime");
        this.mapping.put(ChunkerVanillaEntityType.SMALL_FIREBALL, "minecraft:small_fireball");
        this.mapping.put(ChunkerVanillaEntityType.SNOW_GOLEM, "minecraft:snowman");
        this.mapping.put(ChunkerVanillaEntityType.SNOWBALL, "minecraft:snowball");
        this.mapping.put(ChunkerVanillaEntityType.SPAWNER_MINECART, "minecraft:spawner_minecart");
        this.mapping.put(ChunkerVanillaEntityType.SPECTRAL_ARROW, "minecraft:spectral_arrow");
        this.mapping.put(ChunkerVanillaEntityType.SPIDER, "minecraft:spider");
        this.mapping.put(ChunkerVanillaEntityType.SQUID, "minecraft:squid");
        this.mapping.put(ChunkerVanillaEntityType.TNT, "minecraft:tnt");
        this.mapping.put(ChunkerVanillaEntityType.TNT_MINECART, "minecraft:tnt_minecart");
        this.mapping.put(ChunkerVanillaEntityType.TRIDENT, "minecraft:trident");
        this.mapping.put(ChunkerVanillaEntityType.VILLAGER, "minecraft:villager");
        this.mapping.put(ChunkerVanillaEntityType.WITCH, "minecraft:witch");
        this.mapping.put(ChunkerVanillaEntityType.WITHER, "minecraft:wither");
        this.mapping.put(ChunkerVanillaEntityType.WITHER_SKELETON, "minecraft:wither_skeleton");
        this.mapping.put(ChunkerVanillaEntityType.WITHER_SKULL, "minecraft:wither_skull");
        this.mapping.put(ChunkerVanillaEntityType.WOLF, "minecraft:wolf");
        this.mapping.put(ChunkerVanillaEntityType.ZOMBIE, "minecraft:zombie");
        this.mapping.put(ChunkerVanillaEntityType.ZOMBIE_HORSE, "minecraft:zombie_horse");
        this.mapping.put(ChunkerVanillaEntityType.ZOMBIFIED_PIGLIN, "minecraft:zombie_pigman");
        this.mapping.put(ChunkerVanillaEntityType.ZOMBIE_VILLAGER, "minecraft:zombie_villager");
        this.mapping.put(ChunkerVanillaEntityType.PLAYER, "minecraft:player");
        this.mapping.put(ChunkerVanillaEntityType.FISHING_BOBBER, "minecraft:fishing_bobber");
        if (version.isGreaterThanOrEqual(1, 9, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.SHULKER, "minecraft:shulker");
            this.mapping.put(ChunkerVanillaEntityType.SHULKER_BULLET, "minecraft:shulker_bullet");
        }
        if (version.isGreaterThanOrEqual(1, 10, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.HUSK, "minecraft:husk");
            this.mapping.put(ChunkerVanillaEntityType.POLAR_BEAR, "minecraft:polar_bear");
            this.mapping.put(ChunkerVanillaEntityType.STRAY, "minecraft:stray");
        }
        if (version.isGreaterThanOrEqual(1, 11, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.LLAMA, "minecraft:llama");
            this.mapping.put(ChunkerVanillaEntityType.LLAMA_SPIT, "minecraft:llama_spit");
            this.mapping.put(ChunkerVanillaEntityType.VINDICATOR, "minecraft:vindication_illager");
            this.mapping.put(ChunkerVanillaEntityType.EVOKER, "minecraft:evocation_illager");
            this.mapping.put(ChunkerVanillaEntityType.EVOKER_FANGS, "minecraft:evocation_fangs");
            this.mapping.put(ChunkerVanillaEntityType.VEX, "minecraft:vex");
        }
        if (version.isGreaterThanOrEqual(1, 12, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.PARROT, "minecraft:parrot");
            this.mapping.put(ChunkerVanillaEntityType.ILLUSIONER, "minecraft:illusion_illager");
        }
        if (version.isGreaterThanOrEqual(1, 13, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.COMMAND_BLOCK_MINECART, "minecraft:command_block_minecart");
            this.mapping.put(ChunkerVanillaEntityType.END_CRYSTAL, "minecraft:end_crystal");
            this.mapping.put(ChunkerVanillaEntityType.SNOW_GOLEM, "minecraft:snow_golem");
            this.mapping.put(ChunkerVanillaEntityType.EVOKER, "minecraft:evoker");
            this.mapping.put(ChunkerVanillaEntityType.EVOKER_FANGS, "minecraft:evoker_fangs");
            this.mapping.put(ChunkerVanillaEntityType.ILLUSIONER, "minecraft:illusioner");
            this.mapping.put(ChunkerVanillaEntityType.VINDICATOR, "minecraft:vindicator");
            this.mapping.put(ChunkerVanillaEntityType.IRON_GOLEM, "minecraft:iron_golem");
            this.mapping.put(ChunkerVanillaEntityType.EXPERIENCE_ORB, "minecraft:experience_orb");
            this.mapping.put(ChunkerVanillaEntityType.EXPERIENCE_BOTTLE, "minecraft:experience_bottle");
            this.mapping.put(ChunkerVanillaEntityType.EYE_OF_ENDER, "minecraft:eye_of_ender");
            this.mapping.put(ChunkerVanillaEntityType.FIREWORK_ROCKET, "minecraft:firework_rocket");
            this.mapping.put(ChunkerVanillaEntityType.PHANTOM, "minecraft:phantom");
            this.mapping.put(ChunkerVanillaEntityType.TURTLE, "minecraft:turtle");
            this.mapping.put(ChunkerVanillaEntityType.COD, "minecraft:cod");
            this.mapping.put(ChunkerVanillaEntityType.SALMON, "minecraft:salmon");
            this.mapping.put(ChunkerVanillaEntityType.PUFFERFISH, "minecraft:pufferfish");
            this.mapping.put(ChunkerVanillaEntityType.TROPICAL_FISH, "minecraft:tropical_fish");
            this.mapping.put(ChunkerVanillaEntityType.DROWNED, "minecraft:drowned");
            this.mapping.put(ChunkerVanillaEntityType.DOLPHIN, "minecraft:dolphin");
        }
        if (version.isGreaterThanOrEqual(1, 14, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.PANDA, "minecraft:panda");
            this.mapping.put(ChunkerVanillaEntityType.PILLAGER, "minecraft:pillager");
            this.mapping.put(ChunkerVanillaEntityType.RAVAGER, "minecraft:ravager");
            this.mapping.put(ChunkerVanillaEntityType.CAT, "minecraft:cat");
            this.mapping.put(ChunkerVanillaEntityType.TRADER_LLAMA, "minecraft:trader_llama");
            this.mapping.put(ChunkerVanillaEntityType.WANDERING_TRADER, "minecraft:wandering_trader");
            this.mapping.put(ChunkerVanillaEntityType.FOX, "minecraft:fox");
        }
        if (version.isGreaterThanOrEqual(1, 15, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.BEE, "minecraft:bee");
        }
        if (version.isGreaterThanOrEqual(1, 16, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.PIGLIN, "minecraft:piglin");
            this.mapping.put(ChunkerVanillaEntityType.HOGLIN, "minecraft:hoglin");
            this.mapping.put(ChunkerVanillaEntityType.ZOMBIFIED_PIGLIN, "minecraft:zombified_piglin");
            this.mapping.put(ChunkerVanillaEntityType.STRIDER, "minecraft:strider");
            this.mapping.put(ChunkerVanillaEntityType.ZOGLIN, "minecraft:zoglin");
        }
        if (version.isGreaterThanOrEqual(1, 16, 2)) {
            this.mapping.put(ChunkerVanillaEntityType.PIGLIN_BRUTE, "minecraft:piglin_brute");
        }
        if (version.isGreaterThanOrEqual(1, 17, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.AXOLOTL, "minecraft:axolotl");
            this.mapping.put(ChunkerVanillaEntityType.GLOW_SQUID, "minecraft:glow_squid");
            this.mapping.put(ChunkerVanillaEntityType.GLOW_ITEM_FRAME, "minecraft:glow_item_frame");
            this.mapping.put(ChunkerVanillaEntityType.GOAT, "minecraft:goat");
        }
        if (version.isGreaterThanOrEqual(1, 19, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.WARDEN, "minecraft:warden");
            this.mapping.put(ChunkerVanillaEntityType.TADPOLE, "minecraft:tadpole");
            this.mapping.put(ChunkerVanillaEntityType.FROG, "minecraft:frog");
            this.mapping.put(ChunkerVanillaEntityType.ALLAY, "minecraft:allay");
        }
        if (version.isGreaterThanOrEqual(1, 19, 3)) {
            this.mapping.put(ChunkerVanillaEntityType.CAMEL, "minecraft:camel");
        }
        if (version.isGreaterThanOrEqual(1, 19, 4)) {
            this.mapping.put(ChunkerVanillaEntityType.INTERACTION, "minecraft:interaction");
            this.mapping.put(ChunkerVanillaEntityType.ITEM_DISPLAY, "minecraft:item_display");
            this.mapping.put(ChunkerVanillaEntityType.TEXT_DISPLAY, "minecraft:text_display");
            this.mapping.put(ChunkerVanillaEntityType.BLOCK_DISPLAY, "minecraft:block_display");
            this.mapping.put(ChunkerVanillaEntityType.SNIFFER, "minecraft:sniffer");
        }
        if (version.isGreaterThanOrEqual(1, 20, 3)) {
            this.mapping.put(ChunkerVanillaEntityType.BREEZE, "minecraft:breeze");
            this.mapping.put(ChunkerVanillaEntityType.BREEZE_WIND_CHARGE_PROJECTILE, "minecraft:breeze_wind_charge");
        }
        if (version.isGreaterThanOrEqual(1, 20, 5)) {
            this.mapping.put(ChunkerVanillaEntityType.WIND_CHARGE, "minecraft:wind_charge");
            this.mapping.put(ChunkerVanillaEntityType.ARMADILLO, "minecraft:armadillo");
            this.mapping.put(ChunkerVanillaEntityType.BOGGED, "minecraft:bogged");
        }
        if (version.isGreaterThanOrEqual(1, 20, 5)) {
            this.mapping.put(ChunkerVanillaEntityType.WIND_CHARGE, "minecraft:wind_charge");
            this.mapping.put(ChunkerVanillaEntityType.ARMADILLO, "minecraft:armadillo");
            this.mapping.put(ChunkerVanillaEntityType.BOGGED, "minecraft:bogged");
            this.mapping.put(ChunkerVanillaEntityType.OMINOUS_ITEM_SPAWNER, "minecraft:ominous_item_spawner");
        }
        if (version.isGreaterThanOrEqual(1, 21, 2)) {
            this.mapping.put(ChunkerVanillaEntityType.CREAKING, "minecraft:creaking");
            this.mapping.put(ChunkerVanillaEntityType.OAK_BOAT, "minecraft:oak_boat");
            this.mapping.put(ChunkerVanillaEntityType.SPRUCE_BOAT, "minecraft:spruce_boat");
            this.mapping.put(ChunkerVanillaEntityType.BIRCH_BOAT, "minecraft:birch_boat");
            this.mapping.put(ChunkerVanillaEntityType.JUNGLE_BOAT, "minecraft:jungle_boat");
            this.mapping.put(ChunkerVanillaEntityType.ACACIA_BOAT, "minecraft:acacia_boat");
            this.mapping.put(ChunkerVanillaEntityType.CHERRY_BOAT, "minecraft:cherry_boat");
            this.mapping.put(ChunkerVanillaEntityType.DARK_OAK_BOAT, "minecraft:dark_oak_boat");
            this.mapping.put(ChunkerVanillaEntityType.PALE_OAK_BOAT, "minecraft:pale_oak_boat");
            this.mapping.put(ChunkerVanillaEntityType.MANGROVE_BOAT, "minecraft:mangrove_boat");
            this.mapping.put(ChunkerVanillaEntityType.BAMBOO_RAFT, "minecraft:bamboo_raft");
            this.mapping.put(ChunkerVanillaEntityType.OAK_CHEST_BOAT, "minecraft:oak_chest_boat");
            this.mapping.put(ChunkerVanillaEntityType.SPRUCE_CHEST_BOAT, "minecraft:spruce_chest_boat");
            this.mapping.put(ChunkerVanillaEntityType.BIRCH_CHEST_BOAT, "minecraft:birch_chest_boat");
            this.mapping.put(ChunkerVanillaEntityType.JUNGLE_CHEST_BOAT, "minecraft:jungle_chest_boat");
            this.mapping.put(ChunkerVanillaEntityType.ACACIA_CHEST_BOAT, "minecraft:acacia_chest_boat");
            this.mapping.put(ChunkerVanillaEntityType.CHERRY_CHEST_BOAT, "minecraft:cherry_chest_boat");
            this.mapping.put(ChunkerVanillaEntityType.DARK_OAK_CHEST_BOAT, "minecraft:dark_oak_chest_boat");
            this.mapping.put(ChunkerVanillaEntityType.PALE_OAK_CHEST_BOAT, "minecraft:pale_oak_chest_boat");
            this.mapping.put(ChunkerVanillaEntityType.MANGROVE_CHEST_BOAT, "minecraft:mangrove_chest_boat");
            this.mapping.put(ChunkerVanillaEntityType.BAMBOO_CHEST_RAFT, "minecraft:bamboo_chest_raft");
        }
        if (version.isGreaterThanOrEqual(1, 21, 5)) {
            this.mapping.put(ChunkerVanillaEntityType.LINGERING_POTION, "minecraft:lingering_potion");
            this.mapping.put(ChunkerVanillaEntityType.POTION, "minecraft:splash_potion");
        }
        if (version.isGreaterThanOrEqual(1, 21, 6)) {
            this.mapping.put(ChunkerVanillaEntityType.HAPPY_GHAST, "minecraft:happy_ghast");
        }
        if (version.isGreaterThanOrEqual(1, 21, 9)) {
            this.mapping.put(ChunkerVanillaEntityType.COPPER_GOLEM, "minecraft:copper_golem");
            this.mapping.put(ChunkerVanillaEntityType.MANNEQUIN, "minecraft:mannequin");
        }
        if (version.isGreaterThanOrEqual(1, 21, 11)) {
            this.mapping.put(ChunkerVanillaEntityType.CAMEL_HUSK, "minecraft:camel_husk");
            this.mapping.put(ChunkerVanillaEntityType.NAUTILUS, "minecraft:nautilus");
            this.mapping.put(ChunkerVanillaEntityType.PARCHED, "minecraft:parched");
            this.mapping.put(ChunkerVanillaEntityType.ZOMBIE_NAUTILUS, "minecraft:zombie_nautilus");
        }
    }

    @Override
    public Optional<String> from(ChunkerEntityType input) {
        if (input instanceof ChunkerCustomEntityType) {
            ChunkerCustomEntityType chunkerCustomEntityType = (ChunkerCustomEntityType)input;
            if (this.customIdentifierSupported) {
                return Optional.ofNullable(chunkerCustomEntityType.getIdentifier());
            }
            return Optional.empty();
        }
        if (input instanceof ChunkerVanillaEntityType) {
            ChunkerVanillaEntityType chunkerVanillaEntityType = (ChunkerVanillaEntityType)input;
            return Optional.ofNullable(this.mapping.forward().get(chunkerVanillaEntityType));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ChunkerEntityType> to(String input) {
        if (!((String)input).contains(":")) {
            input = "minecraft:" + (String)input;
        } else if (!((String)input).startsWith("minecraft:") && this.customIdentifierSupported) {
            return Optional.of(new ChunkerCustomEntityType((String)input));
        }
        return Optional.ofNullable((ChunkerEntityType)this.mapping.inverse().get(input));
    }
}

