/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.ContainerBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.util.JsonTextUtil;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class JavaLegacyContainerBlockEntityHandler
extends BlockEntityHandler<JavaResolvers, CompoundTag, ContainerBlockEntity> {
    public JavaLegacyContainerBlockEntityHandler() {
        super("minecraft:container", ContainerBlockEntity.class, () -> {
            throw new IllegalArgumentException("Unable to initialize type of container");
        });
    }

    @Override
    public void read(@NotNull JavaResolvers resolvers, @NotNull CompoundTag input, @NotNull ContainerBlockEntity value) {
        ListTag items = input.getList("Items", CompoundTag.class, null);
        if (items != null) {
            byte index = 0;
            for (CompoundTag itemTag : items) {
                byte slot = itemTag.getByte("Slot", index);
                ChunkerItemStack item = resolvers.readItem(itemTag);
                value.getItems().put(slot, item);
                index = (byte)(index + 1);
            }
        }
        value.setCustomName(input.getOptionalValue("CustomName", String.class).map(JsonTextUtil::fromJSON).orElse(null));
    }

    @Override
    public void write(@NotNull JavaResolvers resolvers, @NotNull CompoundTag output, @NotNull ContainerBlockEntity value) {
        ListTag items = new ListTag(TagType.COMPOUND, value.getItems().size());
        for (Byte2ObjectMap.Entry tag : value.getItems().byte2ObjectEntrySet()) {
            Optional<CompoundTag> item;
            if (((ChunkerItemStack)tag.getValue()).getIdentifier().isAir() || (item = resolvers.writeItem((ChunkerItemStack)tag.getValue())).isEmpty()) continue;
            item.get().put("Slot", tag.getByteKey());
            items.add(item.get());
        }
        output.put("Items", items);
        if (value.getCustomName() != null) {
            output.put("CustomName", JsonTextUtil.toJSON(value.getCustomName()));
        }
    }
}

