/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.DoNotWriteBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.GenerateBeforeProcessBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.UpdateBeforeProcessBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.UpdateBeforeWriteBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.type.JavaLegacyBedBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BedBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerDyeColor;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaLegacyBedBlockEntityHandler
extends BlockEntityHandler<JavaResolvers, CompoundTag, JavaLegacyBedBlockEntity>
implements UpdateBeforeWriteBlockEntityHandler<JavaResolvers, BedBlockEntity>,
UpdateBeforeProcessBlockEntityHandler<JavaResolvers, BedBlockEntity>,
GenerateBeforeProcessBlockEntityHandler<JavaLegacyBedBlockEntity>,
DoNotWriteBlockEntityHandler<BedBlockEntity> {
    public static final BiMap<ChunkerBlockType, ChunkerDyeColor> BED_TO_DYE = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(ChunkerVanillaBlockType.WHITE_BED, (Object)ChunkerDyeColor.WHITE)).put(ChunkerVanillaBlockType.ORANGE_BED, (Object)ChunkerDyeColor.ORANGE)).put(ChunkerVanillaBlockType.MAGENTA_BED, (Object)ChunkerDyeColor.MAGENTA)).put(ChunkerVanillaBlockType.LIGHT_BLUE_BED, (Object)ChunkerDyeColor.LIGHT_BLUE)).put(ChunkerVanillaBlockType.YELLOW_BED, (Object)ChunkerDyeColor.YELLOW)).put(ChunkerVanillaBlockType.LIME_BED, (Object)ChunkerDyeColor.LIME)).put(ChunkerVanillaBlockType.PINK_BED, (Object)ChunkerDyeColor.PINK)).put(ChunkerVanillaBlockType.GRAY_BED, (Object)ChunkerDyeColor.GRAY)).put(ChunkerVanillaBlockType.LIGHT_GRAY_BED, (Object)ChunkerDyeColor.LIGHT_GRAY)).put(ChunkerVanillaBlockType.CYAN_BED, (Object)ChunkerDyeColor.CYAN)).put(ChunkerVanillaBlockType.PURPLE_BED, (Object)ChunkerDyeColor.PURPLE)).put(ChunkerVanillaBlockType.BLUE_BED, (Object)ChunkerDyeColor.BLUE)).put(ChunkerVanillaBlockType.BROWN_BED, (Object)ChunkerDyeColor.BROWN)).put(ChunkerVanillaBlockType.GREEN_BED, (Object)ChunkerDyeColor.GREEN)).put(ChunkerVanillaBlockType.RED_BED, (Object)ChunkerDyeColor.RED)).put(ChunkerVanillaBlockType.BLACK_BED, (Object)ChunkerDyeColor.BLACK)).build();
    private final boolean shouldRemove;

    public JavaLegacyBedBlockEntityHandler(boolean shouldRemove) {
        super("Bed", JavaLegacyBedBlockEntity.class, JavaLegacyBedBlockEntity::new);
        this.shouldRemove = shouldRemove;
    }

    @Override
    public void read(@NotNull JavaResolvers resolvers, @NotNull CompoundTag input, @NotNull JavaLegacyBedBlockEntity value) {
        value.setColor(ChunkerDyeColor.getColorByID(input.getInt("color", 0)).orElse(ChunkerDyeColor.WHITE));
    }

    @Override
    public void write(@NotNull JavaResolvers resolvers, @NotNull CompoundTag output, @NotNull JavaLegacyBedBlockEntity value) {
        output.put("color", value.getColor().getID());
    }

    @Override
    public BedBlockEntity updateBeforeWrite(@NotNull JavaResolvers resolvers, ChunkerColumn column, int x, int y, int z, BedBlockEntity blockEntity) {
        JavaLegacyBedBlockEntity legacyBedBlockEntity = new JavaLegacyBedBlockEntity(blockEntity);
        ChunkerBlockIdentifier blockIdentifier = column.getBlock(x, y, z);
        ChunkerDyeColor color = BED_TO_DYE.getOrDefault(blockIdentifier.getType(), ChunkerDyeColor.WHITE);
        legacyBedBlockEntity.setColor(color);
        return legacyBedBlockEntity;
    }

    @Override
    public BedBlockEntity updateBeforeWrite(@NotNull JavaResolvers resolvers, CompoundTag itemCompoundTag, ChunkerItemStack chunkerItemStack, BedBlockEntity blockEntity) {
        return new JavaLegacyBedBlockEntity(blockEntity);
    }

    @Override
    public Class<BedBlockEntity> getAdditionalHandledClass() {
        return BedBlockEntity.class;
    }

    @Override
    public BedBlockEntity updateBeforeProcess(@NotNull JavaResolvers resolvers, ChunkerColumn column, int x, int y, int z, BedBlockEntity blockEntity) {
        if (blockEntity instanceof JavaLegacyBedBlockEntity) {
            JavaLegacyBedBlockEntity legacyBedBlockEntity = (JavaLegacyBedBlockEntity)blockEntity;
            ChunkerBlockIdentifier blockIdentifier = column.getBlock(x, y, z);
            if (blockIdentifier.isAir()) {
                return blockEntity;
            }
            ChunkerBlockType newType = BED_TO_DYE.inverse().getOrDefault((Object)legacyBedBlockEntity.getColor(), ChunkerVanillaBlockType.WHITE_BED);
            column.setBlock(x, y, z, new ChunkerBlockIdentifier(newType, blockIdentifier.getPresentStates(), blockIdentifier.getPreservedIdentifier()));
            return legacyBedBlockEntity.toChunker();
        }
        return blockEntity;
    }

    @Override
    public BedBlockEntity updateBeforeProcess(@NotNull JavaResolvers resolvers, CompoundTag itemCompoundTag, ChunkerItemStack chunkerItemStack, BedBlockEntity blockEntity) {
        if (blockEntity instanceof JavaLegacyBedBlockEntity) {
            JavaLegacyBedBlockEntity legacyBedBlockEntity = (JavaLegacyBedBlockEntity)blockEntity;
            return legacyBedBlockEntity.toChunker();
        }
        return blockEntity;
    }

    @Override
    public Set<ChunkerBlockType> getGenerateBeforeProcessBlockTypes() {
        return BED_TO_DYE.keySet();
    }

    @Override
    public void generateBeforeProcess(ChunkerColumn column, int x, int y, int z, JavaLegacyBedBlockEntity blockEntity, ChunkerBlockIdentifier blockIdentifier) {
        blockEntity.setColor(ChunkerDyeColor.RED);
    }

    @Override
    public boolean shouldRemoveBeforeWrite(ChunkerColumn column, int x, int y, int z, BedBlockEntity blockEntity) {
        return this.shouldRemove;
    }
}

