/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityResolver;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.EmptyBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyBannerBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyBeaconBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyBedBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyBrewingStandBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyCauldronBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyChestBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyCommandBlockBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyComparatorBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyContainerBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyEnchantmentBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyEndGatewayBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyFlowerPotBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyFurnaceBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyJukeboxBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyNoteBlockBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyPistonArmBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyRandomizableContainerBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacySignBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacySkullBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacySpawnerBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers.JavaLegacyStructureBlockEntityHandler;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.DaylightDetectorBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.EnderChestBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.HopperBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.ChestBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.DispenserBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.DropperBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.ShulkerBoxBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.TrappedChestBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.end.EndPortalBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifierType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Objects;
import java.util.Optional;

public class JavaLegacyBlockEntityResolver
extends BlockEntityResolver<JavaResolvers, CompoundTag> {
    public static final InvertibleMap<String, String> OLD_TO_NEW_ID = InvertibleMap.create();

    public JavaLegacyBlockEntityResolver(Version version, JavaResolvers resolvers) {
        super(version, resolvers, resolvers.converter().shouldAllowNBTCopying());
    }

    @Override
    protected void registerTypeHandlers(Version version) {
        this.register(new JavaLegacyBlockEntityHandler());
        this.register(new JavaLegacyContainerBlockEntityHandler());
        this.register(new JavaLegacyRandomizableContainerBlockEntityHandler(((JavaResolvers)this.resolvers).converter().shouldProcessLootTables()));
        this.register(new JavaLegacyCauldronBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("Airportal", EndPortalBlockEntity.class, EndPortalBlockEntity::new));
        this.register(new JavaLegacyBannerBlockEntityHandler());
        this.register(new JavaLegacyBeaconBlockEntityHandler());
        this.register(new JavaLegacyBrewingStandBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("Chest", ChestBlockEntity.class, ChestBlockEntity::new));
        this.register(new JavaLegacyComparatorBlockEntityHandler());
        this.register(new JavaLegacyCommandBlockBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("DLDetector", DaylightDetectorBlockEntity.class, DaylightDetectorBlockEntity::new));
        this.register(new EmptyBlockEntityHandler("Dropper", DropperBlockEntity.class, DropperBlockEntity::new));
        this.register(new JavaLegacyEnchantmentBlockEntityHandler());
        this.register(new JavaLegacyEndGatewayBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("EnderChest", EnderChestBlockEntity.class, EnderChestBlockEntity::new));
        this.register(new JavaLegacyFurnaceBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("Hopper", HopperBlockEntity.class, HopperBlockEntity::new));
        this.register(new JavaLegacySpawnerBlockEntityHandler());
        this.register(new JavaLegacyPistonArmBlockEntityHandler());
        this.register(new JavaLegacyJukeboxBlockEntityHandler());
        this.register(new JavaLegacySignBlockEntityHandler());
        this.register(new JavaLegacySkullBlockEntityHandler());
        this.register(new JavaLegacyBedBlockEntityHandler(version.isLessThan(1, 12, 0)));
        this.register(new JavaLegacyFlowerPotBlockEntityHandler());
        this.register(new JavaLegacyNoteBlockBlockEntityHandler());
        this.register(new JavaLegacyStructureBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("Trap", DispenserBlockEntity.class, DispenserBlockEntity::new));
        this.register(new JavaLegacyChestBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("TrappedChest", TrappedChestBlockEntity.class, () -> {
            throw new IllegalArgumentException("Cannot make TrappedChest");
        }));
        if (version.isGreaterThanOrEqual(1, 12, 0)) {
            this.register(new EmptyBlockEntityHandler("Shulker", ShulkerBoxBlockEntity.class, ShulkerBoxBlockEntity::new));
        }
    }

    @Override
    protected CompoundTag constructDataType(String key) {
        CompoundTag compoundTag = new CompoundTag(4);
        if (this.version.isGreaterThanOrEqual(1, 11, 0)) {
            key = Objects.requireNonNull(OLD_TO_NEW_ID.forward().get(key));
        }
        compoundTag.put("id", key);
        return compoundTag;
    }

    @Override
    public Optional<String> getKey(CompoundTag input) {
        return input.getOptionalValue("id", String.class).flatMap(id -> {
            if (this.version.isGreaterThanOrEqual(1, 11, 0)) {
                if (!((String)id).contains(":")) {
                    id = "minecraft:" + (String)id;
                }
                return Optional.ofNullable(OLD_TO_NEW_ID.inverse().get(id));
            }
            id = OLD_TO_NEW_ID.inverse().getOrDefault(id, (String)id);
            return Optional.ofNullable(id);
        });
    }

    @Override
    public Optional<Class<? extends BlockEntity>> getBlockEntityClass(ChunkerItemStackIdentifierType itemStackType) {
        if (itemStackType == ChunkerVanillaBlockType.TRAPPED_CHEST) {
            return Optional.of(ChestBlockEntity.class);
        }
        return super.getBlockEntityClass(itemStackType);
    }

    static {
        OLD_TO_NEW_ID.put("Airportal", "minecraft:end_portal");
        OLD_TO_NEW_ID.put("Banner", "minecraft:banner");
        OLD_TO_NEW_ID.put("Bed", "minecraft:bed");
        OLD_TO_NEW_ID.put("Beacon", "minecraft:beacon");
        OLD_TO_NEW_ID.put("Cauldron", "minecraft:brewing_stand");
        OLD_TO_NEW_ID.put("TrappedChest", "minecraft:chest");
        OLD_TO_NEW_ID.put("Chest", "minecraft:chest");
        OLD_TO_NEW_ID.put("Comparator", "minecraft:comparator");
        OLD_TO_NEW_ID.put("Control", "minecraft:command_block");
        OLD_TO_NEW_ID.put("DLDetector", "minecraft:daylight_detector");
        OLD_TO_NEW_ID.put("Dropper", "minecraft:dropper");
        OLD_TO_NEW_ID.put("EnchantTable", "minecraft:enchanting_table");
        OLD_TO_NEW_ID.put("EndGateway", "minecraft:end_gateway");
        OLD_TO_NEW_ID.put("EnderChest", "minecraft:ender_chest");
        OLD_TO_NEW_ID.put("FlowerPot", "minecraft:flower_pot");
        OLD_TO_NEW_ID.put("Furnace", "minecraft:furnace");
        OLD_TO_NEW_ID.put("Hopper", "minecraft:hopper");
        OLD_TO_NEW_ID.put("MobSpawner", "minecraft:mob_spawner");
        OLD_TO_NEW_ID.put("Music", "minecraft:noteblock");
        OLD_TO_NEW_ID.put("Piston", "minecraft:piston");
        OLD_TO_NEW_ID.put("RecordPlayer", "minecraft:jukebox");
        OLD_TO_NEW_ID.put("Sign", "minecraft:sign");
        OLD_TO_NEW_ID.put("Skull", "minecraft:skull");
        OLD_TO_NEW_ID.put("Structure", "minecraft:structure_block");
        OLD_TO_NEW_ID.put("Trap", "minecraft:dispenser");
        OLD_TO_NEW_ID.put("Shulker", "minecraft:shulker_box");
    }
}

