/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.biome;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerCustomBiome;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class JavaNamedBiomeResolver
implements Resolver<String, ChunkerBiome> {
    private final InvertibleMap<ChunkerBiome.ChunkerVanillaBiome, String> mapping = InvertibleMap.enumKeys(ChunkerBiome.ChunkerVanillaBiome.class);
    private final boolean customIdentifierSupported;

    public JavaNamedBiomeResolver(Version javaVersion, boolean customIdentifierSupported) {
        this.customIdentifierSupported = customIdentifierSupported;
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.OCEAN, "minecraft:ocean");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.PLAINS, "minecraft:plains");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DESERT, "minecraft:desert");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.FOREST, "minecraft:forest");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.TAIGA, "minecraft:taiga");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SWAMP, "minecraft:swamp");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.RIVER, "minecraft:river");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.NETHER_WASTES, "minecraft:nether_wastes");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.THE_END, "minecraft:the_end");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.FROZEN_OCEAN, "minecraft:frozen_ocean");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.FROZEN_RIVER, "minecraft:frozen_river");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SNOWY_PLAINS, "minecraft:snowy_plains");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.MUSHROOM_FIELDS, "minecraft:mushroom_fields");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.BEACH, "minecraft:beach");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WINDSWEPT_HILLS, "minecraft:windswept_hills");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.JUNGLE, "minecraft:jungle");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SPARSE_JUNGLE, "minecraft:sparse_jungle");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DEEP_OCEAN, "minecraft:deep_ocean");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.STONY_SHORE, "minecraft:stony_shore");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SNOWY_BEACH, "minecraft:snowy_beach");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.BIRCH_FOREST, "minecraft:birch_forest");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DARK_FOREST, "minecraft:dark_forest");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SNOWY_TAIGA, "minecraft:snowy_taiga");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.OLD_GROWTH_PINE_TAIGA, "minecraft:old_growth_pine_taiga");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WINDSWEPT_FOREST, "minecraft:windswept_forest");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SAVANNA, "minecraft:savanna");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SAVANNA_PLATEAU, "minecraft:savanna_plateau");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.BADLANDS, "minecraft:badlands");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WOODED_BADLANDS, "minecraft:wooded_badlands");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SMALL_END_ISLANDS, "minecraft:small_end_islands");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.END_MIDLANDS, "minecraft:end_midlands");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.END_HIGHLANDS, "minecraft:end_highlands");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.END_BARRENS, "minecraft:end_barrens");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WARM_OCEAN, "minecraft:warm_ocean");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.LUKEWARM_OCEAN, "minecraft:lukewarm_ocean");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.COLD_OCEAN, "minecraft:cold_ocean");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DEEP_LUKEWARM_OCEAN, "minecraft:deep_lukewarm_ocean");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DEEP_COLD_OCEAN, "minecraft:deep_cold_ocean");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DEEP_FROZEN_OCEAN, "minecraft:deep_frozen_ocean");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.THE_VOID, "minecraft:the_void");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SUNFLOWER_PLAINS, "minecraft:sunflower_plains");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WINDSWEPT_GRAVELLY_HILLS, "minecraft:windswept_gravelly_hills");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.FLOWER_FOREST, "minecraft:flower_forest");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.ICE_SPIKES, "minecraft:ice_spikes");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.OLD_GROWTH_BIRCH_FOREST, "minecraft:old_growth_birch_forest");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.OLD_GROWTH_SPRUCE_TAIGA, "minecraft:old_growth_spruce_taiga");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WINDSWEPT_SAVANNA, "minecraft:windswept_savanna");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.ERODED_BADLANDS, "minecraft:eroded_badlands");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.BAMBOO_JUNGLE, "minecraft:bamboo_jungle");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SOUL_SAND_VALLEY, "minecraft:soul_sand_valley");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.CRIMSON_FOREST, "minecraft:crimson_forest");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.WARPED_FOREST, "minecraft:warped_forest");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.BASALT_DELTAS, "minecraft:basalt_deltas");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DRIPSTONE_CAVES, "minecraft:dripstone_caves");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.LUSH_CAVES, "minecraft:lush_caves");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.MEADOW, "minecraft:meadow");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.GROVE, "minecraft:grove");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.SNOWY_SLOPES, "minecraft:snowy_slopes");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.FROZEN_PEAKS, "minecraft:frozen_peaks");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.JAGGED_PEAKS, "minecraft:jagged_peaks");
        this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.STONY_PEAKS, "minecraft:stony_peaks");
        if (javaVersion.isGreaterThanOrEqual(1, 19, 0)) {
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.DEEP_DARK, "minecraft:deep_dark");
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.MANGROVE_SWAMP, "minecraft:mangrove_swamp");
        }
        if (javaVersion.isGreaterThanOrEqual(1, 20, 0)) {
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.CHERRY_GROVE, "minecraft:cherry_grove");
        }
        if (javaVersion.isGreaterThanOrEqual(1, 21, 2)) {
            this.mapping.put(ChunkerBiome.ChunkerVanillaBiome.PALE_GARDEN, "minecraft:pale_garden");
        }
    }

    @Override
    public Optional<String> from(ChunkerBiome input) {
        if (input instanceof ChunkerBiome.ChunkerVanillaBiome) {
            ChunkerBiome.ChunkerVanillaBiome chunkerVanillaBiome = (ChunkerBiome.ChunkerVanillaBiome)input;
            return this.from(chunkerVanillaBiome);
        }
        if (input instanceof ChunkerCustomBiome) {
            ChunkerCustomBiome customIdentifierBiome = (ChunkerCustomBiome)input;
            if (this.customIdentifierSupported) {
                return Optional.ofNullable(customIdentifierBiome.getIdentifier());
            }
            ChunkerBiome.ChunkerVanillaBiome fallback = input.getFallback();
            if (fallback != null) {
                return this.from(fallback);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    protected Optional<String> from(ChunkerBiome.ChunkerVanillaBiome ChunkerVanillaBiome2) {
        ChunkerBiome.ChunkerVanillaBiome fallback;
        String mapped = this.mapping.forward().get(ChunkerVanillaBiome2);
        if (mapped == null && (fallback = ChunkerVanillaBiome2.getFallback()) != null) {
            mapped = this.mapping.forward().get(fallback);
        }
        return Optional.ofNullable(mapped);
    }

    @Override
    public Optional<ChunkerBiome> to(String input) {
        if (!((String)input).contains(":")) {
            input = "minecraft:" + (String)input;
        } else if (!((String)input).startsWith("minecraft:") && this.customIdentifierSupported) {
            return Optional.of(new ChunkerCustomBiome((String)input));
        }
        return Optional.ofNullable((ChunkerBiome)this.mapping.inverse().get(input));
    }
}

