/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.reader;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.reader.ColumnReader;
import com.hivemc.chunker.conversion.encoding.java.base.reader.JavaChunkReader;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.handlers.ColumnConversionHandler;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.column.biome.layout.ChunkerColumnBasedBiomes;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.entity.Entity;
import com.hivemc.chunker.conversion.intermediate.column.heightmap.JavaLegacyHeightMap;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.array.ByteArrayTag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.ByteTag;
import com.hivemc.chunker.nbt.tags.primitive.IntTag;
import com.hivemc.chunker.scheduling.task.FutureTask;
import com.hivemc.chunker.scheduling.task.ProgressiveTask;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class JavaColumnReader
implements ColumnReader {
    private static final Set<String> UNFINISHED_STATUSES = Set.of("empty", "structure_starts", "structure_references", "biomes", "noise", "surface", "carvers", "liquid_carvers", "minecraft:empty", "minecraft:structure_starts", "minecraft:structure_references", "minecraft:biomes", "minecraft:noise", "minecraft:surface", "minecraft:carvers", "minecraft:liquid_carvers");
    protected final Converter converter;
    protected final JavaResolvers resolvers;
    protected final Dimension dimension;
    protected final ChunkCoordPair columnCoords;
    protected CompoundTag columnNBT;

    public JavaColumnReader(Converter converter, JavaResolvers resolvers, Dimension dimension, ChunkCoordPair columnCoords, CompoundTag columnNBT) {
        this.converter = converter;
        this.resolvers = resolvers;
        this.dimension = dimension;
        this.columnCoords = columnCoords;
        this.columnNBT = columnNBT;
    }

    @Override
    public void readColumn(ColumnConversionHandler columnConversionHandler) {
        if (this.columnNBT == null) {
            return;
        }
        this.columnNBT = this.columnNBT.getCompound("Level", this.columnNBT);
        if (!this.columnNBT.contains("xPos") || !this.columnNBT.contains("zPos")) {
            return;
        }
        int xPos = this.columnNBT.getInt("xPos");
        int zPos = this.columnNBT.getInt("zPos");
        if (xPos != this.columnCoords.chunkX() || zPos != this.columnCoords.chunkZ()) {
            this.converter.logNonFatalException(new Exception("Mislocated chunk, chunk states " + xPos + ", " + zPos + " but actually at " + String.valueOf(this.columnCoords)));
        }
        if (this.columnNBT.contains("Status") && UNFINISHED_STATUSES.contains(this.columnNBT.getString("Status"))) {
            return;
        }
        ChunkerColumn column = new ChunkerColumn(this.columnCoords);
        if (this.columnNBT.contains("LightPopulated")) {
            column.setLightPopulated(this.columnNBT.getByte("LightPopulated") != 0);
        }
        ArrayList<ProgressiveTask<Void>> processing = new ArrayList<ProgressiveTask<Void>>(5);
        if (this.converter.shouldProcessHeightMap()) {
            processing.add(Task.asyncConsume("Reading HeightMap", TaskWeight.NORMAL, this::readHeightMap, column));
        }
        if (this.converter.shouldProcessBiomes()) {
            processing.add(Task.asyncConsume("Reading Biomes", TaskWeight.NORMAL, this::readBiomes, column));
        }
        if (this.converter.shouldProcessEntities()) {
            processing.add(Task.asyncConsume("Reading Entities", TaskWeight.HIGH, this::readEntities, column));
        }
        if (this.converter.shouldProcessBlockEntities()) {
            processing.add(Task.asyncConsume("Reading Block Entities", TaskWeight.HIGH, this::readBlockEntities, column));
        }
        processing.add(Task.asyncConsume("Reading Chunks", TaskWeight.HIGHER, this::readChunks, column));
        Task.join(processing).then("Post-processing column", TaskWeight.HIGH, this::postProcess, (List<ChunkerColumn>)((Object)column)).thenConsume("Submitting column", TaskWeight.LOW, columnConversionHandler::convertColumn);
    }

    protected void readHeightMap(ChunkerColumn column) {
        if (!this.columnNBT.contains("HeightMap")) {
            return;
        }
        short[][] heightMapOutput = new short[16][16];
        int[] heightMap = this.columnNBT.getIntArray("HeightMap");
        for (int i = 0; i < heightMap.length; ++i) {
            heightMapOutput[i & 0xF][i >> 4 & 0xF] = (short)heightMap[i];
        }
        column.setHeightMap(new JavaLegacyHeightMap(heightMapOutput));
    }

    protected void readBiomes(ChunkerColumn column) {
        ByteArrayTag byteArrayTag;
        Tag biomes = this.columnNBT.get("Biomes", Tag.class);
        if (biomes == null) {
            return;
        }
        if (biomes instanceof ByteArrayTag && (byteArrayTag = (ByteArrayTag)biomes).getValue() != null) {
            ChunkerBiome[] chunkerBiomeArray = new ChunkerBiome[256];
            byte[] value = byteArrayTag.getValue();
            for (int i = 0; i < chunkerBiomeArray.length; ++i) {
                chunkerBiomeArray[i] = this.resolvers.readBiome(value[i] & 0xFF, this.dimension);
            }
            column.setBiomes(new ChunkerColumnBasedBiomes(chunkerBiomeArray));
        }
    }

    protected void readEntities(ChunkerColumn column) {
        ListTag entities = this.columnNBT.getList("Entities", CompoundTag.class, null);
        if (entities != null) {
            for (CompoundTag entityTag : entities) {
                try {
                    this.readEntity(column, entityTag);
                }
                catch (Exception e) {
                    this.converter.logNonFatalException(new Exception("Failed to process Entity " + String.valueOf(entityTag), e));
                }
            }
        }
    }

    protected void readEntity(ChunkerColumn chunkerColumn, CompoundTag compoundTag) {
        Optional<Entity> entity = this.resolvers.entityResolver().to(compoundTag);
        if (entity.isPresent()) {
            chunkerColumn.getEntities().add(entity.get());
        } else {
            String identifier = this.resolvers.entityResolver().getKey(compoundTag).map(Object::toString).orElseGet(compoundTag::toString);
            this.converter.logMissingMapping(Converter.MissingMappingType.ENTITY, identifier);
        }
    }

    protected void readBlockEntities(ChunkerColumn column) {
        ListTag blockEntities = this.columnNBT.getList("TileEntities", CompoundTag.class, null);
        if (blockEntities != null) {
            for (CompoundTag blockEntityTag : blockEntities) {
                try {
                    this.readBlockEntity(column, blockEntityTag);
                }
                catch (Exception e) {
                    this.converter.logNonFatalException(new Exception("Failed to process BlockEntity " + String.valueOf(blockEntityTag), e));
                }
            }
        }
    }

    protected void readBlockEntity(ChunkerColumn chunkerColumn, CompoundTag compoundTag) {
        Optional<BlockEntity> blockEntity = this.resolvers.blockEntityResolver().to(compoundTag);
        if (blockEntity.isPresent()) {
            chunkerColumn.getBlockEntities().add(blockEntity.get());
        } else {
            String identifier = this.resolvers.blockEntityResolver().getKey(compoundTag).orElseGet(compoundTag::toString);
            this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK_ENTITY, identifier);
        }
    }

    protected void readChunks(ChunkerColumn column) {
        ListTag sections = this.columnNBT.getList("Sections", CompoundTag.class, null);
        if (sections == null && (sections = this.columnNBT.getList("sections", CompoundTag.class, null)) == null) {
            return;
        }
        ArrayList<FutureTask<ChunkerChunk>> tasks = new ArrayList<FutureTask<ChunkerChunk>>(sections.size());
        for (CompoundTag section : sections) {
            byte y;
            Object tag = section.get("Y");
            if (tag == null || section.size() <= 1) continue;
            if (tag instanceof ByteTag) {
                ByteTag byteYTag = (ByteTag)tag;
                y = byteYTag.getValue();
            } else if (tag instanceof IntTag) {
                IntTag intYTag = (IntTag)tag;
                y = intYTag.getBoxedValue().byteValue();
            } else {
                throw new IllegalArgumentException("Invalid Section Y NBT Tag: " + String.valueOf(tag));
            }
            ChunkerChunk chunk = new ChunkerChunk(y);
            tasks.add(Task.async("Creating Chunk Reader", TaskWeight.LOW, () -> this.createChunkReader(column, chunk)).thenConsume("Reading Chunk", TaskWeight.HIGHER, chunkReader -> chunkReader.readChunk(section)).then(chunk));
        }
        Task.join(tasks).thenConsume("Adding chunks to column", TaskWeight.LOW, chunks -> {
            for (ChunkerChunk chunk : chunks) {
                column.getChunks().put(chunk.getY(), chunk);
            }
        });
    }

    protected ChunkerColumn postProcess(ChunkerColumn column) {
        for (ChunkerChunk chunk : column.getChunks().values()) {
            this.resolvers.blockEntityResolver().generateBeforeProcessBlockEntities(column, chunk);
            this.resolvers.entityResolver().generateBeforeProcessEntities(column, chunk);
        }
        List<BlockEntity> blockEntities = column.getBlockEntities();
        for (int i = 0; i < blockEntities.size(); ++i) {
            BlockEntity blockEntity2 = blockEntities.get(i);
            BlockEntity replacement = this.resolvers.blockEntityResolver().updateBeforeProcess(column, blockEntity2.getX(), blockEntity2.getY(), blockEntity2.getZ(), blockEntity2);
            if (replacement == blockEntity2) continue;
            blockEntities.set(i, replacement);
        }
        List<Entity> entities = column.getEntities();
        for (int i = 0; i < entities.size(); ++i) {
            Entity entity2 = entities.get(i);
            Entity replacement = this.resolvers.entityResolver().updateBeforeProcess(column, entity2);
            if (replacement == entity2) continue;
            entities.set(i, replacement);
        }
        column.getBlockEntities().removeIf(blockEntity -> this.resolvers.blockEntityResolver().shouldRemoveBeforeProcess(column, blockEntity.getX(), blockEntity.getY(), blockEntity.getZ(), blockEntity));
        column.getEntities().removeIf(entity -> this.resolvers.entityResolver().shouldRemoveBeforeProcess(column, entity));
        this.resolvers.preTransformManager().solve(column, this.converter.shouldProcessColumnPreTransform());
        return column;
    }

    public JavaChunkReader createChunkReader(ChunkerColumn column, ChunkerChunk chunk) {
        return new JavaChunkReader(this.converter, this.resolvers, column, chunk);
    }
}

