/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.v1_17_30.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.identifier.BedrockBlockCompoundTag;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBChunkType;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBKey;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.io.Writer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import org.iq80.leveldb.DB;

public class ChunkWriter
extends com.hivemc.chunker.conversion.encoding.bedrock.v1_17.writer.ChunkWriter {
    public ChunkWriter(Converter converter, BedrockResolvers resolvers, DB database, Dimension dimension, ChunkerColumn chunkerColumn) {
        super(converter, resolvers, database, dimension, chunkerColumn);
    }

    @Override
    protected void writeBlockPalette(ChunkerChunk chunk) throws Exception {
        byte[] bytes;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            Writer writer = Writer.toBedrockWriter(dataOutputStream);
            writer.writeByte((byte)9);
            Palette<BedrockBlockCompoundTag> blockPalette = chunk.getPalette().map(this.resolvers::writeBlock);
            boolean containsWaterlogged = blockPalette.containsValue(BedrockBlockCompoundTag::waterlogged);
            int layers = containsWaterlogged ? 2 : 1;
            writer.writeByte((byte)layers);
            writer.writeByte(chunk.getY());
            this.writeLayers(writer, layers, blockPalette);
            bytes = byteArrayOutputStream.toByteArray();
        }
        this.writeChunkBytes(chunk, bytes);
    }

    @Override
    protected void writeChunkBytes(ChunkerChunk chunk, byte[] bytes) {
        byte subChunkY = chunk.getY();
        this.database.put(LevelDBKey.key(this.dimension, this.chunkerColumn.getPosition(), subChunkY, LevelDBChunkType.SUB_CHUNK_PREFIX), bytes);
    }
}

