/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.v1_17_30.reader;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.reader.BedrockChunkReader;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBChunkType;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBKey;
import com.hivemc.chunker.conversion.encoding.bedrock.v1_17_30.reader.ChunkReader;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.iq80.leveldb.DB;

public class ColumnReader
extends com.hivemc.chunker.conversion.encoding.bedrock.v1_17.reader.ColumnReader {
    public ColumnReader(BedrockResolvers resolvers, Converter converter, DB database, Dimension dimension, ChunkCoordPair columnCoords) {
        super(resolvers, converter, database, dimension, columnCoords);
    }

    @Override
    protected void readBiomeHeightMap(ChunkerColumn column) {
        try {
            byte[] value = this.database.get(LevelDBKey.key(this.dimension, column.getPosition(), LevelDBChunkType.DATA_3D));
            if (value != null) {
                ByteBuffer buffer = ByteBuffer.wrap(value).order(ByteOrder.LITTLE_ENDIAN);
                if (this.converter.shouldProcessHeightMap()) {
                    column.setHeightMap(this.readHeightMap(buffer));
                } else {
                    buffer.position(buffer.position() + 256);
                }
                if (this.converter.shouldProcessBiomes()) {
                    column.setBiomes(this.readBiomesExtended(buffer));
                }
                return;
            }
            super.readBiomeHeightMap(column);
        }
        catch (Exception e) {
            this.converter.logNonFatalException(e);
        }
    }

    @Override
    public BedrockChunkReader createChunkReader(ChunkerChunk chunk) {
        return new ChunkReader(this.resolvers, this.converter, this.dimension, chunk);
    }
}

