/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.util;

import com.google.common.primitives.Bytes;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBChunkType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class LevelDBKey {
    public static final byte[] ACTOR_PREFIX = "actorprefix".getBytes(StandardCharsets.UTF_8);
    public static final byte[] DIGP_PREFIX = "digp".getBytes(StandardCharsets.UTF_8);
    public static final byte[] LOCAL_PLAYER = "~local_player".getBytes(StandardCharsets.UTF_8);
    public static final byte[] MAP_PREFIX = "map_".getBytes(StandardCharsets.UTF_8);
    public static final byte[] PORTALS = "portals".getBytes(StandardCharsets.UTF_8);

    public static boolean startsWith(byte[] input, byte[] startsWith) {
        if (input.length < startsWith.length) {
            return false;
        }
        for (int i = 0; i < startsWith.length; ++i) {
            if (input[i] == startsWith[i]) continue;
            return false;
        }
        return true;
    }

    public static String extractSuffix(byte[] input, byte[] prefix) {
        return new String(input, prefix.length, input.length - prefix.length, StandardCharsets.UTF_8);
    }

    public static byte[] key(Dimension dimension, ChunkCoordPair chunkCoordPair, byte y, LevelDBChunkType type) {
        return LevelDBKey.key(dimension, chunkCoordPair, y, type.getId());
    }

    public static byte[] key(Dimension dimension, ChunkCoordPair chunkCoordPair, byte y, byte type) {
        ByteBuffer buffer = ByteBuffer.allocate(8 + (dimension == Dimension.OVERWORLD ? 0 : 4) + 2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(chunkCoordPair.chunkX());
        buffer.putInt(chunkCoordPair.chunkZ());
        if (dimension != Dimension.OVERWORLD) {
            buffer.putInt(dimension.getBedrockID());
        }
        buffer.put(type);
        buffer.put(y);
        return buffer.array();
    }

    public static byte[] key(Dimension dimension, ChunkCoordPair chunkCoordPair, LevelDBChunkType type) {
        return LevelDBKey.key(dimension, chunkCoordPair, type.getId());
    }

    public static byte[] key(Dimension dimension, ChunkCoordPair chunkCoordPair, byte type) {
        ByteBuffer buffer = ByteBuffer.allocate(8 + (dimension == Dimension.OVERWORLD ? 0 : 4) + 1);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(chunkCoordPair.chunkX());
        buffer.putInt(chunkCoordPair.chunkZ());
        if (dimension != Dimension.OVERWORLD) {
            buffer.putInt(dimension.getBedrockID());
        }
        buffer.put(type);
        return buffer.array();
    }

    public static byte[] key(byte[] prefix, Dimension dimension, ChunkCoordPair chunkCoordPair) {
        ByteBuffer buffer = ByteBuffer.allocate(prefix.length + 4 + 4 + (dimension == Dimension.OVERWORLD ? 0 : 4));
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(prefix);
        buffer.putInt(chunkCoordPair.chunkX());
        buffer.putInt(chunkCoordPair.chunkZ());
        if (dimension != Dimension.OVERWORLD) {
            buffer.putInt(dimension.getBedrockID());
        }
        return buffer.array();
    }

    public static byte[] key(byte[] prefix, byte[] value) {
        return Bytes.concat(prefix, value);
    }
}

