/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.identifier.BedrockBlockCompoundTag;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBChunkType;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBKey;
import com.hivemc.chunker.conversion.encoding.bedrock.util.PaletteUtil;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.Bool;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.LiquidLevel;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.ShortBasedPalette;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.scheduling.function.ThrowableConsumer;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.iq80.leveldb.DB;
import org.jetbrains.annotations.Nullable;

public class BedrockChunkWriter {
    protected final BedrockResolvers resolvers;
    protected final DB database;
    protected final Converter converter;
    protected final Dimension dimension;
    protected final ChunkerColumn chunkerColumn;

    public BedrockChunkWriter(Converter converter, BedrockResolvers resolvers, DB database, Dimension dimension, ChunkerColumn chunkerColumn) {
        this.resolvers = resolvers;
        this.database = database;
        this.converter = converter;
        this.dimension = dimension;
        this.chunkerColumn = chunkerColumn;
    }

    public void writeChunk(@Nullable ChunkerChunk chunkerChunk) {
        if (chunkerChunk == null || this.converter.shouldDiscardEmptyChunks() && chunkerChunk.isEmpty()) {
            return;
        }
        if (!this.isChunkHeightSupported(chunkerChunk.getY())) {
            return;
        }
        this.createChunkTasks(chunkerChunk);
    }

    protected List<Task<Void>> createChunkTasks(ChunkerChunk chunkerChunk) {
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>(1);
        tasks.add(Task.asyncConsume("Writing Block Palette", TaskWeight.HIGH, this::writeBlockPalette, chunkerChunk));
        return tasks;
    }

    protected boolean isChunkHeightSupported(byte chunkY) {
        return chunkY >= 0 && chunkY < 16;
    }

    protected void writeBlockPalette(ChunkerChunk chunk) throws Exception {
        byte[] bytes;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            Writer writer = Writer.toBedrockWriter(dataOutputStream);
            writer.writeByte((byte)8);
            Palette<BedrockBlockCompoundTag> blockPalette = chunk.getPalette().map(this.resolvers::writeBlock);
            boolean containsWaterlogged = blockPalette.containsValue(BedrockBlockCompoundTag::waterlogged);
            int layers = containsWaterlogged ? 2 : 1;
            writer.writeByte((byte)layers);
            this.writeLayers(writer, layers, blockPalette);
            bytes = byteArrayOutputStream.toByteArray();
        }
        this.writeChunkBytes(chunk, bytes);
    }

    protected void writeChunkBytes(ChunkerChunk chunk, byte[] bytes) {
        byte subChunkY = chunk.getY();
        this.database.put(LevelDBKey.key(this.dimension, this.chunkerColumn.getPosition(), subChunkY, LevelDBChunkType.SUB_CHUNK_PREFIX), bytes);
    }

    protected void writeLayers(Writer writer, int layers, Palette<BedrockBlockCompoundTag> blockPalette) throws Exception {
        ThrowableConsumer<BedrockBlockCompoundTag> writeKey = entry -> Tag.encodeNamed(writer, "", entry.compoundTag());
        for (int layer = 0; layer < layers; ++layer) {
            if (layer == 0) {
                PaletteUtil.writeChunkPalette(writer, blockPalette, false, false, writeKey);
                continue;
            }
            Palette<BedrockBlockCompoundTag> liquidPalette = this.generateLiquidPalette(blockPalette);
            PaletteUtil.writeChunkPalette(writer, liquidPalette, false, false, writeKey);
        }
    }

    protected Palette<BedrockBlockCompoundTag> generateLiquidPalette(Palette<BedrockBlockCompoundTag> blockPalette) {
        short[][][] values = new short[16][16][16];
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    BedrockBlockCompoundTag block = blockPalette.get(x, y, z);
                    values[x][y][z] = (short)(block != null && block.waterlogged() ? 1 : 0);
                }
            }
        }
        List<BedrockBlockCompoundTag> keys = List.of(this.resolvers.writeBlock(ChunkerBlockIdentifier.AIR), this.resolvers.writeBlock(new ChunkerBlockIdentifier(ChunkerVanillaBlockType.WATER, Map.of(VanillaBlockStates.LIQUID_LEVEL, LiquidLevel._0, VanillaBlockStates.FLOWING, Bool.FALSE))));
        return new ShortBasedPalette<BedrockBlockCompoundTag>(keys, values);
    }
}

