/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.itemstack;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.trim.ChunkerTrimPattern;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class BedrockTrimPatternResolver
implements Resolver<String, ChunkerTrimPattern> {
    private final InvertibleMap<ChunkerTrimPattern, String> mapping = InvertibleMap.enumKeys(ChunkerTrimPattern.class);

    public BedrockTrimPatternResolver(Version version) {
        if (version.isGreaterThanOrEqual(1, 19, 80)) {
            this.mapping.put(ChunkerTrimPattern.COAST, "coast");
            this.mapping.put(ChunkerTrimPattern.DUNE, "dune");
            this.mapping.put(ChunkerTrimPattern.EYE, "eye");
            this.mapping.put(ChunkerTrimPattern.RIB, "rib");
            this.mapping.put(ChunkerTrimPattern.SENTRY, "sentry");
            this.mapping.put(ChunkerTrimPattern.SNOUT, "snout");
            this.mapping.put(ChunkerTrimPattern.SPIRE, "spire");
            this.mapping.put(ChunkerTrimPattern.TIDE, "tide");
            this.mapping.put(ChunkerTrimPattern.VEX, "vex");
            this.mapping.put(ChunkerTrimPattern.WARD, "ward");
            this.mapping.put(ChunkerTrimPattern.WILD, "wild");
            this.mapping.put(ChunkerTrimPattern.HOST, "host");
            this.mapping.put(ChunkerTrimPattern.RAISER, "raiser");
            this.mapping.put(ChunkerTrimPattern.SHAPER, "shaper");
            this.mapping.put(ChunkerTrimPattern.SILENCE, "silence");
            this.mapping.put(ChunkerTrimPattern.WAYFINDER, "wayfinder");
        }
        if (version.isGreaterThanOrEqual(1, 20, 80)) {
            this.mapping.put(ChunkerTrimPattern.BOLT, "bolt");
            this.mapping.put(ChunkerTrimPattern.FLOW, "flow");
        }
    }

    @Override
    public Optional<String> from(ChunkerTrimPattern input) {
        return Optional.ofNullable(this.mapping.forward().get((Object)input));
    }

    @Override
    public Optional<ChunkerTrimPattern> to(String input) {
        return Optional.ofNullable(this.mapping.inverse().get(input));
    }
}

