/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.itemstack;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.trim.ChunkerTrimMaterial;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class BedrockTrimMaterialResolver
implements Resolver<String, ChunkerTrimMaterial> {
    private final InvertibleMap<ChunkerTrimMaterial, String> mapping = InvertibleMap.enumKeys(ChunkerTrimMaterial.class);

    public BedrockTrimMaterialResolver(Version version) {
        this.mapping.put(ChunkerTrimMaterial.AMETHYST, "amethyst");
        this.mapping.put(ChunkerTrimMaterial.COPPER, "copper");
        this.mapping.put(ChunkerTrimMaterial.DIAMOND, "diamond");
        this.mapping.put(ChunkerTrimMaterial.EMERALD, "emerald");
        this.mapping.put(ChunkerTrimMaterial.GOLD, "gold");
        this.mapping.put(ChunkerTrimMaterial.IRON, "iron");
        this.mapping.put(ChunkerTrimMaterial.LAPIS, "lapis");
        this.mapping.put(ChunkerTrimMaterial.NETHERITE, "netherite");
        this.mapping.put(ChunkerTrimMaterial.QUARTZ, "quartz");
        this.mapping.put(ChunkerTrimMaterial.REDSTONE, "redstone");
        if (version.isGreaterThanOrEqual(1, 21, 50)) {
            this.mapping.put(ChunkerTrimMaterial.RESIN, "resin");
        }
    }

    @Override
    public Optional<String> from(ChunkerTrimMaterial input) {
        return Optional.ofNullable(this.mapping.forward().get((Object)input));
    }

    @Override
    public Optional<ChunkerTrimMaterial> to(String input) {
        return Optional.ofNullable(this.mapping.inverse().get(input));
    }
}

