/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.java.util.FontUtil;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.sign.HangingSignBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.sign.SignBlockEntity;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.util.JsonTextUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class BedrockSignBlockEntityHandler
extends BlockEntityHandler<BedrockResolvers, CompoundTag, SignBlockEntity> {
    public static final int SIGN_MAX_WIDTH = 88;
    public static final int HANGING_SIGN_MAX_WIDTH = 60;

    public BedrockSignBlockEntityHandler() {
        super("Sign", SignBlockEntity.class, SignBlockEntity::new);
    }

    @Override
    public void read(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag input, @NotNull SignBlockEntity value) {
        value.setWaxed(input.getByte("IsWaxed", (byte)0) == 1);
        this.readSignFace(input.getCompound("FrontText", input), value.getFront(), value instanceof HangingSignBlockEntity);
        CompoundTag backText = input.getCompound("BackText");
        if (backText != null) {
            this.readSignFace(backText, value.getBack(), value instanceof HangingSignBlockEntity);
        }
    }

    protected void readSignFace(@NotNull CompoundTag input, SignBlockEntity.SignFace face, boolean hanging) {
        if (input.contains("Text")) {
            String[] textLines = input.getString("Text", "").split("\n");
            textLines = FontUtil.split(hanging ? 60 : 88, 4, textLines);
            ArrayList<JsonElement> lines = new ArrayList<JsonElement>(4);
            for (int i = 0; i < 4; ++i) {
                JsonObject text = textLines.length > i ? JsonTextUtil.fromText(textLines[i]) : JsonTextUtil.EMPTY_TEXT_TAG;
                lines.add(text);
            }
            face.setLines(lines);
        } else {
            ArrayList<JsonElement> lines = new ArrayList<JsonElement>(4);
            for (int i = 1; i <= 4; ++i) {
                lines.add(input.getOptionalValue("Text" + i, String.class).map(JsonTextUtil::fromText).orElse(JsonTextUtil.EMPTY_TEXT_TAG));
            }
            face.setLines(lines);
        }
        face.setLit(input.getByte("IgnoreLighting", (byte)0) == 1);
        face.setColor(input.getInt("SignTextColor", -16777216));
    }

    @Override
    public void write(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag output, @NotNull SignBlockEntity value) {
        if (resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 19, 80)) {
            output.put("IsWaxed", value.isWaxed() ? (byte)1 : 0);
            this.writeSignFace(resolvers, output.getOrCreateCompound("FrontText"), value.getFront());
            this.writeSignFace(resolvers, output.getOrCreateCompound("BackText"), value.getBack());
        } else {
            this.writeSignFace(resolvers, output, value.getFront());
        }
    }

    protected void writeSignFace(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag output, SignBlockEntity.SignFace face) {
        if (!output.contains("Text")) {
            StringBuilder text = new StringBuilder();
            for (JsonElement line : face.getLines()) {
                text.append(JsonTextUtil.toLegacy(line, true));
                text.append("\n");
            }
            output.put("Text", text.toString());
        }
        if (resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 17, 0)) {
            output.put("IgnoreLighting", face.isLit() ? (byte)1 : 0);
            if (resolvers.dataVersion().getVersion().isLessThanOrEqual(1, 19, 70)) {
                output.put("TextIgnoreLegacyBugResolved", (byte)1);
            }
        }
        output.put("SignTextColor", face.getColor());
    }
}

