/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.UpdateBeforeProcessBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.UpdateBeforeWriteBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.type.BedrockShulkerBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.ShulkerBoxBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.FacingDirection;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class BedrockShulkerBoxBlockEntityHandler
extends BlockEntityHandler<BedrockResolvers, CompoundTag, BedrockShulkerBlockEntity>
implements UpdateBeforeWriteBlockEntityHandler<BedrockResolvers, ShulkerBoxBlockEntity>,
UpdateBeforeProcessBlockEntityHandler<BedrockResolvers, ShulkerBoxBlockEntity> {
    public static final BiMap<FacingDirection, Byte> FACING_DIRECTION_TO_BYTE = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(FacingDirection.NORTH, (Object)2)).put(FacingDirection.EAST, (Object)5)).put(FacingDirection.SOUTH, (Object)3)).put(FacingDirection.WEST, (Object)4)).put(FacingDirection.UP, (Object)1)).put(FacingDirection.DOWN, (Object)0)).build();

    public BedrockShulkerBoxBlockEntityHandler() {
        super("ShulkerBox", BedrockShulkerBlockEntity.class, BedrockShulkerBlockEntity::new);
    }

    @Override
    public void read(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag input, @NotNull BedrockShulkerBlockEntity value) {
        byte facing = input.getByte("facing", (byte)0);
        FacingDirection facingDirection = FACING_DIRECTION_TO_BYTE.inverse().getOrDefault(facing, FacingDirection.NORTH);
        value.setFacing(facingDirection);
    }

    @Override
    public void write(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag output, @NotNull BedrockShulkerBlockEntity value) {
        byte facing = FACING_DIRECTION_TO_BYTE.getOrDefault(value.getFacing(), (byte)0);
        output.put("facing", facing);
    }

    @Override
    public ShulkerBoxBlockEntity updateBeforeWrite(@NotNull BedrockResolvers resolvers, ChunkerColumn column, int x, int y, int z, ShulkerBoxBlockEntity blockEntity) {
        BedrockShulkerBlockEntity bedrockShulkerBlockEntity = new BedrockShulkerBlockEntity(blockEntity);
        ChunkerBlockIdentifier blockIdentifier = column.getBlock(x, y, z);
        FacingDirection facingDirection = blockIdentifier.getState(VanillaBlockStates.FACING_ALL);
        if (facingDirection != null) {
            bedrockShulkerBlockEntity.setFacing(facingDirection);
        }
        return bedrockShulkerBlockEntity;
    }

    @Override
    public ShulkerBoxBlockEntity updateBeforeWrite(@NotNull BedrockResolvers resolvers, CompoundTag itemCompoundTag, ChunkerItemStack chunkerItemStack, ShulkerBoxBlockEntity blockEntity) {
        return new BedrockShulkerBlockEntity(blockEntity);
    }

    @Override
    public Class<ShulkerBoxBlockEntity> getAdditionalHandledClass() {
        return ShulkerBoxBlockEntity.class;
    }

    @Override
    public ShulkerBoxBlockEntity updateBeforeProcess(@NotNull BedrockResolvers resolvers, ChunkerColumn column, int x, int y, int z, ShulkerBoxBlockEntity blockEntity) {
        if (blockEntity instanceof BedrockShulkerBlockEntity) {
            BedrockShulkerBlockEntity bedrockShulkerBlockEntity = (BedrockShulkerBlockEntity)blockEntity;
            ChunkerBlockIdentifier blockIdentifier = column.getBlock(x, y, z);
            if (blockIdentifier.isAir()) {
                return blockEntity;
            }
            blockIdentifier = blockIdentifier.copyWith(VanillaBlockStates.FACING_ALL, bedrockShulkerBlockEntity.getFacing());
            column.setBlock(x, y, z, blockIdentifier);
            return bedrockShulkerBlockEntity.toChunker();
        }
        return blockEntity;
    }

    @Override
    public ShulkerBoxBlockEntity updateBeforeProcess(@NotNull BedrockResolvers resolvers, CompoundTag itemCompoundTag, ChunkerItemStack chunkerItemStack, ShulkerBoxBlockEntity blockEntity) {
        if (blockEntity instanceof BedrockShulkerBlockEntity) {
            BedrockShulkerBlockEntity bedrockShulkerBlockEntity = (BedrockShulkerBlockEntity)blockEntity;
            return bedrockShulkerBlockEntity.toChunker();
        }
        return blockEntity;
    }
}

