/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.UpdateBeforeProcessBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.UpdateBeforeWriteBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.type.BedrockBedBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BedBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerDyeColor;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class BedrockBedBlockEntityHandler
extends BlockEntityHandler<BedrockResolvers, CompoundTag, BedrockBedBlockEntity>
implements UpdateBeforeWriteBlockEntityHandler<BedrockResolvers, BedBlockEntity>,
UpdateBeforeProcessBlockEntityHandler<BedrockResolvers, BedBlockEntity> {
    public static final BiMap<ChunkerBlockType, ChunkerDyeColor> BED_TO_DYE = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(ChunkerVanillaBlockType.WHITE_BED, (Object)ChunkerDyeColor.WHITE)).put(ChunkerVanillaBlockType.ORANGE_BED, (Object)ChunkerDyeColor.ORANGE)).put(ChunkerVanillaBlockType.MAGENTA_BED, (Object)ChunkerDyeColor.MAGENTA)).put(ChunkerVanillaBlockType.LIGHT_BLUE_BED, (Object)ChunkerDyeColor.LIGHT_BLUE)).put(ChunkerVanillaBlockType.YELLOW_BED, (Object)ChunkerDyeColor.YELLOW)).put(ChunkerVanillaBlockType.LIME_BED, (Object)ChunkerDyeColor.LIME)).put(ChunkerVanillaBlockType.PINK_BED, (Object)ChunkerDyeColor.PINK)).put(ChunkerVanillaBlockType.GRAY_BED, (Object)ChunkerDyeColor.GRAY)).put(ChunkerVanillaBlockType.LIGHT_GRAY_BED, (Object)ChunkerDyeColor.LIGHT_GRAY)).put(ChunkerVanillaBlockType.CYAN_BED, (Object)ChunkerDyeColor.CYAN)).put(ChunkerVanillaBlockType.PURPLE_BED, (Object)ChunkerDyeColor.PURPLE)).put(ChunkerVanillaBlockType.BLUE_BED, (Object)ChunkerDyeColor.BLUE)).put(ChunkerVanillaBlockType.BROWN_BED, (Object)ChunkerDyeColor.BROWN)).put(ChunkerVanillaBlockType.GREEN_BED, (Object)ChunkerDyeColor.GREEN)).put(ChunkerVanillaBlockType.RED_BED, (Object)ChunkerDyeColor.RED)).put(ChunkerVanillaBlockType.BLACK_BED, (Object)ChunkerDyeColor.BLACK)).build();

    public BedrockBedBlockEntityHandler() {
        super("Bed", BedrockBedBlockEntity.class, BedrockBedBlockEntity::new);
    }

    @Override
    public void read(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag input, @NotNull BedrockBedBlockEntity value) {
        value.setColor(ChunkerDyeColor.getColorByID(input.getByte("color", (byte)0)).orElse(ChunkerDyeColor.WHITE));
    }

    @Override
    public void write(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag output, @NotNull BedrockBedBlockEntity value) {
        output.put("color", (byte)value.getColor().getID());
    }

    @Override
    public BedBlockEntity updateBeforeWrite(@NotNull BedrockResolvers resolvers, ChunkerColumn column, int x, int y, int z, BedBlockEntity blockEntity) {
        BedrockBedBlockEntity bedrockBedBlockEntity = new BedrockBedBlockEntity(blockEntity);
        ChunkerBlockIdentifier blockIdentifier = column.getBlock(x, y, z);
        ChunkerDyeColor color = BED_TO_DYE.getOrDefault(blockIdentifier.getType(), ChunkerDyeColor.WHITE);
        bedrockBedBlockEntity.setColor(color);
        return bedrockBedBlockEntity;
    }

    @Override
    public BedBlockEntity updateBeforeWrite(@NotNull BedrockResolvers resolvers, CompoundTag itemCompoundTag, ChunkerItemStack chunkerItemStack, BedBlockEntity blockEntity) {
        return new BedrockBedBlockEntity(blockEntity);
    }

    @Override
    public Class<BedBlockEntity> getAdditionalHandledClass() {
        return BedBlockEntity.class;
    }

    @Override
    public BedBlockEntity updateBeforeProcess(@NotNull BedrockResolvers resolvers, ChunkerColumn column, int x, int y, int z, BedBlockEntity blockEntity) {
        if (blockEntity instanceof BedrockBedBlockEntity) {
            BedrockBedBlockEntity bedrockBedBlockEntity = (BedrockBedBlockEntity)blockEntity;
            ChunkerBlockIdentifier blockIdentifier = column.getBlock(x, y, z);
            ChunkerBlockType newType = BED_TO_DYE.inverse().getOrDefault((Object)bedrockBedBlockEntity.getColor(), ChunkerVanillaBlockType.WHITE_BED);
            if (!blockIdentifier.isAir()) {
                column.setBlock(x, y, z, new ChunkerBlockIdentifier(newType, blockIdentifier.getPresentStates(), blockIdentifier.getPreservedIdentifier()));
            }
            return bedrockBedBlockEntity.toChunker();
        }
        return blockEntity;
    }

    @Override
    public BedBlockEntity updateBeforeProcess(@NotNull BedrockResolvers resolvers, CompoundTag itemCompoundTag, ChunkerItemStack chunkerItemStack, BedBlockEntity blockEntity) {
        if (blockEntity instanceof BedrockBedBlockEntity) {
            BedrockBedBlockEntity bedrockBedBlockEntity = (BedrockBedBlockEntity)blockEntity;
            return bedrockBedBlockEntity.toChunker();
        }
        return blockEntity;
    }
}

