/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform.handlers.BedrockChestPreTransformHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform.handlers.BedrockDoorPreTransformHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform.handlers.BedrockFenceGatePreTransformHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform.handlers.BedrockFirePreTransformHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform.handlers.BedrockHangingPlantPreTransformHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform.handlers.BedrockNoteBlockPreTransformHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform.handlers.BedrockRedstonePreTransformHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform.handlers.BedrockStairShapePreTransformHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform.handlers.BedrockStemPreTransformHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform.handlers.BedrockWallPreTransformHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.entity.handlers.BedrockPaintingEntityHandler;
import com.hivemc.chunker.conversion.handlers.pretransform.Edge;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.PreTransformManager;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block.BlockPreTransformHandler;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block.ConnectableBlockPreTransformHandler;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block.HorizontalConnectableBlockPreTransformHandler;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockGroups;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockStateValue;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.Bool;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.FacingDirectionHorizontal;
import com.hivemc.chunker.conversion.intermediate.column.entity.PaintingEntity;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BedrockReaderPreTransformManager
extends PreTransformManager {
    public BedrockReaderPreTransformManager(Version version) {
        super(version);
    }

    @Override
    public void registerHandlers(Version version) {
        if (version.isLessThan(1, 16, 0)) {
            this.registerHandler(new BedrockStemPreTransformHandler(Set.of(ChunkerVanillaBlockType.MELON)), ChunkerVanillaBlockType.ATTACHED_MELON_STEM, new ChunkerBlockType[0]);
            this.registerHandler(new BedrockStemPreTransformHandler(Set.of(ChunkerVanillaBlockType.PUMPKIN)), ChunkerVanillaBlockType.ATTACHED_PUMPKIN_STEM, new ChunkerBlockType[0]);
        }
        this.registerHandler(new HorizontalConnectableBlockPreTransformHandler(){

            @Override
            public boolean canConnect(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
                return relative.getType().equals(ChunkerVanillaBlockType.TRIPWIRE) || relative.getType().equals(ChunkerVanillaBlockType.TRIPWIRE_HOOK);
            }
        }, ChunkerVanillaBlockType.TRIPWIRE, new ChunkerBlockType[0]);
        this.registerHandler(new HorizontalConnectableBlockPreTransformHandler(){

            @Override
            public boolean canConnect(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
                if (ChunkerVanillaBlockGroups.FENCE_GATES.contains(relative.getType())) {
                    FacingDirectionHorizontal facing = relative.getState(VanillaBlockStates.FACING_HORIZONTAL);
                    return Objects.requireNonNull(facing).isAdjacent(direction.asFacingDirectionHorizontal());
                }
                return ChunkerVanillaBlockGroups.WOODEN_FENCES.contains(relative.getType()) || relative.getType().isAllFacesSolid();
            }
        }, ChunkerVanillaBlockGroups.WOODEN_FENCES);
        this.registerHandler(new HorizontalConnectableBlockPreTransformHandler(){

            @Override
            public boolean canConnect(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
                if (ChunkerVanillaBlockGroups.FENCE_GATES.contains(relative.getType())) {
                    FacingDirectionHorizontal facing = relative.getState(VanillaBlockStates.FACING_HORIZONTAL);
                    return Objects.requireNonNull(facing).isAdjacent(direction.asFacingDirectionHorizontal());
                }
                return relative.getType().equals(ChunkerVanillaBlockType.NETHER_BRICK_FENCE) || relative.getType().isAllFacesSolid();
            }
        }, ChunkerVanillaBlockType.NETHER_BRICK_FENCE, new ChunkerBlockType[0]);
        this.registerHandler(new BedrockFenceGatePreTransformHandler(), ChunkerVanillaBlockGroups.FENCE_GATES);
        this.registerHandler(new HorizontalConnectableBlockPreTransformHandler(){

            @Override
            public boolean canConnect(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
                return ChunkerVanillaBlockGroups.BARS_AND_GLASS_PANES.contains(relative.getType()) || ChunkerVanillaBlockGroups.WALLS.contains(relative.getType()) || relative.getType().isAllFacesSolid();
            }
        }, ChunkerVanillaBlockGroups.BARS_AND_GLASS_PANES);
        this.registerHandler(new HorizontalConnectableBlockPreTransformHandler(){

            @Override
            public boolean canConnect(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
                return relative.getType().equals(source.getType()) || relative.getType().equals(ChunkerVanillaBlockType.TRIPWIRE_HOOK);
            }
        }, ChunkerVanillaBlockType.TRIPWIRE, new ChunkerBlockType[0]);
        this.registerHandler(new ConnectableBlockPreTransformHandler(){

            @Override
            public boolean canConnect(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
                return relative.getType().equals(source.getType()) || relative.getType().equals(ChunkerVanillaBlockType.CHORUS_FLOWER) || direction == BlockPreTransformHandler.Direction.DOWN && relative.getType().equals(ChunkerVanillaBlockType.END_STONE);
            }
        }, ChunkerVanillaBlockType.CHORUS_PLANT, new ChunkerBlockType[0]);
        this.registerHandler(new BedrockWallPreTransformHandler(version), ChunkerVanillaBlockGroups.WALLS);
        this.registerHandler(new BlockPreTransformHandler(){

            @Override
            public Set<Edge> getRequiredEdges(ChunkerColumn column, int x, int y, int z, ChunkerBlockIdentifier blockIdentifier) {
                return Collections.emptySet();
            }

            @Override
            public ChunkerBlockIdentifier handle(ChunkerColumn column, Map<Edge, ChunkerColumn> neighbours, int x, int y, int z, ChunkerBlockIdentifier blockIdentifier) {
                ChunkerBlockIdentifier aboveIdentifier = column.getBlock(x, y + 1, z);
                blockIdentifier = ChunkerVanillaBlockGroups.SNOWY_BLOCKS.contains(aboveIdentifier.getType()) ? blockIdentifier.copyWith(VanillaBlockStates.SNOWY, Bool.TRUE) : blockIdentifier.copyWith(VanillaBlockStates.SNOWY, Bool.FALSE);
                return blockIdentifier;
            }
        }, ChunkerVanillaBlockGroups.SNOWY_GRASS_BLOCKS);
        this.registerHandler(new BedrockDoorPreTransformHandler(), ChunkerVanillaBlockGroups.DOORS);
        this.registerHandler(new BedrockStairShapePreTransformHandler(), ChunkerVanillaBlockGroups.STAIRS);
        this.registerHandler(new BedrockRedstonePreTransformHandler(), ChunkerVanillaBlockType.REDSTONE_WIRE, new ChunkerBlockType[0]);
        this.registerHandler(new BedrockNoteBlockPreTransformHandler(), ChunkerVanillaBlockType.NOTE_BLOCK, new ChunkerBlockType[0]);
        this.registerHandler(new BedrockFirePreTransformHandler(), ChunkerVanillaBlockType.FIRE, new ChunkerBlockType[0]);
        this.registerHandler(new BedrockHangingPlantPreTransformHandler(false, identifier -> new ChunkerBlockIdentifier(ChunkerVanillaBlockType.KELP_PLANT, Map.of(VanillaBlockStates.WATERLOGGED, (BlockStateValue)Objects.requireNonNull(identifier.getState(VanillaBlockStates.WATERLOGGED)))), Set.of(ChunkerVanillaBlockType.KELP, ChunkerVanillaBlockType.KELP_PLANT)), ChunkerVanillaBlockType.KELP, new ChunkerBlockType[0]);
        this.registerHandler(new BedrockHangingPlantPreTransformHandler(true, identifier -> new ChunkerBlockIdentifier(ChunkerVanillaBlockType.CAVE_VINES_BODY, identifier.getPresentStates(), identifier.getPreservedIdentifier()), Set.of(ChunkerVanillaBlockType.CAVE_VINES_BODY, ChunkerVanillaBlockType.CAVE_VINES_HEAD)), ChunkerVanillaBlockType.CAVE_VINES_HEAD, new ChunkerBlockType[0]);
        this.registerHandler(new BedrockHangingPlantPreTransformHandler(false, identifier -> new ChunkerBlockIdentifier(ChunkerVanillaBlockType.TWISTING_VINES_PLANT, Map.of(VanillaBlockStates.WATERLOGGED, (BlockStateValue)Objects.requireNonNull(identifier.getState(VanillaBlockStates.WATERLOGGED)))), Set.of(ChunkerVanillaBlockType.TWISTING_VINES, ChunkerVanillaBlockType.TWISTING_VINES_PLANT)), ChunkerVanillaBlockType.TWISTING_VINES, new ChunkerBlockType[0]);
        this.registerHandler(new BedrockHangingPlantPreTransformHandler(true, identifier -> new ChunkerBlockIdentifier(ChunkerVanillaBlockType.WEEPING_VINES_PLANT, Map.of(VanillaBlockStates.WATERLOGGED, (BlockStateValue)Objects.requireNonNull(identifier.getState(VanillaBlockStates.WATERLOGGED)))), Set.of(ChunkerVanillaBlockType.WEEPING_VINES, ChunkerVanillaBlockType.WEEPING_VINES_PLANT)), ChunkerVanillaBlockType.WEEPING_VINES, new ChunkerBlockType[0]);
        this.registerHandler(new BedrockChestPreTransformHandler(), ChunkerVanillaBlockGroups.DOUBLE_CHESTS);
        this.registerHandler(new BedrockPaintingEntityHandler.Relocator(false), PaintingEntity.class);
    }
}

