/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.reader;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.identifier.BedrockBlockCompoundTag;
import com.hivemc.chunker.conversion.encoding.bedrock.util.PaletteUtil;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.ShortBasedPalette;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public class BedrockChunkReader {
    protected final BedrockResolvers resolvers;
    protected final Converter converter;
    protected final Dimension dimension;
    protected final ChunkerChunk chunk;

    public BedrockChunkReader(BedrockResolvers resolvers, Converter converter, Dimension dimension, ChunkerChunk chunk) {
        this.resolvers = resolvers;
        this.converter = converter;
        this.dimension = dimension;
        this.chunk = chunk;
    }

    public void readChunk(byte[] subChunkData) {
        ByteBuffer buffer = ByteBuffer.wrap(subChunkData).order(ByteOrder.LITTLE_ENDIAN);
        Task.asyncConsume("Reading Palette", TaskWeight.HIGHER, this::readPalette, buffer);
    }

    protected void readPalette(ByteBuffer buffer) {
        byte version = buffer.get();
        this.readPalette(version, buffer);
    }

    protected void readPalette(byte version, ByteBuffer buffer) {
        if (version != 8) {
            this.converter.logNonFatalException(new Exception("Unsupported chunk version " + version));
            return;
        }
        byte layers = buffer.get();
        this.readLayers(buffer, layers);
    }

    protected void readLayers(ByteBuffer buffer, byte layers) {
        try {
            Palette<CompoundTag> blockPalette = null;
            Palette<ChunkerBlockIdentifier> liquidPalette = null;
            for (byte layer = 0; layer < layers; layer = (byte)(layer + 1)) {
                if (layer == 0) {
                    blockPalette = PaletteUtil.readChunkPalette(buffer, runtimeID -> this.readBlockPaletteCompound((boolean)runtimeID, buffer));
                    continue;
                }
                liquidPalette = PaletteUtil.readChunkPalette(buffer, runtimeID -> this.readLiquidPaletteEntry((boolean)runtimeID, buffer));
            }
            if (blockPalette != null) {
                if (liquidPalette == null || liquidPalette.isEmpty() || !liquidPalette.containsKey(a -> a.getType() == ChunkerVanillaBlockType.WATER)) {
                    this.chunk.setPalette(blockPalette.map(tag -> this.resolvers.readBlock(new BedrockBlockCompoundTag((CompoundTag)tag, false))));
                } else {
                    ShortBasedPalette<BedrockBlockCompoundTag> mergedPalette = new ShortBasedPalette<BedrockBlockCompoundTag>(2, 16);
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            for (int z = 0; z < 16; ++z) {
                                CompoundTag entry = blockPalette.get(x, y, z);
                                ChunkerBlockIdentifier liquid = liquidPalette.get(x, y, z, ChunkerBlockIdentifier.AIR);
                                boolean waterlogged = liquid.getType() == ChunkerVanillaBlockType.WATER;
                                mergedPalette.set(x, y, z, new BedrockBlockCompoundTag(entry, waterlogged));
                            }
                        }
                    }
                    this.chunk.setPalette(mergedPalette.map(this.resolvers::readBlock).compact(ChunkerBlockIdentifier.AIR));
                }
            }
        }
        catch (Exception e) {
            this.converter.logNonFatalException(e);
        }
    }

    protected CompoundTag readBlockPaletteCompound(boolean runtimeID, ByteBuffer input) throws Exception {
        if (runtimeID) {
            throw new Exception("RuntimeIDs are not supported in block palettes");
        }
        return Tag.readBedrockNBT(input);
    }

    protected ChunkerBlockIdentifier readLiquidPaletteEntry(boolean runtimeID, ByteBuffer input) throws Exception {
        if (runtimeID) {
            throw new Exception("RuntimeIDs are not supported in block palettes");
        }
        return this.resolvers.readBlock(new BedrockBlockCompoundTag(Objects.requireNonNull(Tag.readBedrockNBT(input)), false));
    }
}

