/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state;

import com.google.common.base.Preconditions;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state.StateLookupFunction;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state.StateMapping;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state.TypeMapping;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state.VersionedStateMappingGroup;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockState;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockStateValue;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StateMappingGroup
implements VersionedStateMappingGroup {
    private final List<StateMapping<?, ?>> states;
    private final Map<String, Object> defaultInputs;
    private final Map<BlockState<?>, BlockStateValue> defaultOutputs;

    public StateMappingGroup(List<StateMapping<?, ?>> states, Map<String, Object> defaultInputs, Map<BlockState<?>, BlockStateValue> defaultOutputs) {
        this.states = states;
        this.defaultInputs = defaultInputs;
        this.defaultOutputs = defaultOutputs;
    }

    public void applyInput(StateLookupFunction<String, Object> inputStateLookup, Map<BlockState<?>, BlockStateValue> outputs) {
        for (StateMapping<?, ?> stateMapping : this.states) {
            boolean allowDefaultValue = !this.defaultOutputs.keySet().containsAll(stateMapping.getOutputBlockStates());
            stateMapping.applyInput(inputStateLookup, outputs, allowDefaultValue);
        }
        for (Map.Entry entry : this.defaultOutputs.entrySet()) {
            outputs.putIfAbsent((BlockState)entry.getKey(), (BlockStateValue)entry.getValue());
        }
    }

    public void applyOutput(StateLookupFunction<BlockState<?>, BlockStateValue> inputStateLookup, Map<String, Object> outputs) {
        for (StateMapping<?, ?> stateMapping : this.states) {
            boolean allowDefaultValue = !this.defaultInputs.keySet().containsAll(stateMapping.getInputStateNames());
            stateMapping.applyOutput(inputStateLookup, outputs, allowDefaultValue);
        }
        for (Map.Entry entry : this.defaultInputs.entrySet()) {
            outputs.putIfAbsent((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public StateMappingGroup getStateMappingGroup(Version version) {
        return this;
    }

    public static final class Builder {
        private final List<StateMapping<?, ?>> states = new ArrayList();
        private final Map<String, Object> defaultInputs = new Object2ObjectOpenHashMap<String, Object>();
        private final Map<BlockState<?>, BlockStateValue> defaultOutputs = new Object2ObjectOpenHashMap();

        public <T> Builder defaultInput(String inputStateName, T value) {
            Preconditions.checkArgument(this.defaultInputs.put(inputStateName, value) == null, "Duplicate default output for " + inputStateName);
            return this;
        }

        public <O extends BlockStateValue> Builder defaultOutput(BlockState<O> blockState, O value) {
            Preconditions.checkArgument(this.defaultOutputs.put(blockState, value) == null, "Duplicate default output for " + String.valueOf(blockState));
            return this;
        }

        public <I, O extends BlockStateValue> Builder state(String inputStateName, BlockState<O> blockState, TypeMapping<I, O> typeMapping) {
            this.states.add(new StateMapping(List.of(inputStateName), List.of(blockState), typeMapping));
            return this;
        }

        public <I, O extends BlockStateValue> Builder multiState(String inputStateName, List<BlockState<? extends O>> blockStates, TypeMapping<I, O> typeMapping) {
            this.states.add(new StateMapping<I, O>(List.of(inputStateName), blockStates, typeMapping));
            return this;
        }

        public <I, O extends BlockStateValue> Builder multiState(List<String> inputStateNames, BlockState<O> blockState, TypeMapping<I, O> typeMapping) {
            this.states.add(new StateMapping(inputStateNames, List.of(blockState), typeMapping));
            return this;
        }

        public <I, O extends BlockStateValue> Builder multiState(List<String> inputStateNames, List<BlockState<? extends O>> blockStates, TypeMapping<I, O> typeMapping) {
            this.states.add(new StateMapping<I, O>(inputStateNames, blockStates, typeMapping));
            return this;
        }

        public <I, O extends BlockStateValue> Builder combineInputStates(String inputStateName1, String inputStateName2, BlockState<O> blockState, TypeMapping<I, O> typeMapping) {
            this.states.add(new StateMapping(List.of(inputStateName1, inputStateName2), List.of(blockState), typeMapping));
            return this;
        }

        public <I, O extends BlockStateValue> Builder combineOutputStates(String inputStateName, BlockState<? extends O> blockState1, BlockState<? extends O> blockState2, TypeMapping<I, O> typeMapping) {
            this.states.add(new StateMapping<I, O>(List.of(inputStateName), List.of(blockState1, blockState2), typeMapping));
            return this;
        }

        public StateMappingGroup build() {
            return new StateMappingGroup(this.states, this.defaultInputs, this.defaultOutputs);
        }
    }
}

