/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.base.resolver.identifier;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.ComparableItemProperty;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.ItemMapping;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifierType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.PreservedIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerCustomBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockState;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockStateValue;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.item.ChunkerItemType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.item.ChunkerVanillaItemType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemProperty;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.mapping.MappingsFile;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.mapping.identifier.states.StateValue;
import com.hivemc.chunker.mapping.identifier.states.StateValueInt;
import com.hivemc.chunker.mapping.resolver.MappingsFileResolvers;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.CollectionComparator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeMap;

public abstract class ChunkerItemIdentifierResolver
implements Resolver<Identifier, ChunkerItemStack> {
    protected final Converter converter;
    protected final Version version;
    protected final boolean defaultData;
    protected final boolean reader;
    protected final Map<String, InputStateGrouping<String, Object, ChunkerItemStackIdentifierType, ComparableItemProperty<?>, Object>> inputToChunker = new Object2ObjectOpenHashMap();
    protected final Map<ChunkerItemStackIdentifierType, InputStateGrouping<ComparableItemProperty<?>, Object, String, String, Object>> chunkerToInput = new Object2ObjectOpenHashMap();

    public ChunkerItemIdentifierResolver(Converter converter, Version version, boolean reader, boolean defaultData) {
        this.converter = converter;
        this.version = version;
        this.reader = reader;
        this.defaultData = defaultData;
        this.registerMappings(version);
    }

    private <I, IK extends Comparable<? super IK>, IV, O, OK, OV> void createMapping(Map<I, InputStateGrouping<IK, IV, O, OK, OV>> lookup, I inputIdentifier, NavigableMap<IK, IV> inputStates, O outputIdentifier, NavigableMap<OK, OV> outputStates, boolean override) {
        InputStateGrouping inputStateGrouping = lookup.computeIfAbsent(inputIdentifier, ignored -> new InputStateGrouping());
        OutputMapping<O, OK, OV> outputMapping = new OutputMapping<O, OK, OV>(outputIdentifier, outputStates);
        Map inputStateLookup = inputStateGrouping.getGroups().computeIfAbsent(inputStates.navigableKeySet(), ignored -> new Object2ObjectOpenHashMap());
        ArrayList inputValues = new ArrayList(inputStates.values());
        if (override) {
            if (inputStateLookup.put(inputValues, outputMapping) == null) {
                throw new IllegalArgumentException("No existing mapping to override, identifier: " + String.valueOf(inputIdentifier) + " states: " + String.valueOf(inputStates));
            }
        } else if (inputStateLookup.putIfAbsent(inputValues, outputMapping) != null) {
            throw new IllegalArgumentException("Duplicate state lookup entry, identifier: " + String.valueOf(inputIdentifier) + " states: " + String.valueOf(inputStates));
        }
    }

    protected void registerOverrideOutput(ItemMapping mapping) {
        this.createMapping(this.inputToChunker, mapping.getIdentifier(), mapping.getStates(), mapping.getItemStackIdentifierType(), mapping.getProperties(), false);
        this.createMapping(this.chunkerToInput, mapping.getItemStackIdentifierType(), mapping.getProperties(), mapping.getIdentifier(), mapping.getStates(), true);
    }

    protected void registerOverrideInput(ItemMapping mapping) {
        this.createMapping(this.inputToChunker, mapping.getIdentifier(), mapping.getStates(), mapping.getItemStackIdentifierType(), mapping.getProperties(), true);
        this.createMapping(this.chunkerToInput, mapping.getItemStackIdentifierType(), mapping.getProperties(), mapping.getIdentifier(), mapping.getStates(), false);
    }

    protected void registerOverrideInputOutput(ItemMapping mapping) {
        this.createMapping(this.inputToChunker, mapping.getIdentifier(), mapping.getStates(), mapping.getItemStackIdentifierType(), mapping.getProperties(), true);
        this.createMapping(this.chunkerToInput, mapping.getItemStackIdentifierType(), mapping.getProperties(), mapping.getIdentifier(), mapping.getStates(), true);
    }

    protected void registerOverrideOutput(ItemMapping[] mappings) {
        for (ItemMapping mapping : mappings) {
            this.registerOverrideOutput(mapping);
        }
    }

    protected void registerOverrideInput(ItemMapping[] mappings) {
        for (ItemMapping mapping : mappings) {
            this.registerOverrideInput(mapping);
        }
    }

    protected void registerDuplicateInput(ItemMapping mapping) {
        this.createMapping(this.chunkerToInput, mapping.getItemStackIdentifierType(), mapping.getProperties(), mapping.getIdentifier(), mapping.getStates(), false);
    }

    protected void registerDuplicateInput(ItemMapping[] mappings) {
        for (ItemMapping mapping : mappings) {
            this.registerDuplicateInput(mapping);
        }
    }

    protected void registerDuplicateOutput(ItemMapping mapping) {
        this.createMapping(this.inputToChunker, mapping.getIdentifier(), mapping.getStates(), mapping.getItemStackIdentifierType(), mapping.getProperties(), false);
    }

    protected void registerDuplicateOutput(ItemMapping[] mappings) {
        for (ItemMapping mapping : mappings) {
            this.registerDuplicateOutput(mapping);
        }
    }

    protected void register(ItemMapping mapping) {
        this.createMapping(this.inputToChunker, mapping.getIdentifier(), mapping.getStates(), mapping.getItemStackIdentifierType(), mapping.getProperties(), false);
        this.createMapping(this.chunkerToInput, mapping.getItemStackIdentifierType(), mapping.getProperties(), mapping.getIdentifier(), mapping.getStates(), false);
    }

    protected void register(ItemMapping[] mappings) {
        for (ItemMapping mapping : mappings) {
            this.register(mapping);
        }
    }

    protected void removeOutputMapping(ChunkerItemStackIdentifierType chunkerItemStackIdentifierType) {
        this.chunkerToInput.remove(chunkerItemStackIdentifierType);
    }

    public abstract void registerMappings(Version var1);

    public boolean isSupported(String identifier) {
        return this.inputToChunker.containsKey(identifier);
    }

    public boolean isSupported(ChunkerItemType chunkerItemType) {
        return this.chunkerToInput.containsKey(chunkerItemType);
    }

    protected Optional<ChunkerItemStack> handleConverterMapping(Identifier input, Optional<ChunkerItemStack> output) {
        boolean mapAsItem;
        MappingsFileResolvers mappingsFileResolvers = this.converter.getBlockMappings();
        if (mappingsFileResolvers == null) {
            return output;
        }
        MappingsFile mappings = this.reader ? mappingsFileResolvers.getMappings() : mappingsFileResolvers.getInverseMappings();
        Optional<Identifier> mappedIdentifier = mappings.convertItem(input, mapAsItem = output.isPresent());
        if (mappedIdentifier.isEmpty()) {
            return output;
        }
        return output.map(chunkerItemStack -> new ChunkerItemStack(chunkerItemStack.getIdentifier(), new PreservedIdentifier(this.reader, (Identifier)mappedIdentifier.get()), chunkerItemStack.getProperties())).or(() -> Optional.of(new ChunkerItemStack((ChunkerItemStackIdentifier)ChunkerVanillaItemType.STICK, new PreservedIdentifier(this.reader, (Identifier)mappedIdentifier.get()))));
    }

    protected Optional<Identifier> handleConverterMapping(ChunkerItemStack input, Optional<Identifier> output) {
        ChunkerItemStackIdentifier chunkerItemStackIdentifier;
        if (input.getPreservedIdentifier() == null || this.reader == input.getPreservedIdentifier().fromReader()) {
            return output;
        }
        Optional<ChunkerItemStack> preservedAsChunker = this.resolveTo(input.getPreservedIdentifier().identifier());
        if (preservedAsChunker.isPresent() && (chunkerItemStackIdentifier = preservedAsChunker.get().getIdentifier()) instanceof ChunkerBlockIdentifier) {
            ChunkerItemStack merged;
            Optional<Identifier> preservedConverted;
            ChunkerBlockIdentifier blockIdentifier = (ChunkerBlockIdentifier)chunkerItemStackIdentifier;
            Object2ObjectOpenHashMap states = new Object2ObjectOpenHashMap(blockIdentifier.getPresentStates());
            ChunkerItemStackIdentifier chunkerItemStackIdentifier2 = input.getIdentifier();
            if (chunkerItemStackIdentifier2 instanceof ChunkerBlockIdentifier) {
                ChunkerBlockIdentifier inputBlockIdentifier = (ChunkerBlockIdentifier)chunkerItemStackIdentifier2;
                for (Map.Entry entry : inputBlockIdentifier.getPresentStates().entrySet()) {
                    if (entry.getValue() instanceof ChunkerCustomBlockType.CustomBlockStateValue) continue;
                    states.put((BlockState)entry.getKey(), (BlockStateValue)entry.getValue());
                }
            }
            if ((preservedConverted = this.resolveFrom(merged = new ChunkerItemStack(new ChunkerBlockIdentifier(blockIdentifier.getType(), states)))).isPresent()) {
                Object2ObjectOpenHashMap object2ObjectOpenHashMap = new Object2ObjectOpenHashMap(preservedConverted.get().getStates());
                object2ObjectOpenHashMap.putAll(input.getPreservedIdentifier().identifier().getStates());
                return Optional.of(new Identifier(input.getPreservedIdentifier().identifier().getIdentifier(), object2ObjectOpenHashMap));
            }
        }
        return Optional.of(input.getPreservedIdentifier().identifier());
    }

    @Override
    public Optional<Identifier> from(ChunkerItemStack input) {
        return this.handleConverterMapping(input, this.resolveFrom(input));
    }

    protected Optional<ChunkerItemStack> resolveTo(Identifier input) {
        InputStateGrouping<String, Object, ChunkerItemStackIdentifierType, ComparableItemProperty<?>, Object> grouping = this.inputToChunker.get(input.getIdentifier());
        if (grouping == null) {
            return Optional.empty();
        }
        ArrayList tempList = new ArrayList();
        block0: for (Map.Entry<SortedSet<String>, Map<List<Object>, OutputMapping<ChunkerItemStackIdentifierType, ComparableItemProperty<?>, Object>>> group : grouping.getGroups().entrySet()) {
            for (String stateName : group.getKey()) {
                StateValue<?> stateValue = input.getStates().get(stateName);
                if (stateValue == null) {
                    tempList.clear();
                    continue block0;
                }
                tempList.add(stateValue.getBoxed());
            }
            OutputMapping<ChunkerItemStackIdentifierType, ComparableItemProperty<?>, Object> mapping = group.getValue().get(tempList);
            if (mapping != null) {
                ChunkerItemStackIdentifier type;
                Object2ObjectOpenHashMap properties = new Object2ObjectOpenHashMap(mapping.getOutputs().size());
                Object2ObjectOpenHashMap states = new Object2ObjectOpenHashMap();
                for (Map.Entry<ComparableItemProperty<?>, Object> entry : mapping.getOutputs().entrySet()) {
                    Object object = entry.getKey();
                    if (object instanceof ChunkerItemProperty) {
                        ChunkerItemProperty property = (ChunkerItemProperty)object;
                        properties.put(property, entry.getValue());
                        continue;
                    }
                    object = entry.getKey();
                    if (object instanceof BlockState) {
                        BlockState blockState = (BlockState)object;
                        object = entry.getValue();
                        if (object instanceof BlockStateValue) {
                            BlockStateValue blockStateValue = (BlockStateValue)object;
                            states.put(blockState, blockStateValue);
                            continue;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported property: " + String.valueOf(entry.getKey()));
                }
                ChunkerItemStackIdentifierType chunkerItemStackIdentifierType = mapping.getIdentifier();
                if (chunkerItemStackIdentifierType instanceof ChunkerBlockType) {
                    ChunkerBlockType blockType = (ChunkerBlockType)chunkerItemStackIdentifierType;
                    type = new ChunkerBlockIdentifier(blockType, states);
                } else {
                    chunkerItemStackIdentifierType = mapping.getIdentifier();
                    if (chunkerItemStackIdentifierType instanceof ChunkerItemStackIdentifier) {
                        ChunkerItemStackIdentifier itemStackIdentifier = (ChunkerItemStackIdentifier)((Object)chunkerItemStackIdentifierType);
                        type = itemStackIdentifier;
                    } else {
                        throw new IllegalArgumentException("Unable to create ChunkerItemStackIdentifier from " + String.valueOf(mapping.getIdentifier()));
                    }
                }
                return Optional.of(new ChunkerItemStack(type, properties));
            }
            tempList.clear();
        }
        return Optional.empty();
    }

    @Override
    public Optional<ChunkerItemStack> to(Identifier input) {
        return this.handleConverterMapping(input, this.resolveTo(input));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Optional<Identifier> resolveFrom(ChunkerItemStack input) {
        InputStateGrouping<ComparableItemProperty<?>, Object, String, String, Object> grouping = this.chunkerToInput.get(input.getIdentifier().getItemStackType());
        if (grouping == null) {
            return Optional.empty();
        }
        ArrayList<void> tempList = new ArrayList<void>();
        block0: for (Map.Entry<SortedSet<ComparableItemProperty<?>>, Map<List<Object>, OutputMapping<String, String, Object>>> group : grouping.getGroups().entrySet()) {
            for (ComparableItemProperty comparableItemProperty : group.getKey()) {
                void var8_9;
                if (comparableItemProperty instanceof ChunkerItemProperty) {
                    ChunkerItemProperty property = (ChunkerItemProperty)comparableItemProperty;
                    Object v = input.get(property);
                } else {
                    if (!(comparableItemProperty instanceof BlockState)) throw new IllegalArgumentException("Unsupported property: " + String.valueOf(comparableItemProperty));
                    BlockState blockState = (BlockState)comparableItemProperty;
                    ChunkerItemStackIdentifier chunkerItemStackIdentifier = input.getIdentifier();
                    if (!(chunkerItemStackIdentifier instanceof ChunkerBlockIdentifier)) throw new IllegalArgumentException("Unsupported property: " + String.valueOf(comparableItemProperty));
                    ChunkerBlockIdentifier blockIdentifier = (ChunkerBlockIdentifier)chunkerItemStackIdentifier;
                    Object u = blockIdentifier.getState(blockState);
                }
                if (var8_9 == null) {
                    tempList.clear();
                    continue block0;
                }
                tempList.add(var8_9);
            }
            OutputMapping<String, String, Object> mapping = group.getValue().get(tempList);
            if (mapping != null) {
                Map<String, Object> map = mapping.getOutputs();
                Identifier identifier = Identifier.fromBoxed(mapping.getIdentifier(), new HashMap<String, Object>(map));
                if (!identifier.getDataValue().isEmpty() || !this.defaultData) return Optional.of(identifier);
                identifier.getStates().put("data", new StateValueInt(0));
                return Optional.of(identifier);
            }
            tempList.clear();
        }
        return Optional.empty();
    }

    public static class InputStateGrouping<IK extends Comparable<? super IK>, IV, O, OK, OV> {
        private final TreeMap<SortedSet<IK>, Map<List<IV>, OutputMapping<O, OK, OV>>> groups = new TreeMap(new CollectionComparator().reversed());

        public TreeMap<SortedSet<IK>, Map<List<IV>, OutputMapping<O, OK, OV>>> getGroups() {
            return this.groups;
        }
    }

    public static class OutputMapping<O, OK, OV> {
        private final O identifier;
        private final Map<OK, OV> outputs;

        public OutputMapping(O identifier, Map<OK, OV> outputs) {
            this.identifier = identifier;
            this.outputs = outputs;
        }

        public O getIdentifier() {
            return this.identifier;
        }

        public Map<OK, OV> getOutputs() {
            return this.outputs;
        }
    }
}

