/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.base.resolver.identifier;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Multimap;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state.StateMappingGroup;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state.VersionedStateMappingGroup;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockState;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockStateValue;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.jetbrains.annotations.Nullable;

public class BlockMapping {
    private final String identifier;
    private final ChunkerBlockType blockType;
    private final NavigableMap<String, Object> states;
    @Nullable
    private final VersionedStateMappingGroup versionedStateMappingGroup;
    private final NavigableMap<BlockState<?>, BlockStateValue> blockStates;

    public BlockMapping(String identifier, ChunkerBlockType blockType, NavigableMap<String, Object> states, @Nullable VersionedStateMappingGroup versionedStateMappingGroup, NavigableMap<BlockState<?>, BlockStateValue> blockStates) {
        this.identifier = identifier;
        this.blockType = blockType;
        this.states = states;
        this.versionedStateMappingGroup = versionedStateMappingGroup;
        this.blockStates = blockStates;
    }

    public static BlockMapping of(String identifier, ChunkerBlockType blockType) {
        return new BlockMapping(identifier, blockType, Collections.emptyNavigableMap(), null, Collections.emptyNavigableMap());
    }

    public static <S> BlockMapping of(String identifier, String stateName, S stateValue, ChunkerBlockType blockType) {
        return new BlockMapping(identifier, blockType, ImmutableSortedMap.of(stateName, stateValue), null, Collections.emptyNavigableMap());
    }

    public static <S, V extends BlockStateValue> BlockMapping of(String identifier, String stateName, S stateValue, ChunkerBlockType blockType, BlockState<V> blockState, V blockStateValue) {
        return new BlockMapping(identifier, blockType, ImmutableSortedMap.of(stateName, stateValue), null, ImmutableSortedMap.of(blockState, blockStateValue));
    }

    public static <S, V extends BlockStateValue> BlockMapping of(String identifier, String stateName, S stateValue, ChunkerBlockType blockType, VersionedStateMappingGroup stateMappingGroup, BlockState<V> blockState, V blockStateValue) {
        return new BlockMapping(identifier, blockType, ImmutableSortedMap.of(stateName, stateValue), stateMappingGroup, ImmutableSortedMap.of(blockState, blockStateValue));
    }

    public static <V extends BlockStateValue> BlockMapping of(String identifier, ChunkerBlockType blockType, Map<BlockState<? extends V>, ? extends V> blockStateValues) {
        return new BlockMapping(identifier, blockType, Collections.emptyNavigableMap(), null, ImmutableSortedMap.copyOf(blockStateValues));
    }

    public static <S, V extends BlockStateValue> BlockMapping of(String identifier, String stateName, S stateValue, ChunkerBlockType blockType, Map<BlockState<? extends V>, ? extends V> blockStateValues) {
        return new BlockMapping(identifier, blockType, ImmutableSortedMap.of(stateName, stateValue), null, ImmutableSortedMap.copyOf(blockStateValues));
    }

    public static <S, V extends BlockStateValue> BlockMapping of(String identifier, String stateName, S stateValue, ChunkerBlockType blockType, VersionedStateMappingGroup stateMappingGroup, Map<BlockState<? extends V>, ? extends V> blockStateValues) {
        return new BlockMapping(identifier, blockType, ImmutableSortedMap.of(stateName, stateValue), stateMappingGroup, ImmutableSortedMap.copyOf(blockStateValues));
    }

    public static <S1, S2, V extends BlockStateValue> BlockMapping of(String identifier, String stateName1, S1 stateValue1, String stateName2, S2 stateValue2, ChunkerBlockType blockType, BlockState<V> blockState, V blockStateValue) {
        return new BlockMapping(identifier, blockType, ImmutableSortedMap.of(stateName1, stateValue1, stateName2, stateValue2), null, ImmutableSortedMap.of(blockState, blockStateValue));
    }

    public static <S1, S2, V extends BlockStateValue> BlockMapping of(String identifier, String stateName1, S1 stateValue1, String stateName2, S2 stateValue2, ChunkerBlockType blockType, VersionedStateMappingGroup stateMappingGroup, BlockState<V> blockState, V blockStateValue) {
        return new BlockMapping(identifier, blockType, ImmutableSortedMap.of(stateName1, stateValue1, stateName2, stateValue2), stateMappingGroup, ImmutableSortedMap.of(blockState, blockStateValue));
    }

    public static <S1, S2> BlockMapping of(String identifier, String stateName1, S1 stateValue1, String stateName2, S2 stateValue2, ChunkerBlockType blockType, VersionedStateMappingGroup stateMappingGroup) {
        return new BlockMapping(identifier, blockType, ImmutableSortedMap.of(stateName1, stateValue1, stateName2, stateValue2), stateMappingGroup, Collections.emptyNavigableMap());
    }

    public static <S1, S2> BlockMapping of(String identifier, String stateName1, S1 stateValue1, String stateName2, S2 stateValue2, ChunkerBlockType blockType) {
        return new BlockMapping(identifier, blockType, ImmutableSortedMap.of(stateName1, stateValue1, stateName2, stateValue2), null, Collections.emptyNavigableMap());
    }

    public static <V extends BlockStateValue> BlockMapping of(String identifier, ChunkerBlockType blockType, BlockState<V> blockState, V blockStateValue) {
        return new BlockMapping(identifier, blockType, Collections.emptyNavigableMap(), null, ImmutableSortedMap.of(blockState, blockStateValue));
    }

    public static <S> BlockMapping of(String identifier, String stateName, S stateValue, ChunkerBlockType blockType, VersionedStateMappingGroup stateMappingGroup) {
        return new BlockMapping(identifier, blockType, ImmutableSortedMap.of(stateName, stateValue), stateMappingGroup, Collections.emptyNavigableMap());
    }

    public static BlockMapping of(String identifier, ChunkerBlockType blockType, VersionedStateMappingGroup stateMappingGroup) {
        return new BlockMapping(identifier, blockType, Collections.emptyNavigableMap(), stateMappingGroup, Collections.emptyNavigableMap());
    }

    public static <V extends BlockStateValue> BlockMapping of(String identifier, ChunkerBlockType blockType, VersionedStateMappingGroup stateMappingGroup, BlockState<V> blockState, V blockStateValue) {
        return new BlockMapping(identifier, blockType, Collections.emptyNavigableMap(), stateMappingGroup, ImmutableSortedMap.of(blockState, blockStateValue));
    }

    public static <V extends BlockStateValue> BlockMapping[] merge(ChunkerBlockType blockType, BlockState<V> blockState, Multimap<String, V> identifiersToState) {
        BlockMapping[] mappings = new BlockMapping[identifiersToState.size()];
        int i = 0;
        for (Map.Entry<String, V> entry : identifiersToState.entries()) {
            mappings[i++] = new BlockMapping(entry.getKey(), blockType, Collections.emptyNavigableMap(), null, ImmutableSortedMap.of(blockState, (BlockStateValue)entry.getValue()));
        }
        return mappings;
    }

    public static <V extends BlockStateValue> BlockMapping[] merge(ChunkerBlockType blockType, BlockState<V> blockState, Multimap<String, V> identifiersToState, VersionedStateMappingGroup stateMappingGroup) {
        BlockMapping[] mappings = new BlockMapping[identifiersToState.size()];
        int i = 0;
        for (Map.Entry<String, V> entry : identifiersToState.entries()) {
            mappings[i++] = new BlockMapping(entry.getKey(), blockType, Collections.emptyNavigableMap(), stateMappingGroup, ImmutableSortedMap.of(blockState, (BlockStateValue)entry.getValue()));
        }
        return mappings;
    }

    public static <V extends BlockStateValue> BlockMapping[] group(Multimap<String, ? extends ChunkerBlockType> types, VersionedStateMappingGroup stateMappingGroup, BlockState<V> blockState, V blockStateValue) {
        BlockMapping[] mappings = new BlockMapping[types.size()];
        int i = 0;
        for (Map.Entry<String, ? extends ChunkerBlockType> entry : types.entries()) {
            mappings[i++] = new BlockMapping(entry.getKey(), entry.getValue(), Collections.emptyNavigableMap(), stateMappingGroup, ImmutableSortedMap.of(blockState, blockStateValue));
        }
        return mappings;
    }

    public static BlockMapping[] group(Multimap<String, ? extends ChunkerBlockType> types) {
        BlockMapping[] mappings = new BlockMapping[types.size()];
        int i = 0;
        for (Map.Entry<String, ? extends ChunkerBlockType> entry : types.entries()) {
            mappings[i++] = new BlockMapping(entry.getKey(), entry.getValue(), Collections.emptyNavigableMap(), null, Collections.emptyNavigableMap());
        }
        return mappings;
    }

    public static BlockMapping[] group(Multimap<String, ? extends ChunkerBlockType> types, VersionedStateMappingGroup stateMappingGroup) {
        BlockMapping[] mappings = new BlockMapping[types.size()];
        int i = 0;
        for (Map.Entry<String, ? extends ChunkerBlockType> entry : types.entries()) {
            mappings[i++] = new BlockMapping(entry.getKey(), entry.getValue(), Collections.emptyNavigableMap(), stateMappingGroup, Collections.emptyNavigableMap());
        }
        return mappings;
    }

    public static <S> BlockMapping[] group(String stateName, S stateValue, Multimap<String, ? extends ChunkerBlockType> types, VersionedStateMappingGroup stateMappingGroup) {
        BlockMapping[] mappings = new BlockMapping[types.size()];
        int i = 0;
        for (Map.Entry<String, ? extends ChunkerBlockType> entry : types.entries()) {
            mappings[i++] = new BlockMapping(entry.getKey(), entry.getValue(), ImmutableSortedMap.of(stateName, stateValue), stateMappingGroup, Collections.emptyNavigableMap());
        }
        return mappings;
    }

    public static <S, V extends BlockStateValue> BlockMapping[] group(String stateName, S stateValue, Multimap<String, ? extends ChunkerBlockType> types, VersionedStateMappingGroup stateMappingGroup, BlockState<V> blockState, V blockStateValue) {
        BlockMapping[] mappings = new BlockMapping[types.size()];
        ImmutableSortedMap<BlockState<?>, BlockStateValue> blockStates = ImmutableSortedMap.of(blockState, blockStateValue);
        int i = 0;
        for (Map.Entry<String, ? extends ChunkerBlockType> entry : types.entries()) {
            mappings[i++] = new BlockMapping(entry.getKey(), entry.getValue(), ImmutableSortedMap.of(stateName, stateValue), stateMappingGroup, blockStates);
        }
        return mappings;
    }

    public static <S> BlockMapping[] flatten(String identifier, String stateName, Multimap<S, ? extends ChunkerBlockType> stateToBlockType) {
        BlockMapping[] mappings = new BlockMapping[stateToBlockType.size()];
        int i = 0;
        for (Map.Entry<S, ChunkerBlockType> entry : stateToBlockType.entries()) {
            mappings[i++] = new BlockMapping(identifier, entry.getValue(), ImmutableSortedMap.of(stateName, entry.getKey()), null, Collections.emptyNavigableMap());
        }
        return mappings;
    }

    public static <S, V extends BlockStateValue> BlockMapping[] flatten(String identifier, String stateName, Multimap<S, ? extends ChunkerBlockType> stateToBlockType, BlockState<V> blockState, V blockStateValue) {
        BlockMapping[] mappings = new BlockMapping[stateToBlockType.size()];
        int i = 0;
        ImmutableSortedMap<BlockState<?>, BlockStateValue> blockStates = ImmutableSortedMap.of(blockState, blockStateValue);
        for (Map.Entry<S, ChunkerBlockType> entry : stateToBlockType.entries()) {
            mappings[i++] = new BlockMapping(identifier, entry.getValue(), ImmutableSortedMap.of(stateName, entry.getKey()), null, blockStates);
        }
        return mappings;
    }

    public static <S, V extends BlockStateValue> BlockMapping[] flatten(String identifier, String stateName, Multimap<S, ? extends ChunkerBlockType> stateToBlockType, VersionedStateMappingGroup stateMappingGroup, BlockState<V> blockState, V blockStateValue) {
        BlockMapping[] mappings = new BlockMapping[stateToBlockType.size()];
        int i = 0;
        ImmutableSortedMap<BlockState<?>, BlockStateValue> blockStates = ImmutableSortedMap.of(blockState, blockStateValue);
        for (Map.Entry<S, ChunkerBlockType> entry : stateToBlockType.entries()) {
            mappings[i++] = new BlockMapping(identifier, entry.getValue(), ImmutableSortedMap.of(stateName, entry.getKey()), stateMappingGroup, blockStates);
        }
        return mappings;
    }

    public static <S, V extends BlockStateValue> BlockMapping[] flatten(String identifier, String stateName, BlockState<V> blockState, Multimap<S, Pair<V, ? extends ChunkerBlockType>> stateToBlockType) {
        BlockMapping[] mappings = new BlockMapping[stateToBlockType.size()];
        int i = 0;
        for (Map.Entry<S, Pair<V, ChunkerBlockType>> entry : stateToBlockType.entries()) {
            mappings[i++] = new BlockMapping(identifier, entry.getValue().right(), ImmutableSortedMap.of(stateName, entry.getKey()), null, ImmutableSortedMap.of(blockState, (BlockStateValue)entry.getValue().left()));
        }
        return mappings;
    }

    public static <S> BlockMapping[] flatten(String identifier, String stateName, List<BlockState<?>> blockStates, Multimap<S, Pair<List<BlockStateValue>, ? extends ChunkerBlockType>> stateToBlockType) {
        BlockMapping[] mappings = new BlockMapping[stateToBlockType.size()];
        int i = 0;
        for (Map.Entry<S, Pair<List<BlockStateValue>, ChunkerBlockType>> entry : stateToBlockType.entries()) {
            Preconditions.checkArgument(entry.getValue().left().size() == blockStates.size(), "Number of states does not match");
            ImmutableSortedMap.Builder mapBuilder = ImmutableSortedMap.naturalOrder();
            for (int j = 0; j < blockStates.size(); ++j) {
                mapBuilder.put(blockStates.get(j), entry.getValue().left().get(j));
            }
            mappings[i++] = new BlockMapping(identifier, entry.getValue().right(), (NavigableMap<String, Object>)ImmutableSortedMap.of(stateName, entry.getKey()), null, (NavigableMap<BlockState<?>, BlockStateValue>)((Object)mapBuilder.build()));
        }
        return mappings;
    }

    public static <S> BlockMapping[] flatten(String identifier, String stateName, List<BlockState<?>> blockStates, Multimap<S, Pair<List<BlockStateValue>, ? extends ChunkerBlockType>> stateToBlockType, VersionedStateMappingGroup stateMappingGroup) {
        BlockMapping[] mappings = new BlockMapping[stateToBlockType.size()];
        int i = 0;
        for (Map.Entry<S, Pair<List<BlockStateValue>, ChunkerBlockType>> entry : stateToBlockType.entries()) {
            Preconditions.checkArgument(entry.getValue().left().size() == blockStates.size(), "Number of states does not match");
            ImmutableSortedMap.Builder mapBuilder = ImmutableSortedMap.naturalOrder();
            for (int j = 0; j < blockStates.size(); ++j) {
                mapBuilder.put(blockStates.get(j), entry.getValue().left().get(j));
            }
            mappings[i++] = new BlockMapping(identifier, entry.getValue().right(), (NavigableMap<String, Object>)ImmutableSortedMap.of(stateName, entry.getKey()), stateMappingGroup, (NavigableMap<BlockState<?>, BlockStateValue>)((Object)mapBuilder.build()));
        }
        return mappings;
    }

    public static <S> BlockMapping[] flatten(String identifier, String stateName, Multimap<S, ? extends ChunkerBlockType> stateToBlockType, VersionedStateMappingGroup stateMappingGroup) {
        BlockMapping[] mappings = new BlockMapping[stateToBlockType.size()];
        int i = 0;
        for (Map.Entry<S, ChunkerBlockType> entry : stateToBlockType.entries()) {
            mappings[i++] = new BlockMapping(identifier, entry.getValue(), ImmutableSortedMap.of(stateName, entry.getKey()), stateMappingGroup, Collections.emptyNavigableMap());
        }
        return mappings;
    }

    public static <S1, S2> BlockMapping[] flatten(String identifier, String stateName1, String stateName2, Multimap<Pair<S1, S2>, ? extends ChunkerBlockType> stateToBlockType) {
        BlockMapping[] mappings = new BlockMapping[stateToBlockType.size()];
        int i = 0;
        for (Map.Entry<Pair<S1, S2>, ChunkerBlockType> entry : stateToBlockType.entries()) {
            mappings[i++] = new BlockMapping(identifier, entry.getValue(), ImmutableSortedMap.of(stateName1, entry.getKey().left(), stateName2, entry.getKey().right()), null, Collections.emptyNavigableMap());
        }
        return mappings;
    }

    public static <S1, S2> BlockMapping[] flatten(String identifier, String stateName1, String stateName2, Multimap<Pair<S1, S2>, ? extends ChunkerBlockType> stateToBlockType, VersionedStateMappingGroup stateMappingGroup) {
        BlockMapping[] mappings = new BlockMapping[stateToBlockType.size()];
        int i = 0;
        for (Map.Entry<Pair<S1, S2>, ChunkerBlockType> entry : stateToBlockType.entries()) {
            mappings[i++] = new BlockMapping(identifier, entry.getValue(), ImmutableSortedMap.of(stateName1, entry.getKey().left(), stateName2, entry.getKey().right()), stateMappingGroup, Collections.emptyNavigableMap());
        }
        return mappings;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ChunkerBlockType getBlockType() {
        return this.blockType;
    }

    public NavigableMap<String, Object> getStates() {
        return this.states;
    }

    @Nullable
    public StateMappingGroup getStateMappingGroup(Version version) {
        return this.versionedStateMappingGroup == null ? null : this.versionedStateMappingGroup.getStateMappingGroup(version);
    }

    public NavigableMap<BlockState<?>, BlockStateValue> getBlockStates() {
        return this.blockStates;
    }
}

