/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.base.resolver.blockentity;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.CustomItemNBTBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.DoNotProcessBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.DoNotWriteBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.GenerateBeforeProcessBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.GenerateBeforeWriteBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.UpdateBeforeProcessBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.UpdateBeforeWriteBlockEntityHandler;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.UnknownBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifierType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.resolver.hierarchy.KeyedHierarchyBasedResolver;
import com.hivemc.chunker.resolver.hierarchy.TypeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityResolver<R, D>
extends KeyedHierarchyBasedResolver<R, String, D, BlockEntity> {
    protected final boolean preserveUnknownBlockEntities;
    protected Map<TypeHandler<R, String, D, ? extends BlockEntity>, Map<Class<?>, Collection<Object>>> interfaceHandlerCache;
    protected Map<ChunkerBlockType, TypeHandler<R, String, D, ? extends BlockEntity>> generateBeforeProcessBlockEntityHandlers;
    protected Map<ChunkerBlockType, TypeHandler<R, String, D, ? extends BlockEntity>> generateBeforeWriteBlockEntityHandlers;

    public BlockEntityResolver(Version version, R resolvers, boolean preserveUnknownBlockEntities) {
        super(version, resolvers);
        this.preserveUnknownBlockEntities = preserveUnknownBlockEntities;
    }

    @Override
    protected void init() {
        this.interfaceHandlerCache = new ConcurrentHashMap();
        this.generateBeforeProcessBlockEntityHandlers = new ConcurrentHashMap<ChunkerBlockType, TypeHandler<R, String, D, ? extends BlockEntity>>();
        this.generateBeforeWriteBlockEntityHandlers = new ConcurrentHashMap<ChunkerBlockType, TypeHandler<R, String, D, ? extends BlockEntity>>();
    }

    @Override
    protected void register(TypeHandler<R, String, D, ? extends BlockEntity> typeHandler) {
        Object handler;
        super.register(typeHandler);
        if (typeHandler instanceof GenerateBeforeWriteBlockEntityHandler) {
            handler = (GenerateBeforeWriteBlockEntityHandler)((Object)typeHandler);
            for (ChunkerBlockType type : handler.getGenerateBeforeWriteBlockTypes()) {
                this.generateBeforeWriteBlockEntityHandlers.put(type, typeHandler);
            }
        }
        if (typeHandler instanceof GenerateBeforeProcessBlockEntityHandler) {
            handler = (GenerateBeforeProcessBlockEntityHandler)((Object)typeHandler);
            for (ChunkerBlockType type : handler.getGenerateBeforeProcessBlockTypes()) {
                this.generateBeforeProcessBlockEntityHandlers.put(type, typeHandler);
            }
        }
        if (typeHandler instanceof UpdateBeforeWriteBlockEntityHandler && (handler = (UpdateBeforeWriteBlockEntityHandler)((Object)typeHandler)).getAdditionalHandledClass() != null && handler.getAdditionalHandledClass() != typeHandler.getHandledClass()) {
            this.classHandlerLookup.putIfAbsent(handler.getAdditionalHandledClass(), typeHandler);
        }
        this.interfaceHandlerCache.clear();
    }

    private <T> Collection<Object> generateInterfaceHandlers(Class<T> interfaceClass, TypeHandler<R, String, D, ? extends BlockEntity> lastHandler) {
        Collection<TypeHandler<R, String, D, BlockEntity>> handlers = this.getTypeHandlers(lastHandler);
        if (handlers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> copy = new ArrayList<Object>(handlers.size());
        for (TypeHandler<R, String, D, ? extends BlockEntity> typeHandler : handlers) {
            if (!interfaceClass.isInstance(typeHandler)) continue;
            copy.add(interfaceClass.cast(typeHandler));
        }
        return copy;
    }

    public <T, U extends T> Collection<U> getInterfaceHandlers(Class<T> interfaceClass, TypeHandler<R, String, D, ? extends BlockEntity> lastHandler) {
        Map interfaceLookup = this.interfaceHandlerCache.computeIfAbsent(lastHandler, handler -> new ConcurrentHashMap());
        Collection handlers = interfaceLookup.computeIfAbsent(interfaceClass, handler -> this.generateInterfaceHandlers(interfaceClass, lastHandler));
        return handlers;
    }

    public <T extends BlockEntity> boolean shouldRemoveBeforeProcess(ChunkerColumn column, int x, int y, int z, T blockEntity) {
        Optional lastHandler = this.getFromTypeHandler(blockEntity);
        if (lastHandler.isEmpty()) {
            return false;
        }
        Collection handlers = this.getInterfaceHandlers(DoNotProcessBlockEntityHandler.class, lastHandler.get());
        if (handlers.isEmpty()) {
            return false;
        }
        for (DoNotProcessBlockEntityHandler handler : handlers) {
            if (!handler.shouldRemoveBeforeProcess(column, x, y, z, blockEntity)) continue;
            return true;
        }
        return false;
    }

    public <T extends BlockEntity> boolean shouldRemoveBeforeWrite(ChunkerColumn column, int x, int y, int z, T blockEntity) {
        Optional lastHandler = this.getFromTypeHandler(blockEntity);
        if (lastHandler.isEmpty()) {
            return false;
        }
        Collection handlers = this.getInterfaceHandlers(DoNotWriteBlockEntityHandler.class, lastHandler.get());
        if (handlers.isEmpty()) {
            return false;
        }
        for (DoNotWriteBlockEntityHandler handler : handlers) {
            if (!handler.shouldRemoveBeforeWrite(column, x, y, z, blockEntity)) continue;
            return true;
        }
        return false;
    }

    public <T extends BlockEntity> T updateBeforeProcess(ChunkerColumn column, int x, int y, int z, T blockEntity) {
        Optional lastHandler = this.getFromTypeHandler(blockEntity);
        if (lastHandler.isEmpty()) {
            return blockEntity;
        }
        Collection handlers = this.getInterfaceHandlers(UpdateBeforeProcessBlockEntityHandler.class, lastHandler.get());
        if (handlers.isEmpty()) {
            return blockEntity;
        }
        for (UpdateBeforeProcessBlockEntityHandler handler : handlers) {
            blockEntity = handler.updateBeforeProcess(this.resolvers, column, x, y, z, blockEntity);
        }
        return blockEntity;
    }

    public <T extends BlockEntity> T updateBeforeProcess(CompoundTag itemCompoundTag, ChunkerItemStack chunkerItemStack, T blockEntity) {
        Optional lastHandler = this.getFromTypeHandler(blockEntity);
        if (lastHandler.isEmpty()) {
            return blockEntity;
        }
        Collection handlers = this.getInterfaceHandlers(UpdateBeforeProcessBlockEntityHandler.class, lastHandler.get());
        if (handlers.isEmpty()) {
            return blockEntity;
        }
        for (UpdateBeforeProcessBlockEntityHandler handler : handlers) {
            blockEntity = handler.updateBeforeProcess(this.resolvers, itemCompoundTag, chunkerItemStack, blockEntity);
        }
        return blockEntity;
    }

    public <T extends BlockEntity> T updateBeforeWrite(ChunkerColumn column, int x, int y, int z, T blockEntity) {
        Optional lastHandler = this.getFromTypeHandler(blockEntity);
        if (lastHandler.isEmpty()) {
            return blockEntity;
        }
        Collection handlers = this.getInterfaceHandlers(UpdateBeforeWriteBlockEntityHandler.class, lastHandler.get());
        if (handlers.isEmpty()) {
            return blockEntity;
        }
        for (UpdateBeforeWriteBlockEntityHandler handler : handlers) {
            blockEntity = handler.updateBeforeWrite(this.resolvers, column, x, y, z, blockEntity);
        }
        return blockEntity;
    }

    public <T extends BlockEntity> T updateBeforeWrite(CompoundTag itemCompoundTag, ChunkerItemStack chunkerItemStack, T blockEntity) {
        Optional lastHandler = this.getFromTypeHandler(blockEntity);
        if (lastHandler.isEmpty()) {
            return blockEntity;
        }
        Collection handlers = this.getInterfaceHandlers(UpdateBeforeWriteBlockEntityHandler.class, lastHandler.get());
        if (handlers.isEmpty()) {
            return blockEntity;
        }
        for (UpdateBeforeWriteBlockEntityHandler handler : handlers) {
            blockEntity = handler.updateBeforeWrite(this.resolvers, itemCompoundTag, chunkerItemStack, blockEntity);
        }
        return blockEntity;
    }

    public <T extends BlockEntity> Optional<T> generateFromItemNBT(Class<? extends T> blockEntityClass, @NotNull ChunkerItemStack itemStack, @Nullable T output, @NotNull CompoundTag input) {
        boolean returnOutput;
        Optional lastHandler = this.getFromClassTypeHandler(blockEntityClass);
        if (lastHandler.isEmpty()) {
            return Optional.ofNullable(output);
        }
        Collection handlers = this.getInterfaceHandlers(CustomItemNBTBlockEntityHandler.class, lastHandler.get());
        if (handlers.isEmpty()) {
            return Optional.ofNullable(output);
        }
        boolean bl = returnOutput = output != null;
        if (output == null) {
            output = Objects.requireNonNull((BlockEntity)lastHandler.get().construct());
        }
        for (CustomItemNBTBlockEntityHandler handler : handlers) {
            if (!handler.generateFromItemNBT(this.resolvers, itemStack, output, input)) continue;
            returnOutput = true;
        }
        return returnOutput ? Optional.of(output) : Optional.empty();
    }

    public <T extends BlockEntity> boolean writeToItemNBT(@NotNull ChunkerItemStack itemStack, @NotNull T input, @NotNull CompoundTag output) {
        Optional lastHandler = this.getFromTypeHandler(input);
        if (lastHandler.isEmpty()) {
            return true;
        }
        Collection handlers = this.getInterfaceHandlers(CustomItemNBTBlockEntityHandler.class, lastHandler.get());
        if (handlers.isEmpty()) {
            return true;
        }
        boolean writeBlockEntityData = true;
        for (CustomItemNBTBlockEntityHandler handler : handlers) {
            if (handler.writeToItemNBT(this.resolvers, itemStack, input, output)) continue;
            writeBlockEntityData = false;
        }
        return writeBlockEntityData;
    }

    public void generateBeforeProcessBlockEntities(ChunkerColumn column, ChunkerChunk chunk) {
        Palette<ChunkerBlockIdentifier> palette = chunk.getPalette();
        if (!chunk.getPalette().containsKey(a -> this.generateBeforeProcessBlockEntityHandlers.containsKey(a.getType()))) {
            return;
        }
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    ChunkerBlockIdentifier entry = palette.get(x, y, z, ChunkerBlockIdentifier.AIR);
                    TypeHandler<R, String, D, BlockEntity> lastHandler = this.generateBeforeProcessBlockEntityHandlers.get(entry.getType());
                    if (lastHandler == null || column.getBlockEntity(x, chunk.getY() << 4 | y, z) != null) continue;
                    BlockEntity blockEntity = Objects.requireNonNull(lastHandler.construct());
                    blockEntity.setX(column.getPosition().chunkX() << 4 | x);
                    blockEntity.setY(chunk.getY() << 4 | y);
                    blockEntity.setZ(column.getPosition().chunkZ() << 4 | z);
                    column.getBlockEntities().add(blockEntity);
                    Collection handlers = this.getInterfaceHandlers(GenerateBeforeProcessBlockEntityHandler.class, lastHandler);
                    if (handlers.isEmpty()) {
                        return;
                    }
                    for (GenerateBeforeProcessBlockEntityHandler handler : handlers) {
                        handler.generateBeforeProcess(column, x, y, z, blockEntity, entry);
                    }
                }
            }
        }
    }

    public void generateBeforeWriteBlockEntities(ChunkerColumn column, ChunkerChunk chunk) {
        Palette<ChunkerBlockIdentifier> palette = chunk.getPalette();
        if (!chunk.getPalette().containsKey(a -> this.generateBeforeWriteBlockEntityHandlers.containsKey(a.getType()))) {
            return;
        }
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    ChunkerBlockIdentifier entry = palette.get(x, y, z, ChunkerBlockIdentifier.AIR);
                    TypeHandler<R, String, D, BlockEntity> lastHandler = this.generateBeforeWriteBlockEntityHandlers.get(entry.getType());
                    if (lastHandler == null || column.getBlockEntity(x, chunk.getY() << 4 | y, z) != null) continue;
                    BlockEntity blockEntity = Objects.requireNonNull(lastHandler.construct());
                    blockEntity.setX(column.getPosition().chunkX() << 4 | x);
                    blockEntity.setY(chunk.getY() << 4 | y);
                    blockEntity.setZ(column.getPosition().chunkZ() << 4 | z);
                    column.getBlockEntities().add(blockEntity);
                    Collection handlers = this.getInterfaceHandlers(GenerateBeforeWriteBlockEntityHandler.class, lastHandler);
                    if (handlers.isEmpty()) {
                        return;
                    }
                    for (GenerateBeforeWriteBlockEntityHandler handler : handlers) {
                        handler.generateBeforeWrite(column, x, y, z, blockEntity, entry);
                    }
                }
            }
        }
    }

    @Override
    public Optional<D> from(BlockEntity input) {
        if (input instanceof UnknownBlockEntity) {
            Object output;
            Optional blockEntityHandler;
            UnknownBlockEntity unknownBlockEntity = (UnknownBlockEntity)input;
            if (this.preserveUnknownBlockEntities && (blockEntityHandler = this.getFromClassTypeHandler(BlockEntity.class)).isPresent() && (output = this.constructDataType(unknownBlockEntity.getType())) != null) {
                blockEntityHandler.get().write(this.resolvers, output, input);
                return Optional.of(output);
            }
        }
        return super.from(input);
    }

    @Override
    public Optional<BlockEntity> to(Class<? extends BlockEntity> type, D input) {
        if (type == UnknownBlockEntity.class && this.preserveUnknownBlockEntities) {
            UnknownBlockEntity unknownBlockEntity = new UnknownBlockEntity(this.getKey(input).orElse(""));
            Optional blockEntityHandler = this.getFromClassTypeHandler(BlockEntity.class);
            if (blockEntityHandler.isPresent()) {
                blockEntityHandler.get().read(this.resolvers, input, unknownBlockEntity);
                return Optional.of(unknownBlockEntity);
            }
        }
        return super.to(type, input);
    }

    @Override
    public Optional<BlockEntity> to(D input) {
        Optional<BlockEntity> result = super.to(input);
        if (result.isEmpty() && this.preserveUnknownBlockEntities) {
            return this.to((Class<? extends BlockEntity>)UnknownBlockEntity.class, input);
        }
        return result;
    }

    public Optional<Class<? extends BlockEntity>> getBlockEntityClass(ChunkerItemStackIdentifierType itemStackType) {
        return itemStackType.getBlockEntityClass();
    }
}

