/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.base;

import com.google.common.base.CaseFormat;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.RegionCoordPair;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevel;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.mapping.resolver.MappingsFileResolvers;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public interface Converter {
    public boolean shouldLevelDBCompaction();

    public boolean shouldProcessMaps();

    public boolean shouldProcessItems();

    public boolean shouldProcessEntities();

    public boolean shouldProcessBlockEntities();

    public boolean shouldProcessLootTables();

    public boolean shouldProcessBiomes();

    public boolean shouldProcessHeightMap();

    public boolean shouldProcessColumnPreTransform();

    public boolean shouldProcessLighting();

    public boolean shouldProcessDimension(Dimension var1);

    public boolean shouldProcessRegion(Dimension var1, RegionCoordPair var2);

    public boolean shouldProcessColumn(Dimension var1, ChunkCoordPair var2);

    public boolean shouldAllowNBTCopying();

    public boolean shouldAllowCustomIdentifiers();

    @Nullable
    public MappingsFileResolvers getBlockMappings();

    default public void logNonFatalException(Throwable throwable) {
        throwable.printStackTrace();
    }

    default public void logMissingMapping(MissingMappingType type, String identifier) {
        System.err.println("Missing " + type.getName().replace('_', ' ') + " mapping for " + identifier);
    }

    public boolean shouldDiscardEmptyChunks();

    public boolean shouldPreventYBiomeBlending();

    public Optional<Dimension> getNewDimension(Dimension var1);

    public Optional<ChunkerLevel> level();

    public static enum MissingMappingType {
        BLOCK,
        ITEM,
        POTION,
        EFFECT,
        BIOME,
        ENTITY,
        ENTITY_TYPE,
        BLOCK_ENTITY,
        HORN,
        PAINTING,
        ENCHANTMENT,
        TRIM_MATERIAL,
        TRIM_PATTERN;

        private final String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, this.name());

        public String getName() {
            return this.name;
        }
    }
}

