/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.cli;

import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.hivemc.chunker.cli.EncodingTypeValidator;
import com.hivemc.chunker.cli.JsonObjectOrFile;
import com.hivemc.chunker.cli.VersionProvider;
import com.hivemc.chunker.cli.messenger.Messenger;
import com.hivemc.chunker.cli.messenger.messaging.DimensionPruningList;
import com.hivemc.chunker.conversion.WorldConverter;
import com.hivemc.chunker.conversion.encoding.EncodingType;
import com.hivemc.chunker.conversion.encoding.base.reader.LevelReader;
import com.hivemc.chunker.conversion.encoding.base.writer.LevelWriter;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.mapping.MappingsFile;
import com.hivemc.chunker.mapping.resolver.MappingsFileResolvers;
import com.hivemc.chunker.pruning.PruningConfig;
import com.hivemc.chunker.scheduling.task.TrackedTask;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import picocli.CommandLine;

@CommandLine.Command(name="Chunker", versionProvider=VersionProvider.class, mixinStandardHelpOptions=true)
public class CLI
implements Runnable {
    private static final TypeToken<Map<Dimension, Dimension>> DIMENSION_INPUT_TO_OUTPUT_TYPE = new TypeToken<Map<Dimension, Dimension>>(){};
    private static final Gson GSON = new Gson();
    @CommandLine.Option(names={"--inputDirectory", "-i"}, required=true, description={"Directory to read the world from."})
    private File inputDirectory;
    @CommandLine.Option(names={"--outputFormat", "-f"}, required=true, description={"The format to convert the world to."}, converter={EncodingTypeValidator.class})
    private String format;
    @CommandLine.Option(names={"--outputDirectory", "-o"}, required=true, description={"Directory to write the world to."})
    private File outputDirectory;
    @CommandLine.Option(names={"--blockMappings", "-m"}, description={"A JSON file/object containing block mappings."}, converter={JsonObjectOrFile.Converter.class})
    private JsonObjectOrFile blockMappings;
    @CommandLine.Option(names={"--worldSettings", "-s"}, description={"A JSON file/object containing world settings."}, converter={JsonObjectOrFile.Converter.class})
    private JsonObjectOrFile worldSettings;
    @CommandLine.Option(names={"--pruning", "-p"}, description={"A JSON file/object containing pruning settings."}, converter={JsonObjectOrFile.Converter.class})
    private JsonObjectOrFile pruningSettings;
    @CommandLine.Option(names={"--converterSettings", "-c"}, description={"A JSON file/object containing converter settings."}, converter={JsonObjectOrFile.Converter.class})
    private JsonObjectOrFile converterSettings;
    @CommandLine.Option(names={"--dimensionMappings", "-d"}, description={"A JSON file/object containing dimension mappings."}, converter={JsonObjectOrFile.Converter.class})
    private JsonObjectOrFile dimensionMappings;
    @CommandLine.Option(names={"--keepOriginalNBT", "-k"}, description={"Whether original NBT should be kept and written to the output world (only works if the output is the same as the input)."})
    private boolean keepOriginalNBT;

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("messenger")) {
            Messenger.main(args);
            return;
        }
        int exitCode = new CommandLine(new CLI()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public void run() {
        try {
            Path file;
            Stopwatch stopwatch = Stopwatch.createStarted();
            WorldConverter worldConverter = new WorldConverter(UUID.randomUUID());
            if (this.blockMappings == null) {
                file = this.inputDirectory.toPath().resolve("block_mappings.chunker.json");
                try {
                    if (file.toFile().exists()) {
                        this.blockMappings = new JsonObjectOrFile(file);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to parse integrated block mappings.");
                    throw new RuntimeException(e);
                }
            }
            if (this.blockMappings != null) {
                try {
                    MappingsFile mappingsFile = MappingsFile.load(this.blockMappings.getJSONObjectString());
                    worldConverter.setBlockMappings(new MappingsFileResolvers(mappingsFile));
                }
                catch (Exception e) {
                    System.err.println("Failed to parse block mappings.");
                    throw new RuntimeException(e);
                }
            }
            if (this.worldSettings == null) {
                file = this.inputDirectory.toPath().resolve("world_settings.chunker.json");
                try {
                    if (file.toFile().exists()) {
                        this.worldSettings = new JsonObjectOrFile(file);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to parse integrated world settings.");
                    throw new RuntimeException(e);
                }
            }
            if (this.worldSettings != null) {
                try {
                    worldConverter.setChangedSettings(GSON.fromJson(this.worldSettings.getJSONObjectString(), JsonObject.class));
                }
                catch (Exception e) {
                    System.err.println("Failed to parse world settings.");
                    throw new RuntimeException(e);
                }
            }
            if (this.pruningSettings == null) {
                file = this.inputDirectory.toPath().resolve("pruning.chunker.json");
                try {
                    if (file.toFile().exists()) {
                        this.pruningSettings = new JsonObjectOrFile(file);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to parse integrated pruning settings.");
                    throw new RuntimeException(e);
                }
            }
            if (this.pruningSettings != null) {
                try {
                    DimensionPruningList pruningList = GSON.fromJson(this.pruningSettings.getJSONObjectString(), DimensionPruningList.class);
                    if (pruningList.getConfigs() != null && !pruningList.getConfigs().isEmpty()) {
                        Object2ObjectOpenHashMap<Dimension, PruningConfig> pruningConfigs = new Object2ObjectOpenHashMap<Dimension, PruningConfig>(pruningList.getConfigs().size());
                        for (int i = 0; i < pruningList.getConfigs().size(); ++i) {
                            pruningConfigs.put(Dimension.values()[i], pruningList.getConfigs().get(i));
                        }
                        worldConverter.setPruningConfigs(pruningConfigs);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to parse pruning settings.");
                    throw new RuntimeException(e);
                }
            }
            if (this.dimensionMappings == null) {
                file = this.inputDirectory.toPath().resolve("dimension_mappings.chunker.json");
                try {
                    if (file.toFile().exists()) {
                        this.dimensionMappings = new JsonObjectOrFile(file);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to parse integrated dimension mappings.");
                    throw new RuntimeException(e);
                }
            }
            if (this.dimensionMappings != null) {
                try {
                    Map<Dimension, Dimension> dimensionMapping = GSON.fromJson(this.dimensionMappings.getJSONObjectString(), DIMENSION_INPUT_TO_OUTPUT_TYPE);
                    worldConverter.setDimensionMapping(dimensionMapping);
                }
                catch (Exception e) {
                    System.err.println("Failed to parse dimension mappings.");
                    throw new RuntimeException(e);
                }
            }
            if (this.converterSettings == null) {
                file = this.inputDirectory.toPath().resolve("converter_settings.chunker.json");
                try {
                    if (file.toFile().exists()) {
                        this.converterSettings = new JsonObjectOrFile(file);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to parse integrated converter settings.");
                    throw new RuntimeException(e);
                }
            }
            if (this.converterSettings != null) {
                try {
                    JsonObject parsedConverterSettings = GSON.fromJson(this.converterSettings.getJSONObjectString(), JsonObject.class);
                    boolean skipMaps = parsedConverterSettings.has("mapConversion") && !parsedConverterSettings.get("mapConversion").getAsBoolean();
                    boolean skipLootTables = parsedConverterSettings.has("lootTableConversion") && !parsedConverterSettings.get("lootTableConversion").getAsBoolean();
                    boolean skipItemConversion = parsedConverterSettings.has("itemConversion") && !parsedConverterSettings.get("itemConversion").getAsBoolean();
                    boolean skipBlockConnections = parsedConverterSettings.has("blockConnections") && !parsedConverterSettings.get("blockConnections").getAsBoolean();
                    boolean enableCompact = !parsedConverterSettings.has("enableCompact") || parsedConverterSettings.get("enableCompact").getAsBoolean();
                    boolean discardEmptyChunks = parsedConverterSettings.has("discardEmptyChunks") && parsedConverterSettings.get("discardEmptyChunks").getAsBoolean();
                    boolean preventYBiomeBlending = parsedConverterSettings.has("preventYBiomeBlending") && parsedConverterSettings.get("preventYBiomeBlending").getAsBoolean();
                    worldConverter.setProcessMaps(!skipMaps);
                    worldConverter.setProcessLootTables(!skipLootTables);
                    worldConverter.setProcessItems(!skipItemConversion);
                    worldConverter.setProcessColumnPreTransform(!skipBlockConnections);
                    worldConverter.setLevelDBCompaction(enableCompact);
                    worldConverter.setDiscardEmptyChunks(discardEmptyChunks);
                    worldConverter.setPreventYBiomeBlending(preventYBiomeBlending);
                }
                catch (Exception e) {
                    System.err.println("Failed to parse converter settings.");
                    throw new RuntimeException(e);
                }
            }
            worldConverter.setAllowNBTCopying(this.keepOriginalNBT);
            Optional<? extends LevelReader> reader = EncodingType.findReader(this.inputDirectory, worldConverter);
            Optional<? extends LevelWriter> writer = Messenger.findWriter(this.format, worldConverter, this.outputDirectory);
            if (reader.isEmpty()) {
                System.err.println("Failed to find suitable reader for the world.");
                return;
            }
            if (writer.isEmpty()) {
                System.err.println("Failed to find suitable writer for the world.");
                return;
            }
            System.out.println(MessageFormat.format("Converting from {0} {1} to {2} {3}", reader.get().getEncodingType().getName(), reader.get().getVersion(), writer.get().getEncodingType().getName(), writer.get().getVersion()));
            if (worldConverter.shouldAllowNBTCopying()) {
                if (reader.get().getEncodingType() != writer.get().getEncodingType()) {
                    System.err.println("Original NBT is not available for this conversion due to differing formats. Please disable it to continue.");
                    System.exit(0);
                } else {
                    System.out.println("Original NBT will be copied for this world, if you experience issues consider turning this option off as incompatible NBT may be written.");
                }
            }
            worldConverter.setCompactionSignal(started -> {
                if (started.booleanValue()) {
                    System.out.println("Compacting world, this may take a while...");
                } else {
                    System.out.println("Finished compacting world.");
                }
            });
            TrackedTask<Void> conversionTask = worldConverter.convert(reader.get(), writer.get());
            AtomicReference failed = new AtomicReference();
            conversionTask.future().exceptionally(exception -> {
                failed.set(exception);
                return null;
            });
            double value = -1.0;
            while (value != 1.0 && failed.get() == null) {
                double polled = conversionTask.getProgress();
                if (polled != value) {
                    System.out.printf("%.2f%%%n", polled * 100.0);
                    value = polled;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (failed.get() != null) {
                System.err.println("Failed with exception");
                ((Throwable)failed.get()).printStackTrace();
                System.exit(1);
            } else {
                Duration duration = stopwatch.elapsed();
                System.out.println("Conversion complete! Took " + String.format("%sh %sm %ss %sms", duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart(), duration.toMillisPart()));
                System.exit(0);
            }
        }
        catch (OutOfMemoryError e) {
            try {
                e.printStackTrace();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            System.exit(12);
        }
    }
}

