/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world;

import com.hbm.config.SpaceConfig;
import com.hbm.dim.Ike.WorldGeneratorIke;
import com.hbm.dim.Ike.WorldProviderIke;
import com.hbm.dim.WorldGeneratorCelestial;
import com.hbm.dim.WorldProviderEarth;
import com.hbm.dim.dres.WorldGeneratorDres;
import com.hbm.dim.dres.WorldProviderDres;
import com.hbm.dim.duna.WorldGeneratorDuna;
import com.hbm.dim.duna.WorldProviderDuna;
import com.hbm.dim.eve.WorldGeneratorEve;
import com.hbm.dim.eve.WorldProviderEve;
import com.hbm.dim.laythe.WorldGeneratorLaythe;
import com.hbm.dim.laythe.WorldProviderLaythe;
import com.hbm.dim.minmus.WorldGeneratorMinmus;
import com.hbm.dim.minmus.WorldProviderMinmus;
import com.hbm.dim.moho.WorldGeneratorMoho;
import com.hbm.dim.moho.WorldProviderMoho;
import com.hbm.dim.moon.WorldGeneratorMoon;
import com.hbm.dim.moon.WorldProviderMoon;
import com.hbm.dim.orbit.WorldProviderOrbit;
import com.hbm.dim.tekto.WorldGeneratorTekto;
import com.hbm.dim.tekto.WorldProviderTekto;
import com.hbm.dim.thatmo.WorldProviderThatmo;
import com.hbm.util.BobMathUtil;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;

public class PlanetGen {
    private static ArrayList<Integer> spaceDimensions = new ArrayList();

    public static void init() {
        PlanetGen.registerDimension(SpaceConfig.moonDimension, WorldProviderMoon.class);
        PlanetGen.registerDimension(SpaceConfig.dunaDimension, WorldProviderDuna.class);
        PlanetGen.registerDimension(SpaceConfig.ikeDimension, WorldProviderIke.class);
        PlanetGen.registerDimension(SpaceConfig.eveDimension, WorldProviderEve.class);
        PlanetGen.registerDimension(SpaceConfig.dresDimension, WorldProviderDres.class);
        PlanetGen.registerDimension(SpaceConfig.mohoDimension, WorldProviderMoho.class);
        PlanetGen.registerDimension(SpaceConfig.minmusDimension, WorldProviderMinmus.class);
        PlanetGen.registerDimension(SpaceConfig.laytheDimension, WorldProviderLaythe.class);
        PlanetGen.registerDimension(SpaceConfig.orbitDimension, WorldProviderOrbit.class);
        PlanetGen.registerDimension(SpaceConfig.tektoDimension, WorldProviderTekto.class);
        PlanetGen.registerDimension(SpaceConfig.thatmoDimension, WorldProviderThatmo.class);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorCelestial(), (int)2);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorMoon(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorDuna(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorIke(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorEve(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorDres(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorMoho(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorMinmus(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorLaythe(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorTekto(), (int)1);
    }

    public static int[] getSpaceDimensions() {
        return BobMathUtil.intCollectionToArray(spaceDimensions);
    }

    private static void registerDimension(int dimensionId, Class<? extends WorldProvider> clazz) {
        DimensionManager.registerProviderType((int)dimensionId, clazz, (boolean)false);
        DimensionManager.registerDimension((int)dimensionId, (int)dimensionId);
        if (dimensionId != SpaceConfig.orbitDimension) {
            spaceDimensions.add(dimensionId);
        }
    }

    public static void overrideOverworldProvider() {
        DimensionManager.unregisterProviderType((int)0);
        DimensionManager.registerProviderType((int)0, WorldProviderEarth.class, (boolean)true);
    }
}

