/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.wiaj.actors;

import com.hbm.util.i18n.I18nUtil;
import com.hbm.wiaj.JarScene;
import com.hbm.wiaj.WorldInAJar;
import com.hbm.wiaj.actors.ISpecialActor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ActorFancyPanel
implements ISpecialActor {
    static final ResourceLocation guiUtil = new ResourceLocation("hbm:textures/gui/gui_utility.png");
    List<Object[]> lines = new ArrayList<Object[]>();
    RenderItem itemRender = new RenderItem();
    TextureManager texman = Minecraft.func_71410_x().func_110434_K();
    FontRenderer font;
    int x;
    int y;
    boolean consistentHeight = false;
    int lineDist = 2;
    int tallestElement = 0;
    static final int STACK_HEIGHT = 18;
    Orientation o = Orientation.CENTER;
    int colorBrighter = -3355444;
    int colorDarker = -8553091;
    int colorFrame = -6250336;
    int colorBg = -13619658;
    int blockHeight = 0;
    int blockWidth = 0;

    public ActorFancyPanel(FontRenderer font, int x, int y, Object[][] raw, int autowrap) {
        this.font = font;
        this.x = x;
        this.y = y;
        if (autowrap <= 0) {
            for (Object[] o : raw) {
                this.lines.add(o);
            }
        } else {
            for (Object[] line : raw) {
                if (line.length == 1 && line[0] instanceof String) {
                    List<String> frags = I18nUtil.autoBreak(font, (String)line[0], autowrap);
                    for (String s : frags) {
                        this.lines.add(new Object[]{s});
                    }
                    continue;
                }
                this.lines.add(line);
            }
        }
    }

    public ActorFancyPanel enforceConsistentHeight() {
        this.consistentHeight = true;
        return this;
    }

    public ActorFancyPanel setLineDist(int dist) {
        this.lineDist = dist;
        return this;
    }

    public ActorFancyPanel setOrientation(Orientation o) {
        this.o = o;
        return this;
    }

    public ActorFancyPanel setColors(int brighter, int frame, int darker, int background) {
        this.colorBrighter = brighter;
        this.colorFrame = frame;
        this.colorDarker = darker;
        this.colorBg = background;
        return this;
    }

    public ActorFancyPanel setColors(int[] colors) {
        return this.setColors(colors[0], colors[1], colors[2], colors[3]);
    }

    public int getTallestElement() {
        if (this.tallestElement > 0) {
            return this.tallestElement;
        }
        for (Object[] line : this.lines) {
            for (Object element : line) {
                int height = this.getElementHeight(element);
                if (height <= this.tallestElement) continue;
                this.tallestElement = height;
            }
        }
        return this.tallestElement;
    }

    public int getElementHeight(Object element) {
        if (element instanceof String) {
            return this.font.field_78288_b;
        }
        if (element instanceof ItemStack) {
            return 18;
        }
        if (element instanceof Object[]) {
            Object[] scaledStack = (Object[])element;
            return (int)Math.ceil(18.0 * (Double)scaledStack[1]);
        }
        return 0;
    }

    public int getElementWidth(Object element) {
        if (element instanceof String) {
            return this.font.func_78256_a((String)element);
        }
        if (element instanceof ItemStack) {
            return 18;
        }
        if (element instanceof Object[]) {
            Object[] scaledStack = (Object[])element;
            return (int)Math.ceil(18.0 * (Double)scaledStack[1]);
        }
        return 0;
    }

    private int getBlockHeight() {
        if (this.blockHeight > 0) {
            return this.blockHeight;
        }
        for (Object[] line : this.lines) {
            if (this.blockHeight > 0) {
                this.blockHeight += this.lineDist;
            }
            int lineHeight = this.font.field_78288_b;
            if (this.consistentHeight) {
                lineHeight = Math.max(lineHeight, this.getTallestElement());
            } else {
                for (Object o : line) {
                    lineHeight = Math.max(lineHeight, this.getElementHeight(o));
                }
            }
            this.blockHeight += lineHeight;
        }
        return this.blockHeight;
    }

    private int getBlockWidth() {
        if (this.blockWidth > 0) {
            return this.blockWidth;
        }
        for (Object[] line : this.lines) {
            int lineWidth = 0;
            for (Object o : line) {
                if (lineWidth > 0) {
                    lineWidth += 2;
                }
                lineWidth += this.getElementWidth(o);
            }
            if (lineWidth <= this.blockWidth) continue;
            this.blockWidth = lineWidth;
        }
        return this.blockWidth;
    }

    @Override
    public void drawForegroundComponent(int w, int h, int ticks, float interp) {
        int height = this.getBlockHeight();
        int width = this.getBlockWidth();
        int posX = w / 2 + this.x;
        int posY = h / 2 + this.y;
        switch (this.o) {
            case TOP: {
                posX -= width / 2;
                posY += 15;
                break;
            }
            case BOTTOM: {
                posX -= width / 2;
                posY -= height + 15;
                break;
            }
            case LEFT: {
                posX += 15;
                posY -= height / 2;
                break;
            }
            case RIGHT: {
                posX -= width + 15;
                posY -= height / 2;
                break;
            }
            case CENTER: {
                posX -= width / 2;
                posY -= height / 2;
            }
        }
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.drawRect(posX - 5, posY - 5, posX + width + 5, posY + height + 5, this.colorFrame);
        this.drawRect(posX - 5, posY - 5, posX - 4, posY + height + 4, this.colorBrighter);
        this.drawRect(posX - 5, posY - 5, posX + width + 4, posY - 4, this.colorBrighter);
        this.drawRect(posX + width + 2, posY - 2, posX + width + 3, posY + height + 3, this.colorBrighter);
        this.drawRect(posX - 2, posY + height + 2, posX + width + 3, posY + height + 3, this.colorBrighter);
        this.drawRect(posX - 3, posY - 3, posX - 2, posY + height + 2, this.colorDarker);
        this.drawRect(posX - 3, posY - 3, posX + width + 2, posY - 2, this.colorDarker);
        this.drawRect(posX + width + 4, posY - 4, posX + width + 5, posY + height + 5, this.colorDarker);
        this.drawRect(posX - 4, posY + height + 4, posX + width + 5, posY + height + 5, this.colorDarker);
        this.drawRect(posX - 2, posY - 2, posX + width + 2, posY + height + 2, this.colorBg);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(guiUtil);
        switch (this.o) {
            case TOP: {
                this.drawArrow(posX + width / 2 - 7, posY - 15, 40, 14, 14, 10);
                break;
            }
            case BOTTOM: {
                this.drawArrow(posX + width / 2 - 7, posY + height + 5, 54, 14, 14, 10);
                break;
            }
            case LEFT: {
                this.drawArrow(posX - 15, posY + height / 2 - 7, 40, 0, 10, 14);
                break;
            }
            case RIGHT: {
                this.drawArrow(posX + width + 5, posY + height / 2 - 7, 50, 0, 10, 14);
                break;
            }
        }
        int offsetY = 0;
        for (Object[] line : this.lines) {
            if (offsetY > 0) {
                offsetY += this.lineDist;
            }
            int lineHeight = 0;
            for (Object element : line) {
                lineHeight = Math.max(lineHeight, this.getElementHeight(element));
            }
            int indent = 0;
            for (Object element : line) {
                if (indent > 0) {
                    indent += 2;
                }
                this.drawElement(posX + indent, posY + offsetY + lineHeight / 2, element);
                indent += this.getElementWidth(element);
            }
            offsetY += lineHeight;
        }
        this.itemRender.field_77023_b = 0.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    private void drawArrow(int posX, int posY, int sourceX, int sourceY, int sizeX, int sizeY) {
        this.drawTexturedModalRect(posX, posY, sourceX + 0, sourceY, sizeX, sizeY, this.colorBrighter);
        this.drawTexturedModalRect(posX, posY, sourceX + 28, sourceY, sizeX, sizeY, this.colorFrame);
        this.drawTexturedModalRect(posX, posY, sourceX + 56, sourceY, sizeX, sizeY, this.colorDarker);
        this.drawTexturedModalRect(posX, posY, sourceX + 84, sourceY, sizeX, sizeY, this.colorBg);
    }

    private void drawElement(int x, int y, Object element) {
        if (element instanceof String) {
            String text = (String)element;
            this.font.func_78276_b(text, x, y - this.font.field_78288_b / 2, 0xFFFFFF);
        } else if (element instanceof ItemStack) {
            ItemStack stack = (ItemStack)element;
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (stack.field_77994_a == 0) {
                this.drawGradientRect(x - 1, y - 1 - 8, x + 17, y + 17, -65536, -65536);
                this.drawGradientRect(x, y - 8, x + 16, y + 16, -5197648, -5197648);
            }
            this.itemRender.func_82406_b(this.font, this.texman, stack, x, y - 8);
            this.itemRender.func_94148_a(this.font, this.texman, stack, x, y - 8, null);
            RenderHelper.func_74518_a();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2929);
        }
    }

    @Override
    public void drawBackgroundComponent(WorldInAJar world, int ticks, float interp) {
    }

    @Override
    public void updateActor(JarScene scene) {
    }

    @Override
    public void setActorData(NBTTagCompound data) {
    }

    @Override
    public void setDataPoint(String tag, Object o) {
    }

    protected void drawRect(int minX, int minY, int maxX, int maxY, int color) {
        this.drawGradientRect(minX, minY, maxX, maxY, color, color);
    }

    protected void drawGradientRect(int minX, int minY, int maxX, int maxY, int color1, int color2) {
        double zLevel = 300.0;
        float a1 = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(color1 & 0xFF) / 255.0f;
        float a2 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(r1, g1, b1, a1);
        tessellator.func_78377_a((double)maxX, (double)minY, zLevel);
        tessellator.func_78377_a((double)minX, (double)minY, zLevel);
        tessellator.func_78369_a(r2, g2, b2, a2);
        tessellator.func_78377_a((double)minX, (double)maxY, zLevel);
        tessellator.func_78377_a((double)maxX, (double)maxY, zLevel);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public void drawTexturedModalRect(int posX, int posY, int u, int v, int sizeX, int sizeY) {
        this.drawTexturedModalRect(posX, posY, u, v, sizeX, sizeY, 0xFFFFFF);
    }

    public void drawTexturedModalRect(int posX, int posY, int u, int v, int sizeX, int sizeY, int color) {
        double zLevel = 300.0;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(r, g, b, a);
        tessellator.func_78374_a((double)(posX + 0), (double)(posY + sizeY), zLevel, (double)((float)(u + 0) * f), (double)((float)(v + sizeY) * f1));
        tessellator.func_78374_a((double)(posX + sizeX), (double)(posY + sizeY), zLevel, (double)((float)(u + sizeX) * f), (double)((float)(v + sizeY) * f1));
        tessellator.func_78374_a((double)(posX + sizeX), (double)(posY + 0), zLevel, (double)((float)(u + sizeX) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78374_a((double)(posX + 0), (double)(posY + 0), zLevel, (double)((float)(u + 0) * f), (double)((float)(v + 0) * f));
        tessellator.func_78381_a();
    }

    public static enum Orientation {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        CENTER;

    }
}

