/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.conveyor.IConveyorBelt;
import com.hbm.entity.item.EntityMovingPackage;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerCraneBoxer;
import com.hbm.inventory.gui.GUICraneBoxer;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.network.TileEntityCraneBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCraneBoxer
extends TileEntityCraneBase
implements IGUIProvider,
IControlReceiver {
    public byte mode = 0;
    public static final byte MODE_4 = 0;
    public static final byte MODE_8 = 1;
    public static final byte MODE_16 = 2;
    public static final byte MODE_REDSTONE = 3;
    private boolean lastRedstone = false;

    public TileEntityCraneBoxer() {
        super(21);
    }

    @Override
    public String getName() {
        return "container.craneBoxer";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            boolean redstone = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.mode == 3 && redstone && !this.lastRedstone) {
                ForgeDirection outputSide = this.getOutputSide();
                Block b = this.field_145850_b.func_147439_a(this.field_145851_c + outputSide.offsetX, this.field_145848_d + outputSide.offsetY, this.field_145849_e + outputSide.offsetZ);
                IConveyorBelt belt = null;
                if (b instanceof IConveyorBelt) {
                    belt = (IConveyorBelt)b;
                }
                int pack = 0;
                for (int i = 0; i < this.slots.length; ++i) {
                    if (this.slots[i] == null) continue;
                    ++pack;
                }
                if (belt != null && pack > 0) {
                    ItemStack[] box = new ItemStack[pack];
                    for (int i = 0; i < this.slots.length && pack > 0; ++i) {
                        if (this.slots[i] == null) continue;
                        box[--pack] = this.slots[i].func_77946_l();
                        this.slots[i] = null;
                    }
                    EntityMovingPackage moving = new EntityMovingPackage(this.field_145850_b);
                    Vec3 pos = Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5 + (double)outputSide.offsetX * 0.55), (double)((double)this.field_145848_d + 0.5 + (double)outputSide.offsetY * 0.55), (double)((double)this.field_145849_e + 0.5 + (double)outputSide.offsetZ * 0.55));
                    Vec3 snap = belt.getClosestSnappingPosition(this.field_145850_b, this.field_145851_c + outputSide.offsetX, this.field_145848_d + outputSide.offsetY, this.field_145849_e + outputSide.offsetZ, pos);
                    moving.func_70107_b(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c);
                    moving.setItemStacks(box);
                    this.field_145850_b.func_72838_d((Entity)moving);
                }
            }
            this.lastRedstone = redstone;
            if (this.mode != 3 && this.field_145850_b.func_82737_E() % 2L == 0L) {
                int pack = 1;
                switch (this.mode) {
                    case 0: {
                        pack = 4;
                        break;
                    }
                    case 1: {
                        pack = 8;
                        break;
                    }
                    case 2: {
                        pack = 16;
                    }
                }
                int fullStacks = 0;
                for (int i = 0; i < this.slots.length; ++i) {
                    if (this.slots[i] == null || this.slots[i].field_77994_a != this.slots[i].func_77976_d()) continue;
                    ++fullStacks;
                }
                ForgeDirection outputSide = this.getOutputSide();
                Block b = this.field_145850_b.func_147439_a(this.field_145851_c + outputSide.offsetX, this.field_145848_d + outputSide.offsetY, this.field_145849_e + outputSide.offsetZ);
                IConveyorBelt belt = null;
                if (b instanceof IConveyorBelt) {
                    belt = (IConveyorBelt)b;
                }
                if (belt != null && fullStacks >= pack) {
                    ItemStack[] box = new ItemStack[pack];
                    for (int i = 0; i < this.slots.length && pack > 0; ++i) {
                        if (this.slots[i] == null || this.slots[i].field_77994_a != this.slots[i].func_77976_d()) continue;
                        box[--pack] = this.slots[i].func_77946_l();
                        this.slots[i] = null;
                    }
                    EntityMovingPackage moving = new EntityMovingPackage(this.field_145850_b);
                    Vec3 pos = Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5 + (double)outputSide.offsetX * 0.55), (double)((double)this.field_145848_d + 0.5 + (double)outputSide.offsetY * 0.55), (double)((double)this.field_145849_e + 0.5 + (double)outputSide.offsetZ * 0.55));
                    Vec3 snap = belt.getClosestSnappingPosition(this.field_145850_b, this.field_145851_c + outputSide.offsetX, this.field_145848_d + outputSide.offsetY, this.field_145849_e + outputSide.offsetZ, pos);
                    moving.func_70107_b(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c);
                    moving.setItemStacks(box);
                    this.field_145850_b.func_72838_d((Entity)moving);
                }
            }
            this.networkPackNT(15);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeByte((int)this.mode);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.mode = buf.readByte();
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mode = nbt.func_74771_c("mode");
        this.lastRedstone = nbt.func_74767_n("lastRedstone");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("mode", this.mode);
        nbt.func_74757_a("lastRedstone", this.lastRedstone);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCraneBoxer(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICraneBoxer(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("toggle")) {
            this.mode = (byte)((this.mode + 1) % 4);
        }
    }
}

