/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.handler.atmosphere.ChunkAtmosphereManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerVacuumCircuit;
import com.hbm.inventory.gui.GUIVacuumCircuit;
import com.hbm.inventory.recipes.VacuumCircuitRecipes;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineVacuumCircuit
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IGUIProvider,
IUpgradeInfoProvider {
    public long power;
    public long maxPower = 2000L;
    public long consumption;
    public int progress;
    public int processTime = 1;
    private VacuumCircuitRecipes.VacuumCircuitRecipe recipe;
    public ItemStack display;
    public boolean canOperate = true;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    AxisAlignedBB bb = null;

    public TileEntityMachineVacuumCircuit() {
        super(8);
    }

    @Override
    public String getName() {
        return "container.machineVacuumCircuit";
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        if (stack != null && stack.func_77973_b() instanceof ItemMachineUpgrade && i >= 6 && i <= 7) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:item.upgradePlug", 1.0f, 1.0f);
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            long intendedMaxPower;
            CBT_Atmosphere atmosphere = ChunkAtmosphereManager.proxy.getAtmosphere(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.canOperate = atmosphere == null || atmosphere.getPressure() <= 0.001;
            this.power = Library.chargeTEFromItems(this.slots, 5, this.getPower(), this.getMaxPower());
            this.updateConnections();
            this.recipe = VacuumCircuitRecipes.getRecipe(new ItemStack[]{this.slots[0], this.slots[1], this.slots[2], this.slots[3]});
            this.upgradeManager.checkSlots(this, this.slots, 4, 4);
            int redLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int blueLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            if (this.recipe != null) {
                this.processTime = this.recipe.duration - this.recipe.duration * redLevel / 6 + this.recipe.duration * blueLevel / 3;
                this.consumption = this.recipe.consumption + this.recipe.consumption * (long)redLevel - this.recipe.consumption * (long)blueLevel / 6L;
                intendedMaxPower = this.recipe.consumption * 20L;
                if (this.canProcess(this.recipe)) {
                    ++this.progress;
                    this.power -= this.consumption;
                    if (this.progress >= this.processTime) {
                        this.progress = 0;
                        this.consumeItems(this.recipe);
                        if (this.slots[4] == null) {
                            this.slots[4] = this.recipe.output.func_77946_l();
                        } else {
                            this.slots[4].field_77994_a += this.recipe.output.field_77994_a;
                        }
                        this.func_70296_d();
                    }
                    if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
                        NBTTagCompound dPart = new NBTTagCompound();
                        dPart.func_74778_a("type", "tau");
                        dPart.func_74774_a("count", (byte)3);
                        PacketDispatcher.wrapper.sendToAllAround(new AuxParticlePacketNT(dPart, (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 0.625 + (double)rot.offsetX * 0.5, (double)this.field_145848_d + 1.25, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 0.625 + (double)rot.offsetZ * 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 25.0));
                    }
                } else {
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
                this.consumption = 100L;
                intendedMaxPower = 2000L;
            }
            this.maxPower = Math.max(intendedMaxPower, this.power);
            this.networkPackNT(25);
        }
    }

    public boolean canProcess(VacuumCircuitRecipes.VacuumCircuitRecipe recipe) {
        if (!this.canOperate) {
            return false;
        }
        if (this.power < this.consumption) {
            return false;
        }
        if (this.slots[4] != null) {
            if (this.slots[4].func_77973_b() != recipe.output.func_77973_b()) {
                return false;
            }
            if (this.slots[4].func_77960_j() != recipe.output.func_77960_j()) {
                return false;
            }
            if (this.slots[4].field_77994_a + recipe.output.field_77994_a > this.slots[4].func_77976_d()) {
                return false;
            }
        }
        return true;
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public void consumeItems(VacuumCircuitRecipes.VacuumCircuitRecipe recipe) {
        ItemStack stack;
        int i;
        block0: for (RecipesCommon.AStack aStack : recipe.wafer) {
            for (i = 0; i < 2; ++i) {
                stack = this.slots[i];
                if (!aStack.matchesRecipe(stack, true) || stack.field_77994_a < aStack.stacksize) continue;
                this.func_70298_a(i, aStack.stacksize);
                continue block0;
            }
        }
        block2: for (RecipesCommon.AStack aStack : recipe.pcb) {
            for (i = 2; i < 4; ++i) {
                stack = this.slots[i];
                if (!aStack.matchesRecipe(stack, true) || stack.field_77994_a < aStack.stacksize) continue;
                this.func_70298_a(i, aStack.stacksize);
                continue block2;
            }
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        block5: {
            block4: {
                if (slot >= 2) break block4;
                for (int i = 0; i < 2; ++i) {
                    if (i == slot || this.slots[i] == null || !this.slots[i].func_77969_a(stack)) continue;
                    return false;
                }
                for (RecipesCommon.AStack t : VacuumCircuitRecipes.wafer) {
                    if (!t.matchesRecipe(stack, true)) continue;
                    return true;
                }
                break block5;
            }
            if (slot >= 4) break block5;
            for (int i = 2; i < 4; ++i) {
                if (i == slot || this.slots[i] == null || !this.slots[i].func_77969_a(stack)) continue;
                return false;
            }
            for (RecipesCommon.AStack t : VacuumCircuitRecipes.pcb) {
                if (!t.matchesRecipe(stack, true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 4;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4};
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeLong(this.maxPower);
        buf.writeLong(this.consumption);
        buf.writeInt(this.progress);
        buf.writeInt(this.processTime);
        buf.writeBoolean(this.canOperate);
        if (this.recipe != null) {
            buf.writeBoolean(true);
            buf.writeInt(Item.func_150891_b((Item)this.recipe.output.func_77973_b()));
            buf.writeInt(this.recipe.output.func_77960_j());
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.maxPower = buf.readLong();
        this.consumption = buf.readLong();
        this.progress = buf.readInt();
        this.processTime = buf.readInt();
        this.canOperate = buf.readBoolean();
        if (buf.readBoolean()) {
            int id = buf.readInt();
            int meta = buf.readInt();
            this.display = new ItemStack(Item.func_150899_d((int)id), 1, meta);
        } else {
            this.display = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.maxPower = nbt.func_74763_f("maxPower");
        this.progress = nbt.func_74762_e("progress");
        this.processTime = nbt.func_74762_e("processTime");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74772_a("maxPower", this.maxPower);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("processTime", this.processTime);
    }

    @Override
    public long getPower() {
        return Math.max(Math.min(this.power, this.maxPower), 0L);
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return this.maxPower;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerVacuumCircuit(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIVacuumCircuit(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_vacuum_circuit));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + level * 100 / 6 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 100 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 100 / 6 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.delay", "+" + level * 100 / 3 + "%"));
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        return upgrades;
    }
}

