/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.handler.CompatHandler;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerMachineTurbineGas;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Combustible;
import com.hbm.inventory.gui.GUIMachineTurbineGas;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityMachineTurbineGas
extends TileEntityMachineBase
implements IFluidStandardTransceiver,
IEnergyProviderMK2,
IControlReceiver,
IGUIProvider,
SimpleComponent,
IInfoProviderEC,
CompatHandler.OCComponent,
IFluidCopiable {
    public long power;
    public static final long maxPower = 1000000L;
    public int rpm;
    public int temp;
    public int rpmIdle = 10;
    public int tempIdle = 300;
    public int powerSliderPos;
    public int throttle;
    public boolean autoMode;
    public int state = 0;
    public int counter = 0;
    public int instantPowerOutput;
    public double waterToBoil;
    public FluidTank[] tanks = new FluidTank[4];
    private AudioWrapper audio;
    public static HashMap<FluidType, Double> fuelMaxCons = new HashMap();
    private long powerBeforeNet;
    int rpmLast;
    int tempLast;
    double fuelToConsume;
    AxisAlignedBB bb = null;

    public TileEntityMachineTurbineGas() {
        super(2);
        this.tanks[0] = new FluidTank(Fluids.GAS, 100000);
        this.tanks[1] = new FluidTank(Fluids.LUBRICANT, 16000);
        this.tanks[2] = new FluidTank(Fluids.WATER, 16000);
        this.tanks[3] = new FluidTank(Fluids.HOTSTEAM, 160000);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            FluidType fluid;
            this.waterToBoil = 0.0;
            this.throttle = this.powerSliderPos * 100 / 60;
            if (this.slots[1] != null && this.slots[1].func_77973_b() instanceof IItemFluidIdentifier && (fluid = ((IItemFluidIdentifier)this.slots[1].func_77973_b()).getType(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.slots[1])).hasTrait(FT_Combustible.class) && fluid.getTrait(FT_Combustible.class).getGrade() == FT_Combustible.FuelGrade.GAS) {
                this.tanks[0].setTankType(fluid);
            }
            if (this.autoMode) {
                int powerSliderTarget = this.tanks[0].getFill() * 10 > this.tanks[0].getMaxFill() ? 60 - (int)(60L * this.power / 1000000L) : (int)((double)this.tanks[0].getFill() * 1.0E-4 * (double)(60 - (int)(60L * this.power / 1000000L)));
                if (powerSliderTarget > this.powerSliderPos) {
                    ++this.powerSliderPos;
                } else if (powerSliderTarget < this.powerSliderPos) {
                    --this.powerSliderPos;
                }
            }
            switch (this.state) {
                case 0: {
                    this.shutdown();
                    break;
                }
                case -1: {
                    this.stopIfNotReady();
                    this.startup();
                    break;
                }
                case 1: {
                    this.stopIfNotReady();
                    this.run();
                    break;
                }
            }
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
            this.powerBeforeNet = Math.min(this.power, 1000000L);
            this.power = Library.chargeItemsFromTE(this.slots, 0, this.power, 1000000L);
            this.tryProvide(this.field_145850_b, this.field_145851_c - dir.offsetZ * 5, this.field_145848_d + 1, this.field_145849_e + dir.offsetX * 5, rot);
            if (this.power > 1000000L) {
                this.power = 1000000L;
            }
            for (int i = 0; i < 2; ++i) {
                this.trySubscribe(this.tanks[i].getTankType(), this.field_145850_b, this.field_145851_c - dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite());
                this.trySubscribe(this.tanks[i].getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ, dir);
            }
            this.trySubscribe(this.tanks[2].getTankType(), this.field_145850_b, this.field_145851_c - dir.offsetX * 2 + rot.offsetX * -4, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ * -4, dir.getOpposite());
            this.trySubscribe(this.tanks[2].getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX * 2 + rot.offsetX * -4, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * -4, dir);
            this.sendFluid(this.tanks[3], this.field_145850_b, this.field_145851_c + dir.offsetZ * 6, this.field_145848_d + 1, this.field_145849_e - dir.offsetX * 6, rot.getOpposite());
            this.networkPackNT(150);
        } else if (this.rpm >= 10 && this.state != -1) {
            if (this.audio == null) {
                this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.turbinegasRunning", this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getVolume(1.0f), 20.0f, 2.0f, 20);
                this.audio.startSound();
            } else if (!this.audio.isPlaying()) {
                this.audio.stopSound();
                this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.turbinegasRunning", this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getVolume(1.0f), 20.0f, 2.0f, 20);
                this.audio.startSound();
            }
            this.audio.updatePitch((float)(0.55 + 0.1 * (double)this.rpm / 10.0));
            this.audio.updateVolume(this.getVolume(2.0f));
            this.audio.keepAlive();
        } else if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.powerBeforeNet);
        buf.writeInt(this.rpm);
        buf.writeInt(this.temp);
        buf.writeInt(this.state);
        buf.writeBoolean(this.autoMode);
        buf.writeInt(this.throttle);
        buf.writeInt(this.powerSliderPos);
        if (this.state != 1) {
            buf.writeInt(this.counter);
        } else {
            buf.writeInt(this.instantPowerOutput);
        }
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
        this.tanks[2].serialize(buf);
        this.tanks[3].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.rpm = buf.readInt();
        this.temp = buf.readInt();
        this.state = buf.readInt();
        this.autoMode = buf.readBoolean();
        this.throttle = buf.readInt();
        this.powerSliderPos = buf.readInt();
        if (this.state != 1) {
            this.counter = buf.readInt();
        } else {
            this.instantPowerOutput = buf.readInt();
        }
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
        this.tanks[2].deserialize(buf);
        this.tanks[3].deserialize(buf);
    }

    private void stopIfNotReady() {
        if (this.tanks[0].getFill() == 0 || this.tanks[1].getFill() == 0) {
            this.state = 0;
        }
        if (!this.hasAcceptableFuel()) {
            this.state = 0;
        }
    }

    public boolean hasAcceptableFuel() {
        if (this.tanks[0].getTankType().hasTrait(FT_Combustible.class)) {
            return this.tanks[0].getTankType().getTrait(FT_Combustible.class).getGrade() == FT_Combustible.FuelGrade.GAS;
        }
        return false;
    }

    private void startup() {
        if (!this.breatheAir(0)) {
            this.state = 0;
            return;
        }
        ++this.counter;
        if (this.counter <= 20) {
            this.rpm = 5 * this.counter;
        } else if (this.counter > 20 && this.counter <= 40) {
            this.rpm = 100 - 5 * (this.counter - 20);
        } else if (this.counter > 50) {
            this.rpm = this.rpmIdle * (this.counter - 50) / 530;
            this.temp = this.tempIdle * (this.counter - 50) / 530;
        }
        if (this.counter == 50) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)(this.field_145848_d + 2), (double)this.field_145849_e, "hbm:block.turbinegasStartup", this.getVolume(1.0f), 1.0f);
        }
        if (this.counter == 580) {
            this.state = 1;
        }
    }

    private void shutdown() {
        this.autoMode = false;
        this.instantPowerOutput = 0;
        if (this.powerSliderPos > 0) {
            --this.powerSliderPos;
        }
        if (this.rpm <= 10 && this.counter > 0) {
            if (this.counter == 225) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)(this.field_145848_d + 2), (double)this.field_145849_e, "hbm:block.turbinegasShutdown", this.getVolume(1.0f), 1.0f);
                this.rpmLast = this.rpm;
                this.tempLast = this.temp;
            }
            --this.counter;
            this.rpm = this.rpmLast * this.counter / 225;
            this.temp = this.tempLast * this.counter / 225;
        } else if (this.rpm > 11) {
            this.counter = 42069;
            --this.rpm;
        } else if (this.rpm == 11) {
            this.counter = 225;
            --this.rpm;
        }
    }

    protected int getFluidBurnTemp(FluidType type) {
        double dFuel = type.hasTrait(FT_Combustible.class) ? (double)type.getTrait(FT_Combustible.class).getCombustionEnergy() : 0.0;
        return (int)Math.floor(800.0 - Math.pow(Math.E, -dFuel / 100000.0) * 300.0);
    }

    private void run() {
        double consumption;
        int maxTemp;
        if ((int)((double)this.throttle * 0.9) > this.rpm - this.rpmIdle) {
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                ++this.rpm;
            }
        } else if ((int)((double)this.throttle * 0.9) < this.rpm - this.rpmIdle && this.field_145850_b.func_82737_E() % 2L == 0L) {
            --this.rpm;
        }
        if (this.throttle * 5 * ((maxTemp = this.getFluidBurnTemp(this.tanks[0].getTankType())) - this.tempIdle) / 500 > this.temp - this.tempIdle) {
            if (this.field_145850_b.func_82737_E() % 2L == 0L) {
                ++this.temp;
            }
        } else if (this.throttle * 5 * (maxTemp - this.tempIdle) / 500 < this.temp - this.tempIdle && this.field_145850_b.func_82737_E() % 2L == 0L) {
            --this.temp;
        }
        double d = consumption = fuelMaxCons.containsKey(this.tanks[0].getTankType()) ? fuelMaxCons.get(this.tanks[0].getTankType()) : 5.0;
        if (this.field_145850_b.func_82737_E() % 20L == 0L && this.tanks[0].getTankType() != Fluids.OXYHYDROGEN) {
            PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 0.12f);
        }
        this.makePower(consumption, this.throttle);
    }

    private void makePower(double consMax, int throttle) {
        double waterPerTick;
        int rpmEff;
        double idleConsumption = consMax * 0.05;
        double consumption = idleConsumption + consMax * (double)throttle / 100.0;
        this.fuelToConsume += consumption;
        if (!this.breatheAir((int)Math.floor(this.fuelToConsume))) {
            this.state = 0;
            return;
        }
        this.tanks[0].setFill(this.tanks[0].getFill() - (int)Math.floor(this.fuelToConsume));
        this.fuelToConsume -= (double)((int)Math.floor(this.fuelToConsume));
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            this.tanks[1].setFill(this.tanks[1].getFill() - 1);
        }
        if (this.tanks[0].getFill() < 0) {
            this.tanks[0].setFill(0);
            this.state = 0;
        }
        if (this.tanks[1].getFill() < 0) {
            this.tanks[1].setFill(0);
            this.state = 0;
        }
        long energy = 0L;
        if (this.tanks[0].getTankType().hasTrait(FT_Combustible.class)) {
            energy = this.tanks[0].getTankType().getTrait(FT_Combustible.class).getCombustionEnergy() / 1000L;
        }
        if ((double)this.instantPowerOutput < consMax * (double)energy * (double)(rpmEff = this.rpm - this.rpmIdle) / 90.0) {
            this.instantPowerOutput = (int)((double)this.instantPowerOutput + Math.random() * 0.005 * consMax * (double)energy);
            if ((double)this.instantPowerOutput > consMax * (double)energy * (double)rpmEff / 90.0) {
                this.instantPowerOutput = (int)(consMax * (double)energy * (double)rpmEff / 90.0);
            }
        } else if ((double)this.instantPowerOutput > consMax * (double)energy * (double)rpmEff / 90.0) {
            this.instantPowerOutput = (int)((double)this.instantPowerOutput - Math.random() * 0.011 * consMax * (double)energy);
            if ((double)this.instantPowerOutput < consMax * (double)energy * (double)rpmEff / 90.0) {
                this.instantPowerOutput = (int)(consMax * (double)energy * (double)rpmEff / 90.0);
            }
        }
        this.power += (long)this.instantPowerOutput;
        this.waterToBoil = waterPerTick = consMax * (double)energy * (double)(this.temp - this.tempIdle) / 220000.0;
        int heatCycles = (int)Math.floor(this.waterToBoil);
        int waterCycles = this.tanks[2].getFill();
        int steamCycles = (this.tanks[3].getMaxFill() - this.tanks[3].getFill()) / 10;
        int cycles = BobMathUtil.min(heatCycles, waterCycles, steamCycles);
        this.tanks[2].setFill(this.tanks[2].getFill() - cycles);
        this.tanks[3].setFill(this.tanks[3].getFill() + cycles * 10);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "gas");
        this.tanks[1].readFromNBT(nbt, "lube");
        this.tanks[2].readFromNBT(nbt, "water");
        this.tanks[3].readFromNBT(nbt, "densesteam");
        this.autoMode = nbt.func_74767_n("automode");
        this.power = nbt.func_74763_f("power");
        this.state = nbt.func_74762_e("state");
        this.rpm = nbt.func_74762_e("rpm");
        this.temp = nbt.func_74762_e("temperature");
        this.powerSliderPos = nbt.func_74762_e("slidPos");
        this.instantPowerOutput = nbt.func_74762_e("instPwr");
        this.counter = nbt.func_74762_e("counter");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "gas");
        this.tanks[1].writeToNBT(nbt, "lube");
        this.tanks[2].writeToNBT(nbt, "water");
        this.tanks[3].writeToNBT(nbt, "densesteam");
        nbt.func_74757_a("automode", this.autoMode);
        nbt.func_74772_a("power", this.power);
        if (this.state == 1) {
            nbt.func_74768_a("state", this.state);
            nbt.func_74768_a("rpm", this.rpm);
            nbt.func_74768_a("temperature", this.temp);
            nbt.func_74768_a("slidPos", this.powerSliderPos);
            nbt.func_74768_a("instPwr", this.instantPowerOutput);
            nbt.func_74768_a("counter", 225);
        } else {
            nbt.func_74768_a("state", 0);
            nbt.func_74768_a("rpm", 0);
            nbt.func_74768_a("temperature", 20);
            nbt.func_74768_a("slidPos", 0);
            nbt.func_74768_a("instpwr", 0);
            nbt.func_74768_a("counter", 0);
        }
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("slidPos")) {
            this.powerSliderPos = data.func_74762_e("slidPos");
        }
        if (data.func_74764_b("autoMode")) {
            this.autoMode = data.func_74767_n("autoMode");
        }
        if (data.func_74764_b("state")) {
            this.state = data.func_74762_e("state");
        }
        this.func_70296_d();
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 25.0;
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 5), (double)this.field_145848_d, (double)(this.field_145849_e - 5), (double)(this.field_145851_c + 6), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 6));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public String getName() {
        return "container.turbinegas";
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1], this.tanks[2]};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[3]};
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.DOWN;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.DOWN;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_gas_turbine";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluid(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getFill(), this.tanks[0].getMaxFill(), this.tanks[1].getFill(), this.tanks[1].getMaxFill(), this.tanks[2].getFill(), this.tanks[2].getMaxFill(), this.tanks[3].getFill(), this.tanks[3].getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getType(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getTankType().getName()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getPower(Context context, Arguments args) {
        return new Object[]{this.power};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getThrottle(Context context, Arguments args) {
        return new Object[]{this.throttle};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getState(Context context, Arguments args) {
        return new Object[]{this.state};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getAuto(Context context, Arguments args) {
        return new Object[]{this.autoMode};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] setThrottle(Context context, Arguments args) {
        double input = (double)args.checkInteger(0) * 60.0 / 100.0;
        if (input < 0.0 || input > 100.0) {
            return new Object[]{null, "Input out of range."};
        }
        this.powerSliderPos = (int)input;
        return new Object[]{true};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] setAuto(Context context, Arguments args) {
        this.autoMode = args.checkBoolean(0);
        return new Object[0];
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] start(Context context, Arguments args) {
        this.state = -1;
        return new Object[0];
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] stop(Context context, Arguments args) {
        this.state = 0;
        return new Object[0];
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.throttle, this.state, this.tanks[0].getFill(), this.tanks[0].getMaxFill(), this.tanks[1].getFill(), this.tanks[1].getMaxFill(), this.tanks[2].getFill(), this.tanks[2].getMaxFill(), this.tanks[3].getFill(), this.tanks[3].getMaxFill()};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getFluid", "getType", "getPower", "getThrottle", "getState", "getAuto", "setThrottle", "setAuto", "start", "stop", "getInfo"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getFluid": {
                return this.getFluid(context, args);
            }
            case "getType": {
                return this.getType(context, args);
            }
            case "getPower": {
                return this.getPower(context, args);
            }
            case "getThrottle": {
                return this.getThrottle(context, args);
            }
            case "getState": {
                return this.getState(context, args);
            }
            case "getAuto": {
                return this.getAuto(context, args);
            }
            case "setThrottle": {
                return this.setThrottle(context, args);
            }
            case "setAuto": {
                return this.setAuto(context, args);
            }
            case "start": {
                return this.start(context, args);
            }
            case "stop": {
                return this.stop(context, args);
            }
            case "getInfo": {
                return this.getInfo(context, args);
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineTurbineGas(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineTurbineGas(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74757_a("active", this.state == 1);
        data.func_74780_a("heat", Math.max(20.0, (double)this.temp));
        data.func_74780_a("turbine", (double)this.powerSliderPos * 100.0 / 60.0);
        data.func_74768_a("speed", this.rpm);
        data.func_74780_a("output", (double)this.instantPowerOutput);
        data.func_74780_a("consumption", this.waterToBoil);
        data.func_74780_a("outputmb", this.waterToBoil * 10.0);
    }

    static {
        fuelMaxCons.put(Fluids.GAS, 50.0);
        fuelMaxCons.put(Fluids.SYNGAS, 10.0);
        fuelMaxCons.put(Fluids.OXYHYDROGEN, 100.0);
        fuelMaxCons.put(Fluids.REFORMGAS, 5.0);
    }
}

