/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerMachineExposureChamber;
import com.hbm.inventory.gui.GUIMachineExposureChamber;
import com.hbm.inventory.recipes.ExposureChamberRecipes;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineExposureChamber
extends TileEntityMachineBase
implements IGUIProvider,
IEnergyReceiverMK2,
IUpgradeInfoProvider {
    public long power;
    public static final long maxPower = 1000000L;
    public int progress;
    public static final int processTimeBase = 200;
    public int processTime = 200;
    public static final int consumptionBase = 10000;
    public int consumption = 10000;
    public int savedParticles;
    public static final int maxParticles = 8;
    public boolean isOn = false;
    public float rotation;
    public float prevRotation;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    AxisAlignedBB bb = null;

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("progress");
        this.power = nbt.func_74763_f("power");
        this.savedParticles = nbt.func_74762_e("savedParticles");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("savedParticles", this.savedParticles);
    }

    public TileEntityMachineExposureChamber() {
        super(8);
    }

    @Override
    public String getName() {
        return "container.exposureChamber";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ExposureChamberRecipes.ExposureChamberRecipe recipe;
            this.isOn = false;
            this.power = Library.chargeTEFromItems(this.slots, 5, this.power, 1000000L);
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                for (DirPos pos : this.getConPos()) {
                    this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
            }
            this.upgradeManager.checkSlots(this, this.slots, 6, 7);
            int speedLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int powerLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            int overdriveLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
            this.consumption = 10000;
            this.processTime = 200 - 200 / 4 * speedLevel;
            this.consumption *= speedLevel / 2 + 1;
            this.processTime *= powerLevel / 2 + 1;
            this.consumption /= powerLevel + 1;
            this.processTime /= overdriveLevel + 1;
            this.consumption *= overdriveLevel * 2 + 1;
            if (this.slots[1] == null && this.slots[0] != null && this.slots[3] != null && this.savedParticles <= 0 && (recipe = this.getRecipe(this.slots[0], this.slots[3])) != null) {
                ItemStack container = this.slots[0].func_77973_b().getContainerItem(this.slots[0]);
                boolean canStore = false;
                if (container == null) {
                    canStore = true;
                } else if (this.slots[2] == null) {
                    this.slots[2] = container.func_77946_l();
                    canStore = true;
                } else if (this.slots[2].func_77973_b() == container.func_77973_b() && this.slots[2].func_77960_j() == container.func_77960_j() && this.slots[2].field_77994_a < this.slots[2].func_77976_d()) {
                    ++this.slots[2].field_77994_a;
                    canStore = true;
                }
                if (canStore) {
                    this.slots[1] = this.slots[0].func_77946_l();
                    this.slots[1].field_77994_a = 0;
                    this.func_70298_a(0, 1);
                    this.savedParticles = 8;
                }
            }
            if (this.slots[1] != null && this.savedParticles > 0 && this.power >= (long)this.consumption) {
                recipe = this.getRecipe(this.slots[1], this.slots[3]);
                if (recipe != null && (this.slots[4] == null || this.slots[4].func_77973_b() == recipe.output.func_77973_b() && this.slots[4].func_77960_j() == recipe.output.func_77960_j() && this.slots[4].field_77994_a + recipe.output.field_77994_a <= this.slots[4].func_77976_d())) {
                    ++this.progress;
                    this.power -= (long)this.consumption;
                    this.isOn = true;
                    if (this.progress >= this.processTime) {
                        this.progress = 0;
                        --this.savedParticles;
                        this.func_70298_a(3, 1);
                        if (this.slots[4] == null) {
                            this.slots[4] = recipe.output.func_77946_l();
                        } else {
                            this.slots[4].field_77994_a += recipe.output.field_77994_a;
                        }
                    }
                } else {
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
            }
            if (this.savedParticles <= 0) {
                this.slots[1] = null;
            }
            this.networkPackNT(50);
        } else {
            this.prevRotation = this.rotation;
            if (this.isOn) {
                this.rotation = (float)((double)this.rotation + 10.0);
                if ((double)this.rotation >= 720.0) {
                    this.rotation = (float)((double)this.rotation - 720.0);
                    this.prevRotation = (float)((double)this.prevRotation - 720.0);
                }
            }
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP).getOpposite();
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 7 + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 7 + dir.offsetZ * 2, dir), new DirPos(this.field_145851_c + rot.offsetX * 7 - dir.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 7 - dir.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 8 + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 8 + dir.offsetZ * 2, dir), new DirPos(this.field_145851_c + rot.offsetX * 8 - dir.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 8 - dir.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 9, this.field_145848_d, this.field_145849_e + rot.offsetZ * 9, rot)};
    }

    public ExposureChamberRecipes.ExposureChamberRecipe getRecipe(ItemStack particle, ItemStack ingredient) {
        return ExposureChamberRecipes.getRecipe(particle, ingredient);
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        ItemStack particle;
        if (i == 0 && this.slots[0] != null) {
            return true;
        }
        if (i == 3 && this.slots[3] != null) {
            return true;
        }
        ItemStack itemStack = particle = this.slots[1] != null ? this.slots[1] : this.slots[0];
        if (i == 0 && particle == null && this.slots[3] != null) {
            ExposureChamberRecipes.ExposureChamberRecipe recipe = this.getRecipe(stack, this.slots[3]);
            return recipe != null;
        }
        if (i == 3 && particle != null && this.slots[3] == null) {
            ExposureChamberRecipes.ExposureChamberRecipe recipe = this.getRecipe(this.slots[0], stack);
            return recipe != null;
        }
        if (particle == null && this.slots[3] == null) {
            for (ExposureChamberRecipes.ExposureChamberRecipe recipe : ExposureChamberRecipes.recipes) {
                if (i == 0 && recipe.particle.matchesRecipe(stack, true)) {
                    return true;
                }
                if (i != 3 || !recipe.ingredient.matchesRecipe(stack, true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 2 || i == 4;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0, 2, 3, 4};
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeBoolean(this.isOn);
        buf.writeInt(this.progress);
        buf.writeInt(this.processTime);
        buf.writeInt(this.consumption);
        buf.writeLong(this.power);
        buf.writeByte((int)((byte)this.savedParticles));
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.isOn = buf.readBoolean();
        this.progress = buf.readInt();
        this.processTime = buf.readInt();
        this.consumption = buf.readInt();
        this.power = buf.readLong();
        this.savedParticles = buf.readByte();
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 8), (double)this.field_145848_d, (double)(this.field_145849_e - 8), (double)(this.field_145851_c + 9), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 9));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineExposureChamber(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineExposureChamber(player.field_71071_by, this);
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_exposure_chamber));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + level * 25 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 50 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + (100 - 100 / (level + 1)) + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.delay", "+" + level * 50 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 3);
        return upgrades;
    }
}

