/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.dim.trait.CBT_Dyson;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockMutatorFire;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.CustomDamageHandlerDyson;
import com.hbm.explosion.vanillant.standard.EntityProcessorStandard;
import com.hbm.explosion.vanillant.standard.ExplosionEffectStandard;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.items.ISatChip;
import com.hbm.main.MainRegistry;
import com.hbm.saveddata.SatelliteSavedData;
import com.hbm.saveddata.satellites.Satellite;
import com.hbm.saveddata.satellites.SatelliteDysonRelay;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IDysonConverter;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.ParticleUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityDysonReceiver
extends TileEntityMachineBase {
    public boolean isReceiving;
    public int swarmId;
    public int swarmCount;
    public int swarmConsumers;
    public int beamLength;
    private AudioWrapper audio;
    AxisAlignedBB bb = null;

    public TileEntityDysonReceiver() {
        super(1);
    }

    public static long getEnergyOutput(int swarmCount) {
        double adjustedDensity = (double)swarmCount / 1024.0;
        long maxOutput = 0xCCCCCCCCCCCCCCCL;
        double b = 32.0;
        double c = 1.3;
        double gompertz = Math.exp(-b * Math.exp(-c * adjustedDensity));
        return (long)((double)maxOutput * gompertz) / 20L;
    }

    @Override
    public String getName() {
        return "container.machineDysonReceiver";
    }

    @Override
    public void func_145845_h() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
        if (!this.field_145850_b.field_72995_K) {
            this.swarmId = ISatChip.getFreqS(this.slots[0]);
            SatelliteSavedData data = SatelliteSavedData.getData(this.field_145850_b, this.field_145851_c, this.field_145849_e);
            Satellite sat = data.getSatFromFreq(this.swarmId);
            int sun = this.field_145850_b.func_72972_b(EnumSkyBlock.Sky, this.field_145851_c, this.field_145848_d, this.field_145849_e) - this.field_145850_b.field_73008_k - 11;
            boolean occluded = false;
            block0: for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (this.field_145850_b.func_72976_f(this.field_145851_c + x, this.field_145849_e + z) <= this.field_145848_d + 10) continue;
                    occluded = true;
                    continue block0;
                }
            }
            this.swarmCount = CBT_Dyson.count(this.field_145850_b, this.swarmId);
            this.swarmConsumers = CBT_Dyson.consumers(this.field_145850_b, this.swarmId);
            boolean bl = this.isReceiving = (sat instanceof SatelliteDysonRelay || sun > 0) && this.swarmId > 0 && !occluded && this.swarmCount > 0 && this.swarmConsumers > 0;
            if (this.isReceiving) {
                int maxLength;
                long energyOutput = TileEntityDysonReceiver.getEnergyOutput(this.swarmCount) / (long)this.swarmConsumers;
                this.beamLength = maxLength = 24;
                for (int i = 9; i < maxLength; ++i) {
                    int x = this.field_145851_c + dir.offsetX * i;
                    int y = this.field_145848_d + 1;
                    int z = this.field_145849_e + dir.offsetZ * i;
                    Block block = this.field_145850_b.func_147439_a(x, y, z);
                    boolean detonate = true;
                    TileEntity te = null;
                    if (i > 10) {
                        if (block instanceof BlockDummyable) {
                            int[] pos = ((BlockDummyable)block).findCore(this.field_145850_b, x, y, z);
                            if (pos != null) {
                                te = this.field_145850_b.func_147438_o(pos[0], pos[1], pos[2]);
                            }
                        } else {
                            te = this.field_145850_b.func_147438_o(x, y, z);
                        }
                        if (te instanceof IDysonConverter) {
                            boolean bl2 = detonate = !((IDysonConverter)te).provideEnergy(x, y, z, energyOutput);
                        }
                    }
                    if (!block.func_149662_c() && te == null) continue;
                    if (detonate) {
                        this.field_145850_b.func_147468_f(x, y, z);
                        ExplosionVNT vnt = new ExplosionVNT(this.field_145850_b, x, y, z, 3.0f, null);
                        vnt.setBlockAllocator(new BlockAllocatorStandard());
                        vnt.setBlockProcessor(new BlockProcessorStandard().withBlockEffect(new BlockMutatorFire()));
                        vnt.setEntityProcessor(new EntityProcessorStandard().allowSelfDamage());
                        vnt.setPlayerProcessor(new PlayerProcessorStandard());
                        vnt.setSFX(new ExplosionEffectStandard());
                        vnt.explode();
                    }
                    this.beamLength = i;
                    break;
                }
                double blx = (double)Math.min(this.field_145851_c, this.field_145851_c + dir.offsetX * this.beamLength) + 0.2;
                double bux = (double)Math.max(this.field_145851_c, this.field_145851_c + dir.offsetX * this.beamLength) + 0.8;
                double bly = (double)Math.min(this.field_145848_d, 1 + this.field_145848_d + dir.offsetY * this.beamLength) + 0.2;
                double buy = (double)Math.max(this.field_145848_d, 1 + this.field_145848_d + dir.offsetY * this.beamLength) + 0.8;
                double blz = (double)Math.min(this.field_145849_e, this.field_145849_e + dir.offsetZ * this.beamLength) + 0.2;
                double buz = (double)Math.max(this.field_145849_e, this.field_145849_e + dir.offsetZ * this.beamLength) + 0.8;
                List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)blx, (double)bly, (double)blz, (double)bux, (double)buy, (double)buz));
                for (EntityLivingBase entity : list) {
                    ExplosionVNT vnt = new ExplosionVNT(this.field_145850_b, entity.field_70165_t - (double)dir.offsetX, entity.field_70163_u + 1.5, entity.field_70161_v - (double)dir.offsetZ, 3.0f, null);
                    vnt.setBlockAllocator(new BlockAllocatorStandard());
                    vnt.setBlockProcessor(new BlockProcessorStandard().withBlockEffect(new BlockMutatorFire()));
                    vnt.setEntityProcessor(new EntityProcessorStandard().withDamageMod(new CustomDamageHandlerDyson(energyOutput)));
                    vnt.setPlayerProcessor(new PlayerProcessorStandard());
                    vnt.setSFX(new ExplosionEffectStandard());
                    vnt.explode();
                }
            }
            this.networkPackNT(250);
        } else if (this.isReceiving) {
            if (this.audio == null) {
                this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.dysonBeam", this.field_145851_c + dir.offsetX * 8, this.field_145848_d, this.field_145849_e + dir.offsetZ * 8, 0.75f, 20.0f, 1.0f, 20);
                this.audio.startSound();
            }
            this.audio.keepAlive();
            this.audio.updatePitch(0.85f);
            if (this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                ParticleUtil.spawnFlare(this.field_145850_b, (double)(this.field_145851_c - 5) + this.field_145850_b.field_73012_v.nextDouble() * 10.0, this.field_145848_d + 11, (double)(this.field_145849_e - 5) + this.field_145850_b.field_73012_v.nextDouble() * 10.0, 0.0, 0.1 + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.1, 0.0, 4.0f + this.field_145850_b.field_73012_v.nextFloat() * 2.0f);
            }
        } else if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.isReceiving);
        buf.writeInt(this.swarmId);
        buf.writeInt(this.swarmCount);
        buf.writeInt(this.swarmConsumers);
        buf.writeInt(this.beamLength);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.isReceiving = buf.readBoolean();
        this.swarmId = buf.readInt();
        this.swarmCount = buf.readInt();
        this.swarmConsumers = buf.readInt();
        this.beamLength = buf.readInt();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 25), (double)this.field_145848_d, (double)(this.field_145849_e - 25), (double)(this.field_145851_c + 25), (double)(this.field_145848_d + 19), (double)(this.field_145849_e + 25));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public static void runTests() {
        for (int i = 1; i < 5000; i *= 2) {
            MainRegistry.logger.info(i + " dyson swarm members produces: " + BobMathUtil.getShortNumber(TileEntityDysonReceiver.getEnergyOutput(i) * 20L) + "HE/s");
        }
    }
}

