/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.shader;

import com.hbm.main.MainRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class Shader {
    private boolean hasLoaded = false;
    private int shaderProgram;
    private int vertexShader;
    private int fragmentShader;
    private int previousProgram;
    private HashMap<String, Integer> uniforms = new HashMap();

    public Shader(ResourceLocation fragment) {
        this(new ResourceLocation("hbm", "shaders/default.vert"), fragment);
    }

    public Shader(ResourceLocation vertex, ResourceLocation fragment) {
        try {
            this.vertexShader = this.loadShader(vertex, 35633);
            this.fragmentShader = this.loadShader(fragment, 35632);
            this.shaderProgram = GL20.glCreateProgram();
            GL20.glAttachShader((int)this.shaderProgram, (int)this.vertexShader);
            GL20.glAttachShader((int)this.shaderProgram, (int)this.fragmentShader);
            GL20.glLinkProgram((int)this.shaderProgram);
            if (GL20.glGetProgrami((int)this.shaderProgram, (int)35714) == 0) {
                throw new RuntimeException("Failed to link shader program: " + GL20.glGetProgramInfoLog((int)this.shaderProgram, (int)1024));
            }
            this.hasLoaded = true;
        }
        catch (RuntimeException ex) {
            MainRegistry.logger.error("Shaders failed to load, falling back to default pipeline");
            MainRegistry.logger.catching((Throwable)ex);
            this.hasLoaded = false;
        }
    }

    private int loadShader(ResourceLocation location, int type) {
        int shader = GL20.glCreateShader((int)type);
        GL20.glShaderSource((int)shader, (CharSequence)this.loadResource(location));
        GL20.glCompileShader((int)shader);
        if (GL20.glGetShaderi((int)shader, (int)35713) == 0) {
            throw new RuntimeException("Failed to compile shader: " + GL20.glGetShaderInfoLog((int)shader, (int)1024));
        }
        return shader;
    }

    private String loadResource(ResourceLocation location) {
        try {
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
            return this.loadResource(res.func_110527_b());
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception reading model format", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadResource(InputStream in) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading shader file", e);
        }
    }

    public void use() {
        if (!this.hasLoaded) {
            return;
        }
        this.previousProgram = GL11.glGetInteger((int)35725);
        GL20.glUseProgram((int)this.shaderProgram);
    }

    public void stop() {
        if (!this.hasLoaded) {
            return;
        }
        GL20.glUseProgram((int)this.previousProgram);
    }

    public void cleanup() {
        GL20.glDetachShader((int)this.shaderProgram, (int)this.vertexShader);
        GL20.glDetachShader((int)this.shaderProgram, (int)this.fragmentShader);
        GL20.glDeleteShader((int)this.vertexShader);
        GL20.glDeleteShader((int)this.fragmentShader);
        GL20.glDeleteProgram((int)this.shaderProgram);
    }

    public int getUniformLocation(String name) {
        if (!this.hasLoaded) {
            return 0;
        }
        return this.uniforms.computeIfAbsent(name, n -> GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)n));
    }

    public void setUniform1f(String name, float value) {
        if (!this.hasLoaded) {
            return;
        }
        int location = this.uniforms.computeIfAbsent(name, n -> GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)n));
        GL20.glUniform1f((int)location, (float)value);
    }

    public void setUniform1f(int location, float value) {
        if (!this.hasLoaded) {
            return;
        }
        GL20.glUniform1f((int)location, (float)value);
    }

    public void setUniform1i(String name, int value) {
        if (!this.hasLoaded) {
            return;
        }
        int location = this.uniforms.computeIfAbsent(name, n -> GL20.glGetUniformLocation((int)this.shaderProgram, (CharSequence)n));
        GL20.glUniform1i((int)location, (int)value);
    }

    public void setUniform1i(int location, int value) {
        if (!this.hasLoaded) {
            return;
        }
        GL20.glUniform1i((int)location, (int)value);
    }
}

