/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.block;

import com.hbm.blocks.machine.SolarMirror;
import com.hbm.main.ResourceManager;
import com.hbm.render.util.ObjUtil;
import com.hbm.tileentity.machine.TileEntitySolarMirror;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.Face;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.TextureCoordinate;
import net.minecraftforge.client.model.obj.Vertex;
import net.minecraftforge.client.model.obj.WavefrontObject;

public class RenderMirror
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity te;
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon iicon = block.func_149691_a(0, world.func_72805_g(x, y, z));
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        if (renderer.func_147744_b()) {
            iicon = renderer.field_147840_d;
        }
        if (!((te = world.func_147438_o(x, y, z)) instanceof TileEntitySolarMirror)) {
            return false;
        }
        TileEntitySolarMirror mirror = (TileEntitySolarMirror)te;
        int dx = mirror.tX - mirror.field_145851_c;
        int dy = mirror.tY - mirror.field_145848_d;
        int dz = mirror.tZ - mirror.field_145849_e;
        tessellator.func_78372_c((float)x + 0.5f, (float)y, (float)z + 0.5f);
        ObjUtil.renderPartWithIcon((WavefrontObject)ResourceManager.solar_mirror, "Base", iicon, tessellator, 0.0f, true);
        if (mirror.tY <= mirror.field_145848_d) {
            ObjUtil.renderPartWithIcon((WavefrontObject)ResourceManager.solar_mirror, "Mirror", iicon, tessellator, 0.0f, true);
        } else {
            this.printMirror(iicon, dx, dy, dz);
        }
        tessellator.func_78372_c((float)(-x) - 0.5f, (float)(-y), (float)(-z) - 0.5f);
        return true;
    }

    private void printMirror(IIcon icon, int dx, int dy, int dz) {
        GroupObject go = null;
        for (GroupObject obj : ((WavefrontObject)ResourceManager.solar_mirror).groupObjects) {
            if (!obj.name.equals("Mirror")) continue;
            go = obj;
        }
        if (go == null) {
            return;
        }
        Tessellator tes = Tessellator.field_78398_a;
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double pitch = -Math.asin((double)dy / dist) + 1.5707963267948966;
        double yaw = -Math.atan2(dz, dx) - 1.5707963267948966;
        for (Face f : go.faces) {
            Vertex n = f.faceNormal;
            tes.func_78375_b(n.x, n.y, n.z);
            float brightness = (n.y + 1.0f) * 0.65f;
            if (brightness < 0.45f) {
                brightness = 0.45f;
            }
            tes.func_78386_a(brightness, brightness, brightness);
            for (int i = 0; i < f.vertices.length; ++i) {
                Vertex v = f.vertices[i];
                Vec3 vec = Vec3.func_72443_a((double)v.x, (double)(v.y - 1.0f), (double)v.z);
                vec.func_72440_a((float)pitch);
                vec.func_72442_b((float)yaw);
                float x = (float)vec.field_72450_a;
                float y = (float)vec.field_72448_b + 1.0f;
                float z = (float)vec.field_72449_c;
                TextureCoordinate t = f.textureCoordinates[i];
                tes.func_78374_a((double)x, (double)y, (double)z, (double)icon.func_94214_a((double)(t.u * 16.0f)), (double)icon.func_94207_b((double)(t.v * 16.0f)));
                if (i % 3 != 2) continue;
                tes.func_78374_a((double)x, (double)y, (double)z, (double)icon.func_94214_a((double)(t.u * 16.0f)), (double)icon.func_94207_b((double)(t.v * 16.0f)));
            }
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return SolarMirror.renderID;
    }
}

