/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.main;

import com.google.common.collect.ImmutableList;
import com.hbm.blocks.BlockEnums;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockToolConversion;
import com.hbm.commands.CommandCustomize;
import com.hbm.commands.CommandDebugChunkLoad;
import com.hbm.commands.CommandLocate;
import com.hbm.commands.CommandPacketInfo;
import com.hbm.commands.CommandRadiation;
import com.hbm.commands.CommandReapNetworks;
import com.hbm.commands.CommandReloadClient;
import com.hbm.commands.CommandReloadRecipes;
import com.hbm.commands.CommandReloadServer;
import com.hbm.commands.CommandSatellites;
import com.hbm.commands.CommandStations;
import com.hbm.commands.CommandTotalTime;
import com.hbm.commands.SuicideThreadDump;
import com.hbm.config.BombConfig;
import com.hbm.config.ClientConfig;
import com.hbm.config.CustomMachineConfigJSON;
import com.hbm.config.FalloutConfigJSON;
import com.hbm.config.GeneralConfig;
import com.hbm.config.ItemPoolConfigJSON;
import com.hbm.config.MachineConfig;
import com.hbm.config.MachineDynConfig;
import com.hbm.config.MobConfig;
import com.hbm.config.PotionConfig;
import com.hbm.config.RadiationConfig;
import com.hbm.config.ServerConfig;
import com.hbm.config.SpaceConfig;
import com.hbm.config.StructureConfig;
import com.hbm.config.ToolConfig;
import com.hbm.config.WeaponConfig;
import com.hbm.config.WorldConfig;
import com.hbm.crafting.RodRecipes;
import com.hbm.creativetabs.BlockTab;
import com.hbm.creativetabs.ConsumableTab;
import com.hbm.creativetabs.ControlTab;
import com.hbm.creativetabs.MachineTab;
import com.hbm.creativetabs.MissileTab;
import com.hbm.creativetabs.NukeTab;
import com.hbm.creativetabs.PartsTab;
import com.hbm.creativetabs.TemplateTab;
import com.hbm.creativetabs.WeaponTab;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.WorldTypeTeleport;
import com.hbm.entity.EntityMappings;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.entity.mob.siege.SiegeTier;
import com.hbm.handler.BobmazonOfferFactory;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.CompatHandler;
import com.hbm.handler.DispenserBehaviorHandler;
import com.hbm.handler.FuelHandler;
import com.hbm.handler.GUIHandler;
import com.hbm.handler.HTTPHandler;
import com.hbm.handler.HazmatRegistry;
import com.hbm.handler.HbmKeybinds;
import com.hbm.handler.Identity;
import com.hbm.handler.ae2.AE2CompatHandler;
import com.hbm.handler.atmosphere.ChunkAtmosphereManager;
import com.hbm.handler.imc.IMCBlastFurnace;
import com.hbm.handler.imc.IMCCentrifuge;
import com.hbm.handler.imc.IMCCrystallizer;
import com.hbm.handler.imc.IMCHandler;
import com.hbm.handler.microblocks.MicroBlocksCompatHandler;
import com.hbm.handler.neutron.NeutronHandler;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.hazard.HazardRegistry;
import com.hbm.inventory.FluidContainerRegistry;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.recipes.ArcFurnaceRecipes;
import com.hbm.inventory.recipes.GasCentrifugeRecipes;
import com.hbm.inventory.recipes.LemegetonRecipes;
import com.hbm.inventory.recipes.MagicRecipes;
import com.hbm.inventory.recipes.RadiolysisRecipes;
import com.hbm.inventory.recipes.SILEXRecipes;
import com.hbm.inventory.recipes.anvil.AnvilRecipes;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.mods.XWeaponModManager;
import com.hbm.lib.HbmWorld;
import com.hbm.main.ChunkLoaderManager;
import com.hbm.main.CraftingManager;
import com.hbm.main.ModEventHandler;
import com.hbm.main.ModEventHandlerImpact;
import com.hbm.main.ServerProxy;
import com.hbm.packet.PacketDispatcher;
import com.hbm.potion.HbmPotion;
import com.hbm.saveddata.satellites.Satellite;
import com.hbm.tileentity.TileMappings;
import com.hbm.tileentity.bomb.TileEntityLaunchPadBase;
import com.hbm.tileentity.bomb.TileEntityNukeCustom;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.util.AchievementHandler;
import com.hbm.util.ArmorUtil;
import com.hbm.util.Compat;
import com.hbm.util.CrashHelper;
import com.hbm.util.DamageResistanceHandler;
import com.hbm.util.MobUtil;
import com.hbm.util.ShadyUtil;
import com.hbm.util.StatHelper;
import com.hbm.world.ModBiomes;
import com.hbm.world.PlanetGen;
import com.hbm.world.biome.BiomeGenCraterBase;
import com.hbm.world.feature.BedrockOre;
import com.hbm.world.feature.OreCave;
import com.hbm.world.feature.OreLayer3D;
import com.hbm.world.feature.SchistStratum;
import com.hbm.world.generator.CellularDungeonFactory;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatBasic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="hbm", name="NTM: Space", version="1.0.27 BETA (5572)")
public class MainRegistry {
    @Mod.Instance(value="hbm")
    public static MainRegistry instance;
    @SidedProxy(clientSide="com.hbm.main.ClientProxy", serverSide="com.hbm.main.ServerProxy")
    public static ServerProxy proxy;
    @Mod.Metadata
    public static ModMetadata meta;
    public static Logger logger;
    public static Item.ToolMaterial tMatSchrab;
    public static Item.ToolMaterial tMatHammmer;
    public static Item.ToolMaterial tMatChainsaw;
    public static Item.ToolMaterial tMatSteel;
    public static Item.ToolMaterial tMatTitan;
    public static Item.ToolMaterial tMatAlloy;
    public static Item.ToolMaterial tMatCMB;
    public static Item.ToolMaterial tMatElec;
    public static Item.ToolMaterial tMatDesh;
    public static Item.ToolMaterial tMatCobalt;
    public static Item.ToolMaterial enumToolMaterialSaw;
    public static Item.ToolMaterial enumToolMaterialBat;
    public static Item.ToolMaterial enumToolMaterialBatNail;
    public static Item.ToolMaterial enumToolMaterialGolfClub;
    public static Item.ToolMaterial enumToolMaterialPipeRusty;
    public static Item.ToolMaterial enumToolMaterialPipeLead;
    public static Item.ToolMaterial enumToolMaterialBottleOpener;
    public static Item.ToolMaterial enumToolMaterialSledge;
    public static Item.ToolMaterial enumToolMaterialMultitool;
    public static ItemArmor.ArmorMaterial aMatSchrab;
    public static ItemArmor.ArmorMaterial aMatEuph;
    public static ItemArmor.ArmorMaterial aMatHaz;
    public static ItemArmor.ArmorMaterial aMatHaz2;
    public static ItemArmor.ArmorMaterial aMatHaz3;
    public static ItemArmor.ArmorMaterial aMatSteel;
    public static ItemArmor.ArmorMaterial aMatAsbestos;
    public static ItemArmor.ArmorMaterial aMatTitan;
    public static ItemArmor.ArmorMaterial aMatAlloy;
    public static ItemArmor.ArmorMaterial aMatPaa;
    public static ItemArmor.ArmorMaterial aMatCMB;
    public static ItemArmor.ArmorMaterial aMatAus3;
    public static ItemArmor.ArmorMaterial aMatSecurity;
    public static ItemArmor.ArmorMaterial aMatCobalt;
    public static ItemArmor.ArmorMaterial aMatStarmetal;
    public static ItemArmor.ArmorMaterial aMatBismuth;
    public static CreativeTabs partsTab;
    public static CreativeTabs controlTab;
    public static CreativeTabs templateTab;
    public static CreativeTabs blockTab;
    public static CreativeTabs machineTab;
    public static CreativeTabs nukeTab;
    public static CreativeTabs missileTab;
    public static CreativeTabs weaponTab;
    public static CreativeTabs consumableTab;
    public static StatBase statLegendary;
    public static StatBase statMines;
    public static StatBase statBullets;
    public static Achievement achSacrifice;
    public static Achievement achImpossible;
    public static Achievement achTOB;
    public static Achievement achPotato;
    public static Achievement achC20_5;
    public static Achievement achFiend;
    public static Achievement achFiend2;
    public static Achievement achRadPoison;
    public static Achievement achRadDeath;
    public static Achievement achStratum;
    public static Achievement achOmega12;
    public static Achievement achSomeWounds;
    public static Achievement achSlimeball;
    public static Achievement achSulfuric;
    public static Achievement achGoFish;
    public static Achievement achNo9;
    public static Achievement achInferno;
    public static Achievement achRedRoom;
    public static Achievement bobHidden;
    public static Achievement horizonsStart;
    public static Achievement horizonsEnd;
    public static Achievement horizonsBonus;
    public static Achievement bossCreeper;
    public static Achievement bossMeltdown;
    public static Achievement bossMaskman;
    public static Achievement bossWorm;
    public static Achievement bossUFO;
    public static Achievement digammaSee;
    public static Achievement digammaFeel;
    public static Achievement digammaKnow;
    public static Achievement digammaKauaiMoho;
    public static Achievement digammaUpOnTop;
    public static Achievement rotConsum;
    public static Achievement achBurnerPress;
    public static Achievement achBlastFurnace;
    public static Achievement achAssembly;
    public static Achievement achSelenium;
    public static Achievement achChemplant;
    public static Achievement achConcrete;
    public static Achievement achPolymer;
    public static Achievement achDesh;
    public static Achievement achTantalum;
    public static Achievement achRedBalloons;
    public static Achievement achManhattan;
    public static Achievement achGasCent;
    public static Achievement achCentrifuge;
    public static Achievement achFOEQ;
    public static Achievement achSoyuz;
    public static Achievement achSpace;
    public static Achievement achSchrab;
    public static Achievement achAcidizer;
    public static Achievement achRadium;
    public static Achievement achTechnetium;
    public static Achievement achZIRNOXBoom;
    public static Achievement achChicagoPile;
    public static Achievement achSILEX;
    public static Achievement achWatz;
    public static Achievement achWatzBoom;
    public static Achievement achRBMK;
    public static Achievement achRBMKBoom;
    public static Achievement achBismuth;
    public static Achievement achBreeding;
    public static Achievement achFusion;
    public static Achievement achDriveFail;
    public static int generalOverride;
    public static int polaroidID;
    public static long startupTime;
    public static File configDir;
    public static File configHbmDir;
    public Random rand = new Random();
    private static HashSet<String> ignoreMappings;
    private static HashMap<String, Item> remapItems;

    @Mod.EventHandler
    public void PreLoad(FMLPreInitializationEvent PreEvent) {
        CrashHelper.init();
        startupTime = System.currentTimeMillis();
        configDir = PreEvent.getModConfigurationDirectory();
        configHbmDir = new File(configDir.getAbsolutePath() + File.separatorChar + "hbmConfig");
        if (!configHbmDir.exists()) {
            configHbmDir.mkdir();
        }
        Identity.init(configDir);
        logger.info("Let us celebrate the fact that the logger finally works again!");
        if (generalOverride > 0 && generalOverride < 19) {
            polaroidID = generalOverride;
        } else {
            polaroidID = this.rand.nextInt(18) + 1;
            while (polaroidID == 4 || polaroidID == 9) {
                polaroidID = this.rand.nextInt(18) + 1;
            }
        }
        ShadyUtil.test();
        this.loadConfig(PreEvent);
        HbmPotion.init();
        Mats.MAT_STONE.getUnlocalizedName();
        Fluids.init();
        proxy.registerPreRenderInfo();
        ModBlocks.mainRegistry();
        ModItems.mainRegistry();
        ModBiomes.init();
        proxy.registerRenderInfo();
        HbmWorld.mainRegistry();
        GameRegistry.registerFuelHandler((IFuelHandler)new FuelHandler());
        BulletConfigSyncingUtil.loadConfigsForSync();
        CellularDungeonFactory.init();
        Satellite.register();
        HTTPHandler.loadStats();
        CraftingManager.mainRegistry();
        SiegeTier.registerTiers();
        HazardRegistry.registerItems();
        HazardRegistry.registerTrafos();
        XWeaponModManager.init();
        SolarSystem.init();
        OreDictManager oreMan = new OreDictManager();
        MinecraftForge.EVENT_BUS.register((Object)oreMan);
        OreDictManager.registerGroups();
        OreDictManager.registerOres();
        if (WorldConfig.enableCraterBiomes) {
            BiomeGenCraterBase.initDictionary();
        }
        MainRegistry.aMatSchrab.customCraftingMaterial = ModItems.ingot_schrabidium;
        MainRegistry.aMatHaz.customCraftingMaterial = ModItems.hazmat_cloth;
        MainRegistry.aMatHaz2.customCraftingMaterial = ModItems.hazmat_cloth_red;
        MainRegistry.aMatHaz3.customCraftingMaterial = ModItems.hazmat_cloth_grey;
        MainRegistry.aMatTitan.customCraftingMaterial = ModItems.ingot_titanium;
        MainRegistry.aMatSteel.customCraftingMaterial = ModItems.ingot_steel;
        MainRegistry.aMatAsbestos.customCraftingMaterial = ModItems.asbestos_cloth;
        MainRegistry.aMatAlloy.customCraftingMaterial = ModItems.ingot_advanced_alloy;
        MainRegistry.aMatPaa.customCraftingMaterial = ModItems.plate_paa;
        MainRegistry.aMatCMB.customCraftingMaterial = ModItems.ingot_combine_steel;
        MainRegistry.aMatAus3.customCraftingMaterial = ModItems.ingot_australium;
        MainRegistry.aMatSecurity.customCraftingMaterial = ModItems.plate_kevlar;
        MainRegistry.aMatCobalt.customCraftingMaterial = ModItems.ingot_cobalt;
        MainRegistry.aMatStarmetal.customCraftingMaterial = ModItems.ingot_starmetal;
        MainRegistry.aMatBismuth.customCraftingMaterial = ModItems.plate_bismuth;
        tMatSchrab.setRepairItem(new ItemStack(ModItems.ingot_schrabidium));
        tMatHammmer.setRepairItem(new ItemStack(Item.func_150898_a((Block)ModBlocks.block_schrabidium)));
        tMatChainsaw.setRepairItem(new ItemStack(ModItems.ingot_steel));
        tMatTitan.setRepairItem(new ItemStack(ModItems.ingot_titanium));
        tMatSteel.setRepairItem(new ItemStack(ModItems.ingot_steel));
        tMatAlloy.setRepairItem(new ItemStack(ModItems.ingot_advanced_alloy));
        tMatCMB.setRepairItem(new ItemStack(ModItems.ingot_combine_steel));
        enumToolMaterialBottleOpener.setRepairItem(new ItemStack(ModItems.plate_steel));
        tMatDesh.setRepairItem(new ItemStack(ModItems.ingot_desh));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GUIHandler());
        TileMappings.writeMappings();
        MachineDynConfig.initialize();
        TileEntityLaunchPadBase.registerLaunchables();
        for (Map.Entry<Class<? extends TileEntity>, String[]> e : TileMappings.map.entrySet()) {
            if (e.getValue().length == 1) {
                GameRegistry.registerTileEntity(e.getKey(), (String)e.getValue()[0]);
                continue;
            }
            GameRegistry.registerTileEntityWithAlternatives(e.getKey(), (String)e.getValue()[0], (String[])e.getValue());
        }
        ChestGenHooks.addItem((String)"villageBlacksmith", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ModItems.armor_polish), 1, 1, 3));
        ChestGenHooks.addItem((String)"villageBlacksmith", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ModItems.bathwater), 1, 1, 1));
        ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ModItems.bathwater), 1, 1, 1));
        ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ModItems.serum), 1, 1, 5));
        ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ModItems.no9), 1, 1, 5));
        ChestGenHooks.addItem((String)"mineshaftCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ModItems.key_red_cracked), 1, 1, 5));
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ModItems.heart_piece), 1, 1, 1));
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ModItems.key_red_cracked), 1, 1, 5));
        ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ModItems.heart_piece), 1, 1, 1));
        ChestGenHooks.addItem((String)"pyramidJungleChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ModItems.heart_piece), 1, 1, 1));
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ModItems.scrumpy), 1, 1, 1));
        ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ModItems.scrumpy), 1, 1, 1));
        ChestGenHooks.addItem((String)"bonusChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(ModItems.no9), 1, 1, 7));
        EntityMappings.writeMappings();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ForgeChunkManager.LoadingCallback(){

            public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
                for (ForgeChunkManager.Ticket ticket : tickets) {
                    if (ticket.getType() == ForgeChunkManager.Type.NORMAL) {
                        ChunkLoaderManager.loadTicket(world, ticket);
                        return;
                    }
                    if (!(ticket.getEntity() instanceof IChunkLoader)) continue;
                    ((IChunkLoader)ticket.getEntity()).init(ticket);
                }
            }
        });
        DispenserBehaviorHandler.init();
        MicroBlocksCompatHandler.preInit();
    }

    @Mod.EventHandler
    public static void load(FMLInitializationEvent event) {
        RodRecipes.registerInit();
        statLegendary = new StatBasic("stat.ntmLegendary", (IChatComponent)new ChatComponentTranslation("stat.ntmLegendary", new Object[0])).func_75971_g();
        statMines = new StatBasic("stat.ntmMines", (IChatComponent)new ChatComponentTranslation("stat.ntmMines", new Object[0])).func_75971_g();
        statBullets = new StatBasic("stat.ntmBullets", (IChatComponent)new ChatComponentTranslation("stat.ntmBullets", new Object[0])).func_75971_g();
        achSacrifice = new Achievement("achievement.sacrifice", "sacrifice", -3, 1, ModItems.burnt_bark, null).func_75966_h().func_75987_b().func_75971_g();
        achImpossible = new Achievement("achievement.impossible", "impossible", 18, 10, ModItems.nothing, null).func_75966_h().func_75987_b().func_75971_g();
        achTOB = new Achievement("achievement.tasteofblood", "tasteofblood", 3, 10, new ItemStack(ModItems.fluid_icon, 1, Fluids.ASCHRAB.getID()), null).func_75966_h().func_75987_b().func_75971_g();
        achGoFish = new Achievement("achievement.goFish", "goFish", 5, 10, OreDictManager.DictFrame.fromOne(ModItems.achievement_icon, (Enum)ItemEnums.EnumAchievementType.GOFISH), null).func_75966_h().func_75987_b().func_75971_g();
        achPotato = new Achievement("achievement.potato", "potato", -2, -2, ModItems.battery_potatos, null).func_75966_h().func_75987_b().func_75971_g();
        achC20_5 = new Achievement("achievement.c20_5", "c20_5", 3, 6, OreDictManager.DictFrame.fromOne(ModItems.achievement_icon, (Enum)ItemEnums.EnumAchievementType.QUESTIONMARK), null).func_75966_h().func_75987_b().func_75971_g();
        achFiend = new Achievement("achievement.fiend", "fiend", -6, 8, ModItems.shimmer_sledge, null).func_75966_h().func_75987_b().func_75971_g();
        achFiend2 = new Achievement("achievement.fiend2", "fiend2", -4, 9, ModItems.shimmer_axe, null).func_75966_h().func_75987_b().func_75971_g();
        achStratum = new Achievement("achievement.stratum", "stratum", -4, -2, new ItemStack(ModBlocks.stone_gneiss), null).func_75966_h().func_75987_b().func_75971_g();
        achOmega12 = new Achievement("achievement.omega12", "omega12", 17, -1, ModItems.particle_digamma, null).func_75966_h().func_75987_b().func_75971_g();
        achNo9 = new Achievement("achievement.no9", "no9", -8, 12, ModItems.no9, null).func_75966_h().func_75971_g();
        achSlimeball = new Achievement("achievement.slimeball", "slimeball", -10, 6, OreDictManager.DictFrame.fromOne(ModItems.achievement_icon, (Enum)ItemEnums.EnumAchievementType.ACID), null).func_75966_h().func_75971_g();
        achSulfuric = new Achievement("achievement.sulfuric", "sulfuric", -10, 8, OreDictManager.DictFrame.fromOne(ModItems.achievement_icon, (Enum)ItemEnums.EnumAchievementType.BALLS), achSlimeball).func_75966_h().func_75987_b().func_75971_g();
        achInferno = new Achievement("achievement.inferno", "inferno", -8, 10, ModItems.canister_napalm, null).func_75966_h().func_75987_b().func_75971_g();
        achRedRoom = new Achievement("achievement.redRoom", "redRoom", -10, 10, ModItems.key_red, null).func_75966_h().func_75987_b().func_75971_g();
        bobHidden = new Achievement("achievement.hidden", "hidden", 15, -4, OreDictManager.DictFrame.fromOne(ModItems.achievement_icon, (Enum)ItemEnums.EnumAchievementType.QUESTIONMARK), null).func_75966_h().func_75971_g();
        horizonsStart = new Achievement("achievement.horizonsStart", "horizonsStart", -5, 4, ModItems.sat_gerald, null).func_75966_h().func_75971_g();
        horizonsEnd = new Achievement("achievement.horizonsEnd", "horizonsEnd", -3, 4, ModItems.sat_gerald, horizonsStart).func_75966_h().func_75971_g();
        horizonsBonus = new Achievement("achievement.horizonsBonus", "horizonsBonus", -1, 4, ModItems.sat_gerald, horizonsEnd).func_75966_h().func_75971_g().func_75987_b();
        bossCreeper = new Achievement("achievement.bossCreeper", "bossCreeper", -7, 1, ModItems.coin_creeper, null).func_75966_h().func_75971_g();
        bossMeltdown = new Achievement("achievement.bossMeltdown", "bossMeltdown", -8, 3, ModItems.coin_radiation, bossCreeper).func_75966_h().func_75971_g();
        bossMaskman = new Achievement("achievement.bossMaskman", "bossMaskman", -8, -1, ModItems.coin_maskman, bossCreeper).func_75966_h().func_75971_g();
        bossWorm = new Achievement("achievement.bossWorm", "bossWorm", -8, -3, ModItems.coin_worm, bossMaskman).func_75966_h().func_75971_g().func_75987_b();
        bossUFO = new Achievement("achievement.bossUFO", "bossUFO", -6, -3, ModItems.coin_ufo, bossWorm).func_75966_h().func_75971_g().func_75987_b();
        achRadPoison = new Achievement("achievement.radPoison", "radPoison", -2, 6, ModItems.geiger_counter, null).func_75966_h().func_75971_g();
        achRadDeath = new Achievement("achievement.radDeath", "radDeath", 0, 6, Items.field_151144_bL, achRadPoison).func_75966_h().func_75971_g().func_75987_b();
        achSomeWounds = new Achievement("achievement.someWounds", "someWounds", -2, 10, ModItems.injector_knife, null).func_75966_h().func_75971_g();
        digammaSee = new Achievement("achievement.digammaSee", "digammaSee", -1, 8, OreDictManager.DictFrame.fromOne(ModItems.achievement_icon, (Enum)ItemEnums.EnumAchievementType.DIGAMMASEE), null).func_75966_h().func_75971_g();
        digammaFeel = new Achievement("achievement.digammaFeel", "digammaFeel", 1, 8, OreDictManager.DictFrame.fromOne(ModItems.achievement_icon, (Enum)ItemEnums.EnumAchievementType.DIGAMMAFEEL), digammaSee).func_75966_h().func_75971_g();
        digammaKnow = new Achievement("achievement.digammaKnow", "digammaKnow", 3, 8, OreDictManager.DictFrame.fromOne(ModItems.achievement_icon, (Enum)ItemEnums.EnumAchievementType.DIGAMMAKNOW), digammaFeel).func_75966_h().func_75971_g().func_75987_b();
        digammaKauaiMoho = new Achievement("achievement.digammaKauaiMoho", "digammaKauaiMoho", 5, 8, OreDictManager.DictFrame.fromOne(ModItems.achievement_icon, (Enum)ItemEnums.EnumAchievementType.DIGAMMAKAUAIMOHO), digammaKnow).func_75966_h().func_75971_g().func_75987_b();
        digammaUpOnTop = new Achievement("achievement.digammaUpOnTop", "digammaUpOnTop", 7, 8, OreDictManager.DictFrame.fromOne(ModItems.achievement_icon, (Enum)ItemEnums.EnumAchievementType.DIGAMMAUPONTOP), digammaKauaiMoho).func_75966_h().func_75971_g().func_75987_b();
        achBurnerPress = new Achievement("achievement.burnerPress", "burnerPress", 0, 0, new ItemStack(ModBlocks.machine_press), null).func_75966_h().func_75971_g();
        achBlastFurnace = new Achievement("achievement.blastFurnace", "blastFurnace", 1, 3, new ItemStack(ModBlocks.machine_difurnace_off), achBurnerPress).func_75966_h().func_75971_g();
        achAssembly = new Achievement("achievement.assembly", "assembly", 3, -1, new ItemStack(ModBlocks.machine_assembly_machine), achBurnerPress).func_75966_h().func_75971_g();
        achSelenium = new Achievement("achievement.selenium", "selenium", 3, 2, ModItems.ingot_starmetal, achBurnerPress).func_75966_h().func_75987_b().func_75971_g();
        achChemplant = new Achievement("achievement.chemplant", "chemplant", 6, -1, new ItemStack(ModBlocks.machine_chemical_plant), achAssembly).func_75966_h().func_75971_g();
        achConcrete = new Achievement("achievement.concrete", "concrete", 6, -4, new ItemStack(ModBlocks.concrete), achChemplant).func_75966_h().func_75971_g();
        achPolymer = new Achievement("achievement.polymer", "polymer", 9, -1, ModItems.ingot_polymer, achChemplant).func_75966_h().func_75971_g();
        achDesh = new Achievement("achievement.desh", "desh", 9, 2, ModItems.ingot_desh, achChemplant).func_75966_h().func_75971_g();
        achTantalum = new Achievement("achievement.tantalum", "tantalum", 7, 3, ModItems.gem_tantalium, achChemplant).func_75966_h().func_75987_b().func_75971_g();
        achGasCent = new Achievement("achievement.gasCent", "gasCent", 13, 2, ModItems.ingot_uranium_fuel, achDesh).func_75966_h().func_75971_g();
        achCentrifuge = new Achievement("achievement.centrifuge", "centrifuge", 12, -2, new ItemStack(ModBlocks.machine_centrifuge), achPolymer).func_75966_h().func_75971_g();
        achDriveFail = new Achievement("achievement.driveFail", "driveFail", 8, -3, new ItemStack((Item)ModItems.full_drive), achPolymer).func_75966_h().func_75987_b().func_75971_g();
        achFOEQ = new Achievement("achievement.FOEQ", "FOEQ", 5, 5, ModItems.sat_foeq, achDesh).func_75966_h().func_75987_b().func_75971_g();
        achSoyuz = new Achievement("achievement.soyuz", "soyuz", 7, 6, Items.field_151168_bH, achDesh).func_75966_h().func_75987_b().func_75971_g();
        achSpace = new Achievement("achievement.space", "space", 9, 7, ModItems.missile_soyuz, achDesh).func_75966_h().func_75987_b().func_75971_g();
        achSchrab = new Achievement("achievement.schrab", "schrab", 11, 3, ModItems.ingot_schrabidium, achDesh).func_75966_h().func_75971_g();
        achAcidizer = new Achievement("achievement.acidizer", "acidizer", 11, 5, new ItemStack(ModBlocks.machine_crystallizer), achDesh).func_75966_h().func_75971_g();
        achRadium = new Achievement("achievement.radium", "radium", 13, -4, ModItems.coffee_radium, achCentrifuge).func_75966_h().func_75987_b().func_75971_g();
        achTechnetium = new Achievement("achievement.technetium", "technetium", 15, -2, ModItems.ingot_tcalloy, achCentrifuge).func_75966_h().func_75971_g();
        achZIRNOXBoom = new Achievement("achievement.ZIRNOXBoom", "ZIRNOXBoom", 14, -1, ModItems.debris_element, achCentrifuge).func_75966_h().func_75987_b().func_75971_g();
        achChicagoPile = new Achievement("achievement.chicagoPile", "chicagoPile", 13, 0, ModItems.pile_rod_plutonium, achCentrifuge).func_75966_h().func_75971_g();
        achSILEX = new Achievement("achievement.SILEX", "SILEX", 12, 7, new ItemStack(ModBlocks.machine_silex), achAcidizer).func_75966_h().func_75971_g();
        achWatz = new Achievement("achievement.watz", "watz", 14, 3, ModItems.watz_pellet, achSchrab).func_75966_h().func_75971_g();
        achWatzBoom = new Achievement("achievement.watzBoom", "watzBoom", 14, 5, ModItems.bucket_mud, achWatz).func_75966_h().func_75987_b().func_75971_g();
        achRBMK = new Achievement("achievement.RBMK", "RBMK", 9, -5, (Item)ModItems.rbmk_fuel_ueu, achConcrete).func_75966_h().func_75971_g();
        achRBMKBoom = new Achievement("achievement.RBMKBoom", "RBMKBoom", 9, -7, ModItems.debris_fuel, achRBMK).func_75966_h().func_75987_b().func_75971_g();
        achBismuth = new Achievement("achievement.bismuth", "bismuth", 11, -6, ModItems.ingot_bismuth, achRBMK).func_75966_h().func_75971_g();
        achBreeding = new Achievement("achievement.breeding", "breeding", 7, -6, ModItems.ingot_am_mix, achRBMK).func_75966_h().func_75987_b().func_75971_g();
        achFusion = new Achievement("achievement.fusion", "fusion", 13, -7, new ItemStack(ModBlocks.iter), achBismuth).func_75966_h().func_75987_b().func_75971_g();
        achRedBalloons = new Achievement("achievement.redBalloons", "redBalloons", 11, 0, ModItems.missile_nuclear, achPolymer).func_75966_h().func_75987_b().func_75971_g();
        achManhattan = new Achievement("achievement.manhattan", "manhattan", 11, -4, new ItemStack(ModBlocks.nuke_boy), achPolymer).func_75966_h().func_75987_b().func_75971_g();
        AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage("Nuclear Tech", new Achievement[]{achSacrifice, achImpossible, achTOB, achGoFish, achPotato, achC20_5, achFiend, achFiend2, achStratum, achOmega12, bobHidden, horizonsStart, horizonsEnd, horizonsBonus, achRadPoison, achRadDeath, achNo9, achInferno, achRedRoom, achSlimeball, achSulfuric, bossCreeper, bossMeltdown, bossMaskman, bossWorm, bossUFO, achSomeWounds, digammaSee, digammaFeel, digammaKnow, digammaKauaiMoho, digammaUpOnTop, achBurnerPress, achBlastFurnace, achAssembly, achSelenium, achChemplant, achConcrete, achPolymer, achDesh, achTantalum, achGasCent, achCentrifuge, achDriveFail, achFOEQ, achSoyuz, achSpace, achSchrab, achAcidizer, achRadium, achTechnetium, achZIRNOXBoom, achChicagoPile, achSILEX, achWatz, achWatzBoom, achRBMK, achRBMKBoom, achBismuth, achBreeding, achFusion, achRedBalloons, achManhattan}));
        BobmazonOfferFactory.init();
        IMCHandler.registerHandler("blastfurnace", new IMCBlastFurnace());
        IMCHandler.registerHandler("crystallizer", new IMCCrystallizer());
        IMCHandler.registerHandler("centrifuge", new IMCCentrifuge());
        PlanetGen.init();
        if (Loader.isModLoaded((String)"NotEnoughItems") && ((ModContainer)Loader.instance().getIndexedModList().get("NotEnoughItems")).getVersion().contains("GTNH")) {
            proxy.handleNHNEICompat();
        }
    }

    @Mod.EventHandler
    public static void initIMC(FMLInterModComms.IMCEvent event) {
        ImmutableList inbox = event.getMessages();
        for (FMLInterModComms.IMCMessage message : inbox) {
            IMCHandler handler = IMCHandler.getHandler(message.key);
            if (handler != null) {
                logger.info("Received IMC of type >" + message.key + "< from " + message.getSender() + "!");
                handler.process(message);
                continue;
            }
            logger.error("Could not process unknown IMC type \"" + message.key + "\"");
        }
    }

    @Mod.EventHandler
    public static void PostLoad(FMLPostInitializationEvent PostEvent) {
        Fluids.reloadFluids();
        FluidContainerRegistry.register();
        MagicRecipes.register();
        LemegetonRecipes.register();
        SILEXRecipes.register();
        GasCentrifugeRecipes.register();
        CustomMachineConfigJSON.initialize();
        SerializableRecipe.registerAllHandlers();
        SerializableRecipe.initialize();
        AnvilRecipes.register();
        RadiolysisRecipes.registerRadiolysis();
        FalloutConfigJSON.initialize();
        ItemPoolConfigJSON.initialize();
        ClientConfig.initConfig();
        ServerConfig.initConfig();
        TileEntityNukeCustom.registerBombItems();
        ArmorUtil.register();
        HazmatRegistry.registerHazmats();
        DamageResistanceHandler.init();
        BlockToolConversion.registerRecipes();
        AchievementHandler.register();
        MobUtil.intializeMobPools();
        proxy.registerMissileItems();
        CompatHandler.init();
        AE2CompatHandler.init();
        World.MAX_ENTITY_RADIUS = Math.max(World.MAX_ENTITY_RADIUS, 8.75);
        MinecraftForge.EVENT_BUS.register((Object)new SchistStratum());
        if (WorldConfig.enableHematite) {
            new OreLayer3D(ModBlocks.stone_resource, BlockEnums.EnumStoneType.HEMATITE.ordinal()).setGlobal(true).setScaleH(0.04).setScaleV(0.25).setThreshold(230.0);
        }
        if (WorldConfig.enableBauxite) {
            new OreLayer3D(ModBlocks.stone_resource, BlockEnums.EnumStoneType.BAUXITE.ordinal()).setGlobal(true).setScaleH(0.03).setScaleV(0.15).setThreshold(300.0);
        }
        if (WorldConfig.enableMalachite) {
            new OreLayer3D(ModBlocks.stone_resource, BlockEnums.EnumStoneType.MALACHITE.ordinal()).setGlobal(true).setScaleH(0.1).setScaleV(0.15).setThreshold(275.0);
        }
        if (WorldConfig.enableSulfurCave) {
            new OreCave(ModBlocks.stone_resource, BlockEnums.EnumStoneType.SULFUR.ordinal()).setThreshold(1.5).setRangeMult(20).setYLevel(30).setMaxRange(20).withFluid(ModBlocks.sulfuric_acid_block);
        }
        if (WorldConfig.enableAsbestosCave) {
            new OreCave(ModBlocks.stone_resource, BlockEnums.EnumStoneType.ASBESTOS.ordinal()).setThreshold(1.75).setRangeMult(20).setYLevel(25).setMaxRange(20);
        }
        if (WorldConfig.enableSulfurCave) {
            new OreCave(ModBlocks.stone_resource, BlockEnums.EnumStoneType.SULFUR.ordinal()).setDimension(SpaceConfig.moonDimension).setThreshold(1.5).setRangeMult(20).setYLevel(30).setMaxRange(20);
        }
        new OreLayer3D(ModBlocks.stone_resource, BlockEnums.EnumStoneType.CONGLOMERATE.ordinal()).setDimension(SpaceConfig.moonDimension).setScaleH(0.04).setScaleV(0.25).setThreshold(220.0);
        if (WorldConfig.enableSulfurCave) {
            new OreCave(ModBlocks.stone_resource, BlockEnums.EnumStoneType.SULFUR.ordinal()).setDimension(SpaceConfig.dunaDimension).setThreshold(1.5).setRangeMult(20).setYLevel(30).setMaxRange(20);
        }
        if (WorldConfig.enableSulfurCave) {
            new OreCave(ModBlocks.stone_resource, BlockEnums.EnumStoneType.SULFUR.ordinal()).setDimension(SpaceConfig.ikeDimension).setThreshold(1.5).setRangeMult(20).setYLevel(30).setMaxRange(20);
        }
        new OreLayer3D(ModBlocks.stone_resource, BlockEnums.EnumStoneType.CONGLOMERATE.ordinal()).setDimension(SpaceConfig.ikeDimension).setScaleH(0.04).setScaleV(0.25).setThreshold(220.0);
        if (WorldConfig.enableSulfurCave) {
            new OreCave(ModBlocks.stone_resource, BlockEnums.EnumStoneType.SULFUR.ordinal()).setDimension(SpaceConfig.eveDimension).setThreshold(1.5).setRangeMult(20).setYLevel(30).setMaxRange(20).withFluid(ModBlocks.sulfuric_acid_block);
        }
        new OreCave(ModBlocks.basalt, 0).setDimension(SpaceConfig.eveDimension).setThreshold(0.15).setRangeMult(40).setYLevel(54).setMaxRange(24).setBlockOverride(ModBlocks.eve_silt).setIgnoreWater(true).setStalagmites(false);
        if (WorldConfig.enableSulfurCave) {
            new OreCave(ModBlocks.stone_resource, BlockEnums.EnumStoneType.SULFUR.ordinal()).setDimension(SpaceConfig.mohoDimension).setThreshold(1.5).setRangeMult(20).setYLevel(30).setMaxRange(20);
        }
        if (WorldConfig.enableSulfurCave) {
            new OreCave(ModBlocks.stone_resource, BlockEnums.EnumStoneType.SULFUR.ordinal()).setDimension(SpaceConfig.minmusDimension).setThreshold(1.5).setRangeMult(20).setYLevel(30).setMaxRange(20);
        }
        new OreLayer3D(ModBlocks.minmus_regolith, 0).setDimension(SpaceConfig.minmusDimension).setScaleH(0.06).setScaleV(0.25).setThreshold(220.0);
        new OreLayer3D(ModBlocks.minmus_smooth, 0).setDimension(SpaceConfig.minmusDimension).setScaleH(0.05).setScaleV(0.15).setThreshold(280.0);
        new OreLayer3D(ModBlocks.stone_resource, BlockEnums.EnumStoneType.CONGLOMERATE.ordinal()).setDimension(SpaceConfig.minmusDimension).setScaleH(0.04).setScaleV(0.25).setThreshold(220.0);
        if (WorldConfig.enableSulfurCave) {
            new OreCave(ModBlocks.stone_resource, BlockEnums.EnumStoneType.SULFUR.ordinal()).setDimension(SpaceConfig.laytheDimension).setThreshold(1.5).setRangeMult(20).setYLevel(30).setMaxRange(20).withFluid(ModBlocks.sulfuric_acid_block);
        }
        if (WorldConfig.enableAsbestosCave) {
            new OreCave(ModBlocks.stone_resource, BlockEnums.EnumStoneType.ASBESTOS.ordinal()).setDimension(SpaceConfig.laytheDimension).setThreshold(1.75).setRangeMult(20).setYLevel(25).setMaxRange(20);
        }
        new OreCave(ModBlocks.tumor).setDimension(SpaceConfig.laytheDimension).setThreshold(0.3).setRangeMult(20).setYLevel(25).setMaxRange(70);
        new OreCave(ModBlocks.laythe_silt, 6).setDimension(SpaceConfig.laytheDimension).setThreshold(0.25).setRangeMult(80).setYLevel(54).setMaxRange(24).setBlockOverride(ModBlocks.laythe_silt).setIgnoreWater(true).setStalagmites(false);
        new OreCave(ModBlocks.laythe_silt, 3).setDimension(SpaceConfig.laytheDimension).setThreshold(0.2).setRangeMult(60).setYLevel(58).setMaxRange(14).setBlockOverride(ModBlocks.laythe_silt).setIgnoreWater(true).setStalagmites(false);
        BedrockOre.init();
        PlanetGen.overrideOverworldProvider();
        Compat.handleRailcraftNonsense();
        SuicideThreadDump.register();
        CommandReloadClient.register();
        WorldTypeTeleport.init();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (logger == null) {
            logger = event.getModLog();
        }
        ModEventHandler commonHandler = new ModEventHandler();
        FMLCommonHandler.instance().bus().register((Object)commonHandler);
        MinecraftForge.EVENT_BUS.register((Object)commonHandler);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)commonHandler);
        MinecraftForge.ORE_GEN_BUS.register((Object)commonHandler);
        ModEventHandlerImpact impactHandler = new ModEventHandlerImpact();
        FMLCommonHandler.instance().bus().register((Object)impactHandler);
        MinecraftForge.EVENT_BUS.register((Object)impactHandler);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)impactHandler);
        PacketDispatcher.registerPackets();
        ChunkRadiationManager radiationSystem = new ChunkRadiationManager();
        MinecraftForge.EVENT_BUS.register((Object)radiationSystem);
        FMLCommonHandler.instance().bus().register((Object)radiationSystem);
        PollutionHandler pollution = new PollutionHandler();
        MinecraftForge.EVENT_BUS.register((Object)pollution);
        FMLCommonHandler.instance().bus().register((Object)pollution);
        DamageResistanceHandler dmgHandler = new DamageResistanceHandler();
        MinecraftForge.EVENT_BUS.register((Object)dmgHandler);
        ChunkAtmosphereManager atmosphere = new ChunkAtmosphereManager();
        MinecraftForge.EVENT_BUS.register((Object)atmosphere);
        FMLCommonHandler.instance().bus().register((Object)atmosphere);
        NeutronHandler neutronHandler = new NeutronHandler();
        MinecraftForge.EVENT_BUS.register((Object)neutronHandler);
        FMLCommonHandler.instance().bus().register((Object)neutronHandler);
        if (event.getSide() == Side.CLIENT) {
            HbmKeybinds.register();
            HbmKeybinds keyHandler = new HbmKeybinds();
            FMLCommonHandler.instance().bus().register((Object)keyHandler);
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        World world = event.getServer().func_130014_f_();
        RBMKDials.createDials(world);
        event.registerServerCommand((ICommand)new CommandReloadRecipes());
        event.registerServerCommand((ICommand)new CommandDebugChunkLoad());
        event.registerServerCommand((ICommand)new CommandSatellites());
        event.registerServerCommand((ICommand)new CommandRadiation());
        event.registerServerCommand((ICommand)new CommandStations());
        event.registerServerCommand((ICommand)new CommandPacketInfo());
        event.registerServerCommand((ICommand)new CommandReloadServer());
        event.registerServerCommand((ICommand)new CommandLocate());
        event.registerServerCommand((ICommand)new CommandTotalTime());
        event.registerServerCommand((ICommand)new CommandCustomize());
        event.registerServerCommand((ICommand)new CommandReapNetworks());
        ArcFurnaceRecipes.registerFurnaceSmeltables();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
        if (GeneralConfig.enableStatReRegistering) {
            logger.info("Attempting to re-register item stats...");
            StatHelper.resetStatShitFuck();
            logger.info("Item stats re-registered");
        }
    }

    private void loadConfig(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        GeneralConfig.loadFromConfig(config);
        WorldConfig.loadFromConfig(config);
        MachineConfig.loadFromConfig(config);
        BombConfig.loadFromConfig(config);
        RadiationConfig.loadFromConfig(config);
        PotionConfig.loadFromConfig(config);
        ToolConfig.loadFromConfig(config);
        WeaponConfig.loadFromConfig(config);
        MobConfig.loadFromConfig(config);
        StructureConfig.loadFromConfig(config);
        SpaceConfig.loadFromConfig(config);
        config.save();
        try {
            if (GeneralConfig.enableThermosPreventer && Class.forName("thermos.ThermosClassTransformer") != null) {
                throw new IllegalStateException("The mod tried to start on a Thermos or its fork server and therefore stopped. To allow the server to start on Thermos, change the appropriate config entry (0.00 in hbm.cfg). This was done because, by default, Thermos uses a so-called \"optimization\" feature that reduces tile ticking a lot, which will inevitably break a lot of machines. Most people aren't even aware of this, and start blaming random mods for all their stuff breaking. In order to adjust or even disable this feature, edit \"tileentities.yml\" in your Thermos install folder. If you believe that crashing the server until a config option is changed is annoying, then I would agree, but it's still preferable over wasting hours trying to fix an issue that is really just an \"intended feature\" added by Thermos itself, and not a bug in the mod. You'll have to change Thermos' config anyway so that extra change in NTM's config can't be that big of a burden.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public void handleMissingMappings(FMLMissingMappingsEvent event) {
        ignoreMappings.clear();
        remapItems.clear();
        for (int i = 1; i <= 8; ++i) {
            ignoreMappings.add("hbm:item.gasflame" + i);
        }
        ignoreMappings.add("hbm:item.cyclotron_tower");
        ignoreMappings.add("hbm:item.magnet_dee");
        ignoreMappings.add("hbm:item.centrifuge_tower");
        ignoreMappings.add("hbm:item.gun_revolver_nopip_ammo");
        ignoreMappings.add("hbm:item.gun_revolver_pip_ammo");
        ignoreMappings.add("hbm:item.gun_calamity_ammo");
        ignoreMappings.add("hbm:item.gun_lacunae_ammo");
        ignoreMappings.add("hbm:item.gun_rpg_ammo");
        ignoreMappings.add("hbm:item.gun_mp40_ammo");
        ignoreMappings.add("hbm:item.gun_uzi_ammo");
        ignoreMappings.add("hbm:item.gun_uboinik_ammo");
        ignoreMappings.add("hbm:item.gun_lever_action_ammo");
        ignoreMappings.add("hbm:item.gun_bolt_action_ammo");
        ignoreMappings.add("hbm:item.gun_fatman_ammo");
        ignoreMappings.add("hbm:item.gun_mirv_ammo");
        ignoreMappings.add("hbm:item.gun_stinger_ammo");
        ignoreMappings.add("hbm:item.limiter");
        ignoreMappings.add("hbm:item.turret_biometry");
        ignoreMappings.add("hbm:item.thermo_unit_empty");
        ignoreMappings.add("hbm:item.thermo_unit_endo");
        ignoreMappings.add("hbm:item.thermo_unit_exo");
        ignoreMappings.add("hbm:item.gadget_explosive");
        ignoreMappings.add("hbm:item.man_explosive");
        ignoreMappings.add("hbm:item.crystal_energy");
        ignoreMappings.add("hbm:item.pellet_coolant");
        ignoreMappings.add("hbm:item.turret_control");
        ignoreMappings.add("hbm:tile.sellafield_0");
        ignoreMappings.add("hbm:tile.sellafield_1");
        ignoreMappings.add("hbm:tile.sellafield_2");
        ignoreMappings.add("hbm:tile.sellafield_3");
        ignoreMappings.add("hbm:tile.sellafield_4");
        ignoreMappings.add("hbm:tile.sellafield_core");
        ignoreMappings.add("hbm:tile.fusion_core");
        ignoreMappings.add("hbm:tile.machine_telelinker");
        ignoreMappings.add("hbm:item.dynosphere_base");
        ignoreMappings.add("hbm:item.dynosphere_desh");
        ignoreMappings.add("hbm:item.dynosphere_desh_charged");
        ignoreMappings.add("hbm:item.dynosphere_schrabidium");
        ignoreMappings.add("hbm:item.dynosphere_schrabidium_charged");
        ignoreMappings.add("hbm:item.dynosphere_euphemium");
        ignoreMappings.add("hbm:item.dynosphere_euphemium_charged");
        ignoreMappings.add("hbm:item.dynosphere_dineutronium");
        ignoreMappings.add("hbm:item.dynosphere_dineutronium_charged");
        ignoreMappings.add("hbm:item.factory_core_titanium");
        ignoreMappings.add("hbm:item.factory_core_advanced");
        ignoreMappings.add("hbm:tile.factory_titanium_core");
        ignoreMappings.add("hbm:tile.factory_advanced_core");
        ignoreMappings.add("hbm:tile.factory_titanium_conductor");
        ignoreMappings.add("hbm:tile.factory_advanced_conductor");
        ignoreMappings.add("hbm:tile.factory_titanium_furnace");
        ignoreMappings.add("hbm:tile.factory_advanced_furnace");
        ignoreMappings.add("hbm:tile.turret_light");
        ignoreMappings.add("hbm:tile.turret_heavy");
        ignoreMappings.add("hbm:tile.turret_rocket");
        ignoreMappings.add("hbm:tile.turret_flamer");
        ignoreMappings.add("hbm:tile.turret_tau");
        ignoreMappings.add("hbm:tile.turret_cwis");
        ignoreMappings.add("hbm:tile.turret_spitfire");
        ignoreMappings.add("hbm:tile.turret_cheapo");
        ignoreMappings.add("hbm:item.turret_light_ammo");
        ignoreMappings.add("hbm:item.turret_heavy_ammo");
        ignoreMappings.add("hbm:item.turret_rocket_ammo");
        ignoreMappings.add("hbm:item.turret_flamer_ammo");
        ignoreMappings.add("hbm:item.turret_tau_ammo");
        ignoreMappings.add("hbm:item.turret_cwis_ammo");
        ignoreMappings.add("hbm:item.turret_spitfire_ammo");
        ignoreMappings.add("hbm:item.turret_cheapo_ammo");
        ignoreMappings.add("hbm:tile.cel_prime");
        ignoreMappings.add("hbm:tile.cel_prime_terminal");
        ignoreMappings.add("hbm:tile.cel_prime_battery");
        ignoreMappings.add("hbm:tile.cel_prime_port");
        ignoreMappings.add("hbm:tile.cel_prime_tanks");
        ignoreMappings.add("hbm:tile.rf_cable");
        ignoreMappings.add("hbm:tile.test_container");
        ignoreMappings.add("hbm:tile.test_bb_bork");
        ignoreMappings.add("hbm:tile.test_bb_inf");
        ignoreMappings.add("hbm:tile.test_missile");
        ignoreMappings.add("hbm:tile.rotation_tester");
        ignoreMappings.add("hbm:tile.test_ticker");
        ignoreMappings.add("hbm:tile.dummy_block_flare");
        ignoreMappings.add("hbm:tile.dummy_port_flare");
        ignoreMappings.add("hbm:tile.dummy_block_chemplant");
        ignoreMappings.add("hbm:tile.dummy_port_chemplant");
        ignoreMappings.add("hbm:tile.dummy_block_pumpjack");
        ignoreMappings.add("hbm:tile.dummy_port_pumpjack");
        ignoreMappings.add("hbm:tile.dummy_block_radgen");
        ignoreMappings.add("hbm:tile.dummy_port_radgen");
        ignoreMappings.add("hbm:tile.test_conductor");
        ignoreMappings.add("hbm:tile.dummy_block_fluidtank");
        ignoreMappings.add("hbm:tile.dummy_port_fluidtank");
        ignoreMappings.add("hbm:item.telepad");
        ignoreMappings.add("hbm:item.rubber_gloves");
        ignoreMappings.add("hbm:item.pirfenidone");
        ignoreMappings.add("hbm:item.coin_siege");
        ignoreMappings.add("hbm:item.source");
        ignoreMappings.add("hbm:item.gun_brimstone");
        ignoreMappings.add("hbm:item.stamp_schrabidium_flat");
        ignoreMappings.add("hbm:item.stamp_schrabidium_plate");
        ignoreMappings.add("hbm:item.stamp_schrabidium_wire");
        ignoreMappings.add("hbm:item.stamp_schrabidium_circuit");
        ignoreMappings.add("hbm:item.blades_combine_steel");
        ignoreMappings.add("hbm:item.blades_schrabidium");
        ignoreMappings.add("hbm:item.blades_aluminium");
        ignoreMappings.add("hbm:item.blades_gold");
        ignoreMappings.add("hbm:item.blades_iron");
        ignoreMappings.add("hbm:item.cap_aluminium");
        ignoreMappings.add("hbm:tile.dummy_block_refinery");
        ignoreMappings.add("hbm:tile.dummy_port_refinery");
        ignoreMappings.add("hbm:item.gun_revolver_iron");
        ignoreMappings.add("hbm:item.gun_calamity_dual");
        ignoreMappings.add("hbm:item.gun_revolver_lead");
        ignoreMappings.add("hbm:tile.dummy_block_turbofan");
        ignoreMappings.add("hbm:tile.dummy_port_turbofan");
        ignoreMappings.add("hbm:item.canister_smear");
        ignoreMappings.add("hbm:item.canister_canola");
        ignoreMappings.add("hbm:item.canister_oil");
        ignoreMappings.add("hbm:item.canister_fuel");
        ignoreMappings.add("hbm:item.canister_kerosene");
        ignoreMappings.add("hbm:item.canister_reoil");
        ignoreMappings.add("hbm:item.canister_petroil");
        ignoreMappings.add("hbm:item.canister_gasoline");
        ignoreMappings.add("hbm:item.canister_fracksol");
        ignoreMappings.add("hbm:item.canister_NITAN");
        ignoreMappings.add("hbm:item.canister_heavyoil");
        ignoreMappings.add("hbm:item.canister_bitumen");
        ignoreMappings.add("hbm:item.canister_heatingoil");
        ignoreMappings.add("hbm:item.canister_naphtha");
        ignoreMappings.add("hbm:item.canister_lightoil");
        ignoreMappings.add("hbm:item.canister_biofuel");
        ignoreMappings.add("hbm:item.canister_ethanol");
        ignoreMappings.add("hbm:item.gun_revolver_nightmare2_ammo");
        ignoreMappings.add("hbm:item.gun_revolver_iron_ammo");
        ignoreMappings.add("hbm:item.gun_revolver_gold_ammo");
        ignoreMappings.add("hbm:item.gun_revolver_cursed_ammo");
        ignoreMappings.add("hbm:item.gun_revolver_ammo");
        ignoreMappings.add("hbm:item.gun_revolver_nightmare_ammo");
        ignoreMappings.add("hbm:item.gun_mp_ammo");
        ignoreMappings.add("hbm:item.gun_revolver_lead_ammo");
        ignoreMappings.add("hbm:item.gun_revolver_schrabidium_ammo");
        ignoreMappings.add("hbm:item.tank_waste");
        ignoreMappings.add("hbm:item.digamma_see");
        ignoreMappings.add("hbm:item.digamma_feel");
        ignoreMappings.add("hbm:item.digamma_know");
        ignoreMappings.add("hbm:item.digamma_kauai_moho");
        ignoreMappings.add("hbm:item.digamma_up_on_top");
        ignoreMappings.add("hbm:tile.oil_duct_solid");
        ignoreMappings.add("hbm:tile.oil_duct");
        ignoreMappings.add("hbm:tile.gas_duct_solid");
        ignoreMappings.add("hbm:tile.gas_duct");
        ignoreMappings.add("hbm:tile.dummy_block_assembler");
        ignoreMappings.add("hbm:tile.dummy_port_assembler");
        ignoreMappings.add("hbm:item.canned_beef");
        ignoreMappings.add("hbm:item.canned_tuna");
        ignoreMappings.add("hbm:item.canned_mystery");
        ignoreMappings.add("hbm:item.canned_pashtet");
        ignoreMappings.add("hbm:item.canned_cheese");
        ignoreMappings.add("hbm:item.canned_jizz");
        ignoreMappings.add("hbm:item.canned_milk");
        ignoreMappings.add("hbm:item.canned_ass");
        ignoreMappings.add("hbm:item.canned_pizza");
        ignoreMappings.add("hbm:item.canned_tube");
        ignoreMappings.add("hbm:item.canned_tomato");
        ignoreMappings.add("hbm:item.canned_asbestos");
        ignoreMappings.add("hbm:item.canned_bhole");
        ignoreMappings.add("hbm:item.canned_hotdogs");
        ignoreMappings.add("hbm:item.canned_leftovers");
        ignoreMappings.add("hbm:item.canned_yogurt");
        ignoreMappings.add("hbm:item.canned_stew");
        ignoreMappings.add("hbm:item.canned_chinese");
        ignoreMappings.add("hbm:item.canned_oil");
        ignoreMappings.add("hbm:item.canned_fist");
        ignoreMappings.add("hbm:item.canned_spam");
        ignoreMappings.add("hbm:item.canned_fried");
        ignoreMappings.add("hbm:item.canned_napalm");
        ignoreMappings.add("hbm:item.canned_diesel");
        ignoreMappings.add("hbm:item.canned_kerosene");
        ignoreMappings.add("hbm:item.canned_recursion");
        ignoreMappings.add("hbm:item.canned_bark");
        ignoreMappings.add("hbm:item.primer_357");
        ignoreMappings.add("hbm:item.primer_44");
        ignoreMappings.add("hbm:item.primer_9");
        ignoreMappings.add("hbm:item.primer_50");
        ignoreMappings.add("hbm:item.primer_buckshot");
        ignoreMappings.add("hbm:tile.ore_bedrock_coltan");
        ignoreMappings.add("hbm:item.recycled_ground");
        ignoreMappings.add("hbm:item.recycled_rock");
        ignoreMappings.add("hbm:item.recycled_metal");
        ignoreMappings.add("hbm:item.recycled_refined");
        ignoreMappings.add("hbm:item.recycled_organic");
        ignoreMappings.add("hbm:item.recycled_crystal");
        ignoreMappings.add("hbm:item.recycled_explosive");
        ignoreMappings.add("hbm:item.recycled_electronic");
        ignoreMappings.add("hbm:item.recycled_nuclear");
        ignoreMappings.add("hbm:item.recycled_misc");
        ignoreMappings.add("hbm:item.gun_bf_ammo");
        ignoreMappings.add("hbm:tile.brick_dungeon");
        ignoreMappings.add("hbm:tile.brick_dungeon_flat");
        ignoreMappings.add("hbm:tile.brick_dungeon_tile");
        ignoreMappings.add("hbm:tile.brick_dungeon_circle");
        ignoreMappings.add("hbm:tile.bomber");
        ignoreMappings.add("hbm:item.bolt_tungsten");
        ignoreMappings.add("hbm:item.bolt_dura_steel");
        ignoreMappings.add("hbm:tile.rail_large_curve_wide");
        ignoreMappings.add("hbm:tile.nuke_n45");
        ignoreMappings.add("hbm:tile.machine_coal_off");
        ignoreMappings.add("hbm:tile.machine_coal_on");
        ignoreMappings.add("hbm:tile.machine_drill");
        ignoreMappings.add("hbm:tile.drill_pipe");
        ignoreMappings.add("hbm:tile.dummy_block_drill");
        ignoreMappings.add("hbm:tile.dummy_port_drill");
        ignoreMappings.add("hbm:tile.machine_combine_factory");
        ignoreMappings.add("hbm:tile.watz_core");
        ignoreMappings.add("hbm:tile.watz_hatch");
        ignoreMappings.add("hbm:tile.marker_structure");
        ignoreMappings.add("hbm:tile.reactor_element");
        ignoreMappings.add("hbm:tile.reactor_control");
        ignoreMappings.add("hbm:tile.reactor_hatch");
        ignoreMappings.add("hbm:tile.reactor_ejector");
        ignoreMappings.add("hbm:tile.reactor_inserter");
        ignoreMappings.add("hbm:tile.reactor_conductor");
        ignoreMappings.add("hbm:tile.reactor_computer");
        ignoreMappings.add("hbm:tile.ff");
        ignoreMappings.add("hbm:tile.muffler");
        ignoreMappings.add("hbm:tile.basalt_sulfur");
        ignoreMappings.add("hbm:tile.basalt_fluorite");
        ignoreMappings.add("hbm:tile.basalt_asbestos");
        ignoreMappings.add("hbm:tile.basalt_gem");
        ignoreMappings.add("hbm:item.missile_endo");
        ignoreMappings.add("hbm:item.missile_exo");
        ignoreMappings.add("hbm:item.warhead_thermo_endo");
        ignoreMappings.add("hbm:item.warhead_thermo_exo");
        ignoreMappings.add("hbm:item.gun_dampfmaschine");
        ignoreMappings.add("hbm:item.canteen_13");
        ignoreMappings.add("hbm:tile.residue");
        ignoreMappings.add("hbm:item.powder_cloud");
        ignoreMappings.add("hbm:item.gun_detonator");
        ignoreMappings.add("hbm:item.gun_avenger");
        ignoreMappings.add("hbm:tile.block_cap_nuka");
        ignoreMappings.add("hbm:tile.block_cap_quantum");
        ignoreMappings.add("hbm:tile.block_cap_rad");
        ignoreMappings.add("hbm:tile.block_cap_sparkle");
        ignoreMappings.add("hbm:tile.block_cap_korl");
        ignoreMappings.add("hbm:tile.block_cap_fritz");
        ignoreMappings.add("hbm:tile.block_cap_sunset");
        ignoreMappings.add("hbm:tile.block_cap_star");
        ignoreMappings.add("hbm:tile.machine_deaerator");
        ignoreMappings.add("hbm:item.bottle2_sunset");
        ignoreMappings.add("hbm:item.cap_sunset");
        ignoreMappings.add("hbm:item.cap_star");
        ignoreMappings.add("hbm:tile.test_render");
        ignoreMappings.add("hbm:tile.test_bomb");
        ignoreMappings.add("hbm:tile.test_bomb_advanced");
        ignoreMappings.add("hbm:tile.test_nuke");
        ignoreMappings.add("hbm:tile.test_pipe");
        ignoreMappings.add("hbm:tile.test_ct");
        ignoreMappings.add("hbm:tile.test_rail");
        ignoreMappings.add("hbm:tile.block_niter_reinforced");
        ignoreMappings.add("hbm:tile.siege_shield");
        ignoreMappings.add("hbm:tile.siege_internal");
        ignoreMappings.add("hbm:tile.siege_circuit");
        ignoreMappings.add("hbm:tile.siege_emergency");
        ignoreMappings.add("hbm:tile.siege_hole");
        ignoreMappings.add("hbm:tile.machine_shredder_large");
        ignoreMappings.add("hbm:tile.turret_brandon");
        ignoreMappings.add("hbm:item.bottle2_sunset");
        ignoreMappings.add("hbm:item.pellet_schrabidium");
        ignoreMappings.add("hbm:item.pellet_hes");
        ignoreMappings.add("hbm:item.pellet_mes");
        ignoreMappings.add("hbm:item.pellet_les");
        ignoreMappings.add("hbm:item.pellet_beryllium");
        ignoreMappings.add("hbm:item.pellet_neptunium");
        ignoreMappings.add("hbm:item.pellet_lead");
        ignoreMappings.add("hbm:item.pellet_advanced");
        ignoreMappings.add("hbm:item.board_copper");
        ignoreMappings.add("hbm:item.titanium_filter");
        ignoreMappings.add("hbm:item.battery_steam");
        ignoreMappings.add("hbm:item.battery_steam_large");
        ignoreMappings.add("hbm:item.hull_small_steel");
        ignoreMappings.add("hbm:item.hull_small_aluminium");
        ignoreMappings.add("hbm:item.hull_big_steel");
        ignoreMappings.add("hbm:item.hull_big_aluminium");
        ignoreMappings.add("hbm:item.hull_big_titanium");
        ignoreMappings.add("hbm:item.rod_zirnox_natural_uranium_fuel");
        ignoreMappings.add("hbm:item.rod_zirnox_uranium_fuel");
        ignoreMappings.add("hbm:item.rod_zirnox_th232");
        ignoreMappings.add("hbm:item.rod_zirnox_thorium_fuel");
        ignoreMappings.add("hbm:item.rod_zirnox_mox_fuel");
        ignoreMappings.add("hbm:item.rod_zirnox_plutonium_fuel");
        ignoreMappings.add("hbm:item.rod_zirnox_u233_fuel");
        ignoreMappings.add("hbm:item.rod_zirnox_u235_fuel");
        ignoreMappings.add("hbm:item.rod_zirnox_les_fuel");
        ignoreMappings.add("hbm:item.rod_zirnox_lithium");
        ignoreMappings.add("hbm:item.rod_zirnox_zfb_mox");
        ignoreMappings.add("hbm:item.gas_petroleum");
        ignoreMappings.add("hbm:item.gas_biogas");
        ignoreMappings.add("hbm:item.gas_lpg");
        ignoreMappings.add("hbm:item.gun_coilgun_ammo");
        ignoreMappings.add("hbm:item.rotor_steel");
        ignoreMappings.add("hbm:item.generator_steel");
        ignoreMappings.add("hbm:item.bolt_compound");
        ignoreMappings.add("hbm:tile.anvil_meteorite");
        ignoreMappings.add("hbm:tile.anvil_starmetal");
        ignoreMappings.add("hbm:tile.anvil_bismuth");
        ignoreMappings.add("hbm:tile.lamp_uv_off");
        ignoreMappings.add("hbm:tile.lamp_uv_on");
        ignoreMappings.add("hbm:tile.ams_base");
        ignoreMappings.add("hbm:tile.ams_emitter");
        ignoreMappings.add("hbm:tile.ams_limiter");
        ignoreMappings.add("hbm:tile.dummy_block_ams_limiter");
        ignoreMappings.add("hbm:tile.dummy_port_ams_limiter");
        ignoreMappings.add("hbm:tile.dummy_block_ams_emitter");
        ignoreMappings.add("hbm:tile.dummy_port_ams_emitter");
        ignoreMappings.add("hbm:tile.dummy_block_ams_base");
        ignoreMappings.add("hbm:tile.dummy_port_ams_base");
        ignoreMappings.add("hbm:tile.machine_selenium");
        ignoreMappings.add("hbm:tile.fwatz_conductor");
        ignoreMappings.add("hbm:tile.fwatz_cooler");
        ignoreMappings.add("hbm:tile.fwatz_tank");
        ignoreMappings.add("hbm:tile.fwatz_scaffold");
        ignoreMappings.add("hbm:tile.fwatz_hatch");
        ignoreMappings.add("hbm:tile.fwatz_computer");
        ignoreMappings.add("hbm:tile.fwatz_core");
        ignoreMappings.add("hbm:tile.fwatz_plasma");
        ignoreMappings.add("hbm:tile.ore_meteor_uranium");
        ignoreMappings.add("hbm:tile.ore_meteor_thorium");
        ignoreMappings.add("hbm:tile.ore_meteor_titanium");
        ignoreMappings.add("hbm:tile.ore_meteor_sulfur");
        ignoreMappings.add("hbm:tile.ore_meteor_copper");
        ignoreMappings.add("hbm:tile.ore_meteor_tungsten");
        ignoreMappings.add("hbm:tile.ore_meteor_aluminium");
        ignoreMappings.add("hbm:tile.ore_meteor_lead");
        ignoreMappings.add("hbm:tile.ore_meteor_lithium");
        ignoreMappings.add("hbm:tile.ore_meteor_starmetal");
        ignoreMappings.add("hbm:tile.machine_generator");
        ignoreMappings.add("hbm:item.arc_electrode_desh");
        ignoreMappings.add("hbm:tile.sand_gold");
        ignoreMappings.add("hbm:tile.sand_gold198");
        ignoreMappings.add("hbm:tile.ore_weidanium");
        ignoreMappings.add("hbm:tile.ore_reiium");
        ignoreMappings.add("hbm:tile.ore_unobtainium");
        ignoreMappings.add("hbm:tile.ore_daffergon");
        ignoreMappings.add("hbm:tile.ore_verticium");
        ignoreMappings.add("hbm:item.warhead_mirvlet");
        ignoreMappings.add("hbm:item.generator_front");
        ignoreMappings.add("hbm:tile.rbmk_heatex");
        ignoreMappings.add("hbm:tile.machine_boiler_on");
        ignoreMappings.add("hbm:tile.machine_boiler_electric_off");
        ignoreMappings.add("hbm:tile.machine_boiler_electric_on");
        ignoreMappings.add("hbm:tile.watz_control");
        ignoreMappings.add("hbm:item.circuit_raw");
        ignoreMappings.add("hbm:item.circuit_aluminium");
        ignoreMappings.add("hbm:item.circuit_copper");
        ignoreMappings.add("hbm:item.circuit_red_copper");
        ignoreMappings.add("hbm:item.circuit_gold");
        ignoreMappings.add("hbm:item.circuit_schrabidium");
        ignoreMappings.add("hbm:item.circuit_bismuth_raw");
        ignoreMappings.add("hbm:item.circuit_bismuth");
        ignoreMappings.add("hbm:item.circuit_arsenic_raw");
        ignoreMappings.add("hbm:item.circuit_arsenic");
        ignoreMappings.add("hbm:item.circuit_tantalium_raw");
        ignoreMappings.add("hbm:item.circuit_tantalium");
        ignoreMappings.add("hbm:item.circuit_targeting_tier1");
        ignoreMappings.add("hbm:item.circuit_targeting_tier2");
        ignoreMappings.add("hbm:item.circuit_targeting_tier3");
        ignoreMappings.add("hbm:item.circuit_targeting_tier4");
        ignoreMappings.add("hbm:item.circuit_targeting_tier5");
        ignoreMappings.add("hbm:item.circuit_targeting_tier6");
        ignoreMappings.add("hbm:tile.fluid_duct");
        ignoreMappings.add("hbm:tile.fluid_duct_solid");
        ignoreMappings.add("hbm:item.void_anim");
        ignoreMappings.add("hbm:item.pellet_mercury");
        ignoreMappings.add("hbm:item.pellet_meteorite");
        ignoreMappings.add("hbm:item.d_smoke1");
        ignoreMappings.add("hbm:item.d_smoke2");
        ignoreMappings.add("hbm:item.d_smoke3");
        ignoreMappings.add("hbm:item.d_smoke4");
        ignoreMappings.add("hbm:item.d_smoke5");
        ignoreMappings.add("hbm:item.d_smoke6");
        ignoreMappings.add("hbm:item.d_smoke7");
        ignoreMappings.add("hbm:item.d_smoke8");
        ignoreMappings.add("hbm:item.smoke1");
        ignoreMappings.add("hbm:item.smoke2");
        ignoreMappings.add("hbm:item.smoke3");
        ignoreMappings.add("hbm:item.smoke4");
        ignoreMappings.add("hbm:item.smoke5");
        ignoreMappings.add("hbm:item.smoke6");
        ignoreMappings.add("hbm:item.smoke7");
        ignoreMappings.add("hbm:item.smoke8");
        ignoreMappings.add("hbm:item.battery_su");
        ignoreMappings.add("hbm:item.battery_su_l");
        ignoreMappings.add("hbm:item.redstone_depleted");
        ignoreMappings.add("hbm:item.euphemium_stopper");
        ignoreMappings.add("hbm:item.energy_ball");
        ignoreMappings.add("hbm:item.discharge");
        ignoreMappings.add("hbm:item.empblast");
        ignoreMappings.add("hbm:tile.crystal_power");
        ignoreMappings.add("hbm:tile.crystal_energy");
        ignoreMappings.add("hbm:tile.crystal_robust");
        ignoreMappings.add("hbm:tile.crystal_trixite");
        ignoreMappings.add("hbm:tile.hazmat");
        ignoreMappings.add("hbm:item.pellet_coal");
        ignoreMappings.add("hbm:item.test_helmet");
        ignoreMappings.add("hbm:item.test_chestplate");
        ignoreMappings.add("hbm:item.test_leggings");
        ignoreMappings.add("hbm:item.test_boots");
        ignoreMappings.add("hbm:item.cape_test");
        ignoreMappings.add("hbm:item.spill1");
        ignoreMappings.add("hbm:item.spill2");
        ignoreMappings.add("hbm:item.spill3");
        ignoreMappings.add("hbm:item.spill4");
        ignoreMappings.add("hbm:item.spill5");
        ignoreMappings.add("hbm:item.spill6");
        ignoreMappings.add("hbm:item.spill7");
        ignoreMappings.add("hbm:item.spill8");
        ignoreMappings.add("hbm:item.gas1");
        ignoreMappings.add("hbm:item.gas2");
        ignoreMappings.add("hbm:item.gas3");
        ignoreMappings.add("hbm:item.gas4");
        ignoreMappings.add("hbm:item.gas5");
        ignoreMappings.add("hbm:item.gas6");
        ignoreMappings.add("hbm:item.gas7");
        ignoreMappings.add("hbm:item.gas8");
        ignoreMappings.add("hbm:tile.brick_forgotten");
        ignoreMappings.add("hbm:tile.watz_conductor");
        ignoreMappings.add("hbm:item.flame_1");
        ignoreMappings.add("hbm:item.flame_2");
        ignoreMappings.add("hbm:item.flame_3");
        ignoreMappings.add("hbm:item.flame_3");
        ignoreMappings.add("hbm:item.flame_4");
        ignoreMappings.add("hbm:item.flame_5");
        ignoreMappings.add("hbm:item.flame_6");
        ignoreMappings.add("hbm:item.flame_7");
        ignoreMappings.add("hbm:item.flame_8");
        ignoreMappings.add("hbm:item.flame_9");
        ignoreMappings.add("hbm:item.flame_10");
        ignoreMappings.add("hbm:tile.dummy_block_uf6");
        ignoreMappings.add("hbm:tile.dummy_block_puf6");
        ignoreMappings.add("hbm:item.wire_aluminium");
        ignoreMappings.add("hbm:item.wire_copper");
        ignoreMappings.add("hbm:item.wire_red_copper");
        ignoreMappings.add("hbm:item.wire_tungsten");
        ignoreMappings.add("hbm:item.wire_gold");
        ignoreMappings.add("hbm:item.wire_schrabidium");
        ignoreMappings.add("hbm:item.wire_advanced_alloy");
        ignoreMappings.add("hbm:item.wire_magnetized_tungsten");
        ignoreMappings.add("hbm:item.nugget_weidanium");
        ignoreMappings.add("hbm:item.nugget_reiium");
        ignoreMappings.add("hbm:item.nugget_unobtainium");
        ignoreMappings.add("hbm:item.nugget_daffergon");
        ignoreMappings.add("hbm:item.nugget_verticium");
        ignoreMappings.add("hbm:item.ingot_weidanium");
        ignoreMappings.add("hbm:item.ingot_reiium");
        ignoreMappings.add("hbm:item.ingot_unobtainium");
        ignoreMappings.add("hbm:item.ingot_daffergon");
        ignoreMappings.add("hbm:item.ingot_verticium");
        ignoreMappings.add("hbm:item.powder_weidanium");
        ignoreMappings.add("hbm:item.powder_reiium");
        ignoreMappings.add("hbm:item.powder_unobtainium");
        ignoreMappings.add("hbm:item.powder_daffergon");
        ignoreMappings.add("hbm:item.powder_verticium");
        ignoreMappings.add("hbm:tile.ore_random");
        ignoreMappings.add("hbm:item.crate_caller");
        ignoreMappings.add("hbm:item.pellet_rtg_berkelium");
        ignoreMappings.add("hbm:item.folly_shell");
        ignoreMappings.add("hbm:item.folly_bullet");
        ignoreMappings.add("hbm:item.folly_bullet_nuclear");
        ignoreMappings.add("hbm:item.folly_bullet_du");
        ignoreMappings.add("hbm:item.ammo_folly");
        ignoreMappings.add("hbm:item.ammo_folly_nuclear");
        ignoreMappings.add("hbm:item.ammo_folly_du");
        ignoreMappings.add("hbm:item.clip_revolver_iron");
        ignoreMappings.add("hbm:item.clip_revolver");
        ignoreMappings.add("hbm:item.clip_revolver_gold");
        ignoreMappings.add("hbm:item.clip_revolver_lead");
        ignoreMappings.add("hbm:item.clip_revolver_schrabidium");
        ignoreMappings.add("hbm:item.clip_revolver_cursed");
        ignoreMappings.add("hbm:item.clip_revolver_nightmare");
        ignoreMappings.add("hbm:item.clip_revolver_nightmare2");
        ignoreMappings.add("hbm:item.clip_revolver_pip");
        ignoreMappings.add("hbm:item.clip_revolver_nopip");
        ignoreMappings.add("hbm:item.clip_rpg");
        ignoreMappings.add("hbm:item.clip_stinger");
        ignoreMappings.add("hbm:item.clip_fatman");
        ignoreMappings.add("hbm:item.clip_mirv");
        ignoreMappings.add("hbm:item.clip_bf");
        ignoreMappings.add("hbm:item.clip_mp40");
        ignoreMappings.add("hbm:item.clip_uzi");
        ignoreMappings.add("hbm:item.clip_uboinik");
        ignoreMappings.add("hbm:item.clip_lever_action");
        ignoreMappings.add("hbm:item.clip_bolt_action");
        ignoreMappings.add("hbm:item.clip_xvl1456");
        ignoreMappings.add("hbm:item.clip_osipr");
        ignoreMappings.add("hbm:item.clip_immolator");
        ignoreMappings.add("hbm:item.clip_cryolator");
        ignoreMappings.add("hbm:item.clip_mp");
        ignoreMappings.add("hbm:item.clip_emp");
        ignoreMappings.add("hbm:item.clip_jack");
        ignoreMappings.add("hbm:item.clip_spark");
        ignoreMappings.add("hbm:item.clip_hp");
        ignoreMappings.add("hbm:item.clip_euthanasia");
        ignoreMappings.add("hbm:item.clip_defabricator");
        ignoreMappings.add("hbm:item.ammo_folly_du");
        ignoreMappings.add("hbm:tile.#null");
        ignoreMappings.add("hbm:tile.#void");
        ignoreMappings.add("hbm:tile.#ngtv");
        ignoreMappings.add("hbm:item.gun_rpg");
        ignoreMappings.add("hbm:item.gun_karl");
        ignoreMappings.add("hbm:item.gun_hk69");
        ignoreMappings.add("hbm:item.gun_skystinger");
        ignoreMappings.add("hbm:item.gun_revolver");
        ignoreMappings.add("hbm:item.gun_revolver_saturnite");
        ignoreMappings.add("hbm:item.gun_revolver_gold");
        ignoreMappings.add("hbm:item.gun_revolver_schrabidium");
        ignoreMappings.add("hbm:item.gun_revolver_cursed");
        ignoreMappings.add("hbm:item.gun_revolver_nightmare");
        ignoreMappings.add("hbm:item.gun_revolver_nightmare2");
        ignoreMappings.add("hbm:item.gun_revolver_pip");
        ignoreMappings.add("hbm:item.gun_revolver_nopip");
        ignoreMappings.add("hbm:item.gun_revolver_blackjack");
        ignoreMappings.add("hbm:item.gun_revolver_silver");
        ignoreMappings.add("hbm:item.gun_revolver_red");
        ignoreMappings.add("hbm:item.gun_bio_revolver");
        ignoreMappings.add("hbm:item.gun_deagle");
        ignoreMappings.add("hbm:item.gun_flechette");
        ignoreMappings.add("hbm:item.gun_ar15");
        ignoreMappings.add("hbm:item.gun_calamity");
        ignoreMappings.add("hbm:item.gun_lacunae");
        ignoreMappings.add("hbm:item.gun_proto");
        ignoreMappings.add("hbm:item.gun_mirv");
        ignoreMappings.add("hbm:item.gun_bf");
        ignoreMappings.add("hbm:item.gun_mp40");
        ignoreMappings.add("hbm:item.gun_thompson");
        ignoreMappings.add("hbm:item.gun_uzi_silencer");
        ignoreMappings.add("hbm:item.gun_uzi_saturnite");
        ignoreMappings.add("hbm:item.gun_uzi_saturnite_silencer");
        ignoreMappings.add("hbm:item.gun_uboinik");
        ignoreMappings.add("hbm:item.gun_remington");
        ignoreMappings.add("hbm:item.gun_supershotgun");
        ignoreMappings.add("hbm:item.gun_benelli");
        ignoreMappings.add("hbm:item.gun_ks23");
        ignoreMappings.add("hbm:item.gun_sauer");
        ignoreMappings.add("hbm:item.gun_lever_action");
        ignoreMappings.add("hbm:item.gun_lever_action_dark");
        ignoreMappings.add("hbm:item.gun_lever_action_sonata");
        ignoreMappings.add("hbm:item.gun_bolt_action");
        ignoreMappings.add("hbm:item.gun_bolt_action_green");
        ignoreMappings.add("hbm:item.gun_bolt_action_saturnite");
        ignoreMappings.add("hbm:item.gun_mymy");
        ignoreMappings.add("hbm:item.gun_b93");
        ignoreMappings.add("hbm:item.gun_xvl1456");
        ignoreMappings.add("hbm:item.gun_xvl1456_ammo");
        ignoreMappings.add("hbm:item.gun_osipr");
        ignoreMappings.add("hbm:item.gun_osipr_ammo");
        ignoreMappings.add("hbm:item.gun_osipr_ammo2");
        ignoreMappings.add("hbm:item.gun_immolator");
        ignoreMappings.add("hbm:item.gun_immolator_ammo");
        ignoreMappings.add("hbm:item.gun_cryolator");
        ignoreMappings.add("hbm:item.gun_mp");
        ignoreMappings.add("hbm:item.gun_bolter_digamma");
        ignoreMappings.add("hbm:item.gun_zomg");
        ignoreMappings.add("hbm:item.gun_super_shotgun");
        ignoreMappings.add("hbm:item.gun_moist_nugget");
        ignoreMappings.add("hbm:item.gun_revolver_inverted");
        ignoreMappings.add("hbm:item.gun_emp");
        ignoreMappings.add("hbm:item.gun_emp_ammo");
        ignoreMappings.add("hbm:item.gun_jack");
        ignoreMappings.add("hbm:item.gun_jack_ammo");
        ignoreMappings.add("hbm:item.gun_spark");
        ignoreMappings.add("hbm:item.gun_spark_ammo");
        ignoreMappings.add("hbm:item.gun_hp");
        ignoreMappings.add("hbm:item.gun_hp_ammo");
        ignoreMappings.add("hbm:item.gun_euthanasia");
        ignoreMappings.add("hbm:item.gun_euthanasia_ammo");
        ignoreMappings.add("hbm:item.gun_defabricator");
        ignoreMappings.add("hbm:item.gun_defabricator_ammo");
        ignoreMappings.add("hbm:item.gun_vortex");
        ignoreMappings.add("hbm:item.gun_waluigi");
        ignoreMappings.add("hbm:item.gun_darter");
        ignoreMappings.add("hbm:item.gun_glass_cannon");
        ignoreMappings.add("hbm:item.gun_lunatic_marksman");
        ignoreMappings.add("hbm:item.gun_uac_pistol");
        ignoreMappings.add("hbm:item.ammo_misc");
        ignoreMappings.add("hbm:item.ammo_12gauge");
        ignoreMappings.add("hbm:item.ammo_20gauge");
        ignoreMappings.add("hbm:item.ammo_4gauge");
        ignoreMappings.add("hbm:item.ammo_357");
        ignoreMappings.add("hbm:item.ammo_44");
        ignoreMappings.add("hbm:item.ammo_5mm");
        ignoreMappings.add("hbm:item.ammo_9mm");
        ignoreMappings.add("hbm:item.ammo_45");
        ignoreMappings.add("hbm:item.ammo_556");
        ignoreMappings.add("hbm:item.ammo_762");
        ignoreMappings.add("hbm:item.ammo_22lr");
        ignoreMappings.add("hbm:item.ammo_50ae");
        ignoreMappings.add("hbm:item.ammo_50bmg");
        ignoreMappings.add("hbm:item.ammo_75bolt");
        ignoreMappings.add("hbm:item.ammo_rocket");
        ignoreMappings.add("hbm:item.ammo_grenade");
        ignoreMappings.add("hbm:item.ammo_shell");
        ignoreMappings.add("hbm:item.ammo_nuke");
        ignoreMappings.add("hbm:item.ammo_fuel");
        ignoreMappings.add("hbm:item.ammo_fireext");
        ignoreMappings.add("hbm:item.ammo_dart");
        ignoreMappings.add("hbm:item.ammo_stinger_rocket");
        ignoreMappings.add("hbm:item.ammo_luna_sniper");
        ignoreMappings.add("hbm:item.ammo_coilgun");
        ignoreMappings.add("hbm:item.ammo_cell");
        ignoreMappings.add("hbm:item.b_smoke1");
        ignoreMappings.add("hbm:item.b_smoke2");
        ignoreMappings.add("hbm:item.b_smoke3");
        ignoreMappings.add("hbm:item.b_smoke4");
        ignoreMappings.add("hbm:item.b_smoke5");
        ignoreMappings.add("hbm:item.b_smoke6");
        ignoreMappings.add("hbm:item.b_smoke7");
        ignoreMappings.add("hbm:item.b_smoke8");
        ignoreMappings.add("hbm:item.ln2_1");
        ignoreMappings.add("hbm:item.ln2_2");
        ignoreMappings.add("hbm:item.ln2_3");
        ignoreMappings.add("hbm:item.ln2_4");
        ignoreMappings.add("hbm:item.ln2_5");
        ignoreMappings.add("hbm:item.ln2_6");
        ignoreMappings.add("hbm:item.ln2_7");
        ignoreMappings.add("hbm:item.ln2_8");
        ignoreMappings.add("hbm:item.ln2_9");
        ignoreMappings.add("hbm:item.ln2_10");
        ignoreMappings.add("hbm:item.casing_357");
        ignoreMappings.add("hbm:item.casing_44");
        ignoreMappings.add("hbm:item.casing_9");
        ignoreMappings.add("hbm:item.casing_50");
        ignoreMappings.add("hbm:item.casing_buckshot");
        ignoreMappings.add("hbm:item.assembly_iron");
        ignoreMappings.add("hbm:item.assembly_steel");
        ignoreMappings.add("hbm:item.assembly_lead");
        ignoreMappings.add("hbm:item.assembly_gold");
        ignoreMappings.add("hbm:item.assembly_schrabidium");
        ignoreMappings.add("hbm:item.assembly_nightmare");
        ignoreMappings.add("hbm:item.assembly_desh");
        ignoreMappings.add("hbm:item.assembly_nopip");
        ignoreMappings.add("hbm:item.assembly_smg");
        ignoreMappings.add("hbm:item.assembly_556");
        ignoreMappings.add("hbm:item.assembly_762");
        ignoreMappings.add("hbm:item.assembly_45");
        ignoreMappings.add("hbm:item.assembly_uzi");
        ignoreMappings.add("hbm:item.assembly_actionexpress");
        ignoreMappings.add("hbm:item.assembly_calamity");
        ignoreMappings.add("hbm:item.assembly_lacunae");
        ignoreMappings.add("hbm:item.assembly_luna");
        ignoreMappings.add("hbm:item.pellet_chlorophyte");
        ignoreMappings.add("hbm:item.pellet_canister");
        ignoreMappings.add("hbm:item.pellet_claws");
        ignoreMappings.add("hbm:item.pellet_flechette");
        ignoreMappings.add("hbm:item.bobmazon_materials");
        ignoreMappings.add("hbm:item.bobmazon_machines");
        ignoreMappings.add("hbm:item.bobmazon_weapons");
        ignoreMappings.add("hbm:item.bobmazon_tools");
        ignoreMappings.add("hbm:item.missile_carrier");
        ignoreMappings.add("hbm:item.magnet_circular");
        ignoreMappings.add("hbm:item.mechanism_revolver_1");
        ignoreMappings.add("hbm:item.mechanism_revolver_2");
        ignoreMappings.add("hbm:item.mechanism_rifle_1");
        ignoreMappings.add("hbm:item.mechanism_rifle_2");
        ignoreMappings.add("hbm:item.mechanism_launcher_1");
        ignoreMappings.add("hbm:item.mechanism_launcher_2");
        ignoreMappings.add("hbm:item.mechanism_special");
        ignoreMappings.add("hbm:tile.transission_hatch");
        ignoreMappings.add("hbm:tile.machine_nuke_furnace_off");
        ignoreMappings.add("hbm:tile.machine_nuke_furnace_on");
        ignoreMappings.add("hbm:item.singularity_micro");
        ignoreMappings.add("hbm:item.alloy_knife");
        ignoreMappings.add("hbm:tile.hazmat");
        ignoreMappings.add("hbm:item.gun_cryocannon");
        ignoreMappings.add("hbm:item.gun_cryolator_ammo");
        ignoreMappings.add("hbm:item.canteen_fab");
        ignoreMappings.add("hbm:item.fabsols_vodka");
        ignoreMappings.add("hbm:item.test_nuke_igniter");
        ignoreMappings.add("hbm:item.test_nuke_propellant");
        ignoreMappings.add("hbm:item.test_nuke_tier1_shielding");
        ignoreMappings.add("hbm:item.test_nuke_tier2_shielding");
        ignoreMappings.add("hbm:item.test_nuke_tier1_bullet");
        ignoreMappings.add("hbm:item.test_nuke_tier2_bullet");
        ignoreMappings.add("hbm:item.test_nuke_tier1_target");
        ignoreMappings.add("hbm:item.test_nuke_tier2_target");
        ignoreMappings.add("hbm:tile.hadron_cooler");
        ignoreMappings.add("hbm:tile.machine_transformer_20");
        ignoreMappings.add("hbm:tile.machine_transformer_dnt_20");
        ignoreMappings.add("hbm:item.levitation_unit");
        ignoreMappings.add("hbm:item.letter");
        ignoreMappings.add("hbm:item.chopper_head");
        ignoreMappings.add("hbm:item.chopper_gun");
        ignoreMappings.add("hbm:item.chopper_torso");
        ignoreMappings.add("hbm:item.chopper_tail");
        ignoreMappings.add("hbm:item.chopper_wing");
        ignoreMappings.add("hbm:item.chopper_blades");
        ignoreMappings.add("hbm:item.component_emitter");
        ignoreMappings.add("hbm:item.component_limiter");
        ignoreMappings.add("hbm:item.bottle2_korl_special");
        ignoreMappings.add("hbm:item.bottle2_fritz_special");
        ignoreMappings.add("hbm:item.journal_pip");
        ignoreMappings.add("hbm:item.journal_bj");
        ignoreMappings.add("hbm:item.journal_silver");
        ignoreMappings.add("hbm:tile.machine_arc_furnace_off");
        ignoreMappings.add("hbm:tile.machine_arc_furnace_on");
        ignoreMappings.add("hbm:item.heavy_component");
        ignoreMappings.add("hbm:item.mp_w_20");
        ignoreMappings.add("hbm:item.mp_f_20");
        ignoreMappings.add("hbm:item.mp_thruster_10_kerosene_tec");
        ignoreMappings.add("hbm:item.mp_thruster_15_kerosene_tec");
        ignoreMappings.add("hbm:item.powder_platnium");
        ignoreMappings.add("hbm:item.ingot_platnium");
        ignoreMappings.add("hbm:item.nugget_platnium");
        ignoreMappings.add("hbm:item.t45_kit");
        ignoreMappings.add("hbm:item.fusion_core_infinite");
        ignoreMappings.add("hbm:item.fluid_identifier");
        ignoreMappings.add("hbm:tile.sand_boron");
        ignoreMappings.add("hbm:tile.sand_lead");
        ignoreMappings.add("hbm:tile.sand_uranium");
        ignoreMappings.add("hbm:tile.sand_polonium");
        ignoreMappings.add("hbm:tile.sand_quartz");
        ignoreMappings.add("hbm:tile.hadron_power_10m");
        ignoreMappings.add("hbm:tile.hadron_power_100m");
        ignoreMappings.add("hbm:tile.hadron_power_1g");
        ignoreMappings.add("hbm:tile.hadron_power_10g");
        ignoreMappings.add("hbm:item.bob_metalworks");
        ignoreMappings.add("hbm:item.bob_assembly");
        ignoreMappings.add("hbm:item.bob_chemistry");
        ignoreMappings.add("hbm:item.bob_oil");
        ignoreMappings.add("hbm:item.bob_nuclear");
        ignoreMappings.add("hbm:item.multitool_hit");
        ignoreMappings.add("hbm:item.multitool_dig");
        ignoreMappings.add("hbm:item.multitool_silk");
        ignoreMappings.add("hbm:item.multitool_ext");
        ignoreMappings.add("hbm:item.multitool_miner");
        ignoreMappings.add("hbm:item.multitool_beam");
        ignoreMappings.add("hbm:item.multitool_sky");
        ignoreMappings.add("hbm:item.multitool_mega");
        ignoreMappings.add("hbm:item.multitool_joule");
        ignoreMappings.add("hbm:item.multitool_decon");
        ignoreMappings.add("hbm:tile.struct_iter_core");
        ignoreMappings.add("hbm:tile.struct_plasma_core");
        ignoreMappings.add("hbm:tile.machine_amgen");
        ignoreMappings.add("hbm:tile.machine_geo");
        ignoreMappings.add("hbm:tile.ore_coal_oil");
        ignoreMappings.add("hbm:tile.ore_coal_oil_burning");
        ignoreMappings.add("hbm:tile.block_weidanium");
        ignoreMappings.add("hbm:tile.block_reiium");
        ignoreMappings.add("hbm:tile.block_unobtainium");
        ignoreMappings.add("hbm:tile.block_daffergon");
        ignoreMappings.add("hbm:tile.block_verticium");
        ignoreMappings.add("hbm:tile.machine_schrabidium_transmutator");
        ignoreMappings.add("hbm:tile.machine_discharger");
        ignoreMappings.add("hbm:tile.fusion_conductor");
        ignoreMappings.add("hbm:tile.fusion_center");
        ignoreMappings.add("hbm:tile.fusion_motor");
        ignoreMappings.add("hbm:tile.machine_spp_bottom");
        ignoreMappings.add("hbm:tile.machine_spp_top");
        remapItems.put("hbm:item.gadget_explosive8", ModItems.early_explosive_lenses);
        remapItems.put("hbm:item.man_explosive8", ModItems.explosive_lenses);
        remapItems.put("hbm:item.briquette_lignite", ModItems.briquette);
        remapItems.put("hbm:item.antiknock", ModItems.fuel_additive);
        remapItems.put("hbm:item.kit_toolbox_empty", ModItems.toolbox);
        remapItems.put("hbm:item.kit_toolbox", ModItems.legacy_toolbox);
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (mapping.name.startsWith("hbm:item.ammo_")) {
                mapping.ignore();
                continue;
            }
            if (ignoreMappings.contains(mapping.name)) {
                mapping.ignore();
                continue;
            }
            if (mapping.type != GameRegistry.Type.ITEM || remapItems.get(mapping.name) == null) continue;
            mapping.remap(remapItems.get(mapping.name));
        }
    }

    static {
        logger = LogManager.getLogger((String)"HBM");
        tMatSchrab = EnumHelper.addToolMaterial((String)"SCHRABIDIUM", (int)3, (int)10000, (float)50.0f, (float)100.0f, (int)200);
        tMatHammmer = EnumHelper.addToolMaterial((String)"SCHRABIDIUMHAMMER", (int)3, (int)0, (float)50.0f, (float)1.0E9f, (int)200);
        tMatChainsaw = EnumHelper.addToolMaterial((String)"CHAINSAW", (int)3, (int)1500, (float)50.0f, (float)22.0f, (int)0);
        tMatSteel = EnumHelper.addToolMaterial((String)"HBM_STEEL", (int)2, (int)500, (float)7.5f, (float)2.0f, (int)10);
        tMatTitan = EnumHelper.addToolMaterial((String)"HBM_TITANIUM", (int)3, (int)750, (float)9.0f, (float)2.5f, (int)15);
        tMatAlloy = EnumHelper.addToolMaterial((String)"HBM_ALLOY", (int)3, (int)2000, (float)15.0f, (float)5.0f, (int)5);
        tMatCMB = EnumHelper.addToolMaterial((String)"HBM_CMB", (int)3, (int)8500, (float)40.0f, (float)55.0f, (int)100);
        tMatElec = EnumHelper.addToolMaterial((String)"HBM_ELEC", (int)3, (int)0, (float)30.0f, (float)12.0f, (int)2);
        tMatDesh = EnumHelper.addToolMaterial((String)"HBM_DESH", (int)2, (int)0, (float)7.5f, (float)2.0f, (int)10);
        tMatCobalt = EnumHelper.addToolMaterial((String)"HBM_COBALT", (int)3, (int)750, (float)9.0f, (float)2.5f, (int)60);
        enumToolMaterialSaw = EnumHelper.addToolMaterial((String)"SAW", (int)2, (int)750, (float)2.0f, (float)3.5f, (int)25);
        enumToolMaterialBat = EnumHelper.addToolMaterial((String)"BAT", (int)0, (int)500, (float)1.5f, (float)3.0f, (int)25);
        enumToolMaterialBatNail = EnumHelper.addToolMaterial((String)"BATNAIL", (int)0, (int)450, (float)1.0f, (float)4.0f, (int)25);
        enumToolMaterialGolfClub = EnumHelper.addToolMaterial((String)"GOLFCLUB", (int)1, (int)1000, (float)2.0f, (float)5.0f, (int)25);
        enumToolMaterialPipeRusty = EnumHelper.addToolMaterial((String)"PIPERUSTY", (int)1, (int)350, (float)1.5f, (float)4.5f, (int)25);
        enumToolMaterialPipeLead = EnumHelper.addToolMaterial((String)"PIPELEAD", (int)1, (int)250, (float)1.5f, (float)3.0f, (int)25);
        enumToolMaterialBottleOpener = EnumHelper.addToolMaterial((String)"OPENER", (int)1, (int)250, (float)1.5f, (float)0.5f, (int)200);
        enumToolMaterialSledge = EnumHelper.addToolMaterial((String)"SHIMMERSLEDGE", (int)1, (int)0, (float)25.0f, (float)26.0f, (int)200);
        enumToolMaterialMultitool = EnumHelper.addToolMaterial((String)"MULTITOOL", (int)3, (int)5000, (float)25.0f, (float)5.5f, (int)25);
        aMatSchrab = EnumHelper.addArmorMaterial((String)"HBM_SCHRABIDIUM", (int)100, (int[])new int[]{3, 8, 6, 3}, (int)50);
        aMatEuph = EnumHelper.addArmorMaterial((String)"HBM_EUPHEMIUM", (int)15000000, (int[])new int[]{3, 8, 6, 3}, (int)100);
        aMatHaz = EnumHelper.addArmorMaterial((String)"HBM_HAZMAT", (int)60, (int[])new int[]{2, 5, 4, 1}, (int)5);
        aMatHaz2 = EnumHelper.addArmorMaterial((String)"HBM_HAZMAT2", (int)60, (int[])new int[]{2, 5, 4, 1}, (int)5);
        aMatHaz3 = EnumHelper.addArmorMaterial((String)"HBM_HAZMAT3", (int)60, (int[])new int[]{2, 5, 4, 1}, (int)5);
        aMatSteel = EnumHelper.addArmorMaterial((String)"HBM_STEEL", (int)20, (int[])new int[]{2, 6, 5, 2}, (int)5);
        aMatAsbestos = EnumHelper.addArmorMaterial((String)"HBM_ASBESTOS", (int)20, (int[])new int[]{1, 4, 3, 1}, (int)5);
        aMatTitan = EnumHelper.addArmorMaterial((String)"HBM_TITANIUM", (int)25, (int[])new int[]{3, 8, 6, 3}, (int)9);
        aMatAlloy = EnumHelper.addArmorMaterial((String)"HBM_ALLOY", (int)40, (int[])new int[]{3, 8, 6, 3}, (int)12);
        aMatPaa = EnumHelper.addArmorMaterial((String)"HBM_PAA", (int)75, (int[])new int[]{3, 8, 6, 3}, (int)25);
        aMatCMB = EnumHelper.addArmorMaterial((String)"HBM_CMB", (int)60, (int[])new int[]{3, 8, 6, 3}, (int)50);
        aMatAus3 = EnumHelper.addArmorMaterial((String)"HBM_AUSIII", (int)375, (int[])new int[]{2, 6, 5, 2}, (int)0);
        aMatSecurity = EnumHelper.addArmorMaterial((String)"HBM_SECURITY", (int)100, (int[])new int[]{3, 8, 6, 3}, (int)15);
        aMatCobalt = EnumHelper.addArmorMaterial((String)"HBM_COBALT", (int)70, (int[])new int[]{3, 8, 6, 3}, (int)60);
        aMatStarmetal = EnumHelper.addArmorMaterial((String)"HBM_STARMETAL", (int)150, (int[])new int[]{3, 8, 6, 3}, (int)100);
        aMatBismuth = EnumHelper.addArmorMaterial((String)"HBM_BISMUTH", (int)100, (int[])new int[]{3, 8, 6, 3}, (int)100);
        partsTab = new PartsTab(CreativeTabs.getNextID(), "tabParts");
        controlTab = new ControlTab(CreativeTabs.getNextID(), "tabControl");
        templateTab = new TemplateTab(CreativeTabs.getNextID(), "tabTemplate");
        blockTab = new BlockTab(CreativeTabs.getNextID(), "tabBlocks");
        machineTab = new MachineTab(CreativeTabs.getNextID(), "tabMachine");
        nukeTab = new NukeTab(CreativeTabs.getNextID(), "tabNuke");
        missileTab = new MissileTab(CreativeTabs.getNextID(), "tabMissile");
        weaponTab = new WeaponTab(CreativeTabs.getNextID(), "tabWeapon");
        consumableTab = new ConsumableTab(CreativeTabs.getNextID(), "tabConsumable");
        generalOverride = 0;
        polaroidID = 1;
        startupTime = 0L;
        ignoreMappings = new HashSet();
        remapItems = new HashMap();
    }
}

