/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.dim.CelestialBody;
import com.hbm.items.ISatChip;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemCustomMissilePart;
import com.hbm.saveddata.satellites.Satellite;
import com.hbm.util.i18n.I18nUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ItemSatellite
extends ItemCustomMissilePart
implements ISatChip {
    private boolean canLaunchByHand;

    public ItemSatellite() {
        this(16000);
    }

    public ItemSatellite(int mass) {
        this.makeWarhead(ItemCustomMissilePart.WarheadType.SATELLITE, 15.0f, mass, ItemCustomMissilePart.PartSize.SIZE_20);
        if (mass <= 16000) {
            this.canLaunchByHand = true;
        }
    }

    public ItemSatellite(int mass, ItemCustomMissilePart.WarheadType type) {
        this.makeWarhead(type, 15.0f, mass, ItemCustomMissilePart.PartSize.SIZE_20);
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        super.func_77624_a(itemstack, player, list, bool);
        list.add(I18nUtil.resolveKey("item.sat.desc.frequency", new Object[0]) + ": " + this.getFreq(itemstack));
        if (this == ModItems.sat_foeq) {
            list.add(I18nUtil.resolveKey("item.sat.desc.foeq", new Object[0]));
        }
        if (this == ModItems.sat_gerald) {
            list.add(I18nUtil.resolveKey("item.sat.desc.gerald.single_use", new Object[0]));
            list.add(I18nUtil.resolveKey("item.sat.desc.gerald.orbital_module", new Object[0]));
            list.add(I18nUtil.resolveKey("item.sat.desc.gerald.melter", new Object[0]));
        }
        if (this == ModItems.sat_laser) {
            list.add(I18nUtil.resolveKey("item.sat.desc.laser", new Object[0]));
        }
        if (this == ModItems.sat_mapper) {
            list.add(I18nUtil.resolveKey("item.sat.desc.mapper", new Object[0]));
        }
        if (this == ModItems.sat_miner) {
            list.add(I18nUtil.resolveKey("item.sat.desc.miner", new Object[0]));
        }
        if (this == ModItems.sat_lunar_miner) {
            list.add(I18nUtil.resolveKey("item.sat.desc.lunar_miner", new Object[0]));
        }
        if (this == ModItems.sat_radar) {
            list.add(I18nUtil.resolveKey("item.sat.desc.radar", new Object[0]));
        }
        if (this == ModItems.sat_resonator) {
            list.add(I18nUtil.resolveKey("item.sat.desc.resonator", new Object[0]));
        }
        if (this == ModItems.sat_scanner) {
            list.add(I18nUtil.resolveKey("item.sat.desc.scanner", new Object[0]));
        }
        if (this == ModItems.sat_war) {
            list.add(I18nUtil.resolveKey("item.sat.desc.war", new Object[0]));
        }
        if (this == ModItems.sat_dyson_relay) {
            list.add(I18nUtil.resolveKey("item.sat.desc.dyson_relay", new Object[0]));
        }
        if (this.canLaunchByHand) {
            list.add(EnumChatFormatting.GOLD + I18nUtil.resolveKey("item.sat.desc.launch_by_hand", new Object[0]));
            if (CelestialBody.inOrbit(player.field_70170_p)) {
                list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.sat.desc.deploy_orbit", new Object[0]));
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!this.canLaunchByHand) {
            return stack;
        }
        if (!CelestialBody.inOrbit(world)) {
            return stack;
        }
        if (!world.field_72995_K) {
            int targetDimensionId = CelestialBody.getTarget((World)world, (int)((int)player.field_70165_t), (int)((int)player.field_70161_v)).body.dimensionId;
            WorldServer targetWorld = DimensionManager.getWorld((int)targetDimensionId);
            if (targetWorld == null) {
                DimensionManager.initDimension((int)targetDimensionId);
                targetWorld = DimensionManager.getWorld((int)targetDimensionId);
                if (targetWorld == null) {
                    return stack;
                }
            }
            Satellite.orbit((World)targetWorld, Satellite.getIDFromItem(stack.func_77973_b()), this.getFreq(stack), player.field_70165_t, player.field_70163_u, player.field_70161_v);
            player.func_145747_a((IChatComponent)new ChatComponentText("Satellite launched successfully!"));
        }
        --stack.field_77994_a;
        return stack;
    }
}

