/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCircuit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.item.ItemStack;

public class VacuumCircuitRecipes
extends SerializableRecipe {
    public static List<VacuumCircuitRecipe> recipes = new ArrayList<VacuumCircuitRecipe>();
    public static HashSet<RecipesCommon.AStack> wafer = new HashSet();
    public static HashSet<RecipesCommon.AStack> pcb = new HashSet();

    @Override
    public void registerDefaults() {
        recipes.add(new VacuumCircuitRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.PROCESST1.ordinal()), 200, 250L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.CHIP)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.PCB), new RecipesCommon.ComparableStack(ModItems.circuit, 2, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}));
        recipes.add(new VacuumCircuitRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.PROCESST2.ordinal()), 400, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.GASCHIP)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.BASIC), new RecipesCommon.ComparableStack(ModItems.circuit, 2, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}));
        recipes.add(new VacuumCircuitRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.PROCESST3.ordinal()), 800, 25000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 2, (Enum)ItemCircuit.EnumCircuitType.GASCHIP), new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.HFCHIP)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.ComparableStack(ModItems.circuit, 2, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR_LANTHANIUM)}));
    }

    public static VacuumCircuitRecipe getRecipe(ItemStack[] inputs) {
        for (VacuumCircuitRecipe recipe : recipes) {
            if (!VacuumCircuitRecipes.matchesIngredients(new ItemStack[]{inputs[0], inputs[1]}, recipe.wafer) || !VacuumCircuitRecipes.matchesIngredients(new ItemStack[]{inputs[2], inputs[3]}, recipe.pcb)) continue;
            return recipe;
        }
        return null;
    }

    public static HashMap getRecipes() {
        HashMap<Object[], ItemStack> recipes = new HashMap<Object[], ItemStack>();
        for (VacuumCircuitRecipe recipe : VacuumCircuitRecipes.recipes) {
            ArrayList<RecipesCommon.AStack> ingredients = new ArrayList<RecipesCommon.AStack>();
            for (RecipesCommon.AStack stack : recipe.wafer) {
                ingredients.add(stack);
            }
            for (RecipesCommon.AStack stack : recipe.pcb) {
                ingredients.add(stack);
            }
            recipes.put(ingredients.toArray(), recipe.output);
        }
        return recipes;
    }

    @Override
    public String getFileName() {
        return "hbmVacuumCircuit.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
        wafer.clear();
        pcb.clear();
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        RecipesCommon.AStack[] wafer = VacuumCircuitRecipes.readAStackArray(obj.get("wafer").getAsJsonArray());
        RecipesCommon.AStack[] pcb = VacuumCircuitRecipes.readAStackArray(obj.get("pcb").getAsJsonArray());
        ItemStack output = VacuumCircuitRecipes.readItemStack(obj.get("output").getAsJsonArray());
        int duration = obj.get("duration").getAsInt();
        long consumption = obj.get("consumption").getAsLong();
        recipes.add(new VacuumCircuitRecipe(output, duration, consumption, wafer, pcb));
    }

    @Override
    public void writeRecipe(Object obj, JsonWriter writer) throws IOException {
        VacuumCircuitRecipe recipe = (VacuumCircuitRecipe)obj;
        writer.name("wafer").beginArray();
        for (RecipesCommon.AStack aStack : recipe.wafer) {
            VacuumCircuitRecipes.writeAStack(aStack, writer);
        }
        writer.endArray();
        writer.name("pcb").beginArray();
        for (RecipesCommon.AStack aStack : recipe.pcb) {
            VacuumCircuitRecipes.writeAStack(aStack, writer);
        }
        writer.endArray();
        writer.name("output");
        VacuumCircuitRecipes.writeItemStack(recipe.output, writer);
        writer.name("duration").value((long)recipe.duration);
        writer.name("consumption").value(recipe.consumption);
    }

    public static class VacuumCircuitRecipe {
        public RecipesCommon.AStack[] wafer;
        public RecipesCommon.AStack[] pcb;
        public ItemStack output;
        public int duration;
        public long consumption;

        public VacuumCircuitRecipe(ItemStack output, int duration, long consumption, RecipesCommon.AStack[] wafer, RecipesCommon.AStack[] pcb) {
            this.wafer = wafer;
            this.pcb = pcb;
            this.output = output;
            this.duration = duration;
            this.consumption = consumption;
            for (RecipesCommon.AStack t : wafer) {
                VacuumCircuitRecipes.wafer.add(t);
            }
            for (RecipesCommon.AStack t : pcb) {
                VacuumCircuitRecipes.pcb.add(t);
            }
        }
    }
}

