/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.util.Tuple;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Locale;
import java.util.Stack;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUICalculator
extends GuiScreen {
    private int xSize = 220;
    private int ySize = 50;
    private int borderWidth = 2;
    private GuiTextField inputField;
    private int selectedHist = -1;
    private static final int maxHistory = 6;
    private static Deque<Tuple.Pair<String, Double>> history = new ArrayDeque<Tuple.Pair<String, Double>>();
    private String latestResult = "?";
    private static int factorialCurrentN;

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        this.inputField = new GuiTextField(this.field_146289_q, x + 5, y + 8, 210, 13);
        this.inputField.func_146193_g(-1);
        this.inputField.func_146205_d(false);
        this.inputField.func_146195_b(true);
        this.inputField.func_146203_f(1000);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (!this.inputField.func_146201_a(p_73869_1_, p_73869_2_)) {
            super.func_73869_a(p_73869_1_, p_73869_2_);
        }
        String input = this.inputField.func_146179_b().replaceAll("[^\\d+\\-*/^!.()\\sA-Za-z]+", "");
        if (p_73869_1_ == '\r' || p_73869_1_ == '\n') {
            if (this.selectedHist != -1) {
                input = (String)new ArrayList<Tuple.Pair<String, Double>>(GUICalculator.history).get((int)this.selectedHist).key;
                this.inputField.func_146180_a(input);
                this.selectedHist = -1;
            } else {
                try {
                    double result = GUICalculator.evaluateExpression(input);
                    history.addFirst(new Tuple.Pair<String, Double>(input, result));
                    if (history.size() > 6) {
                        history.removeLast();
                    }
                    String plainStringRepresentation = new BigDecimal(result, MathContext.DECIMAL64).toPlainString();
                    GuiScreen.func_146275_d((String)plainStringRepresentation);
                    this.inputField.func_146180_a(plainStringRepresentation);
                    this.inputField.func_146202_e();
                    this.inputField.func_146199_i(0);
                }
                catch (Exception result) {
                    // empty catch block
                }
                return;
            }
        }
        this.selectedHist = p_73869_2_ == 200 ? Math.max(this.selectedHist - 1, -1) : (p_73869_2_ == 208 ? Math.min(this.selectedHist + 1, history.size() - 1) : -1);
        if (input.isEmpty()) {
            this.latestResult = "?";
            return;
        }
        try {
            this.latestResult = Double.toString(GUICalculator.evaluateExpression(input));
        }
        catch (Exception e) {
            this.latestResult = e.toString();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        int histHeight = (this.field_146289_q.field_78288_b + 2) * 6;
        int histStart = y + 30 + this.field_146289_q.field_78288_b + 8;
        GUICalculator.func_73734_a((int)x, (int)y, (int)(x + this.xSize), (int)(y + this.ySize + histHeight), (int)-13816531);
        GUICalculator.func_73734_a((int)(x + this.borderWidth), (int)(y + this.borderWidth), (int)(x + this.xSize - this.borderWidth), (int)(y + this.ySize - this.borderWidth + histHeight), (int)-12763843);
        GUICalculator.func_73734_a((int)x, (int)(histStart - 5), (int)(x + this.xSize), (int)(histStart - 3), (int)-13816531);
        this.inputField.func_146194_f();
        this.field_146289_q.func_78276_b("=" + this.latestResult, x + 5, y + 30, -1);
        int i = 0;
        for (Tuple.Pair<String, Double> prevInput : history) {
            int hy = y + 50 + (this.field_146289_q.field_78288_b + 1) * i;
            if (i == this.selectedHist) {
                GUICalculator.func_73734_a((int)(x + 4), (int)(hy - 1), (int)(x + 4 + this.xSize - 9), (int)(hy + this.field_146289_q.field_78288_b), (int)-15658735);
            }
            this.field_146289_q.func_78276_b((String)prevInput.key + " = " + prevInput.value, x + 5, hy, -1);
            ++i;
        }
    }

    public static double evaluateExpression(String input) {
        if (input.contains("^")) {
            input = GUICalculator.preEvaluatePower(input);
        }
        char[] tokens = input.toCharArray();
        Stack<Double> values = new Stack<Double>();
        Stack<String> operators = new Stack<String>();
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i] == ' ') continue;
            if (tokens[i] >= '0' && tokens[i] <= '9' || tokens[i] == '.' || tokens[i] == '-' && (i == 0 || "+-*/^(".contains(String.valueOf(tokens[i - 1])))) {
                StringBuilder buffer = new StringBuilder();
                if (tokens[i] == '-') {
                    buffer.append('-');
                    ++i;
                }
                while (i < tokens.length && (tokens[i] >= '0' && tokens[i] <= '9' || tokens[i] == '.')) {
                    buffer.append(tokens[i++]);
                }
                values.push(Double.parseDouble(buffer.toString()));
                --i;
                continue;
            }
            if (tokens[i] == '(') {
                operators.push(Character.toString(tokens[i]));
                continue;
            }
            if (tokens[i] == ')') {
                while (!operators.isEmpty() && ((String)operators.peek()).charAt(0) != '(') {
                    values.push(GUICalculator.evaluateOperator(((String)operators.pop()).charAt(0), (Double)values.pop(), (Double)values.pop()));
                }
                operators.pop();
                if (operators.isEmpty() || ((String)operators.peek()).length() <= 1) continue;
                values.push(GUICalculator.evaluateFunction((String)operators.pop(), (Double)values.pop()));
                continue;
            }
            if (tokens[i] == '+' || tokens[i] == '-' || tokens[i] == '*' || tokens[i] == '/' || tokens[i] == '^') {
                while (!operators.isEmpty() && GUICalculator.hasPrecedence(String.valueOf(tokens[i]), (String)operators.peek())) {
                    values.push(GUICalculator.evaluateOperator(((String)operators.pop()).charAt(0), (Double)values.pop(), (Double)values.pop()));
                }
                operators.push(Character.toString(tokens[i]));
                continue;
            }
            if (tokens[i] == '!') {
                values.push(Double.valueOf(GUICalculator.factorial((int)Math.round((Double)values.pop()))));
                continue;
            }
            if ((tokens[i] < 'A' || tokens[i] > 'Z') && (tokens[i] < 'a' || tokens[i] > 'z')) continue;
            StringBuilder charBuffer = new StringBuilder();
            while (i < tokens.length && (tokens[i] >= 'A' && tokens[i] <= 'Z' || tokens[i] >= 'a' && tokens[i] <= 'z')) {
                charBuffer.append(tokens[i++]);
            }
            String string = charBuffer.toString();
            if (string.equalsIgnoreCase("pi")) {
                values.push(Math.PI);
            } else if (string.equalsIgnoreCase("e")) {
                values.push(Math.E);
            } else {
                operators.push(string.toLowerCase(Locale.ROOT));
            }
            --i;
        }
        while (!operators.empty()) {
            values.push(GUICalculator.evaluateOperator(((String)operators.pop()).charAt(0), (Double)values.pop(), (Double)values.pop()));
        }
        return (Double)values.pop();
    }

    private static double evaluateOperator(char operator, double x, double y) {
        switch (operator) {
            case '+': {
                return y + x;
            }
            case '-': {
                return y - x;
            }
            case '*': {
                return y * x;
            }
            case '/': {
                return y / x;
            }
            case '^': {
                return Math.pow(y, x);
            }
        }
        return 0.0;
    }

    private static double evaluateFunction(String function, double x) {
        switch (function) {
            case "sqrt": {
                return Math.sqrt(x);
            }
            case "sin": {
                return Math.sin(x);
            }
            case "cos": {
                return Math.cos(x);
            }
            case "tan": {
                return Math.tan(x);
            }
            case "asin": {
                return Math.asin(x);
            }
            case "acos": {
                return Math.acos(x);
            }
            case "atan": {
                return Math.atan(x);
            }
            case "log": {
                return Math.log10(x);
            }
            case "ln": {
                return Math.log(x);
            }
            case "ceil": {
                return Math.ceil(x);
            }
            case "floor": {
                return Math.floor(x);
            }
            case "round": {
                return Math.round(x);
            }
        }
        return 0.0;
    }

    private static boolean hasPrecedence(String first, String second) {
        if (second.length() > 1) {
            return false;
        }
        char firstChar = first.charAt(0);
        char secondChar = second.charAt(0);
        if (secondChar == '(' || secondChar == ')') {
            return false;
        }
        return firstChar != '*' && firstChar != '/' && firstChar != '^' || secondChar != '+' && secondChar != '-';
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String preEvaluatePower(String input) {
        int exponentExpressionEnd;
        double result;
        int baseExpressionStart;
        do {
            int powerOperatorIndex;
            boolean previousTokenIsParentheses = input.charAt((powerOperatorIndex = input.lastIndexOf(94)) - 1) == ')';
            int parenthesesDepth = previousTokenIsParentheses ? 1 : 0;
            int n = baseExpressionStart = previousTokenIsParentheses ? powerOperatorIndex - 2 : powerOperatorIndex - 1;
            block11: while (baseExpressionStart >= 0) {
                switch (input.charAt(baseExpressionStart)) {
                    case ')': {
                        if (!previousTokenIsParentheses) break block11;
                        ++parenthesesDepth;
                        break;
                    }
                    case '(': {
                        if (!previousTokenIsParentheses || parenthesesDepth <= 0) break block11;
                        --parenthesesDepth;
                        break;
                    }
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': 
                    case '^': {
                        if (parenthesesDepth == 0) break block11;
                    }
                }
                --baseExpressionStart;
            }
            ++baseExpressionStart;
            if (parenthesesDepth > 0) {
                throw new IllegalArgumentException("Incomplete parentheses");
            }
            boolean nextTokenIsParentheses = input.charAt(powerOperatorIndex + 1) == '(';
            parenthesesDepth = nextTokenIsParentheses ? 1 : 0;
            int n2 = exponentExpressionEnd = nextTokenIsParentheses ? powerOperatorIndex + 2 : powerOperatorIndex + 1;
            block12: while (exponentExpressionEnd < input.length()) {
                switch (input.charAt(exponentExpressionEnd)) {
                    case '(': {
                        if (!nextTokenIsParentheses) break block12;
                        ++parenthesesDepth;
                        break;
                    }
                    case ')': {
                        if (!nextTokenIsParentheses || parenthesesDepth <= 0) break block12;
                        --parenthesesDepth;
                        break;
                    }
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': 
                    case '^': {
                        if (parenthesesDepth == 0) break block12;
                    }
                }
                ++exponentExpressionEnd;
            }
            if (parenthesesDepth > 0) {
                throw new IllegalArgumentException("Incomplete parentheses");
            }
            double base = GUICalculator.evaluateExpression(input.substring(baseExpressionStart, powerOperatorIndex));
            double exponent = GUICalculator.evaluateExpression(input.substring(powerOperatorIndex + 1, exponentExpressionEnd));
            result = Math.pow(base, exponent);
        } while ((input = input.substring(0, baseExpressionStart) + new BigDecimal(result, MathContext.DECIMAL64).toPlainString() + input.substring(exponentExpressionEnd)).contains("^"));
        return input;
    }

    private static int factorial(int in) {
        if (in < 0) {
            throw new IllegalArgumentException("Factorial needs n >= 0");
        }
        if (in < 2) {
            return 1;
        }
        int p = 1;
        int r = 1;
        factorialCurrentN = 1;
        int h = 0;
        int shift = 0;
        int high = 1;
        int log2n = GUICalculator.log2(in);
        while (h != in) {
            shift += h;
            h = in >> log2n--;
            int len = high;
            high = h - 1 | 1;
            if ((len = (high - len) / 2) <= 0) continue;
            r *= (p *= GUICalculator.factorialProduct(len));
        }
        return r << shift;
    }

    private static int factorialProduct(int in) {
        int m = in / 2;
        if (m == 0) {
            return factorialCurrentN += 2;
        }
        if (in == 2) {
            factorialCurrentN = factorialCurrentN + 2;
            return factorialCurrentN * (factorialCurrentN += 2);
        }
        return GUICalculator.factorialProduct(in - m) * GUICalculator.factorialProduct(m);
    }

    private static int log2(int in) {
        int log = 0;
        if ((in & 0xFFFF0000) != 0) {
            in >>>= 16;
            log = 16;
        }
        if (in >= 256) {
            in >>>= 8;
            log += 8;
        }
        if (in >= 16) {
            in >>>= 4;
            log += 4;
        }
        if (in >= 4) {
            in >>>= 2;
            log += 2;
        }
        return log + (in >>> 1);
    }
}

