/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hazard.type;

import com.hbm.config.GeneralConfig;
import com.hbm.config.RadiationConfig;
import com.hbm.hazard.modifier.HazardModifier;
import com.hbm.hazard.type.HazardTypeBase;
import com.hbm.items.ModItems;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class HazardTypeNeutron
extends HazardTypeBase {
    public static final String NEUTRON_KEY = "ntmNeutron";

    @Override
    public void onUpdate(EntityLivingBase target, float level, ItemStack stack) {
        if (RadiationConfig.disableNeutron) {
            return;
        }
        boolean reacher = false;
        if (target instanceof EntityPlayer && !GeneralConfig.enable528) {
            reacher = ((EntityPlayer)target).field_71071_by.func_146028_b(ModItems.reacher);
        }
        if ((level *= (float)stack.field_77994_a) > 0.0f) {
            float rad = level / 20.0f * ContaminationUtil.calculateRadiationMod(target);
            if (GeneralConfig.enable528 && reacher) {
                rad /= 49.0f;
            } else if (reacher) {
                rad = (float)Math.sqrt(rad + 1.0f / ((rad + 2.0f) * (rad + 2.0f))) - 1.0f / (rad + 2.0f);
            }
            if (target instanceof EntityPlayer) {
                int i;
                EntityPlayer player = (EntityPlayer)target;
                for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                    HazardTypeNeutron.apply(player.field_71071_by.func_70301_a(i), rad);
                }
                for (i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                    HazardTypeNeutron.apply(player.field_71071_by.func_70440_f(i), rad);
                }
            }
            ContaminationUtil.contaminate(target, ContaminationUtil.HazardType.NEUTRON, ContaminationUtil.ContaminationType.CREATIVE, rad);
        }
    }

    @Override
    public void updateEntity(EntityItem item, float level) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHazardInformation(EntityPlayer player, List list, float level, ItemStack stack, List<HazardModifier> modifiers) {
        if ((double)(level = HazardModifier.evalAllModifiers(stack, (EntityLivingBase)player, level, modifiers)) < 1.0E-5 || RadiationConfig.disableNeutron) {
            return;
        }
        list.add(EnumChatFormatting.BLUE + "[" + I18nUtil.resolveKey("trait.neutron", new Object[0]) + "]");
        String neut = "" + Math.floor(level * 1000.0f) / 1000.0;
        list.add(EnumChatFormatting.LIGHT_PURPLE + neut + "RAD/s^2");
        if (stack.field_77994_a > 1) {
            list.add(EnumChatFormatting.LIGHT_PURPLE + "Stack: " + Math.floor(level * 1000.0f * (float)stack.field_77994_a) / 1000.0 + "RAD/s^2");
        }
    }

    public static void apply(ItemStack stack, float rad) {
        if (stack == null) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        float activation = stack.field_77990_d.func_74760_g(NEUTRON_KEY);
        stack.field_77990_d.func_74776_a(NEUTRON_KEY, activation + rad / (float)stack.field_77994_a / 10.0f);
    }

    public static void decay(ItemStack stack, float factor) {
        if (stack == null) {
            return;
        }
        if (!stack.func_77942_o()) {
            return;
        }
        float activation = stack.field_77990_d.func_74760_g(NEUTRON_KEY);
        stack.field_77990_d.func_74776_a(NEUTRON_KEY, activation * factor);
        if ((double)activation < 1.0E-5) {
            stack.field_77990_d.func_82580_o(NEUTRON_KEY);
        }
        if (stack.field_77990_d.func_82582_d()) {
            stack.func_77982_d((NBTTagCompound)null);
        }
    }
}

