/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.pollution;

import com.hbm.config.MobConfig;
import com.hbm.config.RadiationConfig;
import com.hbm.entity.mob.glyphid.EntityGlyphid;
import com.hbm.entity.mob.glyphid.EntityGlyphidDigger;
import com.hbm.entity.mob.glyphid.EntityGlyphidScout;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.WorldEvent;

public class PollutionHandler {
    public static final String fileName = "hbmpollution.dat";
    public static HashMap<World, PollutionPerWorld> perWorld = new HashMap();
    public static final float SOOT_PER_SECOND = 0.04f;
    public static final float HEAVY_METAL_PER_SECOND = 0.02f;
    public static final float POISON_PER_SECOND = 0.02f;
    public static Vec3 targetCoords;
    int eggTimer = 0;
    protected static final float DESTRUCTION_THRESHOLD = 15.0f;
    protected static final int DESTRUCTION_COUNT = 5;
    public static final UUID maxHealth;
    public static final UUID attackDamage;

    public static void incrementPollution(World world, int x, int y, int z, PollutionType type, float amount) {
        if (!RadiationConfig.enablePollution) {
            return;
        }
        PollutionPerWorld ppw = perWorld.get(world);
        if (ppw == null) {
            return;
        }
        ChunkCoordIntPair pos = new ChunkCoordIntPair(x >> 6, z >> 6);
        PollutionData data = ppw.pollution.get(pos);
        if (data == null) {
            data = new PollutionData();
            ppw.pollution.put(pos, data);
        }
        data.pollution[type.ordinal()] = MathHelper.func_76131_a((float)((float)((double)data.pollution[type.ordinal()] + (double)amount * MobConfig.pollutionMult)), (float)0.0f, (float)10000.0f);
    }

    public static void decrementPollution(World world, int x, int y, int z, PollutionType type, float amount) {
        PollutionHandler.incrementPollution(world, x, y, z, type, -amount);
    }

    public static void setPollution(World world, int x, int y, int z, PollutionType type, float amount) {
        if (!RadiationConfig.enablePollution) {
            return;
        }
        PollutionPerWorld ppw = perWorld.get(world);
        if (ppw == null) {
            return;
        }
        ChunkCoordIntPair pos = new ChunkCoordIntPair(x >> 6, z >> 6);
        PollutionData data = ppw.pollution.get(pos);
        if (data == null) {
            data = new PollutionData();
            ppw.pollution.put(pos, data);
        }
        data.pollution[type.ordinal()] = amount;
    }

    public static float getPollution(World world, int x, int y, int z, PollutionType type) {
        if (!RadiationConfig.enablePollution) {
            return 0.0f;
        }
        PollutionPerWorld ppw = perWorld.get(world);
        if (ppw == null) {
            return 0.0f;
        }
        ChunkCoordIntPair pos = new ChunkCoordIntPair(x >> 6, z >> 6);
        PollutionData data = ppw.pollution.get(pos);
        if (data == null) {
            return 0.0f;
        }
        return data.pollution[type.ordinal()];
    }

    public static PollutionData getPollutionData(World world, int x, int y, int z) {
        if (!RadiationConfig.enablePollution) {
            return null;
        }
        PollutionPerWorld ppw = perWorld.get(world);
        if (ppw == null) {
            return null;
        }
        ChunkCoordIntPair pos = new ChunkCoordIntPair(x >> 6, z >> 6);
        PollutionData data = ppw.pollution.get(pos);
        return data;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K && RadiationConfig.enablePollution) {
            WorldServer world = (WorldServer)event.world;
            String dirPath = this.getDataDir(world);
            try {
                File pollutionFile = new File(dirPath, fileName);
                if (pollutionFile != null) {
                    if (pollutionFile.exists()) {
                        FileInputStream io = new FileInputStream(pollutionFile);
                        NBTTagCompound data = CompressedStreamTools.func_74796_a((InputStream)io);
                        io.close();
                        perWorld.put(event.world, new PollutionPerWorld(data));
                    } else {
                        perWorld.put(event.world, new PollutionPerWorld());
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.world.field_72995_K) {
            perWorld.remove(event.world);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.world.field_72995_K) {
            WorldServer world = (WorldServer)event.world;
            String dirPath = this.getDataDir(world);
            File pollutionFile = new File(dirPath, fileName);
            try {
                PollutionPerWorld ppw;
                if (!pollutionFile.getParentFile().exists()) {
                    pollutionFile.getParentFile().mkdirs();
                }
                if (!pollutionFile.exists()) {
                    pollutionFile.createNewFile();
                }
                if ((ppw = perWorld.get(world)) != null) {
                    NBTTagCompound data = ppw.writeToNBT();
                    CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)new FileOutputStream(pollutionFile));
                }
            }
            catch (Exception ex) {
                System.out.println("Failed to write " + pollutionFile.getAbsolutePath());
                ex.printStackTrace();
            }
        }
    }

    public String getDataDir(WorldServer world) {
        String dir = world.func_72860_G().func_75765_b().getAbsolutePath();
        String dimId = File.separator + "DIM" + world.field_73011_w.field_76574_g;
        if (world.field_73011_w.field_76574_g != 0 && !dir.endsWith(dimId)) {
            dir = dir + dimId;
        }
        dir = dir + File.separator + "data";
        return dir;
    }

    @SubscribeEvent
    public void updateSystem(TickEvent.ServerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            PollutionHandler.handleWorldDestruction();
            ++this.eggTimer;
            if (this.eggTimer < 60) {
                return;
            }
            this.eggTimer = 0;
            for (Map.Entry<World, PollutionPerWorld> entry : perWorld.entrySet()) {
                HashMap<ChunkCoordIntPair, PollutionData> newPollution = new HashMap<ChunkCoordIntPair, PollutionData>();
                for (Map.Entry<ChunkCoordIntPair, PollutionData> chunk : entry.getValue().pollution.entrySet()) {
                    int[][] offsets;
                    int x = chunk.getKey().field_77276_a;
                    int z = chunk.getKey().field_77275_b;
                    PollutionData data = chunk.getValue();
                    float[] pollutionForNeightbors = new float[PollutionType.values().length];
                    int S = PollutionType.SOOT.ordinal();
                    int H = PollutionType.HEAVYMETAL.ordinal();
                    int P = PollutionType.POISON.ordinal();
                    if (data.pollution[S] > 10.0f) {
                        pollutionForNeightbors[S] = data.pollution[S] * 0.05f;
                        int n = S;
                        data.pollution[n] = data.pollution[n] * 0.8f;
                    }
                    int n = S;
                    data.pollution[n] = data.pollution[n] * 0.99f;
                    int n2 = H;
                    data.pollution[n2] = data.pollution[n2] * 0.9995f;
                    if (data.pollution[P] > 10.0f) {
                        pollutionForNeightbors[P] = data.pollution[P] * 0.025f;
                        int n3 = P;
                        data.pollution[n3] = data.pollution[n3] * 0.9f;
                    } else {
                        int n4 = P;
                        data.pollution[n4] = data.pollution[n4] * 0.995f;
                    }
                    PollutionData newData = (PollutionData)newPollution.get(chunk.getKey());
                    if (newData == null) {
                        newData = new PollutionData();
                    }
                    boolean shouldPut = false;
                    for (int i = 0; i < newData.pollution.length; ++i) {
                        int n5 = i;
                        newData.pollution[n5] = newData.pollution[n5] + data.pollution[i];
                        if (!(newData.pollution[i] > 0.0f)) continue;
                        shouldPut = true;
                    }
                    if (shouldPut) {
                        newPollution.put(chunk.getKey(), newData);
                    }
                    for (int[] offset : offsets = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}}) {
                        ChunkCoordIntPair offPos = new ChunkCoordIntPair(x + offset[0], z + offset[1]);
                        PollutionData offsetData = (PollutionData)newPollution.get(offPos);
                        if (offsetData == null) {
                            offsetData = new PollutionData();
                        }
                        shouldPut = false;
                        for (int i = 0; i < offsetData.pollution.length; ++i) {
                            int n6 = i;
                            offsetData.pollution[n6] = offsetData.pollution[n6] + pollutionForNeightbors[i];
                            if (!(offsetData.pollution[i] > 0.0f)) continue;
                            shouldPut = true;
                        }
                        if (!shouldPut) continue;
                        newPollution.put(offPos, offsetData);
                    }
                }
                entry.getValue().pollution.clear();
                entry.getValue().pollution.putAll(newPollution);
            }
        }
    }

    protected static void handleWorldDestruction() {
        for (Map.Entry<World, PollutionPerWorld> entry : perWorld.entrySet()) {
            World world = entry.getKey();
            WorldServer serv = (WorldServer)world;
            ChunkProviderServer provider = (ChunkProviderServer)serv.func_72863_F();
            for (Map.Entry<ChunkCoordIntPair, PollutionData> pollution : entry.getValue().pollution.entrySet()) {
                float poison = pollution.getValue().pollution[PollutionType.POISON.ordinal()];
                if (poison < 15.0f) continue;
                ChunkCoordIntPair entryPos = pollution.getKey();
                for (int i = 0; i < 5; ++i) {
                    int z;
                    int x = (entryPos.field_77276_a << 6) + world.field_73012_v.nextInt(64);
                    if (!provider.func_73149_a(x >> 4, (z = (entryPos.field_77275_b << 6) + world.field_73012_v.nextInt(64)) >> 4)) continue;
                    int y = world.func_72976_f(x, z) - world.field_73012_v.nextInt(3) + 1;
                    Block b = world.func_147439_a(x, y, z);
                    if (b == Blocks.field_150349_c || b == Blocks.field_150346_d && world.func_72805_g(x, y, z) == 0) {
                        world.func_147465_d(x, y, z, Blocks.field_150346_d, 1, 3);
                        continue;
                    }
                    if (b != Blocks.field_150329_H && b.func_149688_o() != Material.field_151584_j && b.func_149688_o() != Material.field_151585_k) continue;
                    world.func_147449_b(x, y, z, Blocks.field_150350_a);
                }
            }
        }
    }

    @SubscribeEvent
    public void decorateMob(LivingSpawnEvent event) {
        if (!RadiationConfig.enablePollution) {
            return;
        }
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        EntityLivingBase living = event.entityLiving;
        PollutionData data = PollutionHandler.getPollutionData(world, (int)Math.floor(event.x), (int)Math.floor(event.y), (int)Math.floor(event.z));
        if (data == null) {
            return;
        }
        if (living instanceof IMob && !(living instanceof EntityGlyphid) && (double)data.pollution[PollutionType.SOOT.ordinal()] > RadiationConfig.buffMobThreshold) {
            if (living.func_110148_a(SharedMonsterAttributes.field_111267_a) != null && living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(maxHealth) == null) {
                living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(maxHealth, "Soot Anger Health Increase", 1.0, 1));
            }
            if (living.func_110148_a(SharedMonsterAttributes.field_111264_e) != null && living.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111127_a(attackDamage) == null) {
                living.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier(attackDamage, "Soot Anger Damage Increase", 1.5, 1));
            }
            living.func_70691_i(living.func_110138_aP());
        }
    }

    @SubscribeEvent
    public void rampantTargetSetter(PlayerSleepInBedEvent event) {
        if (MobConfig.rampantGlyphidGuidance) {
            targetCoords = Vec3.func_72443_a((double)event.x, (double)event.y, (double)event.z);
        }
    }

    @SubscribeEvent
    public void rampantScoutPopulator(WorldEvent.PotentialSpawns event) {
        float soot;
        if (MobConfig.rampantNaturalScoutSpawn && !event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0 && event.world.func_72937_j(event.x, event.y, event.z) && !event.isCanceled() && event.world.field_73012_v.nextInt(MobConfig.rampantScoutSpawnChance) == 0 && (double)(soot = PollutionHandler.getPollution(event.world, event.x, event.y, event.z, PollutionType.SOOT)) >= MobConfig.rampantScoutSpawnThresh) {
            EntityGlyphidScout scout = new EntityGlyphidScout(event.world);
            scout.func_70012_b(event.x, event.y, event.z, event.world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (scout.func_70814_o()) {
                EntityGlyphidDigger digger = new EntityGlyphidDigger(event.world);
                scout.func_70012_b(event.x, event.y, event.z, event.world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                digger.func_70012_b(event.x, event.y, event.z, event.world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (scout.func_70601_bi()) {
                    event.world.func_72838_d((Entity)scout);
                }
                if (digger.func_70601_bi()) {
                    event.world.func_72838_d((Entity)digger);
                }
            }
        }
    }

    static {
        maxHealth = UUID.fromString("25462f6c-2cb2-4ca8-9b47-3a011cc61207");
        attackDamage = UUID.fromString("8f442d7c-d03f-49f6-a040-249ae742eed9");
    }

    public static enum PollutionType {
        SOOT,
        POISON,
        HEAVYMETAL,
        FALLOUT;

    }

    public static class PollutionData {
        public float[] pollution = new float[PollutionType.values().length];

        public static PollutionData fromNBT(NBTTagCompound nbt) {
            PollutionData data = new PollutionData();
            for (int i = 0; i < PollutionType.values().length; ++i) {
                data.pollution[i] = nbt.func_74760_g(PollutionType.values()[i].name().toLowerCase(Locale.US));
            }
            return data;
        }

        public void toNBT(NBTTagCompound nbt) {
            for (int i = 0; i < PollutionType.values().length; ++i) {
                nbt.func_74776_a(PollutionType.values()[i].name().toLowerCase(Locale.US), this.pollution[i]);
            }
        }
    }

    public static class PollutionPerWorld {
        public HashMap<ChunkCoordIntPair, PollutionData> pollution = new HashMap();

        public PollutionPerWorld() {
        }

        public PollutionPerWorld(NBTTagCompound data) {
            NBTTagList list = data.func_150295_c("entries", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt = list.func_150305_b(i);
                int chunkX = nbt.func_74762_e("chunkX");
                int chunkZ = nbt.func_74762_e("chunkZ");
                this.pollution.put(new ChunkCoordIntPair(chunkX, chunkZ), PollutionData.fromNBT(nbt));
            }
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound data = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            for (Map.Entry<ChunkCoordIntPair, PollutionData> entry : this.pollution.entrySet()) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("chunkX", entry.getKey().field_77276_a);
                nbt.func_74768_a("chunkZ", entry.getKey().field_77275_b);
                entry.getValue().toNBT(nbt);
                list.func_74742_a((NBTBase)nbt);
            }
            data.func_74782_a("entries", (NBTBase)list);
            return data;
        }
    }
}

