/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.ability;

import com.hbm.handler.ability.AvailableAbilities;
import com.hbm.handler.ability.IToolAreaAbility;
import com.hbm.handler.ability.IToolHarvestAbility;
import com.hbm.util.ChatBuilder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;

public class ToolPreset {
    public IToolAreaAbility areaAbility = IToolAreaAbility.NONE;
    public int areaAbilityLevel = 0;
    public IToolHarvestAbility harvestAbility = IToolHarvestAbility.NONE;
    public int harvestAbilityLevel = 0;

    public ToolPreset() {
    }

    public ToolPreset(IToolAreaAbility areaAbility, IToolHarvestAbility harvestAbility) {
        this.areaAbility = areaAbility;
        this.harvestAbility = harvestAbility;
    }

    public ToolPreset(IToolAreaAbility areaAbility, int areaAbilityLevel, IToolHarvestAbility harvestAbility, int harvestAbilityLevel) {
        this.areaAbility = areaAbility;
        this.areaAbilityLevel = areaAbilityLevel;
        this.harvestAbility = harvestAbility;
        this.harvestAbilityLevel = harvestAbilityLevel;
    }

    public ChatComponentText getMessage() {
        if (this.isNone()) {
            return ChatBuilder.start("[Tool ability deactivated]").color(EnumChatFormatting.GOLD).flush();
        }
        boolean hasArea = this.areaAbility != IToolAreaAbility.NONE;
        boolean hasHarvest = this.harvestAbility != IToolHarvestAbility.NONE;
        ChatBuilder builder = ChatBuilder.start("[Enabled ");
        if (hasArea) {
            builder.nextTranslation(this.areaAbility.getName(), new Object[0]);
            builder.next(this.areaAbility.getExtension(this.areaAbilityLevel));
        }
        if (hasArea && hasHarvest) {
            builder.next(" + ");
        }
        if (hasHarvest) {
            builder.nextTranslation(this.harvestAbility.getName(), new Object[0]);
            builder.next(this.harvestAbility.getExtension(this.harvestAbilityLevel));
        }
        return builder.colorAll(EnumChatFormatting.YELLOW).flush();
    }

    public boolean isNone() {
        return this.areaAbility == IToolAreaAbility.NONE && this.harvestAbility == IToolHarvestAbility.NONE;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("area", this.areaAbility.getName());
        nbt.func_74768_a("areaLevel", this.areaAbilityLevel);
        nbt.func_74778_a("harvest", this.harvestAbility.getName());
        nbt.func_74768_a("harvestLevel", this.harvestAbilityLevel);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.areaAbility = IToolAreaAbility.getByName(nbt.func_74779_i("area"));
        this.areaAbilityLevel = nbt.func_74762_e("areaLevel");
        this.harvestAbility = IToolHarvestAbility.getByName(nbt.func_74779_i("harvest"));
        this.harvestAbilityLevel = nbt.func_74762_e("harvestLevel");
        this.areaAbilityLevel = Math.min(this.areaAbilityLevel, this.areaAbility.levels() - 1);
        this.harvestAbilityLevel = Math.min(this.harvestAbilityLevel, this.harvestAbility.levels() - 1);
    }

    public void restrictTo(AvailableAbilities availableAbilities) {
        int maxHarvestLevel;
        int maxAreaLevel = availableAbilities.maxLevel(this.areaAbility);
        if (maxAreaLevel == -1) {
            this.areaAbility = IToolAreaAbility.NONE;
            this.areaAbilityLevel = 0;
        } else if (this.areaAbilityLevel > maxAreaLevel) {
            this.areaAbilityLevel = maxAreaLevel;
        } else if (this.areaAbilityLevel < 0) {
            this.areaAbilityLevel = 0;
        }
        if (!this.areaAbility.allowsHarvest(this.areaAbilityLevel)) {
            this.harvestAbility = IToolHarvestAbility.NONE;
            this.harvestAbilityLevel = 0;
        }
        if ((maxHarvestLevel = availableAbilities.maxLevel(this.harvestAbility)) == -1) {
            this.harvestAbility = IToolHarvestAbility.NONE;
            this.harvestAbilityLevel = 0;
        } else if (this.harvestAbilityLevel > maxHarvestLevel) {
            this.harvestAbilityLevel = maxHarvestLevel;
        } else if (this.harvestAbilityLevel < 0) {
            this.harvestAbilityLevel = 0;
        }
    }
}

