/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.blocks.ModBlocks;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ExplosionTom {
    public int posX;
    public int posY;
    public int posZ;
    public int lastposX = 0;
    public int lastposZ = 0;
    public int radius;
    public int radius2;
    public World worldObj;
    private int n = 1;
    private int nlimit;
    private int shell;
    private int leg;
    private int element;

    public void saveToNbt(NBTTagCompound nbt, String name) {
        nbt.func_74768_a(name + "posX", this.posX);
        nbt.func_74768_a(name + "posY", this.posY);
        nbt.func_74768_a(name + "posZ", this.posZ);
        nbt.func_74768_a(name + "lastposX", this.lastposX);
        nbt.func_74768_a(name + "lastposZ", this.lastposZ);
        nbt.func_74768_a(name + "radius", this.radius);
        nbt.func_74768_a(name + "radius2", this.radius2);
        nbt.func_74768_a(name + "n", this.n);
        nbt.func_74768_a(name + "nlimit", this.nlimit);
        nbt.func_74768_a(name + "shell", this.shell);
        nbt.func_74768_a(name + "leg", this.leg);
        nbt.func_74768_a(name + "element", this.element);
    }

    public void readFromNbt(NBTTagCompound nbt, String name) {
        this.posX = nbt.func_74762_e(name + "posX");
        this.posY = nbt.func_74762_e(name + "posY");
        this.posZ = nbt.func_74762_e(name + "posZ");
        this.lastposX = nbt.func_74762_e(name + "lastposX");
        this.lastposZ = nbt.func_74762_e(name + "lastposZ");
        this.radius = nbt.func_74762_e(name + "radius");
        this.radius2 = nbt.func_74762_e(name + "radius2");
        this.n = nbt.func_74762_e(name + "n");
        this.nlimit = nbt.func_74762_e(name + "nlimit");
        this.shell = nbt.func_74762_e(name + "shell");
        this.leg = nbt.func_74762_e(name + "leg");
        this.element = nbt.func_74762_e(name + "element");
    }

    public ExplosionTom(int x, int y, int z, World world, int rad) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.worldObj = world;
        this.radius = rad;
        this.radius2 = this.radius * this.radius;
        this.nlimit = this.radius2 * 4;
    }

    public boolean update() {
        this.breakColumn(this.lastposX, this.lastposZ);
        this.shell = (int)Math.floor((Math.sqrt(this.n) + 1.0) / 2.0);
        int shell2 = this.shell * 2;
        this.leg = (int)Math.floor((this.n - (shell2 - 1) * (shell2 - 1)) / shell2);
        this.element = this.n - (shell2 - 1) * (shell2 - 1) - shell2 * this.leg - this.shell + 1;
        int n = this.leg == 0 ? this.shell : (this.leg == 1 ? -this.element : (this.lastposX = this.leg == 2 ? -this.shell : this.element));
        this.lastposZ = this.leg == 0 ? this.element : (this.leg == 1 ? this.shell : (this.leg == 2 ? -this.element : -this.shell));
        ++this.n;
        return this.n > this.nlimit;
    }

    private void breakColumn(int x, int z) {
        int dist = this.radius2 - (x * x + z * z);
        if (dist > 0) {
            int pX = this.posX + x;
            int pZ = this.posZ + z;
            double X = Math.pow(this.posX - pX, 2.0);
            double Z = Math.pow(this.posZ - pZ, 2.0);
            double distance = MathHelper.func_76133_a((double)(X + Z));
            int y = 256;
            int terrain = 63;
            double cA = (double)terrain - Math.pow(Math.E, -Math.pow(Math.sqrt(x * x + z * z), 2.0) / 40000.0) * 13.0 + (double)this.worldObj.field_73012_v.nextInt(2);
            double cB = cA + Math.pow(Math.E, -Math.pow(Math.sqrt(x * x + z * z) - 200.0, 2.0) / 400.0) * 13.0;
            int craterFloor = (int)(cB + Math.pow(Math.E, -Math.pow(Math.sqrt(x * x + z * z) - 500.0, 2.0) / 2000.0) * 37.0);
            for (int i = 256; i > 0; --i) {
                if (i != craterFloor && this.worldObj.func_147439_a(pX, i, pZ) == Blocks.field_150350_a) continue;
                y = i;
                break;
            }
            int height = terrain - 14;
            int offset = 20;
            int threshold = (int)((float)Math.sqrt(x * x + z * z) * (float)(height + offset) / (float)this.radius) + this.worldObj.field_73012_v.nextInt(2) - offset;
            while (y > threshold && y != 0) {
                int k;
                int j;
                int i;
                if (y <= craterFloor) {
                    if (this.worldObj.field_73012_v.nextInt(200) == 0) {
                        this.worldObj.func_147465_d(pX, y, pZ, ModBlocks.ore_tektite_osmiridium, 0, 2);
                    } else {
                        this.worldObj.func_147465_d(pX, y, pZ, ModBlocks.tektite, 0, 2);
                    }
                } else if (y > terrain + 1) {
                    if (distance < 500.0) {
                        for (i = -2; i < 3; ++i) {
                            for (j = -2; j < 3; ++j) {
                                for (k = -2; k < 3; ++k) {
                                    if (this.worldObj.func_147439_a(pX + i, y + j, pZ + k).func_149688_o() != Material.field_151586_h && this.worldObj.func_147439_a(pX + i, y + j, pZ + k).func_149688_o() != Material.field_151588_w && this.worldObj.func_147439_a(pX + i, y + j, pZ + k).func_149688_o() != Material.field_151597_y && !this.worldObj.func_147439_a(pX + i, y + j, pZ + k).func_149688_o().func_76217_h()) continue;
                                    this.worldObj.func_147468_f(pX + i, y + j, pZ + k);
                                    this.worldObj.func_147468_f(pX, y, pZ);
                                }
                            }
                        }
                        this.worldObj.func_147465_d(pX, y, pZ, Blocks.field_150350_a, 0, 2);
                    }
                } else if (distance < 500.0) {
                    for (i = -2; i < 3; ++i) {
                        for (j = -2; j < 3; ++j) {
                            for (k = -2; k < 3; ++k) {
                                if (this.worldObj.func_147439_a(pX + i, y + j, pZ + k).func_149688_o() != Material.field_151586_h && this.worldObj.func_147439_a(pX + i, y + j, pZ + k).func_149688_o() != Material.field_151588_w && this.worldObj.func_147439_a(pX + i, y, pZ + k) != Blocks.field_150350_a) continue;
                                this.worldObj.func_147465_d(pX + i, y, pZ + k, Blocks.field_150353_l, 0, 2);
                                this.worldObj.func_147465_d(pX, y, pZ, Blocks.field_150353_l, 0, 2);
                            }
                        }
                    }
                    this.worldObj.func_147465_d(pX, y, pZ, Blocks.field_150353_l, 0, 2);
                }
                --y;
            }
        }
    }
}

