/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.blocks.ModBlocks;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.entity.mob.glyphid.EntityGlyphid;
import com.hbm.entity.projectile.EntityThrowableNT;
import com.hbm.extprop.HbmLivingProps;
import com.hbm.handler.atmosphere.ChunkAtmosphereManager;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.trait.FT_Combustible;
import com.hbm.inventory.fluid.trait.FT_Corrosive;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.fluid.trait.FT_Pheromone;
import com.hbm.inventory.fluid.trait.FT_Poison;
import com.hbm.inventory.fluid.trait.FT_Terraformer;
import com.hbm.inventory.fluid.trait.FT_Toxin;
import com.hbm.inventory.fluid.trait.FT_VentRadiation;
import com.hbm.inventory.fluid.trait.FluidTrait;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.particle.helper.FlameCreator;
import com.hbm.tileentity.IRepairable;
import com.hbm.util.ArmorUtil;
import com.hbm.util.CompatExternal;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.EnchantmentUtil;
import com.hbm.util.EntityDamageUtil;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityChemical
extends EntityThrowableNT {
    public EntityChemical(World world) {
        super(world);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    public EntityChemical(World world, EntityLivingBase thrower, double sideOffset, double heightOffset, double frontOffset) {
        super(world, thrower);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(10, (Object)new Integer(0));
    }

    public EntityChemical setFluid(FluidType fluid) {
        this.field_70180_af.func_75692_b(10, (Object)fluid.getID());
        return this;
    }

    public FluidType getType() {
        return Fluids.fromID(this.field_70180_af.func_75679_c(10));
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            FluidType type;
            if (this.field_70173_aa > this.getMaxAge()) {
                this.func_70106_y();
            }
            if ((type = this.getType()).hasTrait(Fluids.GASEOUS.getClass()) || type.hasTrait(Fluids.EVAP.getClass())) {
                double intensity = 1.0 - (double)this.field_70173_aa / (double)this.getMaxAge();
                List affected = this.field_70170_p.func_72839_b((Entity)this.thrower, this.field_70121_D.func_72314_b(intensity * 2.5, intensity * 2.5, intensity * 2.5));
                for (Entity e : affected) {
                    this.affect(e, intensity);
                }
            }
        } else {
            FluidType type = this.getType();
            ChemicalStyle style = this.getStyle();
            if (type == Fluids.BALEFIRE) {
                if (MainRegistry.proxy.me().func_70032_d((Entity)this) < 100.0f) {
                    FlameCreator.composeEffectClient(this.field_70170_p, this.field_70165_t, this.field_70163_u - 0.125, this.field_70161_v, FlameCreator.META_BALEFIRE);
                }
            } else if (style == ChemicalStyle.LIQUID) {
                Color color = new Color(type.getColor());
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaExt");
                data.func_74778_a("mode", "colordust");
                data.func_74780_a("posX", this.field_70165_t);
                data.func_74780_a("posY", this.field_70163_u);
                data.func_74780_a("posZ", this.field_70161_v);
                data.func_74780_a("mX", this.field_70159_w + this.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                data.func_74780_a("mY", this.field_70181_x - 0.2 + this.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                data.func_74780_a("mZ", this.field_70179_y + this.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                data.func_74776_a("r", (float)color.getRed() / 255.0f);
                data.func_74776_a("g", (float)color.getGreen() / 255.0f);
                data.func_74776_a("b", (float)color.getBlue() / 255.0f);
                MainRegistry.proxy.effectNT(data);
            } else if (style == ChemicalStyle.BURNING && MainRegistry.proxy.me().func_70032_d((Entity)this) < 100.0f) {
                FlameCreator.composeEffectClient(this.field_70170_p, this.field_70165_t, this.field_70163_u - 0.125, this.field_70161_v, FlameCreator.META_FIRE);
            }
        }
        super.func_70071_h_();
    }

    protected void affect(Entity e, double intensity) {
        FluidTrait trait;
        EntityLivingBase living;
        ChemicalStyle style = this.getStyle();
        FluidType type = this.getType();
        EntityLivingBase entityLivingBase = living = e instanceof EntityLivingBase ? (EntityLivingBase)e : null;
        if (style == ChemicalStyle.LIQUID || style == ChemicalStyle.BURNING) {
            intensity = 1.0;
        }
        if (style == ChemicalStyle.AMAT) {
            EntityDamageUtil.attackEntityFromIgnoreIFrame(e, ModDamageSource.radiation, 1.0f);
            if (living != null) {
                ContaminationUtil.contaminate(living, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 50.0f * (float)intensity);
                return;
            }
        }
        if (style == ChemicalStyle.LIGHTNING) {
            EntityDamageUtil.attackEntityFromIgnoreIFrame(e, ModDamageSource.electricity, 0.5f);
            if (living != null) {
                living.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 60, 9));
                living.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 60, 9));
                return;
            }
        }
        if (type.temperature >= 100) {
            EntityDamageUtil.attackEntityFromIgnoreIFrame(e, this.getDamage("boil"), Math.min(0.25f + (float)(type.temperature - 100) * 0.001f, 15.0f));
            if (type.temperature >= 500) {
                e.func_70015_d(10);
            }
        }
        if (style == ChemicalStyle.LIQUID || style == ChemicalStyle.GAS) {
            if (type.temperature < -20 && living != null) {
                EntityDamageUtil.attackEntityFromIgnoreIFrame(e, this.getDamage("boil"), Math.min(0.25f + (float)(-type.temperature) * 0.01f, 2.0f));
            }
            if (type.hasTrait(Fluids.DELICIOUS.getClass()) && living != null && living.func_70089_S()) {
                living.func_70691_i(2.0f * (float)intensity);
            }
        }
        if (style == ChemicalStyle.LIQUID) {
            if (type.hasTrait(FT_Flammable.class) && living != null) {
                HbmLivingProps.setOil(living, 300);
            }
            if (type.hasTrait(Fluids.DELICIOUS.getClass()) && living != null && living.func_70089_S()) {
                living.func_70691_i(2.0f * (float)intensity);
            }
        }
        if (this.isExtinguishing()) {
            e.func_70066_B();
        }
        if (style == ChemicalStyle.BURNING) {
            trait = type.getTrait(FT_Combustible.class);
            EntityDamageUtil.attackEntityFromIgnoreIFrame(e, this.getDamage("flamethrower"), 0.2f + (trait != null ? Math.min((float)((FT_Combustible)trait).getCombustionEnergy() / 100000.0f, 15.0f) : 0.0f));
            e.func_70015_d(5);
        }
        if (style == ChemicalStyle.GASFLAME) {
            FT_Flammable flammable = type.getTrait(FT_Flammable.class);
            FT_Combustible combustible = type.getTrait(FT_Combustible.class);
            float heat = Math.max(flammable != null ? (float)flammable.getHeatEnergy() / 50000.0f : 0.0f, combustible != null ? Math.min((float)combustible.getCombustionEnergy() / 100000.0f, 15.0f) : 0.0f);
            heat = (float)((double)heat * intensity);
            EntityDamageUtil.attackEntityFromIgnoreIFrame(e, this.getDamage("flamethrower"), (0.2f + heat) * (float)intensity);
            e.func_70015_d((int)Math.ceil(5.0 * intensity));
        }
        if (type.hasTrait(FT_Corrosive.class)) {
            trait = type.getTrait(FT_Corrosive.class);
            if (living != null) {
                EntityDamageUtil.attackEntityFromIgnoreIFrame((Entity)living, this.getDamage("acidPlayer"), (float)((FT_Corrosive)trait).getRating() / 50.0f);
                for (int i = 0; i < 4; ++i) {
                    ArmorUtil.damageSuit(living, i, ((FT_Corrosive)trait).getRating() / 40);
                }
            }
        }
        if (type.hasTrait(FT_VentRadiation.class)) {
            trait = type.getTrait(FT_VentRadiation.class);
            if (living != null) {
                ContaminationUtil.contaminate(living, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, ((FT_VentRadiation)trait).getRadPerMB() * 5.0f);
            }
            ChunkRadiationManager.proxy.incrementRad(this.field_70170_p, (int)Math.floor(e.field_70165_t), (int)Math.floor(e.field_70163_u), (int)Math.floor(e.field_70161_v), ((FT_VentRadiation)trait).getRadPerMB() * 5.0f);
        }
        if (type.hasTrait(FT_Poison.class)) {
            trait = type.getTrait(FT_Poison.class);
            if (living != null) {
                living.func_70690_d(new PotionEffect(((FT_Poison)trait).isWithering() ? Potion.field_82731_v.field_76415_H : Potion.field_76436_u.field_76415_H, (int)(100.0 * intensity)));
            }
        }
        if (type.hasTrait(FT_Toxin.class)) {
            trait = type.getTrait(FT_Toxin.class);
            if (living != null) {
                ((FT_Toxin)trait).affect(living, intensity);
            }
        }
        if (type.hasTrait(FT_Pheromone.class)) {
            FT_Pheromone pheromone = type.getTrait(FT_Pheromone.class);
            if (living != null) {
                living.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 2400, 2));
                living.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 6000, 1));
                living.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 2400, 4));
                if (living instanceof EntityGlyphid && pheromone.getType() == 1) {
                    living.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 6000, 4));
                    living.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 1200, 0));
                    living.func_70690_d(new PotionEffect(Potion.field_76444_x.field_76415_H, 1200, 19));
                } else if (living instanceof EntityPlayer && pheromone.getType() == 2) {
                    living.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 2400, 2));
                }
            }
        }
        if (type == Fluids.XPJUICE && e instanceof EntityPlayer) {
            EnchantmentUtil.addExperience((EntityPlayer)e, 1, false);
            this.func_70106_y();
        }
        if (type == Fluids.ENDERJUICE) {
            this.teleportRandomly(e);
        }
    }

    protected boolean isExtinguishing() {
        return this.getStyle() == ChemicalStyle.LIQUID && this.getType().temperature < 50 && !this.getType().hasTrait(FT_Flammable.class);
    }

    protected IRepairable.EnumExtinguishType getExtinguishingType(FluidType type) {
        return type == Fluids.CARBONDIOXIDE ? IRepairable.EnumExtinguishType.CO2 : (type == Fluids.WATER || type == Fluids.HEAVYWATER || type == Fluids.COOLANT ? IRepairable.EnumExtinguishType.WATER : null);
    }

    protected DamageSource getDamage(String name) {
        if (this.thrower != null) {
            return new EntityDamageSourceIndirect(name, (Entity)this, (Entity)this.thrower);
        }
        return new DamageSource(name);
    }

    public boolean teleportRandomly(Entity e) {
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double y = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(e, x, y, z);
    }

    public boolean teleportTo(Entity e, double x, double y, double z) {
        int k;
        int j;
        double targetX = e.field_70165_t;
        double targetY = e.field_70163_u;
        double targetZ = e.field_70161_v;
        e.field_70165_t = x;
        e.field_70163_u = y;
        e.field_70161_v = z;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)e.field_70165_t);
        if (e.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)e.field_70163_u), k = MathHelper.func_76128_c((double)e.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = e.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                e.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                e.func_70107_b(e.field_70165_t, e.field_70163_u, e.field_70161_v);
                if (e.field_70170_p.func_72945_a(e, e.field_70121_D).isEmpty() && !e.field_70170_p.func_72953_d(e.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            e.func_70107_b(targetX, targetY, targetZ);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = targetX + (e.field_70165_t - targetX) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)e.field_70130_N * 2.0;
            double d8 = targetY + (e.field_70163_u - targetY) * d6 + this.field_70146_Z.nextDouble() * (double)e.field_70131_O;
            double d9 = targetZ + (e.field_70161_v - targetZ) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)e.field_70130_N * 2.0;
            e.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        e.field_70170_p.func_72908_a(targetX, targetY, targetZ, "mob.endermen.portal", 1.0f, 1.0f);
        e.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    @Override
    protected void onImpact(MovingObjectPosition mop) {
        if (!this.field_70170_p.field_72995_K) {
            MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                this.affect(mop.field_72308_g, 1.0 - (double)this.field_70173_aa / (double)this.getMaxAge());
            }
            MovingObjectPosition.MovingObjectType cfr_ignored_1 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                FT_Terraformer terra;
                IRepairable.EnumExtinguishType fext;
                Block fire;
                ChemicalStyle style;
                FluidType type = this.getType();
                int x = mop.field_72311_b;
                int y = mop.field_72312_c;
                int z = mop.field_72309_d;
                if (type.hasTrait(FT_VentRadiation.class)) {
                    FT_VentRadiation trait = type.getTrait(FT_VentRadiation.class);
                    ChunkRadiationManager.proxy.incrementRad(this.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, trait.getRadPerMB() * 5.0f);
                }
                if ((style = this.getStyle()) == ChemicalStyle.BURNING || style == ChemicalStyle.GASFLAME) {
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        Object object = fire = type == Fluids.BALEFIRE ? ModBlocks.balefire : Blocks.field_150480_ab;
                        if (!this.field_70170_p.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).isAir((IBlockAccess)this.field_70170_p, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) continue;
                        this.field_70170_p.func_147449_b(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, fire);
                    }
                }
                if (style == ChemicalStyle.BURNING || style == ChemicalStyle.GASFLAME) {
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        Object object = fire = type == Fluids.BALEFIRE ? ModBlocks.balefire : Blocks.field_150480_ab;
                        if (!this.field_70170_p.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).isAir((IBlockAccess)this.field_70170_p, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) continue;
                        this.field_70170_p.func_147449_b(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, fire);
                    }
                }
                if (this.isExtinguishing()) {
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        if (this.field_70170_p.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) != Blocks.field_150480_ab) continue;
                        this.field_70170_p.func_147449_b(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, Blocks.field_150350_a);
                    }
                }
                if ((fext = this.getExtinguishingType(type)) != null) {
                    TileEntity core = CompatExternal.getCoreFromPos(this.field_70170_p, x, y, z);
                    if (core instanceof IRepairable) {
                        ((IRepairable)core).tryExtinguish(this.field_70170_p, x, y, z, fext);
                    }
                    if (fext == IRepairable.EnumExtinguishType.WATER && style == ChemicalStyle.LIQUID) {
                        for (int i = -2; i <= 2; ++i) {
                            for (int j = 0; j <= 1; ++j) {
                                for (int k = -2; k <= 2; ++k) {
                                    if (this.field_70170_p.func_147439_a(x + i, y + j, z + k) != ModBlocks.fallout) continue;
                                    this.field_70170_p.func_147449_b(x + i, y + j, z + k, Blocks.field_150350_a);
                                }
                            }
                        }
                    }
                }
                Block block = this.field_70170_p.func_147439_a(x, y, z);
                if (type == Fluids.SEEDSLURRY) {
                    CBT_Atmosphere atmosphere;
                    if ((block == Blocks.field_150346_d || block == ModBlocks.waste_earth || block == ModBlocks.dirt_dead || block == ModBlocks.dirt_oily) && this.field_70170_p.func_72957_l(x, y + 1, z) >= 9 && this.field_70170_p.getBlockLightOpacity(x, y + 1, z) <= 2 && (atmosphere = CelestialBody.getTrait(this.field_70170_p, CBT_Atmosphere.class)) != null && (atmosphere.hasFluid(Fluids.EARTHAIR) || atmosphere.hasFluid(Fluids.DUNAAIR) || atmosphere.hasFluid(Fluids.CARBONDIOXIDE) || atmosphere.hasFluid(Fluids.OXYGEN))) {
                        this.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150349_c);
                        ChunkAtmosphereManager.proxy.addGrowth(this.field_70170_p, (Block)Blocks.field_150349_c, x, y, z, 4, 6);
                        int totalConversion = 2400;
                        if (CelestialBody.consumeGas(this.field_70170_p, Fluids.CARBONDIOXIDE, totalConversion) || CelestialBody.consumeGas(this.field_70170_p, Fluids.DUNAAIR, totalConversion)) {
                            CelestialBody.emitGas(this.field_70170_p, Fluids.EARTHAIR, totalConversion);
                        }
                        this.field_70170_p.func_72926_e(2005, x, y + 1, z, 0);
                    }
                    int meta = this.field_70170_p.func_72805_g(x, y, z);
                    if (block == Blocks.field_150347_e) {
                        this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150341_Y);
                    }
                    if (block == Blocks.field_150417_aV && meta == 0) {
                        this.field_70170_p.func_147465_d(x, y, z, Blocks.field_150417_aV, 1, 3);
                    }
                    if (block == ModBlocks.waste_earth) {
                        this.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150349_c);
                    }
                    if (block == ModBlocks.brick_concrete) {
                        this.field_70170_p.func_147449_b(x, y, z, ModBlocks.brick_concrete_mossy);
                    }
                    if (block == ModBlocks.concrete_brick_slab && meta % 8 == 0) {
                        this.field_70170_p.func_147465_d(x, y, z, ModBlocks.concrete_brick_slab, meta + 1, 3);
                    }
                    if (block == ModBlocks.brick_concrete_stairs) {
                        this.field_70170_p.func_147465_d(x, y, z, ModBlocks.brick_concrete_mossy_stairs, meta, 3);
                    }
                }
                if (type.hasTrait(FT_Terraformer.class) && block == (terra = type.getTrait(FT_Terraformer.class)).getTargetBlock()) {
                    this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150346_d);
                    ChunkAtmosphereManager.proxy.addGrowth(this.field_70170_p, block, Blocks.field_150346_d, x, y, z, 4, 6);
                }
                this.func_70106_y();
            }
        }
    }

    @Override
    protected float getAirDrag() {
        ChemicalStyle type = this.getStyle();
        if (type == ChemicalStyle.AMAT) {
            return 1.0f;
        }
        if (type == ChemicalStyle.LIGHTNING) {
            return 1.0f;
        }
        if (type == ChemicalStyle.GAS) {
            return 0.95f;
        }
        return 0.99f;
    }

    @Override
    protected float getWaterDrag() {
        ChemicalStyle type = this.getStyle();
        if (type == ChemicalStyle.AMAT) {
            return 1.0f;
        }
        if (type == ChemicalStyle.LIGHTNING) {
            return 1.0f;
        }
        if (type == ChemicalStyle.GAS) {
            return 1.0f;
        }
        return 0.8f;
    }

    public int getMaxAge() {
        switch (this.getStyle()) {
            case AMAT: {
                return 100;
            }
            case LIGHTNING: {
                return 5;
            }
            case BURNING: {
                return 600;
            }
            case GAS: {
                return 60;
            }
            case GASFLAME: {
                return 20;
            }
            case LIQUID: {
                return 600;
            }
        }
        return 100;
    }

    @Override
    public double getGravityVelocity() {
        ChemicalStyle type = this.getStyle();
        if (type == ChemicalStyle.AMAT) {
            return 0.0;
        }
        if (type == ChemicalStyle.LIGHTNING) {
            return 0.0;
        }
        if (type == ChemicalStyle.GAS) {
            return 0.0;
        }
        if (type == ChemicalStyle.GASFLAME) {
            return -0.01;
        }
        return 0.03;
    }

    public ChemicalStyle getStyle() {
        return EntityChemical.getStyleFromType(this.getType());
    }

    public static ChemicalStyle getStyleFromType(FluidType type) {
        if (type == Fluids.IONGEL) {
            return ChemicalStyle.LIGHTNING;
        }
        if (type.isAntimatter()) {
            return ChemicalStyle.AMAT;
        }
        if (type.hasTrait(Fluids.GASEOUS.getClass()) || type.hasTrait(Fluids.EVAP.getClass())) {
            if (type.hasTrait(FT_Flammable.class) || type.hasTrait(FT_Combustible.class)) {
                return ChemicalStyle.GASFLAME;
            }
            return ChemicalStyle.GAS;
        }
        if (type.hasTrait(Fluids.LIQUID.getClass())) {
            if (type.hasTrait(FT_Combustible.class)) {
                return ChemicalStyle.BURNING;
            }
            return ChemicalStyle.LIQUID;
        }
        return ChemicalStyle.NULL;
    }

    public static enum ChemicalStyle {
        AMAT,
        LIGHTNING,
        LIQUID,
        GAS,
        GASFLAME,
        BURNING,
        NULL;

    }
}

