/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.trait;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.trait.CelestialBodyTrait;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class CBT_Dyson
extends CelestialBodyTrait {
    private HashMap<Integer, Swarm> swarms = new HashMap();

    public static void launch(World world, int id) {
        CBT_Dyson.launch(world, id, 1);
    }

    public static void launch(World world, int id, int amount) {
        Swarm swarm;
        CelestialBody star = CelestialBody.getStar(world);
        CBT_Dyson dyson = star.getTrait(CBT_Dyson.class);
        if (dyson == null) {
            dyson = new CBT_Dyson();
        }
        if ((swarm = dyson.swarms.get(id)) == null) {
            swarm = new Swarm(0);
            dyson.swarms.put(id, swarm);
        }
        swarm.members += amount;
        star.modifyTraits(dyson);
    }

    public static int count(World world, int id) {
        CelestialBody star = CelestialBody.getStar(world);
        CBT_Dyson dyson = star.getTrait(CBT_Dyson.class);
        if (dyson == null) {
            return 0;
        }
        Swarm swarm = dyson.swarms.get(id);
        if (swarm == null) {
            return 0;
        }
        return swarm.members;
    }

    public static int consumers(World world, int id) {
        CelestialBody star = CelestialBody.getStar(world);
        CBT_Dyson dyson = star.getTrait(CBT_Dyson.class);
        if (dyson == null) {
            return 0;
        }
        Swarm swarm = dyson.swarms.get(id);
        if (swarm == null) {
            return 0;
        }
        swarm.addedConsumers++;
        return swarm.consumers;
    }

    public int size() {
        int size = 0;
        for (Swarm swarm : this.swarms.values()) {
            size += swarm.members;
        }
        return size;
    }

    public void attenuate() {
        for (Swarm swarm : this.swarms.values()) {
            swarm.consumers = swarm.addedConsumers;
            swarm.addedConsumers = 0;
            if (swarm.members <= 0) continue;
            double decayChance = (double)this.size() / 102400.0;
            if (!(Math.random() < decayChance)) continue;
            --swarm.members;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        int[] swarmData = new int[this.swarms.size() * 2];
        int i = 0;
        for (Map.Entry<Integer, Swarm> entry : this.swarms.entrySet()) {
            swarmData[i] = entry.getKey();
            swarmData[i + 1] = entry.getValue().members;
            i += 2;
        }
        nbt.func_74783_a("swarm", swarmData);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int[] swarmData = nbt.func_74759_k("swarm");
        this.swarms = new HashMap();
        for (int i = 0; i < swarmData.length; i += 2) {
            this.swarms.put(swarmData[i], new Swarm(swarmData[i + 1]));
        }
    }

    @Override
    public void writeToBytes(ByteBuf buf) {
        buf.writeInt(this.swarms.size() * 2);
        for (Map.Entry<Integer, Swarm> entry : this.swarms.entrySet()) {
            buf.writeShort(entry.getKey().intValue());
            buf.writeInt(entry.getValue().members);
        }
    }

    @Override
    public void readFromBytes(ByteBuf buf) {
        int count = buf.readInt();
        this.swarms = new HashMap();
        for (int i = 0; i < count; i += 2) {
            short id = buf.readShort();
            int members = buf.readInt();
            this.swarms.put(Integer.valueOf(id), new Swarm(members));
        }
    }

    private static class Swarm {
        int members;
        int consumers;
        private int addedConsumers;

        public Swarm(int members) {
            this.members = members;
        }
    }
}

