/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.machine.BlockOrbitalStation;
import com.hbm.dim.CelestialBody;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityOrbitalStationLauncher;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class BlockOrbitalStationLauncher
extends BlockOrbitalStation
implements ITooltipProvider {
    public BlockOrbitalStationLauncher(Material mat) {
        super(mat);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityOrbitalStationLauncher();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo(true, true, true);
        }
        return null;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityOrbitalStationLauncher) {
            ((TileEntityOrbitalStationLauncher)te).isBreaking = true;
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!CelestialBody.inOrbit(world)) {
            return false;
        }
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return false;
        }
        if (Math.abs(pos[0] - x) >= 2 || Math.abs(pos[2] - z) >= 2) {
            return false;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityOrbitalStationLauncher)) {
            return false;
        }
        TileEntityOrbitalStationLauncher station = (TileEntityOrbitalStationLauncher)te;
        if (world.field_72995_K) {
            return true;
        }
        if (station.hasDocked) {
            if (!station.hasRider) {
                station.enterCapsule(player);
            }
            return true;
        }
        return this.standardOpenBehavior(world, x, y, z, player, 0);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        if (!CelestialBody.inOrbit(world)) {
            ArrayList<String> text = new ArrayList<String>();
            text.add("&[" + (BobMathUtil.getBlink() ? 0xFF0000 : 0xFFFF00) + "&]! ! ! " + I18nUtil.resolveKey("atmosphere.noOrbit", new Object[0]) + " ! ! !");
            ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
            return;
        }
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityOrbitalStationLauncher)) {
            return;
        }
        TileEntityOrbitalStationLauncher pad = (TileEntityOrbitalStationLauncher)te;
        ArrayList<String> text = new ArrayList<String>();
        if (pad.hasDocked) {
            if (!pad.hasRider) {
                text.add(I18nUtil.resolveKey("station.enterRocket", new Object[0]));
            } else {
                text.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("station.occupiedRocket", new Object[0]));
            }
            ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
            return;
        }
        if (pad.rocket == null || !pad.rocket.validate()) {
            return;
        }
        text.add("Required fuels:");
        for (int i = 0; i < pad.tanks.length; ++i) {
            FluidTank tank = pad.tanks[i];
            if (tank.getTankType() == Fluids.NONE) continue;
            text.add(EnumChatFormatting.GREEN + "-> " + EnumChatFormatting.RESET + tank.getTankType().getLocalizedName() + ": " + tank.getFill() + "/" + tank.getMaxFill() + "mB");
        }
        if (pad.solidFuel.max > 0) {
            text.add(EnumChatFormatting.GREEN + "-> " + EnumChatFormatting.RESET + I18nUtil.resolveKey(ModItems.rocket_fuel.func_77658_a() + ".name", new Object[0]) + ": " + pad.solidFuel.level + "/" + pad.solidFuel.max + "kg");
        }
        if (text.size() <= 1) {
            return;
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

