/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ModBlocks;
import com.hbm.dim.CelestialBody;
import com.hbm.handler.RocketStruct;
import com.hbm.handler.atmosphere.IBlockSealable;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemCustomRocket;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityOrbitalStation;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockOrbitalStation
extends BlockDummyable
implements IBlockSealable,
ILookOverlay {
    public BlockOrbitalStation(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityOrbitalStation();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo(true, false, true);
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{1, 0, 2, 2, 2, 2};
    }

    @Override
    public int getOffset() {
        return 2;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!CelestialBody.inOrbit(world)) {
            return false;
        }
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return false;
        }
        if (Math.abs(pos[0] - x) >= 2 || Math.abs(pos[2] - z) >= 2) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityOrbitalStation)) {
            return false;
        }
        TileEntityOrbitalStation station = (TileEntityOrbitalStation)te;
        if (station.hasStoredItems()) {
            station.giveStoredItems(player);
        } else if (station.hasDocked) {
            if (!station.hasRider) {
                if (player.func_70093_af()) {
                    if (player.func_70694_bm() == null) {
                        station.despawnRocket();
                        station.giveStoredItems(player);
                    }
                } else {
                    station.enterCapsule(player);
                }
            }
        } else {
            ItemStack held = player.func_70694_bm();
            if (held != null) {
                if (held.func_77973_b() == ModItems.rocket_custom && ItemCustomRocket.hasFuel(held)) {
                    station.spawnRocket(held);
                    --held.field_77994_a;
                }
                if (held.func_77973_b() == ModItems.rp_capsule_20 || held.func_77973_b() == ModItems.rp_pod_20) {
                    station.spawnRocket(ItemCustomRocket.build(new RocketStruct(held)));
                    --held.field_77994_a;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isSealed(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        this.makeExtra(world, (x += dir.offsetX * o) + 2, y + 1, (z += dir.offsetZ * o) - 1);
        this.makeExtra(world, x + 2, y + 1, z + 0);
        this.makeExtra(world, x + 2, y + 1, z + 1);
        this.makeExtra(world, x - 2, y + 1, z - 1);
        this.makeExtra(world, x - 2, y + 1, z + 0);
        this.makeExtra(world, x - 2, y + 1, z + 1);
        this.makeExtra(world, x - 1, y + 1, z + 2);
        this.makeExtra(world, x + 0, y + 1, z + 2);
        this.makeExtra(world, x + 1, y + 1, z + 2);
        this.makeExtra(world, x - 1, y + 1, z - 2);
        this.makeExtra(world, x + 0, y + 1, z - 2);
        this.makeExtra(world, x + 1, y + 1, z - 2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        ItemStack held;
        if (!CelestialBody.inOrbit(world)) {
            ArrayList<String> text = new ArrayList<String>();
            text.add("&[" + (BobMathUtil.getBlink() ? 0xFF0000 : 0xFFFF00) + "&]! ! ! " + I18nUtil.resolveKey("atmosphere.noOrbit", new Object[0]) + " ! ! !");
            ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
            return;
        }
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        if (Math.abs(pos[0] - x) >= 2 || Math.abs(pos[2] - z) >= 2) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityOrbitalStation)) {
            return;
        }
        TileEntityOrbitalStation station = (TileEntityOrbitalStation)te;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ArrayList<String> text = new ArrayList<String>();
        for (int i = 0; i < station.slots.length; ++i) {
            if (station.slots[i] == null) continue;
            text.add(EnumChatFormatting.RED + "<- " + EnumChatFormatting.RESET + station.slots[i].func_82833_r());
        }
        if (!text.isEmpty()) {
            text.add(I18nUtil.resolveKey("station.retrieveRocket", new Object[0]));
        } else if (station.hasDocked) {
            if (!station.hasRider) {
                if (player.func_70093_af()) {
                    if (player.func_70694_bm() == null) {
                        text.add(I18nUtil.resolveKey("station.removeRocket", new Object[0]));
                    }
                } else {
                    text.add(I18nUtil.resolveKey("station.enterRocket", new Object[0]));
                }
            } else {
                text.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("station.occupiedRocket", new Object[0]));
            }
            if (station.needsFuel) {
                for (FluidTank tank : station.getReceivingTanks()) {
                    text.add(EnumChatFormatting.GREEN + "-> " + EnumChatFormatting.RESET + tank.getTankType().getLocalizedName() + ": " + tank.getFill() + "/" + tank.getMaxFill() + "mB");
                }
                if (!station.hasFuel) {
                    text.add(EnumChatFormatting.RED + I18nUtil.resolveKey("station.emptyRocket", new Object[0]));
                }
            }
        } else if (!player.func_70093_af() && (held = player.func_70694_bm()) != null) {
            if (held.func_77973_b() == ModItems.rocket_custom && ItemCustomRocket.hasFuel(held)) {
                text.add(I18nUtil.resolveKey("station.placeRocket", new Object[0]));
            }
            if (held.func_77973_b() == ModItems.rp_capsule_20 || held.func_77973_b() == ModItems.rp_pod_20) {
                text.add(I18nUtil.resolveKey("station.placeRocket", new Object[0]));
            }
        }
        if (text.isEmpty()) {
            return;
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    public boolean func_149742_c(World worldIn, int x, int y, int z) {
        if (this == ModBlocks.orbital_station) {
            return false;
        }
        return super.func_149742_c(worldIn, x, y, z);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (this == ModBlocks.orbital_station) {
            return false;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }
}

