/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.machine.MachineBrickFurnace;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.container.ContainerFurnaceBrick;
import com.hbm.inventory.gui.GUIFurnaceBrick;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityFireboxBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

public class TileEntityFurnaceBrick
extends TileEntityMachineBase
implements IGUIProvider {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1, 3};
    private static final int[] slotsSides = new int[]{1};
    public static HashMap<Item, Integer> burnSpeed = new HashMap();
    public int burnTime;
    public int maxBurnTime;
    public int progress;
    public int ashLevelWood;
    public int ashLevelCoal;
    public int ashLevelMisc;

    public TileEntityFurnaceBrick() {
        super(4);
    }

    @Override
    public String getName() {
        return "container.furnaceBrick";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            boolean wasBurning = this.burnTime > 0;
            boolean markDirty = false;
            if (this.burnTime > 0) {
                --this.burnTime;
            }
            if (this.burnTime != 0 || this.slots[1] != null && this.slots[0] != null) {
                if (this.burnTime == 0 && this.canSmelt()) {
                    this.maxBurnTime = this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)this.slots[1]);
                    if (this.burnTime > 0) {
                        markDirty = true;
                        if (this.slots[1] != null) {
                            int threshold;
                            --this.slots[1].field_77994_a;
                            ItemEnums.EnumAshType type = TileEntityFireboxBase.getAshFromFuel(this.slots[1]);
                            if (type == ItemEnums.EnumAshType.WOOD) {
                                this.ashLevelWood += this.burnTime;
                            }
                            if (type == ItemEnums.EnumAshType.COAL) {
                                this.ashLevelCoal += this.burnTime;
                            }
                            if (type == ItemEnums.EnumAshType.MISC) {
                                this.ashLevelMisc += this.burnTime;
                            }
                            if (this.processAsh(this.ashLevelWood, ItemEnums.EnumAshType.WOOD, threshold = 2000)) {
                                this.ashLevelWood -= threshold;
                            }
                            if (this.processAsh(this.ashLevelCoal, ItemEnums.EnumAshType.COAL, threshold)) {
                                this.ashLevelCoal -= threshold;
                            }
                            if (this.processAsh(this.ashLevelMisc, ItemEnums.EnumAshType.MISC, threshold)) {
                                this.ashLevelMisc -= threshold;
                            }
                            if (this.slots[1].field_77994_a == 0) {
                                this.slots[1] = this.slots[1].func_77973_b().getContainerItem(this.slots[1]);
                            }
                        }
                    }
                }
                if (this.burnTime > 0 && this.canSmelt()) {
                    this.progress += this.getBurnSpeed();
                    if (this.progress >= 200) {
                        this.progress = 0;
                        this.smeltItem();
                        markDirty = true;
                    }
                } else {
                    this.progress = 0;
                }
            }
            if (wasBurning != this.burnTime > 0) {
                markDirty = true;
                MachineBrickFurnace.updateBlockState(this.burnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (markDirty) {
                this.func_70296_d();
            }
            this.networkPackNT(15);
        }
    }

    public int getBurnSpeed() {
        Integer speed = burnSpeed.get(this.slots[0].func_77973_b());
        if (speed != null) {
            return speed;
        }
        return 1;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot >= 2 ? false : (slot == 1 ? TileEntityFurnace.func_145952_a((ItemStack)stack) > 0 : true);
    }

    @Override
    public int[] func_94128_d(int side) {
        return side == 0 ? slotsBottom : (side == 1 ? slotsTop : slotsSides);
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.burnTime);
        buf.writeInt(this.maxBurnTime);
        buf.writeInt(this.progress);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.burnTime = buf.readInt();
        this.maxBurnTime = buf.readInt();
        this.progress = buf.readInt();
    }

    protected boolean processAsh(int level, ItemEnums.EnumAshType type, int threshold) {
        if (level >= threshold) {
            if (this.slots[3] == null) {
                this.slots[3] = OreDictManager.DictFrame.fromOne(ModItems.powder_ash, (Enum)type);
                return true;
            }
            if (this.slots[3].field_77994_a < this.slots[3].func_77976_d() && this.slots[3].func_77973_b() == ModItems.powder_ash && this.slots[3].func_77960_j() == type.ordinal()) {
                ++this.slots[3].field_77994_a;
                return true;
            }
        }
        return false;
    }

    private boolean canSmelt() {
        if (this.slots[0] == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.slots[2] == null) {
            return true;
        }
        if (!this.slots[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.slots[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.slots[2].func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]);
            if (this.slots[2] == null) {
                this.slots[2] = itemstack.func_77946_l();
            } else if (this.slots[2].func_77973_b() == itemstack.func_77973_b()) {
                this.slots[2].field_77994_a += itemstack.field_77994_a;
            }
            --this.slots[0].field_77994_a;
            if (this.slots[0].field_77994_a <= 0) {
                this.slots[0] = null;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.burnTime = nbt.func_74762_e("burnTime");
        this.maxBurnTime = nbt.func_74762_e("maxBurn");
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("burnTime", this.burnTime);
        nbt.func_74768_a("maxBurn", this.maxBurnTime);
        nbt.func_74768_a("progress", this.progress);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerFurnaceBrick(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIFurnaceBrick(player.field_71071_by, this);
    }

    static {
        burnSpeed.put(Items.field_151119_aD, 4);
        burnSpeed.put(ModItems.ball_fireclay, 4);
        burnSpeed.put(Item.func_150898_a((Block)Blocks.field_150424_aL), 4);
        burnSpeed.put(Item.func_150898_a((Block)Blocks.field_150347_e), 2);
        burnSpeed.put(Item.func_150898_a((Block)Blocks.field_150354_m), 2);
        burnSpeed.put(Item.func_150898_a((Block)Blocks.field_150364_r), 2);
        burnSpeed.put(Item.func_150898_a((Block)Blocks.field_150363_s), 2);
    }
}

