/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.generic.BlockDoorGeneric;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.DoorDecl;
import com.hbm.tileentity.machine.TileEntityLockableBase;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.Rotation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityDoorGeneric
extends TileEntityLockableBase {
    public byte state = 0;
    protected DoorDecl doorType;
    public int openTicks = 0;
    public long animStartTime = 0L;
    public int redstonePower;
    public boolean shouldUseBB = false;
    private byte skinIndex = 0;
    public Set<BlockPos> activatedBlocks = new HashSet<BlockPos>(4);
    private AudioWrapper audio;
    private AudioWrapper audio2;

    public void func_145845_h() {
        if (this.state == 3) {
            ++this.openTicks;
            if (this.openTicks >= this.getDoorType().timeToOpen()) {
                this.openTicks = this.getDoorType().timeToOpen();
            }
        } else if (this.state == 2) {
            --this.openTicks;
            if (this.openTicks <= 0) {
                this.openTicks = 0;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            BlockPos pos = new BlockPos(this);
            int[][] ranges = this.getDoorType().getDoorOpenRanges();
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            if (this.state == 3) {
                for (int i = 0; i < ranges.length; ++i) {
                    int[] range = ranges[i];
                    BlockPos startPos = new BlockPos(range[0], range[1], range[2]);
                    float time = this.getDoorType().getDoorRangeOpenTime(this.openTicks, i);
                    for (int j = 0; j < Math.abs(range[3]) && !((float)j / (float)Math.abs(range[3] - 1) > time); ++j) {
                        for (int k = 0; k < range[4]; ++k) {
                            BlockPos finalPos;
                            BlockPos add = new BlockPos(0, 0, 0);
                            switch (range[5]) {
                                case 0: {
                                    add = new BlockPos(0, k, (int)Math.signum(range[3]) * j);
                                    break;
                                }
                                case 1: {
                                    add = new BlockPos(k, (int)Math.signum(range[3]) * j, 0);
                                    break;
                                }
                                case 2: {
                                    add = new BlockPos((int)Math.signum(range[3]) * j, k, 0);
                                }
                            }
                            Rotation r = Rotation.getBlockRotation(dir);
                            if (dir == Library.POS_X || dir == Library.NEG_X) {
                                r = r.add(Rotation.CLOCKWISE_180);
                            }
                            if ((finalPos = startPos.add(add).rotate(r).add(pos)).equals(pos)) {
                                this.shouldUseBB = false;
                                continue;
                            }
                            ((BlockDummyable)this.func_145838_q()).makeExtra(this.field_145850_b, finalPos.getX(), finalPos.getY(), finalPos.getZ());
                        }
                    }
                }
            } else if (this.state == 2) {
                for (int i = 0; i < ranges.length; ++i) {
                    int[] range = ranges[i];
                    BlockPos startPos = new BlockPos(range[0], range[1], range[2]);
                    float time = this.getDoorType().getDoorRangeOpenTime(this.openTicks, i);
                    for (int j = Math.abs(range[3]) - 1; j >= 0 && !((float)j / (float)Math.abs(range[3] - 1) < time); --j) {
                        for (int k = 0; k < range[4]; ++k) {
                            BlockPos finalPos;
                            BlockPos add = new BlockPos(0, 0, 0);
                            switch (range[5]) {
                                case 0: {
                                    add = new BlockPos(0, k, (int)Math.signum(range[3]) * j);
                                    break;
                                }
                                case 1: {
                                    add = new BlockPos(k, (int)Math.signum(range[3]) * j, 0);
                                    break;
                                }
                                case 2: {
                                    add = new BlockPos((int)Math.signum(range[3]) * j, k, 0);
                                }
                            }
                            Rotation r = Rotation.getBlockRotation(dir);
                            if (dir == Library.POS_X || dir == Library.NEG_X) {
                                r = r.add(Rotation.CLOCKWISE_180);
                            }
                            if ((finalPos = startPos.add(add).rotate(r).add(pos)).equals(pos)) {
                                this.shouldUseBB = false;
                                continue;
                            }
                            ((BlockDummyable)this.func_145838_q()).removeExtra(this.field_145850_b, finalPos.getX(), finalPos.getY(), finalPos.getZ());
                        }
                    }
                }
            }
            if (this.state == 3 && this.openTicks == this.getDoorType().timeToOpen()) {
                this.state = 1;
            }
            if (this.state == 2 && this.openTicks == 0) {
                this.state = 0;
            }
            this.networkPackNT(100);
            if (this.redstonePower == -1 && this.state == 1) {
                this.tryToggle(-1);
            } else if (this.redstonePower > 0 && this.state == 0) {
                this.tryToggle(-1);
            }
            if (this.redstonePower == -1) {
                this.redstonePower = 0;
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeByte((int)this.state);
        buf.writeByte((int)this.skinIndex);
        buf.writeBoolean(this.shouldUseBB);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.handleNewState(buf.readByte());
        this.setSkinIndex(buf.readByte());
        this.shouldUseBB = buf.readBoolean();
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
        if (this.audio2 != null) {
            this.audio2.stopSound();
            this.audio2 = null;
        }
    }

    public DoorDecl getDoorType() {
        if (this.doorType == null && this.func_145838_q() instanceof BlockDoorGeneric) {
            this.doorType = ((BlockDoorGeneric)this.func_145838_q()).type;
        }
        return this.doorType;
    }

    public boolean tryToggle(EntityPlayer player) {
        if (this.isLocked() && player == null) {
            return false;
        }
        if (this.state == 0 && this.redstonePower > 0) {
            return false;
        }
        if (this.state == 0) {
            if (!this.field_145850_b.field_72995_K && this.canAccess(player)) {
                this.state = (byte)3;
            }
            return true;
        }
        if (this.state == 1) {
            if (!this.field_145850_b.field_72995_K && this.canAccess(player)) {
                this.state = (byte)2;
            }
            return true;
        }
        return false;
    }

    public boolean tryToggle(int passcode) {
        if (this.isLocked() && passcode != this.lock) {
            return false;
        }
        if (this.state == 0) {
            if (!this.field_145850_b.field_72995_K) {
                this.state = (byte)3;
            }
            return true;
        }
        if (this.state == 1) {
            if (!this.field_145850_b.field_72995_K) {
                this.state = (byte)2;
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleNewState(byte state) {
        if (this.state != state) {
            DoorDecl doorType = this.getDoorType();
            if (this.state == 0 && state == 3) {
                if (this.audio != null) {
                    this.audio.stopSound();
                    this.audio.setKeepAlive(0);
                }
                if (doorType.getOpenSoundLoop() != null) {
                    this.audio = MainRegistry.proxy.getLoopedSound(doorType.getOpenSoundLoop(), this.field_145851_c, this.field_145848_d, this.field_145849_e, doorType.getSoundVolume(), 10.0f, 1.0f);
                    this.audio.startSound();
                }
                if (doorType.getOpenSoundStart() != null) {
                    this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, doorType.getOpenSoundStart(), doorType.getSoundVolume(), 1.0f, false);
                }
                if (doorType.getSoundLoop2() != null) {
                    if (this.audio2 != null) {
                        this.audio2.stopSound();
                    }
                    this.audio2 = MainRegistry.proxy.getLoopedSound(doorType.getSoundLoop2(), this.field_145851_c, this.field_145848_d, this.field_145849_e, doorType.getSoundVolume(), 10.0f, 1.0f);
                    this.audio2.startSound();
                }
            }
            if (this.state == 1 && state == 2) {
                if (this.audio != null) {
                    this.audio.stopSound();
                }
                if (doorType.getCloseSoundLoop() != null) {
                    this.audio = MainRegistry.proxy.getLoopedSound(doorType.getCloseSoundLoop(), this.field_145851_c, this.field_145848_d, this.field_145849_e, doorType.getSoundVolume(), 10.0f, 1.0f);
                    this.audio.startSound();
                }
                if (doorType.getCloseSoundStart() != null) {
                    this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, doorType.getCloseSoundStart(), doorType.getSoundVolume(), 1.0f, false);
                }
                if (doorType.getSoundLoop2() != null) {
                    if (this.audio2 != null) {
                        this.audio2.stopSound();
                    }
                    this.audio2 = MainRegistry.proxy.getLoopedSound(doorType.getSoundLoop2(), this.field_145851_c, this.field_145848_d, this.field_145849_e, doorType.getSoundVolume(), 10.0f, 1.0f);
                    this.audio2.startSound();
                }
            }
            if (state == 1 || state == 0) {
                if (this.audio != null) {
                    this.audio.stopSound();
                    this.audio = null;
                }
                if (this.audio2 != null) {
                    this.audio2.stopSound();
                    this.audio2 = null;
                }
            }
            if (this.state == 3 && state == 1 && doorType.getOpenSoundEnd() != null) {
                this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, doorType.getOpenSoundEnd(), doorType.getSoundVolume(), 1.0f, false);
            }
            if (this.state == 2 && state == 0 && doorType.getCloseSoundEnd() != null) {
                this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, doorType.getCloseSoundEnd(), doorType.getSoundVolume(), 1.0f, false);
            }
            this.state = state;
            if (state > 1) {
                this.animStartTime = System.currentTimeMillis();
            }
        }
    }

    public int getSkinIndex() {
        return this.skinIndex;
    }

    public boolean setSkinIndex(byte skinIndex) {
        if (!this.getDoorType().hasSkins()) {
            return false;
        }
        if (this.getDoorType().getSkinCount() < skinIndex) {
            return false;
        }
        this.skinIndex = skinIndex;
        return true;
    }

    public void open() {
        if (this.state == 0) {
            this.state = (byte)3;
        }
    }

    public void close() {
        if (this.state == 1) {
            this.state = (byte)2;
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.state = tag.func_74771_c("state");
        this.openTicks = tag.func_74762_e("openTicks");
        this.animStartTime = tag.func_74762_e("animStartTime");
        this.redstonePower = tag.func_74762_e("redstoned");
        this.shouldUseBB = tag.func_74767_n("shouldUseBB");
        this.skinIndex = tag.func_74771_c("skin");
        NBTTagCompound activatedBlocks = tag.func_74775_l("activatedBlocks");
        this.activatedBlocks.clear();
        for (int i = 0; i < activatedBlocks.func_150296_c().size() / 3; ++i) {
            this.activatedBlocks.add(new BlockPos(activatedBlocks.func_74762_e("x" + i), activatedBlocks.func_74762_e("y" + i), activatedBlocks.func_74762_e("z" + i)));
        }
        super.func_145839_a(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("state", this.state);
        tag.func_74768_a("openTicks", this.openTicks);
        tag.func_74772_a("animStartTime", this.animStartTime);
        tag.func_74768_a("redstoned", this.redstonePower);
        tag.func_74757_a("shouldUseBB", this.shouldUseBB);
        if (this.getDoorType().hasSkins()) {
            tag.func_74774_a("skin", this.skinIndex);
        }
        NBTTagCompound activatedBlocks = new NBTTagCompound();
        int i = 0;
        for (BlockPos p : this.activatedBlocks) {
            activatedBlocks.func_74768_a("x" + i, p.getX());
            activatedBlocks.func_74768_a("y" + i, p.getY());
            activatedBlocks.func_74768_a("z" + i, p.getZ());
            ++i;
        }
        tag.func_74782_a("activatedBlocks", (NBTBase)activatedBlocks);
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
        if (this.audio2 != null) {
            this.audio2.stopSound();
            this.audio2 = null;
        }
    }

    public void updateRedstonePower(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        boolean powered = this.field_145850_b.func_72864_z(x, y, z);
        boolean contained = this.activatedBlocks.contains(pos);
        if (!contained && powered) {
            this.activatedBlocks.add(pos);
            if (this.redstonePower == -1) {
                this.redstonePower = 0;
            }
            ++this.redstonePower;
        } else if (contained && !powered) {
            this.activatedBlocks.remove(pos);
            --this.redstonePower;
            if (this.redstonePower == 0) {
                this.redstonePower = -1;
            }
        }
    }
}

