/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.impl;

import api.hbm.energymk2.IBatteryItem;
import api.hbm.fluidmk2.IFillableItem;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.weapon.sedna.GunConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.factory.XFactoryDrill;
import com.hbm.items.weapon.sedna.mags.IMagazine;
import com.hbm.items.weapon.sedna.mags.MagazineElectricEngine;
import com.hbm.items.weapon.sedna.mags.MagazineLiquidEngine;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemGunDrill
extends ItemGunBaseNT
implements IFillableItem,
IBatteryItem {
    public ItemGunDrill(ItemGunBaseNT.WeaponQuality quality, GunConfig ... cfg) {
        super(quality, cfg);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return XFactoryDrill.getModdableHarvestLevel(stack, Item.ToolMaterial.IRON.func_77996_d());
    }

    public boolean canHarvestBlock(Block par1Block, ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean acceptsFluid(FluidType type, ItemStack stack) {
        IMagazine mag = ((ItemGunBaseNT)stack.func_77973_b()).getConfig(stack, 0).getReceivers(stack)[0].getMagazine(stack);
        if (mag instanceof MagazineLiquidEngine) {
            MagazineLiquidEngine engine = (MagazineLiquidEngine)mag;
            for (FluidType acc : engine.acceptedTypes) {
                if (type != acc) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int tryFill(FluidType type, int amount, ItemStack stack) {
        IMagazine mag = ((ItemGunBaseNT)stack.func_77973_b()).getConfig(stack, 0).getReceivers(stack)[0].getMagazine(stack);
        if (mag instanceof MagazineLiquidEngine) {
            MagazineLiquidEngine engine = (MagazineLiquidEngine)mag;
            int toFill = Math.min(amount, 50);
            toFill = Math.min(toFill, engine.getCapacity(stack) - this.getFill(stack));
            engine.setAmount(stack, this.getFill(stack) + toFill);
            return amount - toFill;
        }
        return 0;
    }

    @Override
    public boolean providesFluid(FluidType type, ItemStack stack) {
        return false;
    }

    @Override
    public int tryEmpty(FluidType type, int amount, ItemStack stack) {
        return amount;
    }

    @Override
    public FluidType getFirstFluidType(ItemStack stack) {
        IMagazine mag = ((ItemGunBaseNT)stack.func_77973_b()).getConfig(stack, 0).getReceivers(stack)[0].getMagazine(stack);
        if (mag instanceof MagazineLiquidEngine) {
            return ((MagazineLiquidEngine)mag).getType(stack, null);
        }
        return Fluids.NONE;
    }

    @Override
    public int getFill(ItemStack stack) {
        IMagazine mag = ((ItemGunBaseNT)stack.func_77973_b()).getConfig(stack, 0).getReceivers(stack)[0].getMagazine(stack);
        if (mag instanceof MagazineLiquidEngine) {
            MagazineLiquidEngine engine = (MagazineLiquidEngine)mag;
            return engine.getAmount(stack, null);
        }
        return 0;
    }

    @Override
    public void chargeBattery(ItemStack stack, long i) {
        IMagazine mag = ((ItemGunBaseNT)stack.func_77973_b()).getConfig(stack, 0).getReceivers(stack)[0].getMagazine(stack);
        if (mag instanceof MagazineElectricEngine) {
            MagazineElectricEngine engine = (MagazineElectricEngine)mag;
            engine.setAmount(stack, Math.min(engine.capacity, engine.getAmount(stack, null) + (int)i));
        }
    }

    @Override
    public void setCharge(ItemStack stack, long i) {
        IMagazine mag = ((ItemGunBaseNT)stack.func_77973_b()).getConfig(stack, 0).getReceivers(stack)[0].getMagazine(stack);
        if (mag instanceof MagazineElectricEngine) {
            MagazineElectricEngine engine = (MagazineElectricEngine)mag;
            engine.setAmount(stack, (int)i);
        }
    }

    @Override
    public void dischargeBattery(ItemStack stack, long i) {
        IMagazine mag = ((ItemGunBaseNT)stack.func_77973_b()).getConfig(stack, 0).getReceivers(stack)[0].getMagazine(stack);
        if (mag instanceof MagazineElectricEngine) {
            MagazineElectricEngine engine = (MagazineElectricEngine)mag;
            engine.setAmount(stack, Math.max(0, engine.getAmount(stack, null) - (int)i));
        }
    }

    @Override
    public long getCharge(ItemStack stack) {
        IMagazine mag = ((ItemGunBaseNT)stack.func_77973_b()).getConfig(stack, 0).getReceivers(stack)[0].getMagazine(stack);
        if (mag instanceof MagazineElectricEngine) {
            MagazineElectricEngine engine = (MagazineElectricEngine)mag;
            return engine.getAmount(stack, null);
        }
        return 0L;
    }

    @Override
    public long getMaxCharge(ItemStack stack) {
        IMagazine mag = ((ItemGunBaseNT)stack.func_77973_b()).getConfig(stack, 0).getReceivers(stack)[0].getMagazine(stack);
        if (mag instanceof MagazineElectricEngine) {
            MagazineElectricEngine engine = (MagazineElectricEngine)mag;
            return engine.getCapacity(stack);
        }
        return 0L;
    }

    @Override
    public long getChargeRate(ItemStack stack) {
        return 50000L;
    }

    @Override
    public long getDischargeRate(ItemStack stack) {
        return 0L;
    }
}

